/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwm_read_rasterfile.p
 > Purpose:		Instruct the PWM to read a bit-image from a local file
 > Author:		Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMGRAPHICS, *PWMRASTERS
 */
compile_mode :pop11 +strict;

uses poppwmlib;

section $-library$-pwmlib => pwm_read_rasterfile;

uses pwmsequences;

define pwm_read_rasterfile(sh, file, dx, dy);
	lvars dx dy sx sy sw sh file;
	unless file.isstring do mishap(file, 1, 'STRING NEEDED') endunless;
	unless sh do 0 ->> sh, 0, 0 endunless -> sw -> sy -> sx;
	checkinteger(sx, 0, false);
	checkinteger(sy, 0, false);
	checkinteger(sw, 0, false);
	checkinteger(sh, 0, false);
	checkinteger(dx, 0, false);
	checkinteger(dy, 0, false);
	pwmsendmessage(file, sh, sw, sy, sx, dy, dx, Pwms_gfxreadrasfile, pwmflushmessage);
enddefine;

endsection;


/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  8 1989 - renamed from -pwm_gfxreadrasterfile-
--- Poplog Documentation Officer, Sep  4 1987 (Ian Rogers);
	added semi-colons after the endsections.
--- Robert Duncan, Jun 26 1987 - moved in synonym -pwm_gfxreadrasfile-
--- Ben Rubinstein, Mar 17 1987 - changed name from -pwm_gfxreadrasfile-
*/
