/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:			C.pwm/lib/pwm/pwm_set_selection.p
 > Purpose:			Instruct the PWM to save a section of text
 > Author:			Ben Rubinstein, Feb 25 1987 (see revisions)
 > Documentation:	HELP * PWMGENERAL
 > Related Files:	LIB * PWM_GETSELECTION
*/
compile_mode :pop11 +strict;

section $-library$-pwmlib => pwm_set_selection;

uses pwmsequences;

define pwm_set_selection(win, l1, c1, l2, c2);
	lvars c1 l1 c2 l2 win;
	checkinteger(c1, 0, false);
	checkinteger(l1, 0, false);
	checkinteger(c2, 0, false);
	checkinteger(l2, 0, false);

	if l2 fi_< l1 or (l1 == l2 and c2 fi_< c1) then
		mishap(c1, l1, c2, l2, 4, 'second point must follow first');
	elseunless lmember(win.pwm_windowtype, [base text ved]) do
		mishap(win, 1, 'BASE, VED OR TEXT WINDOW-ID NEEDED');
	else
		pwmsendmessage(c2, l2, c1, l1, checkpwmwinid(win),
						Pwms_setselection, pwmflushmessage);
	endif;
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  7 1989 - renamed from pwm_setselection
 */
