/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwm_track_mouse.p
 > Purpose:		Provide visual feedback on a moving mouse
 > Author:		Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP * PWM_TRACK_MOUSE
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib => pwm_track_mouse TRKMODE;

uses pwmsequences;

define pwmtrackmodes = newproperty([
	[rline 1]				[rubber_line 1]
	[sketch ^(1 || 32)]		[sketch_line ^(1 || 32)]
	[crossw 2]				[window_crosshairs 2]
	[crossb ^(2 || 32)]		[box_crosshairs ^(2 || 32)]
	[rbox 3]				[rubber_box 3]
	[rsheet ^(3 || 32)]		[rubber_sheet ^(3 || 32)]
	[bbox 4]				[bouncy_box 4]
	[bsheet ^(4 || 32)]		[bouncy_sheet ^(4 || 32)]
	[xorras 5]				[bouncy_xor_ras 5]
	[srcras ^(5 || 32)]		[bouncy_src_ras ^(5 || 32)]
	[mtextl 6]				[marktext_lines 6]
	[mtextw ^(6 || 32)]		[marktext_window ^(6 || 32)]
  ], 8, false, true)
enddefine;

define macro TRKMODE;
	lvars w n;
	if (pwmtrackmodes(itemread() ->> w) ->> n) then
		n :: proglist -> proglist;
	else
		mishap(w, 1, 'NO SUCH MOUSE-TRACKING MODE');
	endif;
enddefine;

/*
|	format of numeric args in command
|
|	num[0]	=	newx								X
|	num[1]	=	newy                                Y
|	num[2]	=	fixed.x		(image.width)           I
|	num[3]	=	fixed.y		(image.height)          J
|	num[4]	=	limit.x
|	num[5]	=	limit.y
|	num[6]	=	limit.width
|	num[7]	=	limit.height
|	num[8]	=	image.origin.x	(may be num[4] if no limit box)	RX
|	num[9]	= 	image.origin.y	(may be num[5] if no limit box) RY
|
*/

define pwm_track_mouse(mode, report);
	lvars report mode i j fx fy rx ry limits surf;
	unless mode or report do return endunless;
	if mode.isword then
		if (pwmtrackmodes(mode) ->> i) then	;;; i used as temp
			i -> mode
		else
			mishap(mode, 1, 'NO SUCH MOUSE-TRACKING MODE');
		endif
	elseunless mode do
		0 -> mode;
	elseunless mode.isinteger do
		mishap(mode, 1, 'NO SUCH MOUSE-TRACKING MODE');
	endif;
	if mode == TRKMODE xorras or mode == TRKMODE srcras then
		checkpwmsurfid() -> surf;
		-> ry -> rx;
	else
		false -> surf;
	endif;
	if mode == 0 then false, 0,0,0,0 endif -> j -> i -> fy -> fx -> limits;
	if report then mode + 64 -> mode endif;
	if surf then ry, rx endif;
	if limits then limits.rev.dl endif;
	j, i, fy, fx;
	if surf then
		mode, surf;
		if limits then Pwms_trackrlimbox else Pwms_trackrnolim endif;
	else
		mode;
		if limits then Pwms_trackmlimbox else Pwms_trackmnolim endif;
	endif;
	pwmsendmessage(true);		;;; always flush (?)
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  8 1989 - renamed from pwm_trackmouse
--- Ben Rubinstein, Apr  5 1987 - removed silly typo "bubber"
--- Ben Rubinstein, Mar 23 1987 - fixed some confusions over arg. order
*/
