/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwm_windowcursor.p
 > Purpose:		Associate a cursor with a window
 > Author:		Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMWINDOWS
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib => pwm_windowcursor;

uses pwmsequences;

define pwm_windowcursor =
	mishap(%1, 'pwm_windowcursor ONLY HAS AN UPDATER'%)
enddefine;

define updaterof pwm_windowcursor(cursor, win);
	lvars win cursor;
	pwmsendmessage(checkpwmcursid(cursor), checkpwmwinid(win),
					Pwms_setwincursor, pwmflushmessage);
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  7 1989
		This -updater of pwm_windowcursor- replaces the original
		-pwm_setwincursor-
 */
