/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwm_windowlocation.p
 > Purpose:		Set or get the position of a window
 > Author:		Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMWINDOWS
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib  => pwm_windowlocation;

uses pwmsequences;

define pwm_windowlocation(win) -> vec;
	lvars win vec temp;
	checkpwmwinid(win) -> win;
	if (getpwmreport(win, Pwms_getwinlocat, Pwms_repwinlocat) == 3) then
		consvector(2) -> vec -> temp;
		unless temp == win do false -> vec endunless;
	else
		false -> vec
	endif
enddefine;

define updaterof pwm_windowlocation(vec, win);
	lvars win vec temp;
	pwmsendmessage(subscrv(2, vec), subscrv(1, vec),
			if win==pwmnxtwin then PwmnxtwinID else checkpwmwinid(win) endif,
			Pwms_setwinlocat, pwmflushmessage);
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  7 1989 - renamed from pwm_window_location
--- Ben Rubinstein, Mar 17 1987 - added patch for -pwmnxtwin- facility
*/
