/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwm_winexternalsize.p
 > Purpose:		Get or set the (maximum) external size of a window
 > Author:		Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMWINDOWS
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib  => pwm_winexternalsize;

uses pwmsequences;

define pwm_winexternalsize(win) -> vec;
	lvars win vec temp;
	checkpwmwinid(win) -> win;
	if (getpwmreport(win, Pwms_getexternsize, Pwms_repexternsize) == 3) then
		consvector(2) -> vec -> temp;
		unless temp == win do false -> vec endunless;
	else
		false -> vec
	endif
enddefine;

define updaterof pwm_winexternalsize(vec, win);
	lvars win vec temp;
	pwmsendmessage(subscrv(2, vec), subscrv(1, vec),
						checkpwmwinid(win), Pwms_setexternsize, true);
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  7 1989 - renamed from pwm_win_externalsize
 */
