/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:        C.pwm/lib/pwm/pwm_wipe_area.p
 > Purpose:     Apply a raster-op over a rectangular area
 > Author:      Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:   HELP *PWMGRAPHICS
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib => pwm_wipe_area;

uses pwmsequences;

define pwm_wipe_area(h);
	lvars x y w h;
	if h then
		-> w -> y -> x;
		checkinteger(x, 0, false);
		checkinteger(y, 0, false);
		checkinteger(w, 0, false);
		checkinteger(h, 0, false);
	else
		0 ->> h ->> w ->> y -> x;
	endif;
	pwmsendmessage(h, w, y, x, Pwms_gfxwipearea, pwmflushmessage);
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Aug  7 1989 -  Renamed from -pwm_gfxwipearea-
 */
