/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:        C.pwm/lib/pwm/pwm_write_rasterfile.p
 > Purpose:     Instruct the PWM to write a bit-image to a local file
 > Author:      Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:   HELP *PWMGRAPHICS
 */
compile_mode :pop11 +strict;

uses poppwmlib;

section $-library$-pwmlib => pwm_write_rasterfile;

uses pwmsequences;

define pwm_write_rasterfile(h, file);
	lvars x y w h file;
	unless file.isstring do mishap(file, 1, 'STRING NEEDED') endunless;
	if h then
		-> w -> y -> x;
		checkinteger(x, 0, false);
		checkinteger(y, 0, false);
		checkinteger(w, 0, false);
		checkinteger(h, 0, false);
	else
		0 ->> x ->> y ->> w -> h;
	endif;

	if getpwmreport(file, h, w, y, x, Pwms_gfxwriterasfil,
											Pwms_idresult) == 1 then
		-> x;
		if x == 2 then
			mishap(file, 1, 'PWM couldn\'t open rasterfile');
		elseunless x == 0 then
			mishap(file, x, 2, 'PWM had unknown error writing rasterfile');
		endif;
	else
		mishap(file, 1,
			'Error in PWM communications: rasterfile may not have been written');
	endif;
enddefine;

endsection;


/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  8 1989 - renamed from pwm_gfxwriterasterfile
--- Robert Duncan, Jun 26 1987 - moved in synonym -pwm_gfxwriterasfile-
--- Ben Rubinstein, Apr  5 1987 - now blocks, and reports errors
--- Ben Rubinstein, Mar 17 1987 - changed name from -pwm_gfxwriterasfile-
*/
