/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwmpaintnum.p
 > Purpose:		The logical colour used by subsequent graphic operations
 > Author:		Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMGRAPHICS
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib => pwmpaintnum;

uses pwmsequences;

lvars gfxpaintnum = 1;

define active pwmpaintnum();
	gfxpaintnum
enddefine;

define updaterof active pwmpaintnum(paint);
	lvars paint;
	if paint.isinteger and paint fi_>= 0 and paint fi_< 256 then
		unless gfxpaintnum == paint do
			pwmsendmessage(paint, Pwms_gfxsetcgpaint, pwmflushmessage);
			paint -> gfxpaintnum;
		endunless;
	else
		mishap(paint, 1, 'Bad number for PWM paint')
	endif
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Aug 11 1989 -  Renamed from -pwmgfxpaintnum-
 */
