/* --- Copyright University of Sussex 1992.  All rights reserved. ---------
 > File:           C.pwm/lib/pwm/pwmraster.p
 > Purpose:		   Records and associated routines for manipulating bit-images
 > Author:         Ben Rubinstein, Sep 21 1986 (see revisions)
 > Documentation:  HELP * PWMRASTERS, * PWMGRAPHICS
 > Related Files:  LIB * SUNRASTERFILE
 */
compile_mode :pop11 +strict;

/*

newpwmraster( <integer:W>, <integer:H>, <integer:D> ) -> <pwmraster>
newpwmraster(<integer:D>, <array>) -> <pwmraster>
newpwmraster( <integer:W>, <integer:H>, <integer:D>, <string> ) -> <pwmraster>

pwmraster_depth( <pwmraster> ) -> <integer>
pwmraster_width( <pwmraster> ) -> <integer>
pwmraster_height( <pwmraster> ) -> <integer>

ispwmraster( <item> ) -> <boolean>

<pwmraster> ( <integer:X>, <integer:Y> ) -> <integer:V>
<integer:V> -> <pwmraster> ( <integer:X>, <integer:Y> )

<integer> -> pwmrastershift;
*/


section $-library$-pwmlib =>
					pwmraster pwmrastershift, newpwmraster, ispwmraster,
					pwmraster_width, pwmraster_height, pwmraster_depth,
					pwmraster_name;

global vars pwmrastershift = 0;

defclass pwmraster {
		pwmraster_width,
		pwmraster_height,
		pwmraster_depth,
		pwmraster_name,
		pwmraster_string, pwmraster_format	;;; private
	};

;;; do not allow any of the fields except the name to be changed
false ->> updater(pwmraster_width)
		->> updater(pwmraster_height)
		->> updater(pwmraster_depth)
		->> updater(pwmraster_string)
		-> updater(pwmraster_format);

;;; class printer defined just to avoid long strings of garbage being
;;; printed out
;;;
procedure(pwr);
	lvars pwr;
	dlocal pop_pr_quotes = false, pop_pr_radix = 10;
	sys_syspr('<pwmraster ');
	if pwr.pwmraster_name then
		sys_syspr('"'); sys_syspr(pwr.pwmraster_name); sys_syspr('" ');
	endif;
	sys_syspr(pwr.pwmraster_width);
	sys_syspr('x');
	sys_syspr(pwr.pwmraster_height);
	sys_syspr('x');
	sys_syspr(pwr.pwmraster_depth);
	sys_syspr('>');
endprocedure -> class_print("pwmraster".key_of_dataword);

;;; just for the access prox below: check that all parts of the pwmraster
;;; are as they should be, so that fast prox can be used safely; check
;;; that the indices are integers and in range, similarly; and get the
;;; bitmask while we're at it
;;;
define syscheckpwrarg(x, y, pwr) -> w -> h -> d -> m -> s;
	lvars x y pwr w h d s m;
	lconstant bitmasks = {128 192 ^false 240 ^false ^false ^false 255};
	lconstant mismess = 'BAD SUBSCRIPT FOR INDEXED ACCESS';
	unless (pwr.pwmraster_width ->> w).isinteger
	and (pwr.pwmraster_height ->> h).isinteger do
		mishap(w, h, pwr, 3, 'PWMRASTER HAS BAD SIZE');
	endunless;
	unless (pwr.pwmraster_depth ->> d).isinteger
		and (fast_subscrv(d, bitmasks) ->> m) do
		mishap(d, pwr, 2, 'PWMRASTER HAS BAD DEPTH');
	endunless;
	unless (pwr.pwmraster_string ->> s).isstring do
		mishap(s.dataword, pwr, 2, 'PWMRASTER HAS BAD STRING')
	endunless;
	unless x.isinteger and x fi_>= 0 and x fi_< w do
		mishap(x, pwr, 2, mismess)
	endunless;
	unless y.isinteger and y fi_>= 0 and y fi_< h
		do mishap(y, pwr, 2, mismess)
	endunless;
enddefine;

define pwmraster_accessor(x, y, pwr);
	lvars x y pwr b w h d m s str;

	;;; check args
	syscheckpwrarg(x, y, pwr) -> w -> h -> d -> m -> str;

	;;; get b=index to byte, and s=bits to roll
	(if ((w fi_* d) fi_// 16 -> b) == 0 then b else (b fi_+ 1) endif)
		fi_* 2 fi_* y -> b;
	((x fi_* d) fi_// 8) fi_+ b -> b -> s;

	;;; get the byte, shift left to get the bits we want at the top,
	;;; mask off, and shift back down
	(((fast_subscrs(b fi_+ 1, str)) fi_<< s) fi_&& m) fi_>> (8 fi_- d)
enddefine;

pwmraster_accessor -> class_apply(pwmraster_key);

define updaterof pwmraster_accessor(v, x, y, pwr);
	lvars v, x, y, pwr, b, w, h, d, m, s, str;
	;;; check args
	syscheckpwrarg(x, y, pwr) -> w -> h -> d -> m -> str;

	(v >> pwmrastershift) && ({1 3 7 15 31 63 127 255}(d)) -> v;

	;;; get b=index to byte, and s=bits to roll
	(if ((w fi_* d) fi_// 16 -> b) == 0 then b
	else (b fi_+ 1)
	endif) fi_* 2 fi_* y -> b;
	((x fi_* d) fi_// 8) fi_+ b fi_+ 1 -> b -> s;

	;;; get the byte, shift mask along to blank the bits ...
	(	(fast_subscrs(b, pwr.pwmraster_string) fi_&& (fi_~~(m fi_>> s)))
		fi_||		;;; ... and or it with...
		;;; ... the value shifted up to fit the space
		(v fi_<< (8 fi_- s fi_- d))
	) -> fast_subscrs(b, pwr.pwmraster_string);
enddefine;

;;; newpwmraster(<integer:W>, <integer:H>, <integer:D>) -> <pwmraster>
;;; newpwmraster(<integer:D>, <array>) -> <pwmraster>
;;; newpwmraster(<integer:W>, <integer:H>, <integer:D>, <string>) -> <pwmraster>
;;;
define newpwmraster(d, s);
	lvars bpl s w h d extra_bits;
	lvars c x y mask shifts scnt;
	lvars x1 x2 y1 y2;
	if s.isstring then
		-> h -> w;
	elseif s.isarray then
		explode(boundslist(s)) -> y2 -> y1 -> x2 -> x1;
		x2 - x1 + 1 -> w;
		y2 - y1 + 1 -> h;
	else
		d, s, false -> s -> d -> h -> w;
	endif;
	unless w.isinteger and w > 0 and h.isinteger and h > 0 do
		mishap(w, h, 2, 'width and height must be integers > 0');
	endunless;
	unless lmember(d, [1 2 4 8]) do
		mishap(d, 1, 'depth must be power of two')
	endunless;
	if (((w * d)  // 16 -> bpl ->> extra_bits) /== 0) do bpl + 1 -> bpl endif;
	if s.isstring then
		unless s.datalength == (bpl * 2 * h) do
			mishap(s.datalength, 1, 'bad length for raster string')
		endunless
	elseif s.isarray then
		(extra_bits > 0 and extra_bits < 9) -> extra_bits;
		subscrv(d, #_< {1 3 7 15 31 63 127 255} >_#) -> mask;
		subscrv(d, #_< {7 3 0  1 0   0   0   0} >_#) -> shifts;
		fast_for y from y1 to y2 do
			0 ->> c -> scnt;
			fast_for x from x1 to x2 do
				(c fi_<< d) fi_|| ((s(x, y) >> pwmrastershift) && mask) -> c;
				if scnt == shifts then c, 0 ->> c; else scnt fi_+ 1 endif -> scnt;
			endfast_for;
			unless scnt == 0 do
				repeat (shifts fi_- scnt) times c fi_<< d -> c endrepeat;
				c fi_<< d
			endunless;
			if extra_bits then 0 endif;
		endfast_for;
		consstring(bpl * 2 * h) -> s;
	else
		inits(bpl * 2 * h) -> s;
	endif;
	conspwmraster(w, h, d, false, s, {% 8, bpl * 2 %});
enddefine;

constant pwmraster = true;		;;; for "uses"

endsection;

/* --- Revision History ---------------------------------------------------
--- John Gibson, Dec 14 1992
			pwm_r*asterdepth	-> pwmraster_depth
			pwm_r*asterwidth	-> pwmraster_width
			pwm_r*asterheight	-> pwmraster_height
		since pwm_r*asterdepth conflicts with the one in pwm_make_rasterarray.
		Also pr_name -> pwmraster_name.

--- Gareth Palmer, Sep  8 1989 - Altered for new names:
		pr_depth                -> pwm_r*asterdepth
		pr_width                -> pwm_r*asterwidth
		pr_height               -> pwm_r*asterheight
--- Ben Rubinstein, Dec  2 1986 - revised format of dumps (half fixed only)
*/
