/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwmrasterop.p
 > Purpose:		Define, set and get the raster-ops used by graphics operations
 > Author:		Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMGRAPHICS
 */
compile_mode :pop11 +strict;

section;

;;; operation types
global constant
	PWM_SRC		= 2:0011,				;;; straight blat of arg pixels
	PWM_DST		= 2:0101,				;;; do nothing (useful in copyraster)

	PWM_SET		= 2:1111,				;;; set pixels to foreground colour
	PWM_CLR		= 2:0000,				;;; set pixels to background colour

	PWM_AND		= PWM_SRC && PWM_DST,	;;; (mask)
	PWM_OR		= PWM_SRC || PWM_DST,	;;; (paint)
	PWM_XOR		= PWM_SRC ||/& PWM_DST,	;;; (inverting paint)
	PWM_ERASE	= ~~PWM_SRC && PWM_DST,	;;; (background-colour paint)

	PWM_NOTSRC	= ~~PWM_SRC && PWM_SET,	;;; blat invert of arg pixels
	PWM_NOTDST	= ~~PWM_DST && PWM_SET;	;;; invert pixels

endsection;


section $-library$-pwmlib => pwmrasterop;

uses pwmsequences;

define checkpwmrop(op) with_props false;
	lvars op;
	unless op.isinteger and op fi_>= 0 and op fi_< 16 do
		mishap(op, 1, 'PWM RASTER-OP NEEDED');
	endunless;
enddefine;

lvars gfxrasterop = PWM_SRC;

define active pwmrasterop();
	gfxrasterop
enddefine;

define updaterof active pwmrasterop(op);
	lvars op;
	checkpwmrop(op);
	unless gfxrasterop == op do
		pwmsendmessage(op, Pwms_gfxsetcgrop, pwmflushmessage);
		op -> gfxrasterop;
	endunless;
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Aug 11 1989 -  Renamed from -pwmgfxrasterop-
--- Ben Rubinstein, Mar 27 1987 - removed very odd use of sections
--- Ben Rubinstein, Feb 17 1987 - raster ops changed into line with GEM
*/
