/* --- Copyright University of Sussex 1989.  All rights reserved. ---------
 > File:		C.pwm/lib/pwm/pwmsun_make_cms.p
 > Purpose:		Make a new colour-map segment
 > Author:		Ben Rubinstein, Dec  2 1986 (see revisions)
 > Documentation:	HELP *PWMCOLOURS
 */
compile_mode :pop11 +strict;

section $-library$-pwmlib => pwmsun_make_cms;

uses pwmsequences;

define pwmsun_make_cms(size);
	lvars size;
	unless lmember(size, [2 4 8 16 32 64 128 256]) do
		mishap(size, 1, 'BAD ARGUMENT FOR SIZE OF NEW COLOUR MAP SEGMENT')
	else
		unless (getpwmreport(size, Pwms_gfxnewcms, Pwms_idresult) == 1) do
			false
		else
			pwmnewcmsid(size >< ' entries')
		endunless
	endunless
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  8 1989 - renamed from pwmsun_gfxnewcms
 */
