/* --- Copyright University of Sussex 1989. All rights reserved. ----------
 > File:            C.pwm/lib/pwm/v12pwm.p
 > Purpose:         V13 to V12 PWM transmogrification library
 > Author:          Nic Ford, 18th August 1987 (see revisions)
 > Documentation:   HELP *V12PWM
 > Related Files:   -none-
 */

#_TERMIN_IF DEF POPC_COMPILING

section $-library$-pwmlib =>
	pwm_selected pwmgrafselected pwm_currentmenu apppwmwindows poppwmwindows
	pwm_closewindow pwm_exposewindow pwm_grafcopyraster pwm_grafdumpraster
	pwm_grafgetmapentry pwm_grafline pwm_grafloadraster pwm_grafparams
	pwm_grafpixel pwm_grafreadraster pwm_grafsaveraster pwm_grafselect
	pwm_grafsetmapentry pwm_graftext pwm_grafwipe pwm_hidewindow
	pwm_icon_position pwm_icon_title pwm_invokemenu pwm_makemenu pwm_movewindow
	pwm_normalcursor pwm_openorclosed pwm_openwindow pwm_refreshwindow
	pwm_resizewindow pwm_select pwm_textcursor pwm_win_charsize
	pwm_win_pixelsize pwm_win_position pwm_window_title pwmsun_getselection
	pwmsun_grafkillcms pwmsun_grafnewcms pwmsun_grafusecms;

global vars pwm_selected = pwmbasewindow;

global vars pwm_grafselected = pwmbasewindow;

global vars pwm_currentmenu = 'NoMenu\t';

define global procedure apppwmwindows(proc);
	lvars   proc;
	pwm_scan_windows(#_< [ved text gfx] >_#, proc)
enddefine;

define global procedure poppwmwindows(wid);
	lvars   wid;
	if wid.isinteger then Pwmwinofid(wid) -> wid endif;
	pwm_eventhandler(wid, false)
enddefine;

define updaterof global procedure poppwmwindows(pdr, wid);
	lvars   pdr wid npd;
	if wid.isinteger then Pwmwinofid(wid) -> wid endif;
	unless fast_lmember(pwm_windowtype(wid), #_< [gfx text] >_#) do
		mishap(wid, 1, 'NON-VED/BASE WINDOW NEEDED')
	endunless;
	procedure(i);
		lvars i ni c b x y;
		if i.isvector and length(i) == 4 then
			fast_subscrv(1, i) -> c;
			fast_subscrv(2, i) -> b;
			if fast_lmember(c, #_< [character `A` opened `O` closed `C`] >_#) ->> x then
				'{i  t' -> ni;
				x.tl.hd -> fast_subscrs(3, ni);
				if c == "character" then
					b
				else
					checkpwmwinid(pwminputsource) fi_+ 32
				endif -> fast_subscrs(4, ni)
			elseif fast_lmember(c, #_< [press release] >_#) then
				fast_subscrv(3, i) -> x;
				fast_subscrv(4, i) -> y;
				'{M  ' sys_>< x sys_>< ';' sys_>< y sys_>< 't' -> ni;
				b fi_+ 32 -> fast_subscrs(4, ni);
				if c == "press" then `P` else `R` endif -> fast_subscrs(3, ni)
			else
				return
			endif
		elseif i.isinteger then
			i -> ni
		else
			mishap(i, 1, '(FOUR ELEMENT) VECTOR OR INTEGER NEEDED')
		endif;
		pdr(checkpwmwinid(pwminputsource), ni)
	endprocedure -> pwm_eventhandler(wid, false);
	pdprops(pdr) -> pdprops(pwm_eventhandler(wid, false))
enddefine;

define global procedure pwm_closewindow;
	pwm_close_window(pwm_selected)
enddefine;

define global procedure pwm_exposewindow;
	pwm_expose_window(pwm_selected)
enddefine;

global vars procedure pwm_grafcopyraster = pwm_copy_raster;

define global procedure pwm_grafdumpraster(height, depth, str);
	lvars str left top width height depth;
	if str.isarray then
		pwm_dump_raster(height, depth, str);  ;;; actually left and top
	elseif str.isstring then
		-> width -> top -> left;
		pwm_dump_raster(left, top,
				pwm_make_rasterarray([% 1, width, 1, height %], depth, str));
	else
		mishap(str, 1, 'BAD ARGUMENT: use a string or an array');
	endif;
enddefine;

define global procedure pwm_grafgetmapentry(entry) -> vec;
	lvars entry vec;
	if (pwm_colourmapentry(entry) ->> vec) then
		[% vec.explode %] -> vec
	endif;
enddefine;

global vars procedure pwm_grafline = pwm_draw_line;

global vars procedure pwm_grafloadraster = pwm_read_rasterfile;

define global procedure pwm_grafparams(op, val);
	lvars op, val;
	op  -> pwmrasterop;
	val -> pwmpaintnum;
enddefine;

global vars procedure pwm_grafpixel = pwm_pixel;

define global procedure pwm_grafreadraster(left, top, width, height, depth) -> s;
	lvars left top width height depth a s i j ppb bpl;
	if (lmember(depth, [1 8 1 2 4 2]) ->> ppb) then
		ppb.tl.hd -> ppb ;;; pixels per byte
	else
		mishap(depth, 1, 'Depth must be a power of two')
	endif;
	if (pwm_load_raster(left, top, width, height) ->> a)
	and a.arrayvector.datakey.class_spec == depth then
		if (width * ppb // 8 -> bpl) > 0 then
			bpl + 1 -> bpl ;;; bytes per line
		endif;
		inits(bpl + erase(bpl // 2)) -> s;
		0 ->> i -> j;
		a.arrayvector -> a;
		repeat height times
			repeat bpl times
				fast_subscrv(i fi_+ 1 ->> i, a)
					-> fast_subscrv(j fi_+ 1 ->> j, s);
			endrepeat;
			j fi_+ erase(bpl // 2) -> j;
		endrepeat;
	else
		false -> s;
	endif;
enddefine;

global vars procedure pwm_grafsaveraster = pwm_write_rasterfile;

define global procedure pwm_grafselect(w);
	lvars   w;
	if w.isinteger then Pwmwinofid(w) -> w endif;
	w ->> pwmgfxsurface -> pwm_grafselected
enddefine;

define global procedure pwm_grafsetmapentry(entry, vals);
	lvars entry vals;
	if vals.islist then
		;;;pwm_gfxsetmapentry(entry, vals.dl)
		vals.dl -> pwm_colourmapentry(entry);
	else
		;;;pwm_gfxsetmapentry(entry, vals)
		vals -> pwm_colourmapentry(entry);
	endif;
enddefine;

global vars procedure pwm_graftext = pwm_draw_text;

global vars procedure pwm_grafwipe = pwm_wipe_area;

define global procedure pwm_hidewindow;
	pwm_hide_window(pwm_selected)
enddefine;

define global procedure pwm_icon_position;
	pwm_iconlocation(pwm_selected)
enddefine;

define updaterof global procedure pwm_icon_position with_nargs 1;
	-> pwm_iconlocation(pwm_selected)
enddefine;

define global procedure pwm_icon_title;
	pwm_iconlabel(pwm_selected)
enddefine;

define updaterof global procedure pwm_icon_title with_nargs 1;
	-> pwm_iconlabel(pwm_selected)
enddefine;

define global procedure pwm_invokemenu(menu);
	lvars   menu x y = false;
	if menu.isinteger then
		menu, pwm_currentmenu -> menu -> y -> x
	elseif menu.isstring then
		-> y;
		if y.isinteger then
			-> x
		elseif y then
			mishap(y, 1, 'FALSE OR INTEGER NEEDED')
		endif
	elseif menu then
		mishap(menu, 1, 'FALSE OR STRING NEEDED')
	else
		pwm_currentmenu -> menu
	endif;
	pwm_display_menu(menu, if y then pwm_selected, x, y endif)
enddefine;

define global procedure pwm_makemenu(str);
	lvars   str;
	if str = '' then 'NoMenu\t' else str endif -> pwm_currentmenu
enddefine;

define global procedure pwm_movewindow;
	pwm_move_window(pwm_selected)
enddefine;

define global procedure pwm_normalcursor;
	pwmstdcursor -> pwm_windowcursor(pwm_selected);
enddefine;

define global procedure pwm_openorclosed;
	pwm_winopenstate(pwm_selected)
enddefine;

define global procedure pwm_openwindow;
	pwm_open_window(pwm_selected)
enddefine;

define global procedure pwm_refreshwindow;
	pwm_refresh_window(pwm_selected)
enddefine;

define global procedure pwm_resizewindow;
	pwm_resize_window(pwm_selected)
enddefine;

define global procedure pwm_select(w);
	lvars   w;
	if w.isinteger then Pwmwinofid(w) -> w endif;
	w -> pwm_selected
enddefine;

define global procedure pwm_textcursor;
	pwmtxtcursor -> pwm_windowcursor(pwm_selected);
enddefine;

define global procedure pwm_win_charsize -> s;
	lvars   s;
	pwm_wininternalsize(pwm_selected) -> s;
	if pwm_windowtype(pwm_selected) == "gfx" then
		{%
			intof(1 + subscrv(1, s)/pwm_fontwidth(pwmstdfont)),
			intof(1 + fast_subscrv(2, s)/pwm_fontheight(pwmstdfont))
		%} -> s
	endif
enddefine;

define updaterof global procedure pwm_win_charsize(s);
	lvars   s;
	if s.isvector and length(s) == 2 then
		if pwm_windowtype(pwm_selected) == "gfx" then
			{%
				subscrv(1, s)*pwm_fontwidth(pwmstdfont),
				fast_subscrv(2, s)*pwm_fontheight(pwmstdfont)
			%} -> s
		endif;
		s -> pwm_wininternalsize(pwm_selected)
	else
		mishap(s, 1, '(TWO ELEMENT) VECTOR NEEDED')
	endif
enddefine;

define global procedure pwm_win_pixelsize -> s;
	lvars   s;
	pwm_wininternalsize(pwm_selected) -> s;
	unless pwm_windowtype(pwm_selected) == "gfx" then
		{%
			subscrv(1, s)*pwm_fontwidth(pwmstdfont),
			fast_subscrv(2, s)*pwm_fontheight(pwmstdfont)
		%} -> s
	endunless
enddefine;

define updaterof global procedure pwm_win_pixelsize(s);
	lvars   s;
	if s.isvector and length(s) == 2 then
		unless pwm_windowtype(pwm_selected) == "gfx" then
			{%
				intof(1 + subscrv(1, s)/pwm_fontwidth(pwmstdfont)),
				intof(1 + fast_subscrv(2, s)/pwm_fontheight(pwmstdfont))
			%} -> s
		endunless;
		s -> pwm_wininternalsize(pwm_selected)
	else
		mishap(s, 1, '(TWO ELEMENT) VECTOR NEEDED')
	endif
enddefine;

define global procedure pwm_win_position;
	pwm_windowlocation(pwm_selected)
enddefine;

define updaterof global procedure pwm_win_position with_nargs 1;
	-> pwm_windowlocation(pwm_selected)
enddefine;

define global procedure pwm_window_title;
	pwm_windowlabel(pwm_selected)
enddefine;

define updaterof global procedure pwm_window_title with_nargs 1;
	-> pwm_windowlabel(pwm_selected)
enddefine;

global vars procedure pwmsun_getselection = pwm_get_selection;

global vars procedure pwmsun_grafkillcms = pwmsun_kill_cms;

global vars procedure pwmsun_grafnewcms = pwmsun_make_cms;

global vars procedure pwmsun_grafusecms = pwmsun_use_cms;

endsection;

vars v12pwm = true;    ;;; for "uses"

/* --- Revision History ---------------------------------------------------
--- Gareth Palmer, Sep  7 1989 - Altered for new names:
		pwm_getselection        -> pwm_get_selection
		pwm_icon_label          -> pwm_iconlabel
		pwm_icon_location       -> pwm_iconlocation
		pwm_setwincursor        -> pwm_windowcursor
		pwm_win_internalsize    -> pwm_wininternalsize
		pwm_win_openstate       -> pwm_winopenstate
		pwm_window_label        -> pwm_windowlabel
		pwm_window_location     -> pwm_windowlocation
		pwmwindowscan       	-> pwm_scan_windows
		pwm_gfxcopyraster       -> pwm_copy_raster
		pwm_gfxdrawline         -> pwm_draw_line
		pwm_gfxpixel            -> pwm_pixel
		pwm_gfxwipearea         -> pwm_wipe_area
		pwmgfxpaintnum          -> pwmpaintnum
		pwmgfxrasterop          -> pwmrasterop
		pwm_displaymenu         -> pwm_display_menu
		pwmsun_gfxkillcms       -> pwmsun_kill_cms
		pwmsun_gfxnewcms        -> pwmsun_make_cms
		pwmsun_gfxusecms        -> pwmsun_use_cms
		pwm_gfxgetmapentry      -> pwm_colourmapentry
		pwm_gfxsetmapentry      -> pwm_colourmapentry   (updater of)
		pwm_gfxtext             -> pwm_draw_text
		newpwmrasterarray       -> pwm_make_rasterarray
		pwm_gfxdumpraster       -> pwm_dump_raster
		pwm_gfxloadraster       -> pwm_load_raster
		pwm_gfxreadrasterfile   -> pwm_read_rasterfile
		pwm_gfxwriterasterfile  -> pwm_write_rasterfile
		pwmeventhandler         -> pwm_eventhandler
 */
