/*  --- Copyright University of Sussex 1986.  All rights reserved. ---------
 > File:            C.pwm/lib/sun/pwmsunutils.p
 > Purpose:         Primitives for controlling Sun PWM windows
 > Author:          Ben Rubinstein, Apr  1 1986 (see revisions)
 > Documentation:   HELP *PWMWINDOWS
 > Related Files:   LIB *PWMSUNGRAPH
 */

#_TERMIN_IF DEF POPC_COMPILING

uses poppwmlib;

section $-library => pwmsunutils
	pwm_select pwm_selected pwm_closewindow pwm_currentmenu pwm_exposewindow
	pwm_hidewindow pwm_icon_position pwm_icon_title pwm_invokemenu
	pwm_makemenu pwm_movewindow pwm_openorclosed pwm_openwindow
	pwm_refreshwindow pwm_resizewindow pwm_win_pixelsize pwm_win_position
	pwm_window_title pwmsun_getselection pwm_normalcursor pwm_textcursor
	call5 apppwmwindows;

section $-pwmlib =>
	pwm_select pwm_selected pwm_closewindow pwm_currentmenu pwm_exposewindow
	pwm_hidewindow pwm_icon_position pwm_icon_title pwm_invokemenu
	pwm_makemenu pwm_movewindow pwm_openorclosed pwm_openwindow
	pwm_refreshwindow pwm_resizewindow pwm_win_pixelsize pwm_win_position
	pwm_window_title pwmsun_getselection pwm_normalcursor pwm_textcursor
	call5 apppwmwindows;

define global apppwmwindows(proc);
	lvars proc;
	pwmwindowscan(false, proc);
enddefine;

define pwm_select(win);
	lvars win;
	win -> pwm_selected;
	unless issubstring('gfx', 1, subscrv(6, win)) do
		win -> pwmtextwindow;
	endunless;
enddefine;

define global pwm_win_pixelsize();
	pwm_win_internalsize(pwm_selected);
enddefine;

define updaterof global pwm_win_pixelsize(vec);
	lvars vec;
	vec -> pwm_win_internalsize(pwm_selected);
enddefine;

define global pwm_win_position();
	pwm_window_location(pwm_selected);
enddefine;

define updaterof global pwm_win_position(vec);
	lvars vec;
	vec -> pwm_window_location(pwm_selected);
enddefine;

define global pwm_icon_position();
	pwm_icon_location(pwm_selected);
enddefine;

define updaterof global pwm_icon_position(vec);
	lvars vec;
	vec -> pwm_icon_location(pwm_selected);
enddefine;

define global pwm_openorclosed();
	pwm_win_openstate(pwm_selected);
enddefine;

define global pwm_exposewindow();
	pwm_expose_window(pwm_selected);
enddefine;

define global pwm_hidewindow();
	pwm_hide_window(pwm_selected);
enddefine;

define global pwm_refreshwindow();
	pwm_refresh_window(pwm_selected);
enddefine;

define global pwm_resizewindow();
	pwm_resize_window(pwm_selected);
enddefine;

define global pwm_openwindow();
	pwm_open_window(pwm_selected);
enddefine;

define global pwm_closewindow();
	pwm_close_window(pwm_selected);
enddefine;

define global pwm_icon_title();
	pwm_icon_label(pwm_selected);
enddefine;

define updaterof global pwm_icon_title();
	-> pwm_icon_label(pwm_selected);
enddefine;

define global pwm_window_title();
	pwm_window_label(pwm_selected);
enddefine;

define updaterof global pwm_window_title();
	-> pwm_window_label(pwm_selected);
enddefine;

define global pwm_movewindow();
	pwm_move_window(pwm_selected);
enddefine;

global vars pwm_currentmenu = false;

define global pwm_makemenu(s);
	s -> pwm_currentmenu;
enddefine;

define global pwm_invokemenu(s);
	lvars s x y;
	unless s.isstring do s, false -> s endunless -> y;
	unless y.isinteger do
		if y then mishap(y, 1, 'integer or false needed') else false endif
	endunless -> x;
	unless s do pwm_currentmenu -> s endunless;
	pwm_displaymenu(s, false)
enddefine;

define global pwm_normalcursor();
	pwm_setwincursor(pwmtextwindow, pwmstdcursor);
enddefine;

define global pwm_textcursor();
	pwm_setwincursor(pwmtextwindow, pwmtxtcursor);
enddefine;

define global poppwmwindows(window);
	lvars window;
	pwmeventhandler(window, false);
enddefine;

define updaterof global poppwmwindows(proc, window);
	lvars proc window;
	(procedure(event, proc);
		lvars event proc;
		proc(pwminputsource, event);
	endprocedure)(% proc %) -> pwmeventhandler(window, false);
enddefine;

global vars pwmsun_getselection = pwm_getselection;

;;; the reporter forms of the procedures above send an escape sequence to
;;; the terminal, and expect a complex sequence back,  which  they analyse
;;; to extract the required value.  If something goes wrong in the
;;; transmission or reception of one or the other, the procedure returns
;;; FALSE.
;;;
;;;     This procedure therefore makes up to five attempts to call
;;; the given procedure, and if FALSE is returned five times mishaps.
;;;
define global call5(proc);
	repeat  5 times
		if  .proc.dup then return else erase endif
	endrepeat;
	mishap(proc.pdprops, 1, 'cannot read tty value');
enddefine;

endsection;

global vars pwmsunutils = true; ;;; so that this can be loaded with "uses"

endsection;

/* --- Revision History ---------------------------------------------------
--- Ben Rubinstein, Mar  2 1987 - moved -poppwmwindows- into library
--- Ben Rubinstein, Jan 22 1987 - added redefn. of -apppwmwindows-
--- Ben Rubinstein, Dec  7 1986 - redefined to use new functions.
						These functions are now obsolete.
--- Ben Rubinstein, Oct  7 1986 - pwmpr takes delimiter character
--- Ben Rubinstein, Sep 21 1986 - added identity, tracking functions
--- Ben Rubinstein, Jun 12 1986 - revised for new escape sequences
--- Ben Rubinstein, May 30 1986 - fixed bug in pwm_icon_position
--- Ben Rubinstein, May  9 1986 - added pwmsun_getselection
*/
