/*  --- Copyright University of Sussex 1992.  All rights reserved. ---------
 > File:           C.pwm/lib/sun/vedmice.p
 > Purpose:        example of fun things to do with mice under PWM
 > Author:         Ben Rubinstein, Apr 1 1986 (see revisions)
 > Documentation:  HELP *PWMVED, *PWMWINDOWS
 > Related Files:  LIB *PWMSUNUTILS
 */
compile_mode :pop11 +strict;

/*
*  	on status line in header area (to the left of the command part):
*       left button scrolls up the command line file, right button scrolls
*           down it, middle button does command currently on status line.
*
*   elsewhere:
*       left button -
*           press-release with no move: jump to mouse cursor
*           moved: mark range
*
*       middle button -
*           press-release with no move: jump to mouse cursor
*           moved vertically or diagonally:
*				pull line mouse started on, up or down in window
*			moved horizontally:
*				pull file right or left in window
*           (cursor may be moved to keep it in the window)
*
*       right button -
*           invoke either a menu to do with the marked range, or (if the
*           mouse was on the status line) one to open and close various
*           windows
*
*       This file is not intended to be a definitive assignment of functions
*   to mouse buttons, but rather an example to show how such assignments can
*   be set up.
*
*/

uses-now poppwmlib;

section;

;;; menus and corresponding vectors of procedures, used for right-button-down
;;; in main area
;;;
lconstant
	menu1 = 'No marked range:\tYank\tCopy In\tMove In\tYank Word\t',
	prox1 = {% ident ved_yank, ident ved_ti, ident ved_mi, ident ved_yankw %},
	menu2 = 'Marked Range:\tClear\tLoad\tCopy here\tMove here\tCopy->buffer\tDelete\t',
	prox2 = {% ident ved_crm, ident ved_lmr, ident ved_t, ident ved_m,
											ident ved_copy, ident ved_d %};

;;; left and middle button down just save the mouse position here
;;;
lvars vedmousedownx = false, vedmousedowny = false;

;;; clean up - used eg if mouse exits window with a button pressed
;;;
define vars vedmice_resetcursor();
	pwm_setwincursor(wvedwindow, pwmstdcursor); ;;; reset normal mouse cursor
enddefine;

;;; menu to put up if right button pressed down in region of status line:
;;; offers to close all windows, or all except the current one; or to
;;; open and expose the window for any of the files.
;;;
define vars vedstatuslinemenu();
	lvars s w f files;
	;;; make a string with the names of files, seperated by tabs to be
	;;; different options in the menu
	cons_with consstring {% applist(vedbufferlist, procedure(f);
								lvars f;
								explode(subscrv(1, f)), `\t`
							endprocedure) %} -> files;

	;;; if it was very long, throw it away and make one with the filenames
	;;; abbreviated
	if files.datalength > 220 then
		cons_with consstring {% applist(vedbufferlist, procedure(f);
									lvars f;
									`|`,
									explode(sys_fname_nam(subscrv(1, f))),
									`\t`
								endprocedure) %} -> files;
	endif;
	;;; add a title to the menu and two more options, and display it
	pwm_display_menu('Files:\tClose rest\tClose all\t' <> files) -> s;
	if s then
		if s > 2 then
			;;; greater than two - user selected one of the file names
			wved_open_window(subscrv(33, subscrl(s - 2, vedbufferlist)));
		elseif s > 0 then
			;;; (if it was zero, none of the options selected.)
			;;; set up an argument to -pwm_scan_windows- to specify either
			;;; all windows, or all windows except the current ved one
			if s == 1 then [^wvedwindow text ved gfx base] else false endif;
			;;; and call -pwm_scan_windows- to close all the specified windows
			pwm_scan_windows(wved_close_window);
		endif;
	else	;;; result was false - something went wrong in the menu call
		vederror('Couldn\'t read menu result ' >< s)
	endif;
enddefine;

;;; put up a menu according to whether or not there's a marked range, and
;;;	left -pwm_make_menucall- call an appropriate procedure according to the result
;;;
define vars vedrangemenu();
	unless pwm_make_menucall(
			if	vvedmarklo > vvedmarkhi	;;; if there's no marked range
			then menu1, prox1, false
			else menu2, prox2, false
			endif) then
		vederror('bad result on menu invocation')
	endunless
enddefine;

;;; jump to the position in the file specified by the given screen
;;; coordinates (obtained from the mouse)
;;;
define vars vedjumptomouse(x, y);
	lvars x y;
	if x == 0			;;; the column used to display the marked range mark
	or (y == 0 and x < 10) then	;;; status line to left of command area
		vederror('can\'t move cursor there')
	else
		if  y > 0 then	;;; not on status line
			if vedonstatus then vedstatusswitch() endif;
			vedjumpto(vedlineoffset + y, vedcolumnoffset + x)
		else
			unless vedonstatus do vedstatusswitch() endunless;
			vedjumpto(vedline, vedcolumnoffset + x - 9)
		endif;
	endif
enddefine;

;;; left button: mark range.
;;; -x- and -y- are the position where the mouse was released; the position
;;;	at which it was pressed was saved in -vedmousedownx- and -vedmousedowny-
;;;
define vars vedmousemarkrange(x, y);
	lvars x y;
	dlocal vedline, vedcolumn;	;;; localise these so we don't move cursor
	if y == 0 or vedmousedowny == 0 then
		vederror('can\'t mark status line')		;;; that's true!
	else
		vedjumpto(vedlineoffset + min(y, vedmousedowny), vedcolumn);
		vedmarklo();
		vedjumpto(vedlineoffset + max(y, vedmousedowny), vedcolumn);
		vedmarkhi();
	endif
enddefine;

;;; pull file in window - vertically if any vertical movement, else sideways.
;;; -x- and -y- are the position where the mouse was released; the position
;;;	at which it was pressed was saved in -vedmousedownx- and -vedmousedowny-
;;;
define vars vedmousepullfile(x, y);
	lvars x y vl vc vlo vco;

	;;; save these so we know if we ended up moving at all
	vedline -> vl;			vedcolumn -> vc;
	vedlineoffset -> vlo;	vedcolumnoffset -> vco;

	;;; check in reasonable position, and calculate new offset for window
	;;; into file.  Then adjust cursor position if necessary to make sure
	;;; it's in the window.
	if y == 0 or vedmousedowny == 0 then
		vederror('can\'t drag to/from status line')
	elseif y == vedmousedowny then		;;; only horizontal movement
		max(x, 1) -> x;
		max(vedmousedownx, 1) -> vedmousedownx;
		max(0, vedcolumnoffset - x + vedmousedownx) -> vedcolumnoffset;
		max(vedcolumn, vedcolumnoffset + 1) -> vedcolumn;
		min(vedcolumn, vedcolumnoffset + vedscreenwidth + 1) -> vedcolumn
	else
		max(0, vedlineoffset - y + vedmousedowny) -> vedlineoffset;
		max(vedline, vedlineoffset + 1) -> vedline;
		min(vedline, vedlineoffset + vedscreenlength - 1) -> vedline;
	endif;

	;;; see whether we moved, and if so refresh
	unless	vedline == vl 		 and vedcolumn == vc
	and		vedlineoffset == vlo and vedcolumnoffset == vco do
		vedrefresh();
	endunless;
enddefine;

;;; scroll up or down in the status line file: -up- is true for right button,
;;; false for left button
;;;
define vars vedmousestatusscroll(up);
	lvars onstatus up;
	;;; make sure we're on status line, and save whether we already were
	unless (vedonstatus ->> onstatus) do vedswitchstatus() endunless;

	;;; see whether we can move, and if not restore the old position before
	;;; complaining
	if (up and vedline == 1) or (not(up) and vedatend()) then
		unless (onstatus) do vedswitchstatus() endunless;
		vederror(if up then 'TOP OF STATUS LINE FILE'
					else 'END OF STATUS LINE FILE' endif);
	else	;;; move!
		if up then vedcharup() else vedchardown() endif;
	endif;

	;;; leave cursor at end of new command
	vedtextright();

	;;; if cursor wasn't on status line, put it back where it belongs
	unless (onstatus) do vedswitchstatus() endunless;
enddefine;

;;; catch a 'mouse down' event, decode the coordinates, and call a procedure
;;; to handle it.  -b- is button, -x- and -y- the position it was pressed at
;;;
define vars vedmice_respond_mousedown(b, x, y);
	lvars b x y;
	if b == 3 then			;;; button is a menu of one kind or another,
		if y > 0 then		;;; except in leftmost portion of status line
			vedrangemenu();
		elseunless x < 9 then
			vedstatuslinemenu();
		endif
	elseif y > 0 or x > 9 then	;;; don't do anything for leftmost bit of
		x -> vedmousedownx;		;;; status line (all done when the button is
		y -> vedmousedowny;		;;; released) otherwise save position and
		pwm_setwincursor(wvedwindow, pwmtxtcursor)	;;; change cursor
	endif;
enddefine;

;;; catch a 'mouse up' event, decode the -coordinates-, and call a
;;; procedure to handle it
;;;
define vars vedmice_respond_mouseup(b, x, y);
	lvars b x y;
	if y == 0 and x < 9 then	;;; leftmost bit of status line
		if      b == 1 then vedmousestatusscroll(true)		;;; true = up
		elseif  b == 2 then vedredocommand()
		elseif  b == 3 then vedmousestatusscroll(false)
		endif
	else
		vedmice_resetcursor();	;;; cursor was set to a funny - put it back
		if y == vedmousedowny and (y == 0 or x == vedmousedownx) then
			vedjumptomouse(x, y)		;;; mouse not moved, or on status line
		elseif b == 1 then				;;; moved with left button down
			vedmousemarkrange(x, y);	;;; - use it to mark a range
		elseif b == 2 then				;;; moved with middle button down
			vedmousepullfile(x, y);		;;; - use it to scroll the window
		endif;
	endif;
enddefine;

sys_runtime_apply(
	procedure;
		fill(vedmice_respond_mousedown,		;;; mouse button pressed
			vedmice_respond_mouseup,		;;;	mouse button released
			#_< erasenum(% 3 %) >_#,		;;; mouse moved (do nothing)
			vedmice_resetcursor,			;;; mouse exit window - reset cursor
			vedpwmmousetraps) ->
	endprocedure);

constant vedmice = true;			;;; for uses

endsection;

/* --- Revision History ---------------------------------------------------
--- John Gibson, Dec 14 1992
		o After changing pwm_make_menucall to allow idents in proclist,
		  changed prox1 & 2 to contain ved command ids instead of procedures
		o Made last fill be a runtime action
--- John Williams, Aug  5 1992	- added -vedmice- for -uses-
--- Ben Rubinstein, Mar  5 1987 - added lots more comments for tutorial use
--- Ben Rubinstein, Feb 24 1987 - fixed bug in sideways pull
--- Ben Rubinstein, Dec 11 1986 - rewrote to use new functions
--- Ben Rubinstein, Sep 10 1986 - generalised for easy recustomisation
--- Ben Rubinstein, Aug 10 1986 - cleaned up a few more rough edges
--- Ben Rubinstein, Jun 25 1986 - added "no marked range" menu
--- Ben Rubinstein, Jun 20 1986 - cleaned up a few rough edges
*/
