/*  --- Copyright University of Sussex 1994.  All rights reserved. ---------
 > File:            C.pwm/lib/ved/term/vedpwmsunscreen.p
 > Purpose:         Configure Ved for the Sun Poplog Window Manager.
 > Author:          Ben Rubinstein, Apr  1 1986 (see revisions)
 > Documentation:   HELP *VEDPWM
 > Related Files:   LIB *PWMSUNUTILS *PWMSGRAPHICS
					LIB *VEDPWMSUN *VEDPWMSUNKEYS
 */
compile_mode :pop11 +strict;

section;

vars procedure vedsunrefresh;

define lconstant refresh() with_props vedsunrefresh;
	pwm_check_window_size(wvedwindow);
enddefine;

define vedpwmsunscreen();
	dlocal vedscreengraphtrans;		;;; keep the default value of this
	vedvi200screen();
	refresh -> vedsunrefresh;
	"pwmsun" -> vedterminalname;
	false -> vedscrollscreen;
enddefine;

endsection;


/* --- Revision History ---------------------------------------------------
--- John Gibson, Mar 16 1994
		Added declaration for vedsunrefresh
--- John Gibson, Feb 14 1992
		Added dlocal for vedscreengraphtrans and removed vedset g*raphic
--- Andreas Schoter, Mar 28 1990
		Repackaged the library to work with -vedinitterm-
--- Rob Duncan, Oct 30 1989
		Rewrote to work with new VED startup procedure: packaged everything
		into procedure -vedpwmsun-, added explicit calls to -vedvi200screen-
		and -vedsunkeys- and deleted some unnecessary assignments.
		Sectionised.
--- Ben Rubinstein, Jun 20 1986 - fixed vedsunrefresh, vved...pad for new
								sequence set
--- Mark Rubinstein, May  1 1986 - changed the construction of vedstatusheader
	so that there are no hi bit characters in the file.
*/
