/* --- Copyright University of Sussex 1987.  All rights reserved. ---------
 * File:        C.pwm/pwm/pwimages.h
 * Purpose:     images for icons and cursors
 * Author:      Ben Rubinstein, Feb 20 1987
 */


unsigned short poplog_icon[256] = {     /* "images/poplog.icon" */
	0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x8000,0x0000,0x0000,0x00F1,
	0x8000,0x0000,0x0100,0x01A9,0x8000,0x0000,0x0200,0x0355,
	0x8000,0x0000,0x0200,0x02AB,0x8000,0x0000,0x0000,0x0155,
	0x8000,0x0000,0x0200,0x01AB,0x8000,0x0000,0x0408,0x0755,
	0x8000,0x0000,0x0400,0x1AAB,0x8000,0x0000,0x0000,0x755D,
	0x9DF0,0x1F1D,0xF000,0xAA93,0x8E38,0x238E,0x3800,0x5561,
	0x8C1C,0x41CC,0x1C00,0x2AA1,0x8C0C,0xC0CC,0x0C20,0x1541,
	0x8C0C,0xC0CC,0x0C40,0x0AC1,0x8C0C,0xC0CC,0x0C80,0x0581,
	0x8C0C,0xC0CC,0x0C00,0x0281,0x8C08,0xE08C,0x0808,0x4101,
	0x8E10,0x710E,0x1031,0x8001,0x8FE0,0x3E0F,0xE042,0x0001,
	0x8C00,0x000C,0x0084,0x0001,0x8C00,0x000C,0x0018,0x00C1,
	0x8C00,0x000C,0x0020,0x0701,0x8C00,0x000C,0x00C0,0x1801,
	0x9E00,0x001E,0x0100,0x6001,0x8000,0x0000,0x8200,0x0001,
	0x8000,0x0000,0x0C00,0x0081,0x8000,0x0000,0x1000,0x00E1,
	0x8000,0x0006,0x000F,0x0701,0x8000,0x000F,0x03F0,0x0001,
	0x8000,0x001D,0x8000,0x0001,0x8000,0x001A,0xC000,0x0001,
	0x8000,0x0039,0x6000,0x0001,0x8000,0x006C,0xB03E,0x0001,
	0x8000,0x00E7,0x7000,0x3E01,0x8000,0x01A3,0xE000,0x0001,
	0x8000,0x0399,0xC000,0x0101,0x8000,0x068B,0x8000,0x0001,
	0x8000,0x0E66,0x0000,0x0001,0x8000,0x1A2C,0x0000,0x0001,
	0x8000,0x3998,0x0000,0x0001,0x8003,0xECB3,0xC000,0x0001,
	0x807F,0xA260,0xC000,0x0001,0x83C1,0x3AC0,0xC000,0x0001,
	0x8E01,0xC980,0xC000,0x0001,0x9802,0x2F00,0xC000,0x0001,
	0xB000,0x2200,0xC07C,0x0F91,0xE181,0x3A00,0xC08E,0x18F1,
	0xC000,0x0E00,0xC107,0x3061,0x8020,0x0600,0xC303,0x3061,
	0x8100,0x4400,0xC303,0x3061,0xA421,0x2400,0xC303,0x18C1,
	0x8800,0x0400,0xC303,0x1F81,0x8000,0x0400,0xC382,0x3001,
	0x8100,0x0C00,0xC1C4,0x3FE1,0x8001,0x0803,0xF0F8,0x1FF1,
	0x8810,0x0800,0x0000,0x1031,0x8400,0x5800,0x0000,0x2011,
	0x8410,0x1000,0x0000,0x2011,0x8000,0x3000,0x0000,0x3FE1,
	0x9400,0x6000,0x0000,0x1FC1,0x8122,0xC000,0x0000,0x0001,
	0x8001,0x8000,0x0000,0x0001,0xFFFF,0xFFFF,0xFFFF,0xFFFF
};
DEFINE_ICON_FROM_IMAGE(popicon, poplog_icon);

unsigned short ved_icon[256] = {        /* images/ved.icon */
	0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x8010,0x0001,0x8000,0x0001,
	0x8030,0x0001,0x8000,0x0001,0xE020,0x0001,0x8000,0x0001,
	0xA020,0x0001,0x8000,0x0001,0xA060,0xE01F,0x0000,0x0001,
	0x9041,0x207D,0x8000,0x0001,0x9882,0x1071,0x0000,0x0001,
	0x8884,0x2041,0x8000,0x0001,0x8C84,0xE0C1,0x8000,0x0001,
	0x8487,0x8381,0x8000,0x0001,0x8684,0x04C1,0x8000,0x0001,
	0x8386,0x0842,0x4000,0x0001,0x8302,0x183E,0x5E00,0x0001,
	0x8101,0x1004,0x6600,0x0001,0x8100,0xE000,0x7C00,0x0001,
	0x8000,0x0001,0x8000,0x0001,0x8000,0x0006,0x0000,0x0001,
	0x8000,0x0038,0x0000,0x0001,0x8000,0x00C0,0x0000,0x0001,
	0x8000,0x3F00,0x0000,0x0001,0x8000,0xC000,0x0000,0x0001,
	0x8000,0xE000,0x0000,0x0001,0x8000,0x7800,0x0000,0x0001,
	0x8000,0x7F00,0x0000,0x0001,0x8000,0x3CE0,0x0000,0x0001,
	0x8000,0x381C,0x0000,0x0001,0x8000,0x1003,0x0000,0x0001,
	0x8000,0x1003,0x8000,0x0001,0x8000,0x0802,0x4000,0x0001,
	0x8000,0x040F,0x2000,0x0001,0x8000,0x0419,0x9000,0x0001,
	0x8000,0x0218,0xC800,0x0001,0x8000,0x0272,0x2400,0x0001,
	0x8000,0x01A4,0x5200,0x0001,0x8000,0x0151,0x1900,0x0001,
	0x8000,0x00A8,0x8C80,0x0001,0x8000,0x0056,0x2240,0x0001,
	0x8000,0x002A,0x4520,0x0001,0x8000,0x0015,0x1190,0x0001,
	0x8000,0x000A,0x8848,0x0001,0x8000,0x0005,0x6224,0x0001,
	0x8000,0x0002,0xA452,0x0001,0x8000,0x0001,0x5109,0x0001,
	0x8000,0x0000,0xA88C,0x8001,0x8000,0x0000,0x5622,0x4001,
	0x8000,0x0000,0x2A45,0x2001,0x8000,0x0000,0x1511,0x9001,
	0x8000,0x0000,0x0A88,0xC801,0x8000,0x0000,0x0562,0x2401,
	0x8000,0x0000,0x02A4,0x5201,0x8000,0x0000,0x0151,0x1901,
	0x8000,0x0000,0x00A8,0x8C81,0x8000,0x0000,0x0056,0x2241,
	0x8000,0x0000,0x002A,0x4521,0x8000,0x0000,0x0015,0x1191,
	0x8000,0x0000,0x000A,0x88C9,0x8000,0x0000,0x0005,0x6225,
	0x8000,0x0000,0x0002,0xA453,0x8000,0x0000,0x0001,0x5119,
	0x8000,0x0000,0x0000,0xA88D,0x8000,0x0000,0x0000,0x5623,
	0x8000,0x0000,0x0000,0x2A45,0xFFFF,0xFFFF,0xFFFF,0xFFFF
};
DEFINE_ICON_FROM_IMAGE(vedicon, ved_icon);

/* this is basically "/usr/include/images/painting_hand.pr",
*  with extra white border to make it wider.
*/

unsigned short gfx_icon[256] = {
	0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8006,0x0000,0x0000,0x0001,
	0x8003,0x8000,0x0000,0x0001,0x8000,0xE000,0x0000,0x0001,
	0x8000,0x3800,0x0000,0x0001,0x8000,0x0E00,0x0000,0x0001,
	0x8000,0x0380,0x0000,0x0001,0x8000,0x00E0,0x0000,0x0001,
	0x8000,0x0038,0x0000,0x0001,0x8000,0x03FF,0xF800,0x0001,
	0x8000,0x0800,0x0600,0x0001,0x8000,0x1000,0x0180,0x0001,
	0x8000,0x2080,0x0060,0x0001,0x8000,0x204F,0xD018,0x0001,
	0x8000,0x4000,0x0E04,0x0001,0x8000,0x8000,0x0184,0x0001,
	0x8001,0x0000,0x0064,0x0001,0x8001,0x0005,0xF018,0x0001,
	0x8002,0x0000,0x0410,0x0001,0x8004,0x0000,0x010F,0x0001,
	0x8008,0x0000,0x00C5,0xC001,0x8008,0x0001,0xF024,0x7001,
	0x8010,0x0000,0x061C,0x3C01,0x8000,0x0000,0x0188,0x1C01,
	0x8050,0x0000,0x0048,0x0C01,0x8088,0x0007,0xF8B0,0x0401,
	0x8104,0x0018,0x0700,0x0001,0x8202,0x0060,0x0000,0x0001,
	0x8201,0x0080,0x0000,0x0001,0x8100,0x8300,0x0000,0x0001,
	0x8080,0x4C00,0x0000,0x0001,0x8042,0x0000,0x0000,0x0001,
	0x8020,0x4000,0x0000,0x0001,0x8010,0x8000,0x0000,0x0001,
	0x8009,0x0000,0x0000,0x0001,0x8006,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0xFFFF,0xFFFF,0xFFFF,0xFFFF
};
DEFINE_ICON_FROM_IMAGE(gfxicon, gfx_icon);

unsigned short txt_icon[256] = {
	0xFFFF,0xFFFF,0xFFFF,0xFFFF,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8055,0x5150,0x1505,0x5501,0x80AA,0xA0A8,0x2A0A,0xAA01,
	0x8055,0x5054,0x5405,0x5501,0x80AA,0xA02A,0xA80A,0xAA01,
	0x8005,0x0015,0x5000,0x5001,0x800A,0x000A,0xA000,0xA001,
	0x8005,0x0005,0x4000,0x5001,0x800A,0x0002,0x8000,0xA001,
	0x8005,0x0001,0x4000,0x5001,0x800A,0x0002,0xA000,0xA001,
	0x8005,0x0005,0x5000,0x5001,0x800A,0x000A,0xA800,0xA001,
	0x8005,0x0015,0x5400,0x5001,0x800A,0x002A,0x2A00,0xA001,
	0x8005,0x0054,0x1500,0x5001,0x800A,0x00A8,0x0A80,0xA001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8FDC,0x7F96,0xB8F9,0xFFB1,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8F7F,0xFDF2,0x5FF9,0xFFF1,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8FB5,0xBFFF,0xFBE7,0xBFF1,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8FBB,0xFF94,0x7E0E,0x3E31,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8F9F,0xFF7E,0x1E3F,0xFEF1,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8EF9,0xFFDF,0xFBFE,0xEFF1,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8FFF,0xF6A9,0xFF94,0xCF31,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8EBB,0xFDFF,0xBE66,0xFFF1,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8CFF,0xF732,0xAEDB,0xFD71,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0x8000,0x0000,0x0000,0x0001,
	0x8000,0x0000,0x0000,0x0001,0xFFFF,0xFFFF,0xFFFF,0xFFFF
};
DEFINE_ICON_FROM_IMAGE(txticon, txt_icon);

static short txt_cursor1[] = {      /* "images/txt.cursor" */
	0x8000,0xC000,0xE000,0xF000,0xF800,0xFC00,0xFE00,0xF000,
	0xD800,0x9800,0x0C00,0x0C00,0x0600,0x0600,0x0300,0x0300
};
DEFINE_CURSOR_FROM_IMAGE(txtcursor1, 1, 1, PIX_SRC | PIX_DST, txt_cursor1);

static short txt_cursor2[] = {      /* "images/text.cursor" */
	0x3C78,0x0280,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,
	0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0280,0x3C78
};
DEFINE_CURSOR_FROM_IMAGE(txtcursor2, 7, 7, PIX_SRC | PIX_DST, txt_cursor2);

static short gfx_cursor[] = {       /* "images/gfx.cursor" */
	0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0380,0xFEFE,
	0x0380,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0000
};
DEFINE_CURSOR_FROM_IMAGE(gfxcursor, 7, 7, PIX_SRC ^ PIX_DST, gfx_cursor);

DEFINE_CURSOR_FROM_IMAGE(nullcursor, 0, 0, PIX_DST, NULL);
