/* --- Copyright University of Sussex 1992.  All rights reserved. ---------
 > File:            C.pwm/src/pwmdeclare.ph
 > Purpose:         PWM MACROS
 > Author:          Ben Rubinstein, Feb 10 1987 (see revisions)
 */


lconstant macro (

	;;; PWMWINDOW subscript macros
	PW_OPEN     = 1,   ;;; true/false = open/iconic
	PW_WIDTH    = 2,   ;;; internal width in characters/pixels
	PW_HEIGHT   = 3,   ;;; internal height in characters/pixels
	PW_FILE     = 4,   ;;; iff ved window, name of file; else false
	PW_CHANGED  = 5,   ;;; iff ved window, boolean:
						;;;         iff true, vedsetonscreen must refresh
	PW_WTYPE    = 5,    ;;;  else id string for type of window
	PW_TRAPS    = 6,   ;;; responders to mouse events: in user window,
						;;;     a proc. or property, else vector of 4 prox

	PW_PWLENGTH        = 6,

	;;; maximum number of windows it is possible to have
	PWM_MAXWINDOWS = 64,

	;;;  arguments to pwm_pwmcommand
	PWMCOM_EXTERN       = `0`,  ;;; tell PWM it's not connected to POPLOG
	PWMCOM_CONNECTED    = `1`,  ;;; tell PWM it's connected to POPLOG

	PWMCOM_SUSPENDED    = `2`,  ;;; tell PWM POPLOG's not listening to it
	PWMCOM_RESTORED     = `3`,  ;;; tell PWM POPLOG is listening to it

	PWMCOM_BASECOOKED   = `4`,  ;;; ask the PWM to be a cooked tty in base win
	PWMCOM_BASERAW      = `5`,  ;;; ask the PWM to be a raw tty in base win

	PWMCOM_VEDCOOKED    = `6`,  ;;; ask the PWM to be a cooked tty in ved wins
	PWMCOM_VEDRAW       = `7`,  ;;; ask the PWM to be a raw tty in ved windows

	PWMCOM_RESETIN      = `8`,  ;;; report source of next input

	;;; special id char to set attributes of pre-natal window
	PWM_NXTWIN_ID = 90,

	PWM_LOADED	= [testdef ispwm_id],
	PWM_WEAK	= [weakref[ispwm_id]],
	);


;;;  all the items (such as windows, menus, etc) which the pwm can
;;; dynamically create and destroy are referenced via a special record,
;;; which allows the garbage collector to instruct the PWM to release the
;;; resource if the user has lost all references to it.
;;; The essential fields of these id records are a procedure which can be
;;; be used to kill it, which both serves to identify the kind of resource
;;; and is used by the garbage collector, and the id which is actually used
;;; to specify the item in communications with the PWM. All other data
;;; about the record is stored in a vector hanging off the third field.
;;; If the item has already been destroyed, the idchar is replaced by false.

struct PWM_ID
	{ full  PWM_KILLPROC,
			KEY,
>->			PWM_IDCHAR,
			PWM_INFO;
	};


/* N.B. Don't put any permanent identifier declarations in this file */


/* --- Revision History ---------------------------------------------------
--- John Gibson, Dec 11 1992
		Removed identifier declarations, added comment
--- Simon Nichols, Nov 21 1991
		Increased PWM_MAXWINDOWS from 16 to 64.
--- John Gibson, Jun  8 1991
		wved_ rationalisation
--- Aaron Sloman, Oct 23 1990
	renamed pwm_set_vedsize as wved_set_size
--- Aaron Sloman, Sep 26 1990
	Added wved_should_warp_mouse
	Replaced Pwmwindowchanged with wved_is_changed_window and made it vars
	Made wved_open_window, pwm_close_window, wvedtextwindow and other
	things vars
--- John Gibson, Jan  7 1990
		Changes for new pointers.
--- John Gibson, Feb 15 1988
		Added macros PWM_LOADED and PWM_WEAK
 */
