/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            C.pwm/src/pwmio.p
 > Purpose:
 > Author:          Ben Rubenstein (see revisions)
 */

;;; --------------------- PWM I/O ROUTINES -------------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'io.ph'
#_INCLUDE 'unixdefs.ph'
#_INCLUDE 'unix_tty.ph'

section $-Sys$-Io;

constant
		procedure Do_interact_read
	;

endsection;

;;; ----------------------------------------------------------------------

section $-Sys => pwmensureprompt;

	/*	Ensure that next call of Pwmterm_read (below) will issue a prompt.
		Used by setpop, ved_pop.
	*/
define vars pwmensureprompt(flag);
	lvars flag;
	if flag then
		dev_in!D_FLAGS _biset _M_D_TERM_PROMPT
	else
		dev_in!D_FLAGS _biclear _M_D_TERM_PROMPT
	endif -> dev_in!D_FLAGS
enddefine;

	/*	Read PWM 'terminal'
		Will only be called for dev_in
	*/
define lconstant Pwmterm_read(dev, _bsub, userbuf, _nbytes);
	lvars buf = dev!D_IN_BUFFER, dev, userbuf, _count, _nbytes, _bsub;

	if (Io$-Do_interact_read(dev) -> _count) then
		;;; some new input was read
		if _zero(_count) then
			dev!D_FLAGS _biset _M_D_TERM_PROMPT -> dev!D_FLAGS;
			return(0)
		elseif buf!BUF_START[_count _sub _1] == _:`\n` then
			dev!D_FLAGS _biset _M_D_TERM_PROMPT -> dev!D_FLAGS
		elseif buf!BUF_START[_count _sub _1] == _:`\^Z` then
			;;; PWM cannot 'send' a termin, so we have to do it on ^Z
			;;;		(temporary version 13 only)
			dev!D_FLAGS _biset _M_D_TERM_PROMPT -> dev!D_FLAGS;
			_count _sub _1 ->> _count -> buf!BUF_COUNT;
			returnif(_zero(_count)) (0)
		else
			dev!D_FLAGS _biclear _M_D_TERM_PROMPT -> dev!D_FLAGS
		endif
	endif;

	_int(_nbytes) -> _nbytes;
	if _nbytes _lt _count then _nbytes -> _count endif;
	_bmove(@@(b)[_count], buf@BUF_START[buf!BUF_POSITION],
									userbuf@(w->b)[_int(_bsub) _sub _1]) -> ;
	buf!BUF_POSITION _add _count -> buf!BUF_POSITION;
	_pint(_count)
enddefine;

	/*	Alter dev_in to work with a PWM
	*/
define Pwm$-Make_devin();
	lvars tcb;
	Pwmterm_read -> dev_in!D_READ;
	raw_dev_in!D_IN_BUFFER -> dev_in!D_IN_BUFFER;
	;;; set rare mode on popdevin
	dev_in!D_CTRL_BLK -> tcb;
	true -> tcb!TCB_ARG3;
	false -> tcb!TCB_PARAMS_SETUP
enddefine;

endsection;		/* $-Sys */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Apr 21 1994
		Moved to C.pwm
--- John Gibson, Mar 17 1994
		Moved from C.unix to C.sun, and added #_TERMIN_IF making file empty
		for anything but SunOS 4.
--- John Gibson, Oct 22 1990
		Changed -Pwmterm_read- to have new-style args for device read
		procedures.
--- Aaron Sloman, Sep 28 1990
		made pwmensureprompt vars
--- John Gibson, Aug 28 1989
		Changed method of setting popdevin tty params to rare mode
		in -Make_devin-
--- John Gibson, Aug 22 1989
		Included unix_tty.ph
--- John Gibson, Feb 21 1989
		Simplified to use -Do_interact_read- in devio.p. The flag
		_M_D_GOT_EOL was performing the same function as _M_D_TERM_PROMPT,
		so replaced it with the latter.
--- John Gibson, Feb 19 1989
		Added _M_D_TERM_PROMPT to dev_in flags (replaces _M_D_RAWTERM
		not being set).
		Included io.ph
--- John Gibson, Mar 28 1988
		Moved out of sysio.p
 */
