/* --- Copyright University of Sussex 1995.	 All rights reserved. ---------
 > File:		C.pwm/ved/src/vdpwm.p
 > Purpose:		USING THE POPLOG WINDOW MANAGER
 > Author:		Ben Rubinstein, Nov	 8 1986 (see revisions)
 */

#_INCLUDE 'vddeclare.ph'
#_INCLUDE '../../src/pwmdeclare.ph'

constant procedure (
		vedansiscreenxy, vedinascii, vedpwm_doinputevent,
		vedsetkey, vedvt52screenxy,

		checkpwmcmsid, checkpwmcursid, checkpwmfontid, checkpwmmenuid,

		pwm_kill_cursor, pwm_kill_font, pwm_kill_menu, pwm_kill_page,
		pwmsendmessage, pwmsun_kill_cms, pwm_select_window,

		wved_set_size,
		Sys$-Ved$-Write_one_file, Sys$-Ved$-Set_poplinemax
	);

vars procedure (
		ved_rrq, ved_q, ved_ved,
		handlepopescape, vedtermsetup, vedscreenraw, vedscreencooked,
		vedscreenxy, vedwinresized,
		pwm_inputcatcher, pwm_quit_window, pwmensureprompt,

		wved_window_size, wved_is_live_window, wved_is_open_window,
		wved_create_window, wved_destroy_window, wved_open_window,
		wved_close_window, wved_raise_window, wved_get_one_input,
		wved_icon_label, wved_do_interrupt_trap,
		wved_mishap_reset, wved_ved_name_hook,
		wved_set_input_focus, wved_window_label,
	);

vars
		wvedwindowchanged, wvedbreaktofit,
	;


lvars
	Pwmtextwindow,
	Pwmgfxwindow,
	;


;;; --- DECLARATIONS -------------------------------------------------------


;;; this is consulted by vedswapfiles and vedsetonscreen.  If true, the user
;;; explicitly asked to switch files (either by escape-x or by enter ved
;;; etc): so we should open the window and move the mouse into it
;;; (vedswapfiles) or ask the PWM to tell us the source of the next input.
;;; if we don't do the latter, then when the user 'ved's a file already in
;;; the buffer, which may be closed, ved assumes that the next input is
;;; directed into that file, when in fact the user may still be typing away
;;; in some other window, wondering why nothing is happening.  If on the
;;; other hand ved always requested the PWM to report the source of the
;;; next input, then it would re-edit files for every character that was
;;; pressed.
;;;
vars
	$-Sys$-Pwm$-user_switch = true;

vars
	;;; iff false, there was a communications failure during the last attempt
	;;; to get a report from the pwm
	pwmgotreport = true,

	;;; called by sysexit
	procedure pwmexit	= identfn,

	;

;;; --- ESCAPE SEQUENCES ---------------------------------------------------

lconstant
	Pwmc_numberterm		=	`t`,
	Pwms_numberterm		=	't',
	Pwmc_stringterm1	=	`\^[`,
	Pwmc_stringterm2	=	`\\`,
	Pwms_stringterm		=	'\^[\\',

	Pwms_digimesshead = '\^[^',		;;; the lead two characters of a message
									;;; from the pwm which does not contain
									;;; a string - used by Setup_ved

	Pwms_idresult		=	'\^[^ZI%it',

	Pwms_repinevent		=	'\^[^i%c%ct',


	Pwms_quitrequest	= writeable '^IQ t',  ;;; used for checking

	Pwms_txtselect		=	'\^[{ST%it',
	Pwms_forceselect	=	'\^[{SI%it',
	Pwms_gfxsetsurf		=	'\^[{SG%it',

	Pwms_killwindow		=	'\^[{Kw%it',
	Pwms_killcursor	 =	 '\^[{Kc%it',
	Pwms_killmenu	   =   '\^[{Km%it',
	Pwms_gfxkillpage	=	'\^[{Ks%it',
	Pwms_gfxkillfont	=	'\^[{Kf%it',
	Pwms_gfxkillcms		=	'\^[{KC%it',

	Pwms_advidentity	=	'\^[{APit',
	Pwms_repidentity	=	'\^[~RP%s\t%s\t%d;%d;%d\t%s\t%s\t%d;%d\t%d;%d;%d\^[\\',

	Pwms_setwtitle		=	'\^[}FT%i%s\^[\\',
	Pwms_getwtitle		=	'\^[{AT%it',
	Pwms_repwtitle		=	'\^[~FT%s\^[\\',
	Pwms_setititle		=	'\^[}Ft%i%s\^[\\',
	Pwms_getititle		=	'\^[{At%it',
	Pwms_repititle		=	'\^[~Ft%s\^[\\',

	Pwms_setinternsize	=	'\^[{Fs%i%d;%dt',
	Pwms_getinternsize	=	'\^[{As%it',
	Pwms_repinternsize	=	'\^[^Ur%i%d;%dt',
	Pwms_repinternsize_head = '\^[^Ur',

	Pwms_pwmcommand =	'\^[{VC%ct',
	Pwms_oneinput		=	'\^[{AP1t',

	Pwms_closewin		=	'\^[{WC%it',
	Pwms_openwin		=	'\^[{WO%it',
	Pwms_exposewin		=	'\^[{WE%it',	;;; added A.S. Sept 1990

	Pwms_tidywindows	=	'\^[}Sw%s\^[\\',
	Pwms_promptuser		=	'\^[}Up%d;%s\^[\\',

	Pwms_maketxtwin		=	'\^[}Nwt%i%d;%d;%s\^[\\',
	Pwms_makegfxwin		=	'\^[}Nwg%i%d;%d;%s\^[\\',
	Pwms_makevedwin		=	'\^[}Nwv%i%d;%d;%s\^[\\',

	Pwms_adviseifopen	=	'\^[{AI%it',
	Pwms_repopenstate	=	'\^[^I%c%it',
	;

vars pwminputsource;	;;; forward

define lconstant Kill_window(w);
	lvars w c;
	if (w!PWM_IDCHAR ->> c) then
		pwmsendmessage(c, Pwms_killwindow, true);
		false -> w!PWM_IDCHAR;
	endif;
	if w == pwminputsource then false -> pwminputsource endif;
	if w == Pwmgfxwindow then pwmbasewindow -> Pwmgfxwindow endif;
	if w == Pwmtextwindow then pwmbasewindow -> Pwmtextwindow endif;
enddefine;


;;; --- RESOURCE RECORDS ----------------------------------------------------

;;;	 all the items (such as windows, menus, etc) which the pwm can
;;; dynamically create and destroy are referenced via a special record,
;;; which allows the garbage collector to instruct the PWM to release the
;;; resource if the user has lost all references to it.
;;; The essential fi;;; be used to kill it, which both serves to identify the kind of resource
;;; and is used by the garbage collector, and the id which is actually used
;;; to specify the item in communications with the PWM. All other data
;;; about the record is stored in a vector hanging off the third field.
;;; If the item has already been destroyed, the idchar is replaced by false.

lconstant	pwm_id_key;

define ispwm_id(obj);
	lvars obj;
	if iscompound(obj) and obj!KEY == pwm_id_key then true
	else false
	endif;
enddefine;

define lconstant Pwm_id_print(id);
	lvars id, kproc, f;
	dlocal pop_pr_quotes = false, pop_pr_radix = 10;
	id!PWM_KILLPROC -> kproc;
	sys_syspr(if id!PWM_IDCHAR then '<pwm-' else '<DEAD pwm-' endif);
	if kproc == Kill_window then
		if (fast_subscrv(PW_FILE, id!PWM_INFO) ->> f) then
			sys_syspr('ved-window ');
			sys_syspr(f);
		elseif ispair(fast_subscrv(PW_WTYPE, id!PWM_INFO) ->> f) then
			sys_syspr(f.fast_front);
			sys_syspr('-window: ');
			sys_syspr(f.fast_back);
		else
			sys_syspr(f);
			sys_syspr('-window');
		endif;
	elseif kproc == pwm_kill_font then
			sys_syspr('font ');
			sys_syspr(subscrv(4, id!PWM_INFO));
	else
		if kproc == pwm_kill_cursor then
			sys_syspr('cursor ');
		elseif kproc == pwm_kill_menu then
			sys_syspr('menu ');
		elseif kproc == pwm_kill_page then
			sys_syspr('page ');
		elseif kproc == pwmsun_kill_cms then
			sys_syspr('cms ');
		else
			sys_syspr('OBJECT ');
			sys_syspr(kproc);
		endif;
		if id!PWM_IDCHAR then sys_syspr(id!PWM_IDCHAR) endif;
		sys_syspr(': ');
		sys_syspr(id!PWM_INFO);
	endif;
	cucharout(`>`);
enddefine;

lconstant
	pwm_id_key = struct KEY_R =>> {%
		_NULL,					;;; K_GC_RELOC
		key_key,				;;; KEY
		_:M_K_SPECIAL_RECORD _biset _:M_K_WRITEABLE,
								;;; K_FLAGS
		$-Sys$- _gctype_fullrec, ;;; K_GC_TYPE
		$-Sys$-Record_getsize,	;;; K_GET_SIZE

		"pwm_id",				;;; K_DATAWORD
		false,					;;; K_SPEC
		ispwm_id,				;;; K_RECOGNISER
		WREF $-Sys$-Exec_nonpd,	;;; K_APPLY
		nonop ==,				;;; K_SYS_EQUALS
		WREF nonop ==,			;;; K_EQUALS
		Pwm_id_print,			;;; K_SYS_PRINT
		WREF Pwm_id_print,		;;; K_PRINT
		WREF $-Sys$-Fullrec1_hash,;;; K_HASH

		_:NUMTYPE_NON_NUMBER,	;;; K_NUMBER_TYPE
		_:PROLOG_TYPE_OTHER,	;;; K_PLOG_TYPE
		_:EXTERN_TYPE_NORMAL,	;;; K_EXTERN_TYPE
		_0,						;;; K_SPARE_BYTE

		@@(struct PWM_ID)++,	;;; K_RECSIZE_R
		false,					;;; K_CONS_R
		false,					;;; K_DEST_R
		false,					;;; K_ACCESS_R
	%};

define lconstant Newpwm_id(kproc, idchar, info) -> id;
	lvars kproc, idchar, info, id;
	$-Sys$-Get_record(pwm_id_key) -> id;
	kproc -> id!PWM_KILLPROC;
	idchar -> id!PWM_IDCHAR;
	info -> id!PWM_INFO;
	;;; add file to table
	$-Sys$-Add_file_tab_entry(id)
enddefine;

define pwmidinfo(id);
	lvars id;
	if ispwm_id(id) then
		id!PWM_INFO
	else
		mishap(id, 1, 'PWM-ID NEEDED');
	endif
enddefine;

;;; all windows except the base window, which is permanent, are stored in
;;; the file table (as are all pwm id records except for a few other static
;;; ones): this allows them to be freed on a garbage collection.  In order
;;; for that to work, we can't have any other pointers to the (gc-collectable)
;;; windows in the system; so when the pwm tells us that there is input on
;;; a window #n, we have to search through the filetable to get hold of the
;;; record.	 (We could maintain a separate table, but it would require more
;;; work - explicit hooks in the gc stuff to update pointers in it) and this
;;; is efficient enough.)
;;;
define Pwmwinofid(i);
	lvars i, record, _table = $-Sys$- _file_tab,
		_limit = $-Sys$- _file_tab_next_free;
	if i == 0 then
		pwmbasewindow
	else
		while _table <@(w) _limit do
			_table!(w) -> record;
			if record!KEY == pwm_id_key
			and record!PWM_KILLPROC == Kill_window
			and record!PWM_IDCHAR == i then
				return(record);
			endif;
			_table@(w)++ -> _table;
		endwhile;
		false
	endif;
enddefine;

;;; send a message to the PWM asking it to kill all windows except those
;;; with a ved-pwmwindow for a file in the buffer list, or which are
;;; otherwise false.
;;;
define lconstant Tidy_windows();
	lvars i w s, count = 0;
	for i from 1 to PWM_MAXWINDOWS do
		if (Pwmwinofid(i) ->> w) and w!PWM_IDCHAR then
			i fi_+ ` `;
			count fi_+ 1 -> count;
		endif
	endfor;
	consstring(count) -> s;
	pwmsendmessage(s, Pwms_tidywindows, true);
	if vedediting and vedbufferlist /== [] then
		pwm_select_window(wved_window_of_file(vedbufferlist.hd))
	else
		pwm_select_window(pwmbasewindow)
	endif
enddefine;

;;;
;;;		ALL THIS STUFF SHOULD BE MOVED INTO THE LIBRARY, BUT THIS IS
;;;		NOT THE TIME....

;;; these procedures construct records for the various kind of resource
define pwm_kill_cursor(cid);
	lvars cid;
	pwmsendmessage(checkpwmcursid(cid), Pwms_killcursor, true);
	false -> cid!PWM_IDCHAR;
enddefine;

define pwmnewcursorid(idc, props);
	lvars idc, props;
	Newpwm_id(pwm_kill_cursor, idc, props);
enddefine;

define pwm_kill_menu(mid);
	lvars mid;
	unless mid.isstring then
		pwmsendmessage(checkpwmmenuid(mid), Pwms_killmenu, true);
		false -> mid!PWM_IDCHAR;
	endunless;
enddefine;

define pwmnewmenuid(idc, props);
	lvars idc, props;
	Newpwm_id(pwm_kill_menu, idc, props);
enddefine;

define pwm_kill_font(fid);
	lvars fid;
	pwmsendmessage(checkpwmfontid(fid), Pwms_gfxkillfont, true);
	false -> fid!PWM_IDCHAR;
enddefine;

define pwmnewfontid(idc, props);
	lvars idc, props;
	Newpwm_id(pwm_kill_font, idc, props);
enddefine;

define pwm_kill_page(sid);
	lvars sid, i;
	if sid.ispwm_id
	and sid!PWM_KILLPROC == pwm_kill_page then
		if (sid!PWM_IDCHAR ->> i) then
			pwmsendmessage(i, Pwms_gfxkillpage, true);
			false -> sid!PWM_IDCHAR;
		else
			mishap(sid, 1, 'LIVE PWM PAGE-ID NEEDED');
		endif
	else
		mishap(sid, 1, 'PWM PAGE-ID NEEDED');
	endif;
enddefine;

define pwmnewpageid(idc, props);
	lvars idc, props;
	Newpwm_id(pwm_kill_page, idc, props);
enddefine;

define pwmsun_kill_cms(cmsid);
	lvars cmsid;
	pwmsendmessage(checkpwmcmsid(cmsid), Pwms_gfxkillcms, true);
	false -> cmsid!PWM_IDCHAR;
enddefine;

define pwmnewcmsid(idc, props);
	lvars idc, props;
	Newpwm_id(pwmsun_kill_cms, idc, props);
enddefine;

;;; these procedures give a mishap if the argument is not an appropriate
;;; kind of resource, otherwise they return the idchar.

define checkpwmwinid(o) -> c with_props false;
	lvars o c;
	if o.ispwm_id and o!PWM_KILLPROC == Kill_window then
		unless (o!PWM_IDCHAR ->> c) then
			mishap(o, 1, 'LIVE PWM WINDOW-ID NEEDED')
		endunless
	else
		mishap(o, 1, 'PWM WINDOW-ID NEEDED');
	endif;
enddefine;

define checkpwmcursid(o) -> c with_props false;
	lvars o c;
	if o.ispwm_id and o!PWM_KILLPROC == pwm_kill_cursor then
		unless (o!PWM_IDCHAR ->> c) then
			mishap(o, 1, 'LIVE PWM CURSOR-ID NEEDED')
		endunless
	else
		mishap(o, 1, 'PWM CURSOR-ID NEEDED');
	endif;
enddefine;

define checkpwmmenuid(o) -> c with_props false;
	lvars o c;
	if o.ispwm_id and o!PWM_KILLPROC == pwm_kill_menu then
		unless (o!PWM_IDCHAR ->> c) then
			mishap(o, 1, 'LIVE PWM MENU-ID NEEDED')
		endunless
	else
		mishap(o, 1, 'PWM MENU-ID NEEDED');
	endif;
enddefine;

define checkpwmfontid(o) -> c with_props false;
	lvars o c;
	if o.ispwm_id and o!PWM_KILLPROC == pwm_kill_font then
		unless (o!PWM_IDCHAR ->> c) then
			mishap(o, 1, 'LIVE PWM FONT-ID NEEDED')
		endunless
	else
		mishap(o, 1, 'PWM FONT-ID NEEDED');
	endif;
enddefine;

define checkpwmcmsid(o) -> c with_props false;
	lvars o c;
	if o.ispwm_id and o!PWM_KILLPROC == pwmsun_kill_cms then
		unless (o!PWM_IDCHAR ->> c) then
			mishap(o, 1, 'LIVE PWM CMS-ID NEEDED')
		endunless
	else
		mishap(o, 1, 'PWM CMS-ID NEEDED');
	endif;
enddefine;

;;; this one is a bit different:
;;; check that the argument is either a window or a page
;;;
define checkpwmsurfid(o) -> c with_props false;
	lvars o c;
	if o.ispwm_id
	and (o!PWM_KILLPROC == pwm_kill_page
		or o!PWM_KILLPROC == Kill_window) then
		unless (o!PWM_IDCHAR ->> c) then
			mishap(o, 1, 'LIVE PWM SURFACE-ID NEEDED');
		endunless
	else
		mishap(o, 1, 'PWM SURFACE-ID NEEDED');
	endif;
enddefine;

;;; users can only kill their own windows
define checkpwmuserwin(w) -> c with_props false;
	dlvars w c;
	if (checkpwmwinid(w) ->> c) == 0		;;; base win's id char
	or fast_subscrv(PW_FILE, w!PWM_INFO) then
		mishap(w, 1, 'ILLEGAL ACTION ON BASE/VED WINDOW')
	endif;
enddefine;

/*
 *	all windows have a 6-element vector in the PWM_INFO field of the id
 *	record, with the following fields (macros for the subscripts are assigned
 *	in vddeclare.ph):
 *
 *	(1) PW_OPEN	 - true/false = open/iconic
 *	(2) PW_WIDTH	- internal width in characters/pixels
 *	(3) PW_HEIGHT	- internal height in characters/pixels
 *	(4) PW_FILE		- iff ved window, name of associated file; else false
 *	(5) PW_CHANGED	- iff ved window, boolean:
 *							iff true, vedsetonscreen must refresh
 *	(5) PW_WTYPE		else id string for type of window
 *	(6) PW_TRAPS	- in user window, procedure or property, else vector of
 *						four prox: responders to mosue events
 */

lconstant	;;; these go in the PW_WTYPE slot of non-ved windows
	Pwmtxtw_ids = "text",
	Pwmgfxw_ids = "gfx",
	Pwmbsew_ids = "base";

define Sys$-Pwm$-Is_changed_window(win);
	lvars win;
	fast_subscrv(PW_CHANGED, win!PWM_INFO);
enddefine;
;;;
define updaterof Sys$-Pwm$-Is_changed_window(v, win);
	lvars win v;
	v -> fast_subscrv(PW_CHANGED, win!PWM_INFO);
enddefine;

define lconstant Window_size(win) with_props wved_window_size;
	lvars win;
	checkpwmwinid(win) ->;
	fast_subscrv(PW_WIDTH, win!PWM_INFO),
	fast_subscrv(PW_HEIGHT, win!PWM_INFO);
enddefine;

define lconstant Pwmsetwindowwidth(win, v);
	lvars win, v;
	v -> fast_subscrv(PW_WIDTH, win!PWM_INFO);
enddefine;

define lconstant Pwmsetwindowheight(win, v);
	lvars win, v;
	v -> fast_subscrv(PW_HEIGHT, win!PWM_INFO);
enddefine;

;;; id records for static resources: the base window, the standard font,
;;; and two cursors.
;;;

constant
	pwmbasewindow = writeable struct PWM_ID =>>
				{% Kill_window, pwm_id_key, 0, false %},

	pwmstdfont = writeable struct PWM_ID =>>
				{% pwm_kill_font, pwm_id_key, 0, false %},

	pwmstdcursor = struct PWM_ID =>>
				{% pwm_kill_cursor, pwm_id_key, 0, 'STD' %},

	pwmtxtcursor = struct PWM_ID =>>
				{% pwm_kill_cursor, pwm_id_key, 1, 'TXT' %},

	pwmgfxcursor = struct PWM_ID =>>
				{% pwm_kill_cursor, pwm_id_key, 2, 'GFX' %};


;;; special argument accepted by open/close and window/icon position prox
;;;
constant pwmnxtwin = '<pseudo-pwm-window: next window>';

;;; window (we think) we're currently getting input from
;;;
protected vars pwminputsource = pwmbasewindow;

vars vedpwmmousetraps = writeable {% false, false, false, false %};


;;;--- IDENTIFIERS -------------------------------------------------------

;;; call a user-supplied procedure with the id of each live window
;;;
define pwm_scan_windows(select, proc);
	lvars i, select, win, v, t, g, procedure proc;
	$-Sys$-Check_procedure(proc);
	if select then
		unless select.islist then mishap(select, 1, 'LIST NEEDED') endunless;
		lmember("ved", select) -> v;
		lmember("text", select) -> t;
		lmember("gfx", select) -> g;
	else
		[] -> select;
	endif;
	if (select == [])
	or (lmember("base", select) and not(lmember(pwmbasewindow, select))) then
		proc(pwmbasewindow)
	endif;
	for i from 1 to PWM_MAXWINDOWS do
		if (Pwmwinofid(i) ->> win) then
			if lmember(win, select) then
				nextloop;
			elseif fast_subscrv(PW_FILE, win!PWM_INFO) then
				unless v then nextloop endunless;
			elseif fast_subscrv(PW_WTYPE, win!PWM_INFO) == Pwmtxtw_ids then
				unless t then nextloop endunless;
			else	;;; must be gfx
				unless g then nextloop endunless
			endif;
			proc(win);
		endif
	endfor
enddefine;

;;; --- PRIMITIVES FOR CONTROLLING PWM -------------------------------------

;;; writes specstring to poprawdevout, with substitutions off stack as follows:
;;;			%c	= ascii code from stack
;;;			%i	= small int from stack: add 32 to get ascii code
;;;			%d	= number from stack printed in decimal
;;;			%s	= string from stack
;;;			%<char> = char
;;;
define pwmsendmessage(specstring, flush);
	dlvars i = 1, c temp l specstring flush;
	dlocal cucharout = rawcharout, pop_pr_radix = 10;

	unless popunderpwm then
		mishap(0, 'NOT IN PWM');
	endunless;

	specstring.datalength -> l;

	until i > l do
		if (subscrs(i, specstring) ->> c) == `%` then
			i fi_+ 1 -> i;
			if i fi_>= l then
				mishap(specstring, 1, 'bad pwm specification')
			else
				subscrs(i, specstring) -> c;
			endif;
			if c == `c` then
				rawcharout();
			elseif	c == `i` then
				-> temp;
				rawcharout(temp fi_+ ` `);
			elseif	c == `s` then
				-> temp;
				syswrite(poprawdevout, temp, temp.datalength);
			elseif	c == `d` then
				-> temp;
				sys_syspr(temp);
			else
				rawcharout(c);
			endif
		else
			rawcharout(c);
		endif;
		i fi_+ 1 -> i;
	enduntil;
	if flush then sysflush(poprawdevout) endif;
enddefine;

;;; read characters from poprawdevin to fill in the pattern string.	 Returns
;;; false as soon as a character is read which does not match the pattern;
;;; else returns when a complete pattern has been read, with matches for
;;; any variables, and the number of matches (i.e. 0 would indicate a
;;; succesful read of a string with no variables).	The variables are
;;;		%c	- match any character, stack the ascii code
;;;		%i	- match any character, stack (ascii code - 32)
;;;		%d	- match a decimal integer, stack it
;;;		%s	- match a string, stack it
;;;
;;; note: the last character in the pattern must be constant; at most two
;;; matching constant characters terminate a string match
;;; (i.e.		'AbcDEfDEF' will not match 'A%sDEF',
;;; because 'AbcDE' will match to 'A%sDE', and 'fDEF' won't match 'F')
;;; definers of new pwm sequences should bear this in mind.
;;;
define lconstant Pwmpatternread(pattern, rep);
	dlvars c pattern rep plen pindex r osl number sgn nchars lchar;

	define lconstant fail;
		erasenum(stacklength() - osl);
		exitfrom(false, Pwmpatternread);
	enddefine;

	unless popunderpwm then
		mishap(0, 'NOT IN PWM');
	endunless;

	stacklength() -> osl;
	pattern.datalength -> plen;
	1 -> pindex;
	false ->> number ->> nchars -> lchar;

	until pindex > plen do
		rep() -> c;
	usechar:
		if number then
			if c.isnumbercode then
				c fi_- `0` fi_+ number fi_* 10 -> number;
			else
				sgn * number, false -> number;
				goto usechar;
			endif
		elseif nchars and lchar then
			if c = fast_subscrs(pindex, pattern) then
				consstring(nchars), false ->> nchars -> lchar;
				pindex fi_+ 1 -> pindex;
			else
				lchar, false -> lchar;
				nchars fi_+ 1 -> nchars;
			endif
		elseif nchars then
			if c == r then
				if pindex fi_<= plen
				and fast_subscrs(pindex, pattern) /== `%` then
					c -> lchar;
				else
					consstring(nchars);
					false ->> nchars -> lchar;
				endif
			else
				c, nchars fi_+ 1 -> nchars;
			endif
		elseif fast_subscrs(pindex, pattern) == `%` then
			pindex fi_+ 2 -> pindex;
			if (fast_subscrs(pindex fi_- 1 , pattern) ->> r) == `d` then
				if c == `-` then
					-1 -> sgn;	0 -> number;
				elseif isnumbercode(c) then
					1 -> sgn;	c fi_- `0` -> number;
				else
					fail();
				endif;
			elseif r == `c` then c
			elseif r == `i` then c fi_- 32
			elseif r == `s` then
				fast_subscrs(pindex, pattern) -> r;
				0 -> nchars;
				pindex fi_+ 1 -> pindex;
				goto usechar;
			endif;
		elseif fast_subscrs(pindex, pattern) /== c then
			fail();
		else
			pindex fi_+ 1 -> pindex;
		endif;
	enduntil;
	stacklength() fi_- osl;
enddefine;

;;; get a report from the PWM:
;;;		trigger:	a (pattern) string, sent to the tty by pwmsendmessage
;;;							to trigger the report
;;;		pattern:	a pattern string, the report itself.  matches to
;;;							variables in the pattern will be stacked, and the
;;;							count returned or false.
;;;
define getpwmreport(trigger, pattern);
	dlvars trigger pattern;
	sysflush(poprawdevout);
	sys_clear_input(poprawdevin);
	pwmsendmessage(trigger, true);
	Pwmpatternread(pattern, rawcharin) ->> pwmgotreport;
enddefine;

vars pwmflushmessage = true;

define active pwmalwaysflush;
	pwmflushmessage;
enddefine;

define updaterof active pwmalwaysflush(b);
	lvars b;
	unless b.isboolean then mishap(b, 1, 'BOOLEAN NEEDED') endunless;
	unless b == pwmflushmessage then
		unless b then sysflush(poprawdevout) endunless;
		b -> pwmflushmessage;
	endunless;
enddefine;

;;; pwm returns the following data (in order they come off the stack after
;;; calling getpwmreport)
;;;		details of standard font:	width, height, baseline
;;;		size of base window:		width height
;;;		miscellaneous field:	(string)
;;;		date:					(string)
;;;		screen size:			width height depth
;;;		version number:			(float)
;;;		machine					(string)
;;;
define lconstant Pwmidentity() -> v;
	lvars v w;
	if (getpwmreport(Pwms_advidentity, Pwms_repidentity) == 12) then
		consvector('STD', 4) -> (pwmstdfont!PWM_INFO);
		-> v -> w;	;;; base window width and height
		{% true, w, v, false, Pwmbsew_ids,
			{% false, false, false, false %} %} -> (pwmbasewindow!PWM_INFO);
		consvector(5) -> v;
		subscrv(1, v); subscrv(2, v); subscrv(3, v);
		consvector(3) -> subscrv(3, v);
		strnumber() -> subscrv(2, v);
		consword() -> subscrv(1, v);
	else
		false -> v;
	endif
enddefine;

;;; makes a new text window,
;;;
define vars pwm_make_txtwin(name, columns, rows) -> n;
	lvars name rows columns n;
	Sys$-Check_string(name);
	Sys$-Check_integer(columns, 1);
	Sys$-Check_integer(rows, 1);
	unless (getpwmreport(name, rows, columns, 0, Pwms_maketxtwin,
					Pwms_idresult) ->> n) == 1 then
		Tidy_windows();
		false
	endunless -> n;
	if n and n > 0 then
		Newpwm_id(Kill_window, n,
					consvector(true, columns, rows, false,
								conspair(Pwmtxtw_ids, name),
								pwm_inputcatcher, PW_PWLENGTH)
					)
	else
		false
	endif -> n;
enddefine;

;;; makes a new graphics window. returns the new window id, or false
;;;
define vars pwm_make_gfxwin(name, width, height) -> n;
	lvars name height width n;
	Sys$-Check_string(name);
	Sys$-Check_integer(width, 1);
	Sys$-Check_integer(height, 1);

	unless (getpwmreport(name, height, width, 0, Pwms_makegfxwin,
					Pwms_idresult) ->> n) == 1 then
		Tidy_windows();
		false
	endunless -> n;

	if n and n > 0 then
		Newpwm_id(Kill_window, n,
						consvector(true, width, height, false,
									conspair(Pwmgfxw_ids, name),
									pwm_inputcatcher, PW_PWLENGTH)
					);
	else
		false
	endif -> n;
enddefine;


;;; Unlike pwm_winopenstate, the next procedure checks (or updates) only the
;;; local record of a window
define lconstant Is_open_window(win) with_props wved_is_open_window;
	;;; check if window is open
	lvars win;
	subscrv(PW_OPEN, win!PWM_INFO);
enddefine;
;;;
define updaterof Is_open_window(win) with_props wved_is_open_window;
	lvars win;
	-> subscrv(PW_OPEN, win!PWM_INFO);
enddefine;


define pwm_winopenstate(win);
	lvars win i c w;
	checkpwmwinid(win) -> i;
	if getpwmreport(i, Pwms_adviseifopen, Pwms_repopenstate) == 2 then
		-> w -> c;
		if w == i and c == `O` then
			true -> wved_is_open_window(win);
			"open"
		elseif w == i and c == `C` then
			false -> wved_is_open_window(win);
			"closed"
		else false
		endif
	else false
	endif
enddefine;


lvars
	Pwmtextwindow = pwmbasewindow,
	Pwmgfxwindow  = pwmbasewindow,
	;

/*
The following is no longer really needed. See HELP V12PWM
*/
vars
	pwm_selected = pwmbasewindow;		;;; just for compatability


;;; get or update the window to be used for text input and output
define active pwmtextwindow(); Pwmtextwindow enddefine;
;;;
define updaterof active pwmtextwindow(win);
	lvars win i t;
	unless win == Pwmtextwindow then
		checkpwmwinid(win) -> i;
		if ispair(fast_subscrv(PW_WTYPE, win!PWM_INFO) ->> t)
		and (t.fast_front == Pwmgfxw_ids) then
				mishap(win, 1, 'Can\'t assign text output to graphics window');
		else
			pwmsendmessage(i, Pwms_txtselect, pwmflushmessage);
			win ->> Pwmtextwindow -> pwm_selected;
		endif;
	endunless;
enddefine;

define vars active pwmgfxsurface(); Pwmgfxwindow enddefine;
;;;;
define updaterof active pwmgfxsurface(sid);
	lvars sid;
	unless Pwmgfxwindow == sid then
		pwmsendmessage(checkpwmsurfid(sid), Pwms_gfxsetsurf, pwmflushmessage);
		sid -> Pwmgfxwindow;
	endunless;
enddefine;

;;; user version of kill window, to stop them killing a ved window.
;;;
define vars pwm_kill_window(win);
	lvars win;
	checkpwmuserwin(win) -> ;
	Kill_window(win);
enddefine;

;;; return the title stripe of a window
;;;
define lconstant Window_label(win) with_props wved_window_label;
	lvars win;
	unless getpwmreport(checkpwmwinid(win),
						Pwms_getwtitle, Pwms_repwtitle) == 1 then
		false
	endunless
enddefine;
;;;
;;; set the title stripe of a window
;;;
define updaterof Window_label(string, win) with_props wved_window_label;
	lvars win string;
	Sys$-Check_string(string);
	pwmsendmessage(string, checkpwmwinid(win), Pwms_setwtitle, true);
/*
 *	;;; update INFO slot
 *	No! This is completely wrong: IR 26/1/89
 *	win!PWM_INFO -> win;
 *	if fast_subscrv(PW_FILE, win) then
 *		string -> fast_subscrv(PW_FILE,win); ;;; ved window
 *	else
 *		string -> back(fast_subscrv(PW_WTYPE,win)); ;;; other window
 *	endif,
 */
enddefine;

;;; return the title stripe of a window's icon
;;;
define lconstant Icon_label(win) with_props wved_icon_label;
	lvars win;
	unless getpwmreport(checkpwmwinid(win),
					Pwms_getititle, Pwms_repititle) == 1 then
		false
	endunless;
enddefine;
;;;
;;; set the title stripe of a window's icon
;;;
define updaterof Icon_label(string, win) with_props wved_icon_label;
	lvars win string;
	Sys$-Check_string(string);
	pwmsendmessage(string, checkpwmwinid(win), Pwms_setititle, true);
/*
 *	;;; update INFO slot
 *	No! This is completely wrong: IR 26/1/89
 *	win!PWM_INFO -> win;
 *	if fast_subscrv(PW_FILE, win) then
 *		string -> fast_subscrv(PW_FILE,win); ;;; ved window
 *	else
 *		string -> back(fast_subscrv(PW_WTYPE,win)); ;;; other window
 *	endif,
 */
enddefine;

;;; report size of current window in characters:
;;; returns a vector of two integers, as {columns, lines}
;;;
define vars pwm_wininternalsize(win);
	lvars win s temp;
	checkpwmwinid(win) -> win;
	if getpwmreport(win, Pwms_getinternsize, Pwms_repinternsize) == 3 then
		consvector(2) -> s -> temp;
		if win = temp then s else false endif;
	else
		false
	endif;
enddefine;

;;; set the size of a window:
;;; takes a vector giving the size in characters, as {columns, lines}
;;;
define updaterof pwm_wininternalsize(vec, win);
	lvars vec win;
	pwmsendmessage(subscrv(2, vec), fast_subscrv(1, vec),
					checkpwmwinid(win), Pwms_setinternsize, true);
	Pwmsetwindowwidth(win, fast_subscrv(1, vec));
	Pwmsetwindowheight(win, fast_subscrv(2, vec));
enddefine;

;;; ensure a window is open and exposed
;;;
define lconstant Open_window(win) with_props wved_open_window;
	lvars win;
	if win == "basewindow" then pwmbasewindow -> win endif;
	if win == pwmnxtwin then
		pwmsendmessage(PWM_NXTWIN_ID, Pwms_openwin, true);
	else
		pwmsendmessage(checkpwmwinid(win), Pwms_openwin, true);
		true -> wved_is_open_window(win);
	endif;
enddefine;

;;; ensure a window is exposed
;;;
define lconstant Raise_window(win) with_props wved_raise_window;
	lvars win;
	if win == "basewindow" then pwmbasewindow -> win endif;
	if win == pwmnxtwin then
		pwmsendmessage(PWM_NXTWIN_ID, Pwms_exposewin, true);
	else
		if wved_is_open_window(win) then
			pwmsendmessage(checkpwmwinid(win), Pwms_exposewin, true);
		else
			wved_open_window(win)
		endif;
		true -> wved_is_open_window(win);
	endif;
enddefine;

;;; close a window (make it iconic)
;;;
define lconstant Close_window(win) with_props wved_close_window;
	lvars win;
	if win == "all" then
		;;; close all windows
		pwm_scan_windows([^pwmtextwindow base ved text gfx], Close_window);
		if vedargument == nullstring then
			Close_window(pwmtextwindow)
		endif
	else
		if win == "basewindow" then pwmbasewindow -> win endif;
		if win == pwmnxtwin then
			pwmsendmessage(PWM_NXTWIN_ID, Pwms_closewin, true);
		else
			pwmsendmessage(checkpwmwinid(win), Pwms_closewin, true);
			false -> wved_is_open_window(win);
		endif
	endif
enddefine;

;;; send one of the "private" commands to the PWM
;;; N.B. - commands are sent as the ascii code of the number.  This procedure
;;;	 assumes the correct code is given as argument - i.e. `1`, not 1.
;;;
define pwm_pwmcommand(c);
	lvars c;
	pwmsendmessage(c, Pwms_pwmcommand, true);
enddefine;

;;; "select" a window to receive input.
;;; That is, ensure that if the next action by the user is an ordinary
;;; keyboard action, that keyboard input will be assigned to the window
;;; which is currently the one selected for output.
;;;
define lconstant Set_input_focus(win) with_props wved_set_input_focus;
	lvars win;
	if win == "basewindow" then pwmbasewindow -> win endif;
	pwm_winopenstate(win) ->;
	unless wved_is_open_window(win) then
		wved_open_window(win)
	endunless;
	pwmsendmessage(checkpwmwinid(win), Pwms_forceselect, true);
	false -> wvedwindowchanged;
enddefine;

;;; get an input event from the pwm: this may be either a mouse button
;;; being pressed or released, or a key being pressed on the keyboard.
;;; it will be returned as a 'special input event' code: note that no
;;; account will be taken by the PWM of which window it came from (so there
;;; is no danger that you will actually get a stream of characters preceding
;;; it because it came from a different window from the last input.) Used
;;; in particular to get a response for "VED HERE, PRESS RETURN..." messages
;;;
define lconstant Get_one_input() -> s with_props wved_get_one_input;
	lvars s;
	lconstant nullbutton = 'B ';
	if getpwmreport(Pwms_oneinput, Pwms_repinevent) == 2 then
		consstring(2) -> s;
	else
		nullbutton -> s
	endif;
	false -> wvedwindowchanged;
enddefine;

define lconstant Do_interrupt_trap() with_props wved_do_interrupt_trap;
	;;; unfortunately this causes the mouse cursor to move to top left if
	;;; already in the window.
;;;	wved_set_input_focus(wvedwindow);
	pwm_pwmcommand(PWMCOM_RESETIN)
enddefine;

;;; get a user confirmation.  The PWM (at least on the sun) puts the text in
;;; -s- up in a box roughly in the middle of the screen, and awaits any input
;;; event other than mouse motion, before removing the box again.  The text
;;; will arranged in the box by the sun window manager, breaking at spaces:
;;; carriage returns, line-feeds etc will be ignored. The only control over
;;; formatting that is availiable is in the width of the box: the argument
;;; -l- specifies this in characters.
;;;
;;;	 The PWM returns a 'special input event', consisting of two
;;; characters, where the first one describes the interpretation of
;;; the second: relevant ones here are:
;;;	 'A' - second character is an ascii code
;;;	 'B' - second character describes a mouse button as number + 32
;;;
;;;	 This procedure simply returns the two character string.  If anything
;;; goes wrong, at the PWM end or here, the string will refer to the
;;; spurious button '0'.
;;;
define vars pwm_prompt_user(l, s) -> s;
	lvars l s;
	Sys$-Check_string(s);
	Sys$-Check_integer(l, 1);
	lconstant nullbutton = 'B ';
	if getpwmreport(s, l, Pwms_promptuser, Pwms_repinevent) == 2 then
		consstring(2) -> s;
	else
		nullbutton -> s
	endif;
enddefine;


;;; --- CATCHING INPUT EVENTS ---------------------------------------------

lconstant
	Allpwmevents = [closed elevator input mousexit move character
					opened press quitrequest release resized];

;;; return the procedure catching a named event, or all events
define pwm_eventhandler(win, event);
	dlvars win event prop;
	checkpwmuserwin(win) ->;
	fast_subscrv(PW_TRAPS, win!PWM_INFO) -> prop;
	if event and not(lmember(event, Allpwmevents)) then
		mishap(event, win, 2, 'PWM INPUT EVENT CODE NEEDED');
	endif;
	if event and prop.isproperty then prop(event) else prop endif;
enddefine;

define updaterof pwm_eventhandler(proc, win, event);
	dlvars win event prop proc;
	checkpwmuserwin(win) ->;
	if event and not(lmember(event, Allpwmevents)) then
		mishap(event, win, 2, 'PWM INPUT EVENT CODE NEEDED');
	elseunless proc.isprocedure or proc.isword do
		mishap(proc, 1, 'procedure or variable needed for event trap');
	elseif event then
		unless (fast_subscrv(PW_TRAPS, win!PWM_INFO) ->> prop).isproperty then
			newproperty([[quitrequest ^(pwm_quit_window(%false%))]], 20,
						false, "perm") ->> prop
									-> fast_subscrv(PW_TRAPS, win!PWM_INFO);
		endunless;
		proc -> prop(event);
	else
		proc -> fast_subscrv(PW_TRAPS, win!PWM_INFO);
	endif;
enddefine;

lconstant MOUSE_EVENT_TYPES =
	[press 1 release 2 move 3 mousexit 4];

define vars vedmousetrap(event);
	lvars event proc i;
	if (lmember(event, MOUSE_EVENT_TYPES) ->> i) then
		subscrv(i.tl.hd, fast_subscrv(PW_TRAPS, wvedwindow!PWM_INFO))
	else
		mishap(event, 1, 'no such event')
	endif;
enddefine;
;;;
define updaterof vedmousetrap(proc, event);
	lvars event i v proc;
	if proc and not(proc.isprocedure or proc.isword) then
		mishap(proc, 1, 'bad handler for ved trap')
	elseif (lmember(event, MOUSE_EVENT_TYPES) ->> i) then
		if (subscrv(PW_TRAPS, wvedwindow!PWM_INFO) ->> v) == vedpwmmousetraps
		then copy(v) ->> v -> subscrv(PW_TRAPS, wvedwindow!PWM_INFO);
		endif;
		proc -> subscrv(i.tl.hd, v);
	else
		mishap(event, 1, 'no such event')
	endif
enddefine;


;;; --- HANDLING PWM ESCAPE SEQUENCES -------------------------------------

lconstant
	Pwmeventvector	= writeable {0 0 0 0},
	Pwmoneidpattern = '%c%it',
	Pwmoneidevents	= [`C` closed `I` input `M` mousexit
						`O` opened `Q` quitrequest],
	Pwmbxypattern	= '%c%i%d;%dt',
	Pwmbxyevents	= [`M` move `P` press `R` release
						`r` resized `e` elevator],
	Pwmerrorpattern = 'Er%d;%d;%s\^[\\',
	;

;;; this takes a character repeater to read chars from the PWM with.  If
;;; c is false, then it assumes an escape has just been read, else c is the
;;; one character which has been read after the escape.
;;; returns an event vector or false.
define lconstant Pwmparsespontaneous(c, rep);
	dlvars c rep b x y, t = false;
	if (if c then c else rep() ->> c endif) == `^` then
		rep() -> c;
		if c == `I` then
			if (Pwmpatternread(Pwmoneidpattern, rep) ->> t) == 2 then
				-> b -> c;
				if (lmember(c, Pwmoneidevents) ->> t) then
					return(fill(t.tl.hd, b, 0, 0, Pwmeventvector))
				endif
			endif
		elseif c == `M` then
			if (Pwmpatternread(Pwmbxypattern, rep) ->> t) == 4 then
				-> y -> x -> b -> c;
				if (lmember(c, Pwmbxyevents) ->> t) then
					return(fill(t.tl.hd, b, x, y, Pwmeventvector))
				endif
			endif
		endif
	elseif c == `~` then
		if (Pwmpatternread(Pwmerrorpattern, rep) ->> t) == 3 then
			mishap(3, 'PWM HAS REPORTED AN ERROR');
		endif
	endif;
	if t then erase(t) endif;
	false
enddefine;


lconstant procedure Handlespontevent;

;;; received a message saying that input is now coming from window <wn>
;;;	 ved a file, go to pop, or start passing input to user procedure.
;;;
define pwmnewinputsource(wnum);
	lvars wnum proc lproc seq evnt win file c;
	dlocal pwmflushmessage;
	Pwmwinofid(wnum) or pwmbasewindow ->> win -> pwminputsource;
	if win == pwmbasewindow then
		pwm_select_window(pwmbasewindow);
		if PWMWINDOWS then
			if vedediting then
				ved_save_file_globals();
				if wvedalwaysraise then wved_open_window(pwmbasewindow) endif;
				rawcharout(`\n`);
				`\n` -> poplastchar;
				vedscreencooked();
				sysflush(poprawdevout);
				false -> Sys$-Pwm$-Is_changed_window(wvedwindow);
				if vedinvedprocess then
					;;; May re-do some of above, in vededit's exit actions
					vedexit(identfn)
				endif;
			endif;
;;;			return;
		endif;
	elseif fast_subscrv(PW_FILE, win!PWM_INFO)		;;; ved window
	and (wved_file_of_window(win) ->> file) then
		true -> pwmflushmessage;
		unless PWMWINDOWS then
			mishap(win, 1, 'window attached to file when vedusewindows /= "pwm"')
		endunless;
		pwm_select_window(win);
		if wvedalwaysraise then wved_open_window(win) endif;
		"pwmnewinputsource" -> $-Sys$-Pwm$-user_switch;
		false -> wvedwindowchanged;
		;;; Now get the file
		if iscaller(vedpwm_doinputevent) then
			chainfrom(file, identfn, vedpwm_doinputevent, vededit);
		else
			chain(file, identfn, vededit);	;;; identfn is for defaultproc
		endif;
	else	;;; user window
		recursive_valof(fast_subscrv(PW_TRAPS, win!PWM_INFO)) -> proc;

		if proc.isprocedure then
			repeat
				if (vedinascii() ->> c) == `\^[` then
					if (Pwmparsespontaneous(false,vedinascii) ->> seq) then
						if (fast_subscrv(1, seq) ->> evnt) == "input" then
							chain(fast_subscrv(2, seq), pwmnewinputsource);
						elseif Handlespontevent(seq, evnt) then
							false	;;; ->lproc: do nothing, already handled
						elseif proc.isproperty then
							recursive_valof(proc(fast_subscrv(1, seq)))
						else
							proc
						endif -> lproc;
						if lproc then lproc(copy(seq)) endif;
						if pwminputsource /== win then
							chain(pwminputsource!PWM_IDCHAR, pwmnewinputsource);
						endif;
					endif
				else
					if proc.isproperty then
						recursive_valof(proc("character"))
					else
						recursive_valof(proc)
					endif -> lproc;
					if lproc then
						lproc(consvector("character", c, 0, 0, 4));
					endif;
				endif;
			endrepeat;
		elseif fast_subscrv(PW_FILE, win!PWM_INFO) then
			Kill_window(win);
		elseif proc then
			mishap(win, proc, 2, 'catcher for window not a procedure');
		else
			mishap(win, 1, 'input received on unknown window')
		endif;
	endif;
enddefine;

define pwm_check_window_size();
	dlvars vec;
	if (pwm_wininternalsize(wvedwindow) ->> vec) then
		Pwmsetwindowwidth(wvedwindow, fast_subscrv(1, vec));
		Pwmsetwindowheight(wvedwindow, fast_subscrv(2, vec));
		vedwinresized();
	endif
enddefine;

;;; called when a VED window has been resized.	The new size info is
;;; already in the window record
define vars vedwinresized(sized_win);
	lvars sized_win, editing_sized, ow, ol;
	dlocal pwmtextwindow = sized_win, ved_current_file;

	vedscreenwidth -> ow;			;;; not saved in file, can't dlocal 'cos
	vedscreenlength -> ol;			;;; need to keep new vals if editing this
	(sized_win == wvedwindow) -> editing_sized;

	unless editing_sized then
		wved_file_of_window(sized_win) -> ved_current_file
	endunless;

	wved_set_size(sized_win);
	0 -> vedscreenoffset;

	vedrefresh();

	if editing_sized then
		Sys$-Ved$-Set_poplinemax(vedscreenwidth)
	else
		ow -> vedscreenwidth;
		ol -> vedscreenlength;
	endif;
enddefine;

;;; call the appropriate event handler for the window with the event
define pwmuserwinevent(win, seq);
	lvars win proc seq;
	dlocal pwminputsource = win;
	recursive_valof(fast_subscrv(PW_TRAPS, win!PWM_INFO)) -> proc;
	if proc.isproperty then
		recursive_valof(proc(subscrv(1, seq))) -> proc
	endif;
	if proc.isprocedure then proc(copy(seq)) endif;
	false -> wvedwindowchanged;
enddefine;


;;; sequence is an event record, i.e. a vector
;;; a spontaneous event (i.e. one which is not a direct response to a
;;; request from poplog. if the event is one that is not (necessarily)
;;; anything to do with the current input window, deal with it and return
;;; true, else return false
define lconstant Handlespontevent(seq, evnt);
	lvars seq, win, evnt, i, button;

	define lconstant mouse_quit_ved();
		lvars button, waschanged = wvedwindowchanged;
		if vedchanged and vedwriteable then
			repeat
				pwm_prompt_user(31, 'FILE CHANGED. WRITE IT? Press: ' <>
								'Left button to write and quit, ' <>
								'Middle button to simply quit, ' <>
								'Right button to continue.') -> button;
				quitif(member(button, ['B!' 'B"' 'B#' 'Ay' 'An' 'Ac']))
			endrepeat;
			if member(button, ['B!' 'Ay']) then
				Sys$-Ved$-Write_one_file();
				ved_q();
			elseif member(button, ['B"' 'An']) then
				ved_rrq();
			else return()
			endif
		else
			ved_q()
		endif;
		unless waschanged or not(PWMWINDOWS) then
			;;; check if it is necessary to warp cursor to new window
			wved_should_warp_mouse("mousequit") -> wvedwindowchanged
		endunless;
	enddefine;

	false -> wvedwindowchanged;
	if lmember(evnt, [opened closed resized quitrequest]) then
		returnunless(Pwmwinofid(fast_subscrv(2, seq)) ->> win) (true);
		if evnt == "resized" then
			Pwmsetwindowwidth(win, (fast_subscrv(3, seq) ->> i));
			Pwmsetwindowheight(win, fast_subscrv(4, seq));
			if win == pwmbasewindow then
				Sys$-Ved$-Set_poplinemax(i)
			elseif fast_subscrv(PW_FILE, win!PWM_INFO) then ;;; a ved window
				vedwinresized(win)
			else
				pwmuserwinevent(win, seq);
			endif;
		elseif evnt == "quitrequest" then
			if win == pwmbasewindow then
				pwm_prompt_user(47, 'Quitting the base window means leaving POPLOG. ' <>
						'Are you sure?	Press Left button to confirm, ' <>
						'any other to cancel.') -> button;
				if button = 'B!' then
					pwmbasewindow -> pwmtextwindow;
					sysexit()
				endif;
			elseif fast_subscrv(PW_FILE, win!PWM_INFO) then
				;;; a ved window
				[^mouse_quit_ved] -> ved_char_in_stream;
				pwmnewinputsource(subscrv(2, seq));
			else
				pwmuserwinevent(win, seq);
			endif;
		else
			(evnt == "opened") -> wved_is_open_window(win);
			unless win == pwmbasewindow
			or fast_subscrv(PW_FILE, win!PWM_INFO)
			then
				pwmuserwinevent(win, seq);
			endunless;
		endif;
		true
	else
		false
	endif
enddefine;

;;; sequence is an event record, i.e. a vector
;;;
define lconstant Handlepwmremark(seq);
	dlvars seq evnt i traps proc win;


	if (fast_subscrv(1, seq) ->> evnt) == "input" then
		pwmnewinputsource(fast_subscrv(2, seq));
	elseif Handlespontevent(seq, evnt) then
		;;; okay - already handled
	elseif (lmember(evnt, [mousexit move release press]) ->> i) then
		i.length -> i;
		if	pwminputsource
		and (subscrv(PW_TRAPS, pwminputsource!PWM_INFO) ->> traps) then
			if traps.isvector then
				subscrv(i, traps)
			elseif traps.isproperty then
				traps(evnt)
			else
				traps
			endif -> proc;
			if (recursive_valof(proc) ->> proc) then
				if proc.isprocedure then
					if traps.isvector then
						proc(if i < 4 then
								fast_subscrv(2, seq),
								fast_subscrv(3, seq),
								fast_subscrv(4, seq)
							endif);
					else
						proc(seq);
					endif;
				else
					mishap(proc, evnt, 2, 'MOUSE TRAP NOT A PROCEDURE');
				endif;
			endif;
		endif;
	else
		mishap(seq, 1, 'UNKNOWN SPONTANEOUS PWM EVENT');
	endif;
	false -> wvedwindowchanged;
enddefine;

;;; handle an escape in pop.  this is called directly from charin
;;;
define pwmhandlepopescape();
	lvars seq;
	if (Pwmparsespontaneous(false, cucharin) ->> seq) then
		Handlepwmremark(seq);
	else
		printf('\n;;;\^G Edit keys don\'t work outside VED');
		interrupt();
	endif
enddefine;

;;; mapped to the appropriate escape sequence in Setup_ved
;;;
define vedpwm_doinputevent();
	lvars seq;
	false -> wvedwindowchanged;
	if (Pwmparsespontaneous(`^`, vedinascii) ->> seq) then
		Handlepwmremark(seq);
	else
		vederror('garbled input event')
	endif
enddefine;


;;; --- MISCELLANEOUS PWM PROCEDURES ---------------------------------------

;;; kill a ved window and ensure we have no more references to it.
;;; In general, if the window is wvedfreewindow it has probably been left by
;;; mistake, most likely because a "qved" type operation went wrong.  So we
;;; set the flag to explicitly open the file that ved falss back to, which may
;;; be the already-being-edited argument to "qved", or may simply be the window
;;; in which an error message will be displayed.
;;;
define lconstant Destroy_window(window) with_props wved_destroy_window;
	lvars window;
	if window == wvedfreewindow then
		false -> wvedfreewindow
	else
		false -> $-Sys$-Pwm$-user_switch;
	endif;
	Kill_window(window);
enddefine;

;;; select a ved window and adjust screen dimension variables
;;;
define pwm_select_window(window);
	lvars window;
	wved_set_size(window);
	window -> pwmtextwindow;
enddefine;

;;; the vt52 screenxy is faster, but it cannot send addresses > 95, because
;;; of the encoding system; the ansi screnxy has greater generality but takes
;;; longer.	 So only use it you have to.
;;;
define vedpwmscreenxy(x, y);
	lvars x y;
	if x fi_< 96 and y fi_< 96 then
		vedvt52screenxy(x, y)
	else
		vedansiscreenxy(x, y)
	endif
enddefine;

;;; get a window for ved to display a file in, or mishap
;;;

define lconstant Create_window() with_props wved_create_window;
	lvars name = vedpathname, width = vedscreenwidth, height = vedscreenlength,
		win, s;
	if	(wvedfreewindow ->> wvedwindow) then
		false -> wvedfreewindow;				 ;;; take over window freed by
		wvedwindow -> pwmtextwindow;			;;; ved_qved etc and change
		wved_open_window(wvedwindow);			;;; it to fit (faster than
		sys_fname_namev(name)				;;; making a new one)
				-> wved_icon_label(wvedwindow);
		{% width, height %} -> pwm_wininternalsize(wvedwindow);
		name	-> wved_window_label(wvedwindow);
		true	-> wved_is_open_window(wvedwindow);
		name	-> fast_subscrv(PW_FILE, wvedwindow!PWM_INFO);
		true	-> Sys$-Pwm$-Is_changed_window(wvedwindow);
		Pwmsetwindowwidth(wvedwindow, width);
		Pwmsetwindowheight(wvedwindow, height);
		vedpwmmousetraps -> subscrv(PW_TRAPS, wvedwindow!PWM_INFO);
	else
		unless getpwmreport(name, height, width, 0, Pwms_makevedwin,
					Pwms_idresult) == 1
		then
			Tidy_windows();
			mishap(name, 1,
					'Can\'t get a window for file: (type-ahead?)');
		else
			-> win;
			if win > 0 then
				Newpwm_id(Kill_window, win,
						consvector(true, width, height, name, true,
									vedpwmmousetraps,
									PW_PWLENGTH))
					->> wvedwindow -> pwmtextwindow;
			else
				mishap(name, 1,
					'Can\'t get a window for file: (not enough windows?)');
			endif;
		endunless;
	endif;
	false -> wvedwindowchanged;
	initdstring(vedscreenwidth) -> vedstatusline;
	true
enddefine;

;;; default response for quitrequested event
;;;
define vars pwm_quit_window(event, word);
	lvars event word;
	pwm_kill_window(pwminputsource);
	if word then false -> valof(word) endif;
	false -> wvedwindowchanged;
enddefine;

;;; the default procedure for user windows - just reports any input.
;;; input will be a string, which is an escape sequence without the
;;; preceding escape, or a character.
;;;
define vars pwm_inputcatcher(input);
	lvars input wn wt;
	pwminputsource!PWM_IDCHAR -> wn;
	fast_subscrv(PW_WTYPE, pwminputsource!PWM_INFO) -> wt;
	wt >< ' '  >< wn -> wt;
	if input.isinteger then
		'character "' <> consstring(input, 1) <> '" received from ' <> wt
	else
		if subscrv(1, input) == "quitrequest" then
			Kill_window(pwminputsource);
			wt <> ' killed'
		else
			('message ' >< input) <> ' received from ' <> wt
		endif
	endif -> input;
	if vedinvedprocess then
		vedputmessage(input)
	else
		pr(';;; ' <> input <> '\n');
	endif
enddefine;


;;; --- USER PROCEDURES ----------------------------------------------------

;;; nasty, non event-driven user programs can use this function to get
;;; an event on a window or windows
;;;
define vars pwm_wait_inevent(window, call);
	lvars window call seq proc c;

	false -> wvedwindowchanged;

	define lconstant chkwin;
		checkpwmuserwin() ->;
	enddefine;

	if window.islist then
		applist(window, chkwin);
	else
		chkwin(window);
		conspair(window, nil) -> window;
	endif;

	repeat				;;; wait till input is on this window
		until lmember(pwminputsource, window) do
			if vedinascii() == `\^[`
			and (Pwmparsespontaneous(false, vedinascii) ->> seq)
			and fast_subscrv(1, seq) == "input" then
				Pwmwinofid(fast_subscrv(2, seq)) -> pwminputsource;
			endif;
		enduntil;

		false -> seq;		;;; get an event
		until seq do
			if (vedinascii() ->> c) == `\^[` then
				Pwmparsespontaneous(false,vedinascii) -> seq;
			else
				consvector("character", c, 0, 0, 4) -> seq;
			endif;
		enduntil;

					;;; check in case input has switched again
		quitunless(fast_subscrv(1, seq) == "input");

		Pwmwinofid(fast_subscrv(2, seq)) -> pwminputsource;
	endrepeat;

	if call then
		recursive_valof(fast_subscrv(PW_TRAPS, pwminputsource!PWM_INFO)) -> proc;
		if proc.isproperty then
			recursive_valof(proc(subscrv(1, seq))) -> proc
		endif;
		if proc.isprocedure then proc(copy(seq)) endif;
	else
		seq
	endif;
enddefine;

define lconstant Printpwmwindow(win);
	lvars win, f, width, height;
	dlocal pop_pr_quotes = false, pop_pr_radix = 10;
	pwm_winopenstate(win) ->;
	sys_syspr(win!PWM_IDCHAR);
	if wved_is_open_window(win) then
		sys_syspr('=  open	(');
	else
		sys_syspr('= closed (');
	endif;
	wved_window_size(win) -> (width, height);
	sys_syspr(width), sys_syspr(', '), sys_syspr(height), sys_syspr(') ');
	if (subscrv(PW_FILE, win!PWM_INFO) ->> f) then
		sys_syspr('"' <> f <> '"');
	elseunless f do
		fast_subscrv(PW_WTYPE, win!PWM_INFO) -> f;
		sys_syspr(if f.ispair then f.fast_front else f endif);
	else
		sys_syspr('UNKNOWN TYPE');
	endif;
	charout(`\n`);
enddefine;

define vars ved_windows();
	if popunderpwm then
		pr('WINDOWS CURRENTLY BEING USED:\n');
		pwm_scan_windows(false, Printpwmwindow);
	else
		vederror('not using PWM');
	endif;
enddefine;

define lconstant Pwmcheckliveid(o, type, kpdr);
	lvars o type kpdr;
	if o.ispwm_id and o!PWM_KILLPROC == kpdr then
		if o!PWM_IDCHAR then true else false endif
	else
		mishap(o, 1, 'PWM ' sys_>< type sys_>< '-ID NEEDED')
	endif
enddefine;

vars procedure	(
	islivepwmwindow =	Pwmcheckliveid(% 'WINDOW', Kill_window %),
	islivepwmpage	=	Pwmcheckliveid(% 'PAGE', pwm_kill_page %),
	islivepwmcursor =	Pwmcheckliveid(% 'CURSOR', pwm_kill_cursor %),
	islivepwmmenu	=	Pwmcheckliveid(% 'MENU', pwm_kill_menu %),
	islivepwmfont	=	Pwmcheckliveid(% 'FONT', pwm_kill_font %),
	islivepwmsuncms =	Pwmcheckliveid(% 'CMS', pwmsun_kill_cms %)
				);

define pwm_idtype(o);
	lvars o;
	if o.ispwm_id then
		#_< newproperty([	[^Kill_window	window]
							[^pwm_kill_page page]
							[^pwm_kill_cursor	cursor]
							[^pwm_kill_menu		menu]
							[^pwm_kill_font font]
							[^pwmsun_kill_cms	cms]
						], 7, false, "perm") >_# (o!PWM_KILLPROC)
	else
		false
	endif;
enddefine;

define vars islivepwmsurface(o);
	lvars o;
	if o.ispwm_id and (o!PWM_KILLPROC == Kill_window
					   or o!PWM_KILLPROC == pwm_kill_page) then
		if o!PWM_IDCHAR then true else false endif
	else
		mishap(o, 1, 'PWM SURFACE-ID NEEDED')
	endif
enddefine;

define lconstant Is_live_window(o) with_props wved_is_live_window;
	lvars o;
	if o.ispwm_id then
		if o!PWM_IDCHAR then true else false endif
	else
		mishap(o, 1, 'PWM IDENTIFIER NEEDED')
	endif
enddefine;


;;; --- OTHER WVED_ PROCEDURES --------------------------------------------

	;;; Called by -sysprmishap-
define lconstant Mishap_reset() with_props wved_mishap_reset;
	unless vedinvedprocess then
		pwmbasewindow -> pwmtextwindow;
		pwm_pwmcommand(PWMCOM_BASECOOKED)
	endunless;
	pwm_pwmcommand(PWMCOM_RESETIN);
	wved_open_window(pwmtextwindow)
enddefine;

define lconstant Ved_name_hook() with_props wved_ved_name_hook;
	vedpathname -> wved_window_label(wvedwindow);
	sys_fname_namev(vedcurrent) -> wved_icon_label(wvedwindow);
enddefine;

	;;; Called by "pwm" -> vedusewindows
define wved_change_usewindows_pwm(usewindows, usewindows_id);
	lvars usewindows, usewindows_id;
	unless popunderpwm then
		mishap(0, 'CAN\'T SET vedusewindows TO "pwm" WHEN NOT USING PWM');
	endunless;
	if usewindows then

		;;; assign wved_ variable procedures
		Window_size			-> wved_window_size;
		Window_label		-> wved_window_label;
		Is_live_window		-> wved_is_live_window;
		Is_open_window		-> wved_is_open_window;
		Create_window		-> wved_create_window;
		Destroy_window		-> wved_destroy_window;
		Open_window			-> wved_open_window;
		Close_window		-> wved_close_window;
		Raise_window		-> wved_raise_window;
		Get_one_input		-> wved_get_one_input;
		Do_interrupt_trap	-> wved_do_interrupt_trap;
		Icon_label			-> wved_icon_label;
		Ved_name_hook		-> wved_ved_name_hook;
		Set_input_focus		-> wved_set_input_focus;
		Mishap_reset		-> wved_mishap_reset;

		[vedswapfiles vedfileselect ved_rb] -> vedwarpcontext;
		consstring(`\^[`, `{`, `V`, `C`, PWMCOM_VEDRAW, Pwmc_numberterm,
						`\^[`, `G`, `\^[`, `j`, 10) -> vvedscreensetpad;
		consstring(`\^[`, `{`, `V`, `C`, PWMCOM_VEDCOOKED, Pwmc_numberterm,
						`\^[`, `G`, `\^[`, `j`, 10) -> vvedscreenresetpad;

	else
		consstring(`\^[`, `{`, `V`, `C`, PWMCOM_BASERAW, Pwmc_numberterm,
						`\^[`, `G`, `\^[`, `j`, 10) -> vvedscreensetpad;
		consstring(`\^[`, `{`, `V`, `C`, PWMCOM_BASECOOKED, Pwmc_numberterm,
						`\^[`, `G`, `\^[`, `j`,10) -> vvedscreenresetpad;
	endif;
	usewindows -> fast_idval(usewindows_id)		;;; "pwm" or false
enddefine;
;;;
uses-by_name (wved_change_usewindows_pwm);


;;; ---------------------------------------------------------------------

;;; called by sysexit (assigned to "pwmexit" by $-Sys$-Pwm$-Runtime_startup, below)
;;;
define lconstant Pwmexit();
	lvars x w;
	;;; In case this is a 'bad' exit, don't attempt any I/O
	;;; if -popdevin- is not a (foreground) terminal
	returnunless(systrmdev(popdevin) == true);

	wved_open_window(pwmbasewindow);
	pwmbasewindow -> pwmtextwindow;
	for x from 1 to PWM_MAXWINDOWS do
		if (Pwmwinofid(x) ->> w) then Kill_window(w) endif;
	endfor;
	pwm_pwmcommand(PWMCOM_EXTERN);
enddefine;

define $-Sys$-Pwm$-Set_popunderpwm();
	;;; find out if connected to PWM
	if (systranslate('TERM') ->> popunderpwm)
	and isstartstring('pwm', popunderpwm) then
		Pwmidentity()
	else
		false
	endif -> popunderpwm;
	if popunderpwm then $-Sys$-Pwm$-Make_devin() endif
enddefine;

;;; Called by Do_runtime_startup (ie including after saved images restored)
;;;
define $-Sys$-Pwm$-Runtime_startup();
	lvars dir;
	"pwm" -> vedusewindows;
	pwmhandlepopescape -> handlepopescape;
	Pwmexit -> pwmexit;
	pwm_pwmcommand(PWMCOM_CONNECTED);	;;; handshake
	pwm_pwmcommand(PWMCOM_RESTORED);	;;; redundant but safe
	pwm_pwmcommand(PWMCOM_BASECOOKED);

	;;; Ensure lib dir is autoloadable
	'$poppwmlib/' dir_>< nullstring -> dir;
	unless member(dir, popautolist) then
		dir :: popautolist -> popautolist
	endunless
enddefine;

	;;; check no pwm windows open (apart from base) -- called by Do_syssave
define $-Sys$-Pwm$-Save_check();
	pwm_scan_windows(false,
			procedure(w);
				lvars w;
				unless w == pwmbasewindow then
					mishap(0, 'MUST KILL ALL WINDOWS BEFORE SAVING SYSTEM')
				endunless
			endprocedure)
enddefine;

lconstant macro NO_RESTORE_VALS = [
	(popunderpwm,
	 Sys$-Ved$-Using_windows,
	 pwmexit,
	 handlepopescape,
	 pwmstdfont!PWM_INFO,
	 pwmbasewindow!PWM_INFO)
];

	;;; This is dlocal to Do_sysrestore so that the values are not restored
define active:6 Sys$-Pwm$-No_restore_vals;
	NO_RESTORE_VALS
enddefine;
;;;
define updaterof active Sys$-Pwm$-No_restore_vals;
	-> NO_RESTORE_VALS
enddefine;


;;; called in vedsetup
;;;
define Sys$-Pwm$-Setup_ved();
	vedpwmscreenxy -> vedscreenxy;
	vedsetkey(Pwms_digimesshead,  vedpwm_doinputevent);
	if PWMWINDOWS then
		consstring(`\^[`, `{`, `V`, `C`, PWMCOM_VEDRAW, Pwmc_numberterm,
						`\^[`, `G`, `\^[`, `j`, 10) -> vvedscreensetpad;
		consstring(`\^[`, `{`, `V`, `C`, PWMCOM_VEDCOOKED, Pwmc_numberterm,
						`\^[`, `G`, `\^[`, `j`, 10) -> vvedscreenresetpad;
	else
		consstring(`\^[`, `{`, `V`, `C`, PWMCOM_BASERAW, Pwmc_numberterm,
						`\^[`, `G`, `\^[`, `j`, 10) -> vvedscreensetpad;
		consstring(`\^[`, `{`, `V`, `C`, PWMCOM_BASECOOKED, Pwmc_numberterm,
						`\^[`, `G`, `\^[`, `j`, 10) -> vvedscreenresetpad;
	endif;
enddefine;

	;;; called by -setpop-
define Sys$-Pwm$-Setpop();
	Tidy_windows();
	pwm_select_window(pwmbasewindow);
	pwmensureprompt(true);
	pwm_pwmcommand(PWMCOM_BASECOOKED)
enddefine;

	;;; called by Sys_stop_handler
define Sys$-Pwm$-Stop_handler(sig);
	lvars sig;
	returnunless(popunderpwm);
	if sig fi_> 0 then
		;;; stopping
		pwm_pwmcommand(`2`);		;;; 'Poplog suspending'
		pwm_pwmcommand(`5`);		;;; 'let tty driver handle cooked mode'
	else
		;;; continuing
		pwm_pwmcommand(`3`);		;;; 'Poplog restarting'
		pwm_pwmcommand(`4`);		;;; 'PWM must handle cooked mode'
		pwm_pwmcommand(`8`);		;;; 'clear current input window'
		charout(0);
	endif
enddefine;

define tryunderpwm();
	dlocal pop_timeout pop_timeout_secs;
	3 -> pop_timeout_secs;
	procedure; exitfrom(false, Pwmidentity) endprocedure -> pop_timeout;
	unless popunderpwm then
		unless vedbufferlist == nil then
			mishap(0, 'tryunderpwm MUST NOT BE CALLED WHEN EDITING ANY FILES');
		endunless;
		Pwmidentity() -> popunderpwm;
		if popunderpwm then
			Sys$-Pwm$-Make_devin();
			Sys$-Pwm$-Runtime_startup();
			Sys$-Pwm$-Setup_ved();
		endif;
	endunless;
enddefine;



/* --- Revision History ---------------------------------------------------
--- John Gibson, Jun  9 1995
		Changed pwm_id_key to new layout
--- John Gibson, Apr 21 1994
		Moved to C.pwm
--- John Gibson, Mar 21 1994
		Made Handlespontevent just return true if Pwmwinofid returns false.
		Also made pwmnewinputsource take basewindow as input source in the
		same circumstances.
--- John Gibson, Mar 18 1994
		# Changed from C.all to C.sun, and added #_TERMIN_IF making file empty
		  for anything but SunOS 4.
		# Removed all VMS code.
		# Moved w*ved_ved_init_comp code to vdinitseq.p
--- John Gibson, Mar 16 1994
		Put code from Pwm$-Se*tup into Pwm$-Runtime_startup
--- John Gibson, Jan 21 1994
		Renamed wved_is_ch*anged_window as Sys$-Pwm$-Is_changed_window
--- John Gibson, Jun 12 1993
		Added wved_change_usewindows_pwm, called by "pwm" -> vedusewindows
		etc, and rewrote veduse*pwmwindows as a Ved autoloadable library
		procedure calling vedusewindows.
--- John Gibson, Dec 18 1992
		Took out all top-level initialisations of wved_ procedures/variables
		and made $-Sys$-Pwm$-Runtime_startup assign all the procedures on startup
--- John Gibson, Dec 11 1992
		Added Unix Stop_handler (code from sig_stop.p)
--- Simon Nichols, Jun  5 1992
		Added forward declaration of -pwminputsource- above its first use
		in -Kill_window-.
--- John Gibson, Apr 21 1992
		Got rid of remaining none*xporteds
--- John Gibson, Oct 19 1991
		Fixed pwmnewinputsource to call ved*getfile instead of ved*editor (so
		that wvedwindowchanged is not set true), and to set $-Sys$-Pwm$-user_switch
		to "pwmnewinputsource" to stop vedsetonscreen setting it true.
--- John Gibson, Sep 20 1991
		Removed assignment to wved_change_ved_mode
--- Andreas Schoter, Sep  9 1991
	Changed occurrances of -popliblist- to -popautolist-
--- John Gibson, Jul  9 1991
		Added "basewindow" as equivalent to pwmbasewindow in wved_open_window
		etc.
--- Jonathan Meyer, Jun 18 1991
		Added wved_ved_set_window to ring bell
--- John Gibson, Jun  8 1991
		wved_ rationalisation
--- John Gibson, Apr 11 1991
		Changed -veduse*pwmwindows- to use to USEWINDOWS and -vedwarpcontext-.
--- Aaron Sloman, Jan 16 1991
	Made wved_set_input_focus check if window is iconic and if so open it
	first.
--- Aaron Sloman, Jan 14 1991
	Made wved_set_input_focus and other procedures set wvedwindowchanged false.
	Made true equivalent to [vedswapfiles vedfileselect ved_rb] if assigned to veduse*pwmwindows
--- Aaron Sloman, Jan 11 1991
		Made true equivalent to [vedswapfiles] if assigned to veduse*pwmwindows
		(Requested by Colin Shearer)
--- Aaron Sloman, Oct 12 1990
		renamed xved as wved. Renamed pwm_set_vedsize as wved_set_size
--- Aaron Sloman, Oct  8 1990
	made wved_is_live_window vars
--- Aaron Sloman, Oct  8 1990
	Added vedscreenwrap test in -wved_set_size-
--- Aaron Sloman, Sep 27 1990
	Made a lot more identifiers user-assignable. To be summarised in
	HELP NEWS.
	Added Pwms_exposewin and used it to define wved_raise_window
		(which may need revision)
	Introduced wved_set_size
	Made wved_get_one_input and wved_set_input_focus user definable, for xved
	Renamed Vedpwmwarping and moved it into vdwindows.p
	pwmtextwindow made vars
--- Aaron Sloman, Sep 25 1990
	Replaced Pwmgetvedwindow with wved_create_window and made it vars
	Added wved_is_open_window and its updater
	made wved_open_window and wved_close_window user definable
--- Aaron Sloman, Sep 25 1990
		Made pwm_select_window user definable
--- Aaron Sloman, Sep 23 1990
		Replaced Pwmvedwinfile with wved_file_of_window, and moved to vdwindows.p
		Replaced use of VF_PW*MWINDOW with wved_window_of_file
		replaced Vedfreewindow with wvedfreewindow, and exported it
--- Aaron Sloman, Aug 10 1990
		removed vedscreenreset declaration
--- Aaron Sloman, Jul 10 1990
		Allowed updater of -veduse*pwmwindows- to accept a false value when
		popunderpwm is false
		Replaced "unless ... do" with "unless ... then" in many places.
		Replaced "Sys$-" with "$-Sys$-", in preparation for sectionising
--- Aaron Sloman, Jul  9 1990
		Allowed PWMWINDOWS to be updated with something other than
			-true-. So it can be a word or list of words.
		Introduced wvedwindowchanged and Vedpwmwarping
--- John Gibson, Mar 14 1990
		Change to key layout.
--- John Gibson, Dec  4 1989
		Change to -pwm_id_key- for new pop pointers
--- Rob Duncan, Nov	 7 1989
		Added explicit escape character to start of strings assigned to
		-vvedscreensetpad- and -vvedscreenresetpad-, since these are now
		output via -vedscreencontrol- instead of -vedscreenescape-
--- John Gibson, Aug 25 1989
		Replaced use of -pop_exit_ok- in -Pwmexit- with test for
		whether -popdevin- is a (foreground) terminal.
--- John Gibson, Aug  2 1989
		Now uses -sys_fname_namev- to get filename part in
		-Pwmgetvedwindow-.
--- Ian Rogers, Feb 20 1989
		Changed garbage creating instances of ... * 7/8 to (... * 7) >> 3
--- Ian Rogers, Feb 16 1989
		Fixed pwmid_type, see SFR 4267
--- Ian Rogers, Jan 26 1989
		Commented out the attempts to update the PWM_INFO vector
		within the updaters of pwm_window_label and pwm_icon_label.
--- John Gibson, Jan 23 1989
		Got rid of unnecessary uses of -apply-
--- John Gibson, Oct 25 1988
		(Code received from Paul White at SD).
--- Roger Evans, Jul 27 1988
		Made -pwm_window_labal- and -pwm_icon_label- update PW_INFO data
--- Ian Rogers, 7th June 1988
		Implemented -pwmid_type- See HELP *PWMGENERAL
--- John Gibson, Mar 28 1988
		Make_pwm_devin -> Sys$-Pwm$-Make_devin
--- John Gibson, Feb 22 1988
		Check_string into section Sys
--- John Gibson, Feb 15 1988
		Added Sys$-Pwm$- Set_popunderpwm, Setpop, and
		No_restore_vals to perform necessary operations for setting up, -setpop- and
		-sysprmishap-, and -Do_sysrestore-
		Replace Pwmensureprompt() with pwmensureprompt(true).
		Moved initialisation of -pwmexit- into this file from sysutil.p.
		Replaced -vednullstring- with -nullstring-
--- John Gibson, Feb 11 1988
		Check_integer in section Sys
		 CONTENTS - (Use <ENTER> g to access required sections)

*/
