/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:            C.sparc/src/closure_cons.p
 > Purpose:         Constructing closures (SPARC version)
 > Author:          Robert Smith, Aug 19 1988 (see revisions)
 > Documentation:	REF *PROCEDURE
 > Related Files:   C.sparc/src/ass.p
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'drop_code.ph'

section $-Sys;

global constant
		procedure (Exec_closure, Vm$-Drop_hi, Vm$-Drop_lo)
	;

endsection;

;;; ---------------------------------------------------------------------

section $-Sys$-Vm;

	/*	Construct a raw closure for _______nfroz frozvals
	*/
define $-Sys$-Cons_closure(_nfroz) -> _clos;
	lvars _clos, _drop_ptr, _size, _nfroz, _temp, _pdr;

	;;; macro for dropping words
	lconstant macro W = [_drop_ptr!(w)++ -> _drop_ptr];

	;;; calculate length of code to be planted in words
	if _nfroz _gr _16 then
		_7 -> _size
	else
		_nfroz _mult _2 _add _7 -> _size
	endif;

	;;; add header size and frozval size to get total
	@@PD_CLOS_FROZVALS[_nfroz _add _size] _sub @@POPBASE -> _size;
	Get_store(_size) -> _clos;
	##(w){_size} ->> _size -> _clos!PD_LENGTH;
	unless _clos!PD_LENGTH == _size then
		_clos -> Get_store();		;;; junk it
		mishap(0, 'CLOSURE EXCEEDS MAXIMUM ALLOWABLE SIZE')
	endunless;

	;;; plant code
	_clos@PD_CLOS_FROZVALS[_nfroz] ->> _drop_ptr -> _clos!PD_EXECUTE;

	_NOP_INST 									-> W;	;;; nop
	_NOP_INST									-> W;	;;; nop
	if _nfroz _gr _16 then
		;;; just give _clos address to Exec_closure (5 words)
		$-Sys$-Exec_closure -> _pdr;
		_F3iM_INST(_OP_st, _:Rusp, _-4, _:Ropb) -> W;	;;; st %opb, [%us-4]
		_F2_INST(_OP_sethi, Drop_hi(_pdr), _:Ropb)
												-> W;	;;; sethi %hi(addr), %opb
		_F3iA_INST(_OP_or, _:Ropb, Drop_lo(_pdr), _:Ropb)
												-> W;	;;; or %opb, %lo(addr), %opb
		_F3iA_INST(_OP_jmpl, _:Ropb, @@(w){_pdr!PD_EXECUTE, _pdr} _add _8,
										_:Rg0)	-> W;	;;; jmp %opb + X+8
		_F3iA_INST(_OP_sub, _:Rusp, _4, _:Rusp) -> W;	;;; sub %us, 4, %us
	else
		;;; plant code to move PD_EXECUTE field of pdpart to r0 (3 words)
		_F3iA_INST(_OP_add, _:Ropb, @@PD_CLOS_FROZVALS, _:Ro1)
												-> W;	;;; add %opb, f, %o1
		_F3iM_INST(_OP_ld, _:Ropb, @@PD_CLOS_PDPART, _:Ropb)
												-> W;	;;; ld [%opb+p], %opb
		_F3iM_INST(_OP_ld, _:Ropb, @@PD_EXECUTE, _:Ro0)
												-> W;	;;; ld [%opb], %o0

		;;; now plant code to push them onto the stack (_______nfroz*2 words)
		_0 -> _temp;
		until _zero(_nfroz) do
			_F3iM_INST(_OP_ld, _:Ro1, _temp, _:Ro2) -> W;	;;; ld [%o1+n], %o2
			_F3iM_INST(_OP_st, _:Rusp, _-4 _sub _temp, _:Ro2)
													-> W;	;;; st %o2, [%us-(4+n)]
			_nfroz _sub _1 -> _nfroz;
			_temp _add _4 -> _temp
		enduntil;
		;;; finally, enter pdpart (2 words)
		_F3iA_INST(_OP_jmpl, _:Ro0, _8, _:Rg0)		-> W;	;;; jmp %o0 + 8
		_F3iA_INST(_OP_sub, _:Rusp, _temp, _:Rusp)	-> W;	;;; sub %us, n, %us
	endif
enddefine;

endsection;		/* $-Sys$-Vm */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct  1 1997
		Changed instructions to use new _Fn... instruction macros
		from drop_code.ph, etc.
--- John Gibson, Sep 23 1992
		Added check for size not being too large
--- John Gibson, Apr 30 1989
		Put into section $-Sys$-Vm
--- John Gibson, Feb 13 1989
		Rewrote to use WORD macro
--- Robert Smith, Sep  8 1988
	Corrected size allocated for closure.
 */
