/* --- Copyright University of Sussex 1989. All rights reserved. ----------
 > File:            C.vax/src/pdr_compose.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 > Documentation:	REF *PROCEDURE
*/

;;; -------------- COMPOSITION OF 2 PROCEDURES (VAX) ------------------------

#_INCLUDE 'declare.ph'

;;; ----------------------------------------------------------------------

section $-Sys;

	;;; macros for dropping longs, shorts and bytes at _drop_ptr
lconstant macro (
	LONG	= [_drop_ptr!(l)++ -> _drop_ptr],
	SHORT	= [_drop_ptr!(s)++ -> _drop_ptr],
	BYTE	= [_drop_ptr!(b)++ -> _drop_ptr],
	);

	/*	Construct a raw procedure for composition of two procedures
		-- used by <>
	*/
define Cons_pcomposite() -> _comp;
	lvars _comp, _drop_ptr, _offs, _size;

	@@PD_COMPOSITE_TABLE[_5] _sub @@POPBASE -> _size;
	Get_store(_size) -> _comp;
	;;; initialise header
	##(w){_size} -> _comp!PD_LENGTH;
	_0 ->> _comp!PD_REGMASK -> _comp!PD_NLOCALS;
	_0 ->> _comp!PD_NUM_STK_VARS -> _comp!PD_NUM_PSTK_VARS;
	_0 -> _comp!PD_GC_SCAN_LEN;
	##SF_LOCALS -> _comp!PD_GC_OFFSET_LEN;
	##SF_LOCALS _sub ##SF_RETURN_ADDR  -> _comp!PD_FRAME_LEN;

	;;; start of instructions
	_comp@PD_COMPOSITE_TABLE ->> _drop_ptr -> _comp!PD_EXECUTE;

	;;; stack frame
	_16:AFDF -> SHORT;					;;; pushal pc rel byte offset
	@@(w){_comp, _drop_ptr@(b)++} -> BYTE;	;;; proc addr

	;;; plant code to call first then second
	_0 -> _offs;
	fast_repeat 2 times
		;;; get PD_EXECUTE field - depends on the offset of this field
		;;; being 0. Can then do jsb (r0) instead of jsb @PD_EXECUTE(r0)
		_16:BFD0 -> SHORT;				;;; movl pc rel def byte offset
		@@(w){_comp@PD_COMPOSITE_P1{_offs}, _drop_ptr@(b)++} -> BYTE;	;;; <offset>
		_16:50 -> BYTE;					;;; r0
		_16:6016 -> SHORT;				;;; jsb (r0)
		@@(w)[_1] -> _offs
	endfast_repeat;

	_drop_ptr -> _comp!PD_EXIT;			;;; pointer to exit code
	_16:8ED5 -> SHORT;					;;; tstl (sp)+
	_16:05 -> BYTE						;;; rsb
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- John Gibson, Feb 13 1989
		Changed procedure name and moved common code to data_concat.p
		(Uses new struct definition for fields PD_COMPOSITE_P1, P2 etc)
--- John Gibson, Apr  1 1988
		Moved out of partapply.p
--- John Gibson, Mar 22 1988
		Rewrote to use macros to plant code rather than using ass.p
		procedures.
 */
