$! --- Copyright University of Sussex 1992. All rights reserved. ----------
$! File:            C.vms/com/install.com
$! Purpose:         install the POPLOG executable and saved images as shareable
$! Author:          John Gibson, Dec 10 1985 (see revisions)
$! Documentation:   DOC * REBUILD
$! Related Files:
$ ! This command file installs the POPLOG executable image as shareable, and
$ ! also the standard POPLOG saved images.
$ ! It requires the system privilege CMKRNL to run "install", and the
$ ! privileges PRMGBL and SYSGBL to install the saved images
$
$ set verify
$ on error then exit
$ install :== $sys$system:install/comm
$ if p1 .eqs. "ADD" then goto add
$
$ install
	replace popsys:basepop11/share/open/head
	list popsys:basepop11
$ goto saved_images
$
$ add:
$ install
	add popsys:basepop11/share/open/head
	list popsys:basepop11
$
$
$ saved_images:
$ run popsys:basepop11
	;;; install standard saved images
	;;; (2nd arg "true" means install, "false" for de-install)
	sys_install_image('popsavelib:startup.psv', true);
	sys_install_image('popsavelib:prolog.psv', true);
	sys_install_image('popsavelib:clisp.psv', true);
	sys_install_image('popsavelib:pml.psv', true);

$ set nover

$! --- Revision History ---------------------------------------------------
$! --- Robert John Duncan, May 15 1992 -- changed to use basepop11 and
$!			added startup and pml saved images
