$! --- Copyright University of Sussex 1996.  All rights reserved. ---------
$! File:            C.vms/com/popenv.com
$! Purpose:         Logical names and symbols for POPLOG
$! Author:          John Gibson (see revisions)
$! Documentation:
$! Related Files:   C.vms/com/poplog.com
$
$
$! --- Binaries, command files etc
$ define/nolog popcom		usepop:[pop.com]
$ define/nolog popsrc		usepop:[pop.src]
$ define/nolog popsys		usepop:[pop.pop]
$ define/nolog popexternlib	usepop:[pop.extern.lib]
$ define/nolog popobjlib	usepop:[pop.obj]
$

$! --- Standard library directories
$ define/nolog popautolib	usepop:[pop.lib.auto]
$ define/nolog popdatalib	usepop:[pop.lib.data]
$ define/nolog popliblib	usepop:[pop.lib.lib]
$ define/nolog poppwmlib	usepop:[pop.lib.pwm]
$ define/nolog popsunlib	usepop:[pop.lib.sun]
$ define/nolog popvedlib	usepop:[pop.lib.ved]
$

$! --- Standard local directories
$ if "''f$logical("POPLOCAL")'" .eqs. ""
$ then
$	u = f$logical("USEPOP")
$	if f$extract(f$length(u) - 1, 1, u) .eqs. "]"
$	then
$		define/trans=conceal poplocal "''f$extract(0, f$length(u) - 1, u)'POP.]"
$   else
$       define/trans=conceal poplocal usepop:[pop.]
$	endif
$ endif
$
$ define/nolog poplocalauto	poplocal:[local.auto]
$ define/nolog poplocalbin	poplocal:[local.bin]
$

$! --- Contrib directory
$ if "''f$logical("POPCONTRIB")'" .eqs. "" then -
		define popcontrib	usepop:[pop.contrib]
$

$! --- For system start up
$ if "''f$logical("POPLIB")'" .eqs. "" then -
		define poplib 		"''f$logical("SYS$LOGIN")'"
$
$ define/nolog popsavelib	usepop:[pop.lib.psv]
$ define/nolog/trans=terminal popcomppath -
				"|poplib:|poplocalauto:|popautolib:|popliblib:"
$ define/nolog/trans=terminal popsavepath -
				"|poplib:|poplocalbin:|popsavelib:"
$

$! --- For X linking
$ if f$search("sys$share:decw$xmlibshr12.exe") .nes. ""
$ then
$	XTLIBS = "sys$share:decw$xtlibshrr5/share sys$share:decw$xlibshr/share"
$	define/nolog POP_XT_EXLIBS	"x=mit/11005: ''XTLIBS'"
$	define/nolog POP_XM_EXLIBS -
				"x=motif/1002: sys$share:decw$xmlibshr12/share ''XTLIBS'"
$ else
$	XTLIBS = "sys$share:decw$xtshr/share sys$share:decw$xlibshr/share"
$	define/nolog POP_XT_EXLIBS	"x=mit/11004: ''XTLIBS'"
$	define/nolog POP_XM_EXLIBS -
				"x=motif/1001: sys$share:decw$xmlibshr/share ''XTLIBS'"
$ endif
$ define/nolog POP_XLINK_EXLIBS	"==POP_XM_EXLIBS"
$

$! --- For popexternlib: shareable images on the Alpha
$ if f$getsyi("NODE_HWTYPE") .eqs. "ALPH"
$ then
$	define/nolog pop$c_callback popexternlib:pop$c_callback.exe
$	define/nolog pop$libxpw popexternlib:pop$libxpw.exe
$	define/nolog pop$libxpm popexternlib:pop$libxpm.exe
$ endif
$

$! --- For making #include <X11/?.h> work in C source files
$ define/nolog x11 decw$include:
$
$
$ !Allow send/edit in mail to run VED: Delete if you prefer EDT from MAIL
$
$ if "''f$logical("MAIL$EDIT")'" .eqs. "" then -
		define mail$edit 	popcom:mailedit.com
$

$!  --- Foreign commands for system compilation/linking etc
$
$ popc		:== $popsys:corepop +popsys:popc.psv
$ poplibr	:== $popsys:corepop +popsys:poplibr.psv
$ poplink	:== $popsys:corepop +popsys:poplink.psv
$

$! --- Poplog command symbols
$
$ open/read/err=nocommands r popsys:popenv.com
$	close r
$	@popsys:popenv.com
$ nocommands:
$

$! Not so useful symbol definitions
$
$ bye       :== @popcom:bye         ! log out and purge/keep:2
$ q         :== @popcom:dostop      ! needed for pop sub processes
$ setpop    :== debug               ! for returning to POP after control Y

$! Unix-style commands previously in this file are now defined by
$! @popcom:unixcomm

$ exit
$


$! --- Revision History ---------------------------------------------------
$! --- Poplog System, Mar  4 1996 (Julian Clinton) Added pop$libxpm.
$! --- John Gibson, Dec 20 1994  Moved Unix-style commands to unixcomm.com
$! --- John Gibson, Nov 19 1994  Alpha additions
$! --- John Gibson, Jul 10 1993  Added popc,poplibr,poplink commands
$! --- John Gibson, Jul  8 1993  Added popobjlib
$! --- John Gibson, May 11 1993
$!		Made consistent with Unix system, by making all settings unconditional
$!		except for poplocal, popcontrib and poplib. Changed to use define
$!		instead of assign (more like Unix setenv).
$!		Added defines for logical names POP_XT_EXLIBS and POP_XM_EXLIBS etc.
$! --- John Gibson, Oct 30 1991
$1		Added assignment to make logical name x11 equivalent to decw$include
$! --- Robert John Duncan, Aug 27 1991
$!		Deleted command to switch off system messages
$! --- John Gibson, Aug  2 1991
$!  	Got rid of $ at the beginning of continuation lines
$! --- Robert John Duncan, Jun 25 1991
$!		Command symbols (pop11, prolog etc.) now defined in popsys:popenv
$! --- John Gibson, May  2 1991
$!		Removed popexlinkbase
$! --- John Williams, Sep 28 1990
$!		Added popcontrib
$! --- John Gibson, May 20 1990
$!		Added popexternlib
$! --- John Williams, Feb 27 1990
$!      Reversed ordering of poplocalbin and popsavelib in popsavepath
$! --- John Williams, Feb 23 1990
$!      Added poplocalauto: to popcomppath
$! --- John Gibson, Sep 11 1989
$!      Made assignments for popcomppath and popsavepath be terminal
$! --- Rob Duncan, Aug 22 1989
$!      Added definition for "pml"
$! --- John Williams, Feb 23 1989
$!      Tidied up substantially; now functionally equivalent to Unix version
