$! --- Copyright University of Sussex 1996. All rights reserved. ----------
$! File:		C.vms/pop/pglink.com
$! Purpose:		Link the full Poplog system
$! Author:      John Gibson, Jun 26 1988 (see revisions)

$ on warning then exit

$ false = 0
$ true	= 1

$ Q		= false
$ RSV	= false
$ VED	= true
$ XLINK	= "-xlink"	! default to POP_XLINK_EXLIBS
$ MAP	= false
$ LO	= ""
$ LF	= ""
$ PFLAG	= "-p"
$ DEFS	= ""
$ EMB	= "-emb"

$! Options for normal link:
$!   Image name newpop11
$!   Entry procedure $-Sys$-Poplog_Main
$!   Export $- (top level) and $-lisp sections
$ NORM_ARGS = "-o newpop11 -e ""$-Sys$-Poplog_Main"" -s ( $-  ""$-lisp"" )"

$ ARGLOOP:
$	if p1 .eqs. "" then goto ARGSDONE
$	if p1 .eqs. "-Q"
$	then
$		Q = true
$		goto NEXTARG
$	endif
$	if p1 .eqs. "-A" .or. p1 .eqs. "-PONLY"
$	then
$		PFLAG = p1
$		goto NEXTARG
$	endif
$	if p1 .eqs. "-MAP"
$	then
$		MAP = true
$		goto NEXTARG
$	endif
$	if p1 .eqs. "-RSV"
$	then
$		RSV = true
$		goto NEXTARG
$	endif
$	if p1 .eqs. "-NOVED"
$	then
$		VED = false
$		goto NEXTARG
$	endif
$	if p1 .eqs. "-NOX"
$	then
$		XLINK = ""
$		goto NEXTARG
$	endif
$	if p1 .eqs. "-NOSHARE"
$	then
$		NORM_ARGS = NORM_ARGS + " -noshare"
$		goto NEXTARG
$	endif
$	if p1 .eqs. "-CORE" .or. p1 .eqs. "-SAFE"	! same as -noshare -noved -nox
$	then
$		NORM_ARGS = NORM_ARGS + " -noshare"
$		VED = false
$		XLINK = ""
$		RSV = true
$		EMB	= ""
$		goto NEXTARG
$	endif
$	if f$extract(0,4,p1) .eqs. "-DEF"
$	then
$		DEFS = DEFS + " " + p1 + " """ + p2 + """"
$		gosub SHIFTARG
$		if p1 .nes. "(" then goto NEXTARG
$		gosub SHIFTARG
$		DEFLOOP:
$		if p1 .eqs. ")"
$		then
$			DEFS = DEFS + " )"
$			goto NEXTARG
$		else
$			DEFS = DEFS + " """ + p1 + """"
$			gosub SHIFTARG
$			goto DEFLOOP
$		endif
$	endif
$	if f$extract(0,2,p1) .eqs. "-X"
$	then
$		XLINK = p1
$		goto NEXTARG
$	endif
$
$	write sys$output "Usage: @pglink [-imd dir] [-q] [-a] [-map] [-rsv] [-nox] [-noshare]"
$	exit 20		! SS$_BADPARAM

$	NEXTARG:
$	gosub SHIFTARG
$	goto ARGLOOP

$	SHIFTARG:
$	p1 = p2
$	p2 = p3
$	p3 = p4
$	p4 = p5
$	p5 = p6
$	p6 = p7
$	p7 = p8
$	p8 = ""
$	return


$ ARGSDONE:
$ poplink := $popsys:corepop +popsys:poplink.psv

$ if Q
$ then
$	poplink -q -ident 0 -o newpop11 'EMB'
$

$ else
$	WFILES = ""
$	WLIBS  = ""
$	goto MAKEARGS

$	ADDLIB:			! subroutine
$		WFILE = WFILE + "w_files."
$		if f$search(WFILE) .nes. ""
$		then
$			WFILE = "@" + WFILE
$			WFILES = WFILES + " " + WFILE
$		else
$			WFILE = ""
$		endif
$		WLIBS = "popobjlib:" + WLIB + ".wlb -ex ( " + WFILE + " ) " + WLIBS
$		return

$	MAKEARGS:
$
$	WFILE = "[-.src]"
$	WLIB  = "src"
$	gosub ADDLIB

$	if VED
$	then
$		WFILE = "[-.ved.src]"
$		WLIB  = "vedsrc"
$		gosub ADDLIB
$	endif

$	if XLINK .nes. ""
$	then
$		WFILE = "[-.x.src]"
$		WLIB  = "xsrc"
$		gosub ADDLIB
$	endif

$	if MAP
$	then
$		LF = LF + "/full/map=newpop11"
$	else
$		LF = LF + "/nomap"
$	endif
$
$	DATE = f$time()
$	DATE = f$extract(0,20,DATE)
$

$!	The cruddy DCL foreign command line is limited to 255 chars, so
$!	to run poplink we have to create an @file for most of the args
$	close/nolog pglink$args
$	open/write pglink$args pglink.args
$
$	write pglink$args NORM_ARGS
$	write pglink$args DEFS
$	write pglink$args WFILES
$	write pglink$args WLIBS
$	write pglink$args " -lf ( ", LF, " ) -lo ( ", LO, " ) ", XLINK
$	close pglink$args
$	poplink 'PFLAG' 'EMB' -date "''DATE'" -ident 0 @pglink.args
$	delete pglink.args;*
$
$	if RSV
$	then
$		if MAP then del newpop11.map;0
$		poplink -q 'EMB' -date "''DATE'" -ident 1 -o rsvpop11
$		delete poplink_dat.o;0		! keep the poplink_dat.o with -ident 0
$	endif
$ endif

$ purge newpop11.*
$ if RSV
$ then
$	purge rsvpop11.*
$ endif


$! --- Revision History ---------------------------------------------------
$! --- John Gibson, Mar 12 1996  Made it delete the RSV poplink_dat.o
$! --- John Gibson, Jul 26 1995  Ensured all links except RSV have -ident 0
$! --- John Gibson, Dec 16 1994  Changed to cope with W_FILES etc
$! --- John Gibson, Dec  3 1993  Added -ponly option
$! --- John Gibson, Jul 13 1993  Made -core do -rsv as well
$! --- John Gibson, Jul  9 1993
$!		Moved to $popsys.
$!		All w-libraries now specified as files in popobjlib: Removed
$!		assigns for logical names (popsrc etc). Got rid of all options
$!		setting dirs; these are now assumed set correctly. Also, poplink now
$!		handles creating the .stb files.
$! --- John Gibson, May 11 1993
$!		Removed -xlibs option, added -xt and -xm instead. Shareable
$!		library for X link now picked up from POP_XM_EXLIBS etc.
$! --- John Gibson, May  6 1993
$!		Removed XtP*oplog.obj from link (now part of $popexternlib/libpop.olb)
$! --- Simon Nichols, Jun  5 1992
$!		Changed writing of pglink_args to output a space between XWLB and
$!		VEDWLB.
$! --- John Gibson, Apr  2 1992
$!		Now links with VED files from ved/src. Added -noved and
$!		-safe options (-safe = -noshare -noved -nox)
$! --- Robert John Duncan, Jan 10 1992
$!		Changed always to use safepop11
$! --- Robert John Duncan, Oct 29 1991
$!		Changed to use Motif X libraries
$! --- Robert John Duncan, Jun 20 1991
$!		Added -xlibs option
$! --- John Gibson, May  8 1991
$!		Added -def* options
$! --- John Gibson, Jan 22 1991
$!		Rewritten; added -noshare option; added X stuff and -nox option.
$! --- John Gibson, Nov 22 1990
$!		Added assigns for popsrc and popexternlib
$! --- John Gibson, May  7 1989
$!		Added -e argument to poplink command to specify entry
$!		procedure $-Sys$-Poplog_Main, define in poplog_main.p. Since
$!		poplog_main.p therefore no longer defines the default entry
$!		procedure $-Pop$-Main, poplog_main.w/.o can now be part of the
$!		src.wlb/.olb library.
