/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:			C.vms/src/devio.p
 > Purpose:
 > Author:			John Gibson, et al (see revisions)
 > Related Files:	Unix versions
 */

;;; -------------------- DEVICE I/O (VMS) ------------------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'io.ph'
#_INCLUDE 'vmsdefs.ph'

global constant
		procedure (sysfileok, exitfrom, copy_fixed, init_fixed,
		Sys$-Add_file_tab_entry, Sys$-Timed_wait_apply, Sys$-App_open_devs,
		Sys$-Vms_set_Ctrl_C)
	;

global vars
		procedure (pop_timeout, pop_file_write_error),
		pop_timeout_secs, pop_buffer_charout
	;

weak global constant
		procedure (sys_input_waiting, sys_clear_input)
	;

section $-Sys$-Io;

constant
		procedure (Init_device, No_write, Prompt, Kill_device, Cons_iobuffer,
		Rms_read, Rms_write, Rms_write_bytes, Rms_flush, Rms_get, Rms_put,
		Rms_close, Vms_aed_read, Vms_aed_write, Trm_refresh_prompt
		)
	;

vars
		_terminal_io_done
	;

weak constant
		procedure (Test_input, Clear_input)
	;

endsection;


;;; ------------------------------------------------------------------------

section $-Sys$-Io;

vars
	_over_diskquota = false;


;;; --- READING DEVICES ------------------------------------------------------

lconstant
		procedure (Record_write, Record_flush, Write_test_error)
	;

define lconstant Read_error(dev);
	lvars dev;
	Syserr_mishap(dev, 1, 'ERROR READING DEVICE')
enddefine;


	/*	Read file orientated device (disk, tape, etc)
		i.e. supply _nbytes if possible
	*/
define lconstant File_read(dev, _bsub, userbuf, _nbytes);
	lvars buffer, dev, userbuf, _count, _take, _nbytes, _bsub;
	dev!D_IN_BUFFER -> buffer;
	_int(_bsub) _sub _1 -> _bsub;

	if _nbytes == 1 then
		if buffer!BUF_POSITION == buffer!BUF_COUNT then
			unless Rms_get(dev, false) then Read_error(dev) endunless;
			returnif(_zero(buffer!BUF_COUNT)) (0)	;;; eof
		endif;
		buffer!BUF_POSITION -> _take;
		buffer!BUF_START[_take] -> userbuf!(w->b)[_bsub];
		_take _add _1 -> buffer!BUF_POSITION;
		return(1)
	endif;

	_int(_nbytes) ->> _nbytes -> _count;
	until _zero(_count) do
		if _zero(buffer!BUF_COUNT _sub buffer!BUF_POSITION ->> _take) then
			unless Rms_get(dev, false) then Read_error(dev) endunless;
			returnif(_zero(buffer!BUF_COUNT ->> _take))
									(_pint(_nbytes _sub _count))	;;; eof
		endif;
		if _count _lt _take then _count -> _take endif;
		_bmove(@@(b)[_take], buffer@BUF_START[buffer!BUF_POSITION],
												userbuf@(w->b)[_bsub]) -> ;
		_count _sub _take -> _count;
		_bsub _add _take -> _bsub;
		buffer!BUF_POSITION _add _take -> buffer!BUF_POSITION
	enduntil;
	_pint(_nbytes)
enddefine;

define lconstant Cancel_async(ctrl_blk, _dealloc_ef);
	lvars ctrl_blk, _dealloc_ef, _efn = ctrl_blk!ICB_ASYNC_EFN;
	returnif(_zero(_efn));
	if ctrl_blk!ICB_FLAGS _bitst _M_ICB_ASYNC_LIVE then
		;;; will set event flag (if not already set)
		_extern sys\$cancel(ctrl_blk!ICB_CHANNEL) -> ;
		_extern sys\$waitfr(_efn) -> ;
		ctrl_blk!ICB_FLAGS _biclear _M_ICB_ASYNC_LIVE -> ctrl_blk!ICB_FLAGS
	endif;
	if _dealloc_ef then
		_extern pop\$free_clust0_ef(_efn) -> ;
		_0 -> ctrl_blk!ICB_ASYNC_EFN
	endif
enddefine;

define Do_interact_read(dev, pwm_dev_out);
	lvars	dev, buf = dev!D_IN_BUFFER, _count;
	dlvars	ctrl_blk, _allocated_ef = false, pwm_dev_out;

	define lconstant Do_read(dev, timclos);
		lvars	dev, buf, promptstring = false, prompt, timclos, nbuf,
				_save_termio_done, _promptlen;

		dlocal	0 % , if dlocal_context fi_<= 2 then
						Cancel_async(ctrl_blk, _allocated_ef)
					  endif % ;

		if _zero(ctrl_blk!ICB_ASYNC_EFN) then
			;;; alloc event flag
			_extern pop\$get_clust0_ef() -> ctrl_blk!ICB_ASYNC_EFN;
			true -> _allocated_ef
		else
			Cancel_async(ctrl_blk, false)
		endif;

		;;; ensure dev buffer is fixed-address, replacing it if not
		dev!D_IN_BUFFER -> buf;
		unless buf!BUF_FLAGS _bitst _M_BUF_FIXED_ADDR then
			if buf >=@(w) _system_end then
				copy_fixed(buf) ->> buf -> dev!D_IN_BUFFER
			endif;
			buf!BUF_FLAGS _biset _M_BUF_FIXED_ADDR -> buf!BUF_FLAGS
		endunless;

		if dev!D_FLAGS _bitst _M_D_TERM_PROMPT then
			Prompt(dev) -> promptstring;
			unless pwm_dev_out or promptstring <@(w) _system_end
			or buf!BUF_SIZE _greq promptstring!V_LENGTH then
				;;; make buffer big enough to hold non-fixed prompt
				promptstring!V_LENGTH -> _promptlen;
				init_fixed(_pint(_promptlen _add (##BUF_START _sub ##V_BYTES)),
												string_key) -> nbuf;
				_bmove(@@(b)[buf!V_LENGTH], buf@V_BYTES, nbuf@V_BYTES) -> ;
				nbuf ->> buf -> dev!D_IN_BUFFER;
				_promptlen -> buf!BUF_SIZE
			endunless;
			_terminal_io_done -> _save_termio_done;
			_terminal_io_done _add _1 -> _terminal_io_done
		endif;

		repeat
			if dev!D_WRITE /== No_write then
				fast_apply(dev, dev!D_FLUSH)
			elseif testdef popdevin and dev == weakref[popdevin] dev_in then
				fast_apply(dup(dev_out)!D_FLUSH)
			elseif testdef poprawdevin
			and dev == weakref[poprawdevin] raw_dev_in then
				fast_apply(dup(weakref[poprawdevin] raw_dev_out)!D_FLUSH)
			endif;

			false -> prompt;
			if promptstring then
				if _terminal_io_done /== _save_termio_done then
					if pwm_dev_out then
						;;; pwm 'terminal' mailbox -- pwm_dev_out is
						;;; output dev
						Record_write(pwm_dev_out, 1, promptstring,
											_pint(promptstring!V_LENGTH))
					else
						promptstring -> prompt
					endif
				endif;
				;;; For _M_D_LOGICAL_TERM, Rms_get will add 1 to this
				_terminal_io_done _add _1 -> _save_termio_done
			endif;

			if Rms_get(dev, prompt) then
				;;; 2nd result true says new input read
				exitfrom(true, buf!BUF_COUNT, Do_interact_read)

			;;; else read error/timed out/interrupted
			elseif _syserror == _:'SS$_CANCEL' then
				_CHECKINTERRUPT;		;;; interrupted
				if timclos and not(fast_frozval(1,timclos)) then
					;;; timer expired
					pop_timeout();
					chainfrom(dev, pwm_dev_out, dup(Do_interact_read))
				endif
			else
				;;; read error
				Read_error(dev)
			endif
		endrepeat
	enddefine;


	buf!BUF_COUNT _sub buf!BUF_POSITION -> _count;
	returnif(_nonzero(_count)) (false, _count);		;;; nothing new read

	dev!D_CTRL_BLK -> ctrl_blk;
	if dev!D_FLAGS _bitst _M_D_LOGICAL_TERM
	and isinteger(pop_timeout_secs ->> _count) and _count fi_>= 0 then
		if _count == 0 then
			ctrl_blk!ICB_FLAGS _biset _M_ICB_READ_NOW -> ctrl_blk!ICB_FLAGS;
			Do_read(dev, false)
		else
			Timed_wait_apply(dev, _count*1e6, Do_read)
		endif
	else
		Do_read(dev, false)
	endif
enddefine;		/* Do_interact_read */

	/*	Read interactive device (terminal, mailbox)
	*/
define lconstant Interact_read(dev, _bsub, userbuf, _nbytes);
	lvars buf, dev, userbuf, _count, _nbytes, _bsub;
	Do_interact_read(dev, false) -> (, _count);
	unless _zero(_count) then
		dev!D_IN_BUFFER -> buf;
		_int(_nbytes) -> _nbytes;
		if _nbytes _lt _count then _nbytes -> _count endif;
		_bmove(@@(b)[_count], buf@BUF_START[buf!BUF_POSITION],
									userbuf@(w->b)[_int(_bsub) _sub _1]) -> ;
		buf!BUF_POSITION _add _count -> buf!BUF_POSITION
	endunless;
	_pint(_count)
enddefine;

	/*	Read record-orientated device - ie don't read
		next record if can supply less than nbytes from buffer
	*/
define lconstant Record_read(dev, _bsub, userbuf, _nbytes);
	lvars buffer, dev, userbuf, _count, _nbytes, _bsub;
	dev!D_IN_BUFFER -> buffer;
	if _zero(buffer!BUF_COUNT _sub buffer!BUF_POSITION ->> _count) then
		if dev!D_WRITE /== No_write then
			fast_apply(dev, dev!D_FLUSH)
		elseif testdef popdevin and dev == weakref[popdevin] dev_in then
			fast_apply(dup(dev_out)!D_FLUSH)
		endif;
		unless Rms_get(dev, false) then Read_error(dev) endunless;
		returnif(_zero(buffer!BUF_COUNT ->> _count)) (0)	;;; eof
	endif;

	_int(_nbytes) -> _nbytes;
	if _nbytes _lt _count then _nbytes -> _count endif;
	_bmove(@@(b)[_count], buffer@BUF_START[buffer!BUF_POSITION],
									userbuf@(w->b)[_int(_bsub) _sub _1]) -> ;
	buffer!BUF_POSITION _add _count -> buffer!BUF_POSITION;
	_pint(_count)
enddefine;

define lconstant Blockio_read(dev, _bsub, userbuf, _nbytes);
	lvars buffer, dev, userbuf, _count, _take, _pos, _nbytes, _bsub;
	dev!D_IN_BUFFER -> buffer;
	_int(_bsub) _sub _1 -> _bsub;
	_int(_nbytes) ->> _nbytes -> _count;

	until _zero(_count) do
		buffer!BUF_POSITION -> _pos;
		buffer!BUF_COUNT _sub _pos -> _take;
		if _zero(_take) then
			if _zero(buffer!BUF_BLK_NUM)
			or buffer!BUF_COUNT == buffer!BUF_SIZE then
				if buffer!BUF_FLAGS _bitst _M_BUF_MODIFIED then
					Write_test_error(Rms_write(buffer, dev!D_CTRL_BLK), dev);
				endif;
				buffer!BUF_BLK_NUM _add _1 -> buffer!BUF_BLK_NUM;
				unless Rms_read(buffer, dev!D_CTRL_BLK) then
					Read_error(dev)
				endunless;
				buffer!BUF_COUNT -> _take
			endif;
			if _zero(_take) then return(_pint(_nbytes _sub _count)) endif;
			buffer!BUF_POSITION -> _pos
		endif;
		if _count _lt _take then _count -> _take endif;
		_bmove(@@(b)[_take], buffer@BUF_START[_pos], userbuf@(w->b)[_bsub]) -> ;
		_count _sub _take -> _count;
		_bsub _add _take -> _bsub;
		_pos _add _take -> buffer!BUF_POSITION
	enduntil;
	_pint(_nbytes)
enddefine;

define lconstant Waed_read(dev, _bsub, userbuf, _nbytes);
	lvars dev, userbuf, _nbytes, _bsub;
	_pint(Vms_aed_read(userbuf@(w->b)[_int(_bsub) _sub _1], _int(_nbytes),
													dev!D_CTRL_BLK, true))
enddefine;

define lconstant Aed_read(dev, _bsub, userbuf, _nbytes);
	lvars dev, userbuf, _nbytes, _bsub;
	_pint(Vms_aed_read(userbuf@(w->b)[_int(_bsub) _sub _1], _int(_nbytes),
													dev!D_CTRL_BLK, false))
enddefine;

define lconstant Clear_term_input(dev);
	lvars dev, ctrl_blk = dev!D_CTRL_BLK, buf = dev!D_IN_BUFFER;
	_0 ->> buf!BUF_COUNT -> buf!BUF_POSITION;
	ctrl_blk!ICB_FLAGS _biset _M_ICB_PURGE -> ctrl_blk!ICB_FLAGS
enddefine;


;;; --- WRITING DEVICES --------------------------------------------------

define lconstant Write_error(dev);
	lvars dev, ctrl_blk;
	dev!D_CTRL_BLK -> ctrl_blk;
	if ctrl_blk!ICB_DEVCHAR _bitst _:'DEV$M_FOD' then
		;;; if file-type dev then close without trying to flush.
		;;; Then give dev to procedure pop_file_write_error
		Rms_close(ctrl_blk);
		Kill_device(dev);
		pop_file_write_error(dev)
	endif;
	Syserr_mishap(dev, 1, 'ERROR WRITING DEVICE')
enddefine;

define lconstant Write_test_error(_result, dev);
	lvars dev, _devflags, _result;
	dlocal cucharout;
	unless _result then
		Write_error(dev)
	elseif (dev!D_CTRL_BLK!ICB_DEVCHAR ->> _devflags) _bitst _:'DEV$M_FOD'
	and _devflags _bitst _:'DEV$M_RND' and _result /== true then
		if _result == 0 then
			false -> _over_diskquota
		elseunless _over_diskquota then
			;;; write succeeded after retry on quota error - put out warning
			cucharerr -> cucharout;
			syspr('\^G\n;;; WARNING - DISK QUOTA EXCEEDED, USING OVERDRAFT\n')
		endif
	endunless
enddefine;

	/*	Write to terminal
	*/
define lconstant Term_write(dev, _bsub, userbuf, _nbytes);
	lvars buffer, dev, do_write, userbuf, _take, _pos, _nbytes, _bsub;
	dev!D_OUT_BUFFER -> buffer;
	_int(_bsub) _sub _1 -> _bsub;

	if _nbytes == 1 then
		buffer!BUF_POSITION -> _pos;
		userbuf!(w->b)[_bsub] ->> _take -> buffer!BUF_START[_pos];
		_pos _add _1 ->> _pos -> buffer!BUF_POSITION;
		unless _take _greq _:`\s` and _pos _lt buffer!BUF_SIZE
												and pop_buffer_charout
		then
			Rms_put(dev) ->
		endunless;
		return
	endif;

	_int(_nbytes) -> _nbytes;
	until _zero(_nbytes) do
		buffer!BUF_POSITION -> _pos;
		;;; find newline or end
		_locc(userbuf@(w->b)[_bsub], @@(b)[_nbytes], _:`\n`) -> _take;
		if _take == _-1 then
			_nbytes, false
		else
			##(b){_take} _add _1, true
		endif -> (_take, do_write);

		if _pos _add _take _greq buffer!BUF_SIZE then
			buffer!BUF_SIZE _sub _pos -> _take;
			true -> do_write
		endif;
		_bmove(@@(b)[_take], userbuf@(w->b)[_bsub], buffer@BUF_START[_pos]) -> ;
		_nbytes _sub _take -> _nbytes;
		_bsub _add _take -> _bsub;
		_pos _add _take -> buffer!BUF_POSITION;
		if do_write or not(pop_buffer_charout) then
			Rms_put(dev) ->
		endif
	enduntil
enddefine;

	/*	Write terminal in raw mode
	*/
define lconstant Rawterm_write(dev, _bsub, userbuf, _nbytes);
	lvars buffer, dev, do_write, userbuf, _take, _pos, _nbytes, _bsub;
	dev!D_OUT_BUFFER -> buffer;
	_int(_bsub) _sub _1 -> _bsub;

	if _nbytes == 1 then
		buffer!BUF_POSITION -> _pos;
		userbuf!(w->b)[_bsub] ->> _take -> buffer!BUF_START[_pos];
		_pos _add _1 ->> _pos -> buffer!BUF_POSITION;
		if _take == _0 or _pos _greq buffer!BUF_SIZE then
			Rms_put(dev) ->
		endif;
		return
	endif;

	_int(_nbytes) -> _nbytes;
	until _zero(_nbytes) do
		buffer!BUF_POSITION -> _pos;
		_nbytes -> _take;
		false -> do_write;
		if _pos _add _take _greq buffer!BUF_SIZE then
			buffer!BUF_SIZE _sub _pos -> _take;
			true -> do_write
		endif;
		_bmove(@@(b)[_take], userbuf@(w->b)[_bsub], buffer@BUF_START[_pos]) -> ;
		_nbytes _sub _take -> _nbytes;
		_bsub _add _take -> _bsub;
		_pos _add _take -> buffer!BUF_POSITION;
		if do_write then Rms_put(dev) -> endif
	enduntil
enddefine;

	/*	Write buffered records taking newline as end of record
	*/
define Line_write(dev, _bsub, userbuf, _nbytes);
	lvars buffer, dev, do_write, userbuf, _take, _pos, _nbytes, _bsub;
	dev!D_OUT_BUFFER -> buffer;		  ;;; i/o buffer
	_int(_bsub) _sub _1 -> _bsub;

	if _nbytes == 1 then
		buffer!BUF_POSITION -> _pos;
		userbuf!(w->b)[_bsub] ->> _take -> buffer!BUF_START[_pos];
		_pos _add _1 ->> _pos -> buffer!BUF_POSITION;
		if _take == _:`\n` or _pos _greq buffer!BUF_SIZE then
			Write_test_error(Rms_put(dev), dev)
		endif;
		return
	endif;

	_int(_nbytes) -> _nbytes;
	until _zero(_nbytes) do
		buffer!BUF_POSITION -> _pos;
		;;; find newline or end
		_locc(userbuf@(w->b)[_bsub], @@(b)[_nbytes], _:`\n`) -> _take;
		if _take == _-1 then
			_nbytes, false
		else
			##(b){_take} _add _1, true
		endif -> (_take, do_write);

		if _pos _add _take _greq buffer!BUF_SIZE then
			buffer!BUF_SIZE _sub _pos -> _take;
			true -> do_write
		endif;
		_bmove(@@(b)[_take], userbuf@(w->b)[_bsub], buffer@BUF_START[_pos]) -> ;
		_nbytes _sub _take -> _nbytes;
		_bsub _add _take -> _bsub;
		_pos _add _take -> buffer!BUF_POSITION;
		if do_write then
			Write_test_error(Rms_put(dev), dev)
		endif
	enduntil
enddefine;

	/*	Write non-buffered records
	*/
define lconstant Record_write(dev, _bsub, userbuf, _nbytes);
	lvars buffer, dev, userbuf, _take, _nbytes, _bsub;
	dev!D_OUT_BUFFER -> buffer;
	_int(_bsub) _sub _1 -> _bsub;
	if _zero(_int(_nbytes) ->> _nbytes) then
		_0 -> buffer!BUF_POSITION;
		Write_test_error(Rms_put(dev), dev);
		return
	endif;
	until _zero(_nbytes) do
		_nbytes -> _take;
		if _nbytes _gr buffer!BUF_SIZE then buffer!BUF_SIZE -> _take endif;
		_bmove(@@(b)[_take], userbuf@(w->b)[_bsub], buffer@BUF_START[_0]) -> ;
		_nbytes _sub _take -> _nbytes;
		_bsub _add _take -> _bsub;
		_take -> buffer!BUF_POSITION;
		Write_test_error(Rms_put(dev), dev)
	enduntil
enddefine;

define lconstant Blockio_write(dev, _bsub, userbuf, _nbytes);
	lvars buffer, ctrl_blk, dev, userbuf, _take, _pos, _nbytes, _bsub;
	dev!D_IN_BUFFER -> buffer;
	dev!D_CTRL_BLK -> ctrl_blk;
	_int(_bsub) _sub _1 -> _bsub;
	_int(_nbytes) -> _nbytes;
	until _zero(_nbytes) do
		buffer!BUF_SIZE _sub buffer!BUF_POSITION -> _take;
		if _zero(_take) or _zero(buffer!BUF_BLK_NUM) then
			if buffer!BUF_FLAGS _bitst _M_BUF_MODIFIED then
				Write_test_error(Rms_write(buffer, ctrl_blk), dev)
			endif;
			buffer!BUF_BLK_NUM _add _1 -> buffer!BUF_BLK_NUM;
			buffer!BUF_SIZE -> _take;
			if _nbytes _gr _take then
				;;; write whole blocks
				_nbytes -> _take;
				;;; RMS field for size is only a short
				if _take _gr _16:FFFF then _16:FFFF -> _take endif;
				_take _sub (_take _div buffer!BUF_SIZE -> _pos) -> _take;
				Write_test_error(
					Rms_write_bytes(ctrl_blk, userbuf@(w->b)[_bsub], _take,
										buffer!BUF_BLK_NUM), dev);
				_bsub _add _take -> _bsub;
				_nbytes _sub _take -> _nbytes;
				buffer!BUF_BLK_NUM _add _pos -> buffer!BUF_BLK_NUM;
				buffer!BUF_SIZE -> _take
			endif;
			if dev!D_READ == Blockio_read then   ;;; i.e. if updating
				unless Rms_read(buffer, ctrl_blk) then
					Read_error(dev)
				endunless
			else
				_0 -> buffer!BUF_COUNT;
				_0 -> buffer!BUF_POSITION
			endif
		endif;
		if _nbytes _lt _take then _nbytes -> _take endif;
		unless _zero(_take) then
			buffer!BUF_POSITION -> _pos;
			_bmove(@@(b)[_take], userbuf@(w->b)[_bsub],
												buffer@BUF_START[_pos]) -> ;
			_pos _add _take ->> _pos -> buffer!BUF_POSITION;
			if _pos _gr buffer!BUF_COUNT then _pos -> buffer!BUF_COUNT endif;
			_bsub _add _take -> _bsub;
			_nbytes _sub _take -> _nbytes;
			buffer!BUF_FLAGS _biset _M_BUF_MODIFIED -> buffer!BUF_FLAGS
		endunless
	enduntil
enddefine;

define lconstant Waed_write(dev, _bsub, userbuf, _nbytes);
	lvars dev, userbuf, _nbytes, _bsub;
	Vms_aed_write(userbuf@(w->b)[_int(_bsub) _sub _1], _int(_nbytes),
														dev!D_CTRL_BLK, true)
enddefine;

define lconstant Aed_write(dev, _bsub, userbuf, _nbytes);
	lvars dev, userbuf, _nbytes, _bsub;
	Vms_aed_write(userbuf@(w->b)[_int(_bsub) _sub _1], _int(_nbytes),
														dev!D_CTRL_BLK, false)
enddefine;


;;; --- SEEKING -----------------------------------------------------------

define lconstant Blockio_seek(dev, _pos, _mode) -> _returnpos;
	lvars	buffer, ctrl_blk, dev, _pos, _blocknum, _mode, _curpos, _eof,
			_returnpos;
	dev!D_CTRL_BLK -> ctrl_blk;
	dev!D_IN_BUFFER -> buffer;

	;;; ensure eof byte correct
	ctrl_blk!ICB_EOF_BYTE -> _eof;
	buffer!BUF_BLK_NUM  -> _blocknum;
	unless _zero(_blocknum) then _blocknum _sub _1 -> _blocknum endunless;
	_blocknum _mult ctrl_blk!ICB_BLK_SIZE _add buffer!BUF_POSITION -> _curpos;
	if _curpos _gr _eof then _curpos ->> _eof -> ctrl_blk!ICB_EOF_BYTE endif;

	_int(_pos) -> _pos;
	if _mode == 1 then
		;;; relative to current position
		_curpos _add _pos -> _pos
	elseif _mode == 2 then
		;;; relative to EOF
		_eof _add _pos -> _pos
	;;; else absolute
	endif;
	_pint(_pos) -> _returnpos;					;;; return position after seek
	if _pos _gr _eof then
		;;; seeking past EOF
		unless dev!D_WRITE == Blockio_write then
			mishap(dev, 1, 'SEEKING PAST EOF ON FILE NOT OPEN FOR WRITING')
		endunless;
		Blockio_seek(dev, 0, 2) -> ;		;;; get to EOF first
		_pos _sub ctrl_blk!ICB_EOF_BYTE -> _pos; ;;; no of bytes to extend by
		until _zero(_pos) do
			Blockio_write(dev, 1, '\^@', 1);
			_pos _sub _1 -> _pos
		enduntil;
		return
	endif;
	;;; not past EOF
	;;; set _pos to offset within block, _blocknum to block number
	_pos _div ctrl_blk!ICB_BLK_SIZE -> (_pos, _blocknum);
	_blocknum _add _1 -> _blocknum;
	unless _blocknum == buffer!BUF_BLK_NUM then
		if buffer!BUF_FLAGS _bitst _M_BUF_MODIFIED then
			Write_test_error(Rms_write(buffer, ctrl_blk), dev)
		endif;
		_blocknum -> buffer!BUF_BLK_NUM;
		unless Rms_read(buffer, ctrl_blk) then Read_error(dev) endunless
	endunless;
	_pos -> buffer!BUF_POSITION
enddefine;


;;; --- FLUSHING --------------------------------------------------------

define lconstant Record_flush(dev);
	lvars dev;
	unless _zero(dev!D_OUT_BUFFER!BUF_POSITION) then
		Write_test_error(Rms_put(dev), dev)
	endunless;
	unless Rms_flush(dev!D_CTRL_BLK) then Write_error(dev) endunless
enddefine;

define lconstant Blockio_flush(dev);
	lvars buffer, dev;
	dev!D_IN_BUFFER -> buffer;
	if buffer!BUF_FLAGS _bitst _M_BUF_MODIFIED then
		Write_test_error(Rms_write(buffer, dev!D_CTRL_BLK), dev)
	endif;
	unless Rms_flush(dev!D_CTRL_BLK) then Write_error(dev) endunless
enddefine;


;;; --- CLOSING --------------------------------------------------------------

define lconstant File_close(dev);
	lvars dev, ctrl_blk = dev!D_CTRL_BLK, unit_n = dev!D_UNIT_N;

	Cancel_async(ctrl_blk, true);
	unless dev!D_WRITE == No_write then
		fast_apply(dev, dev!D_FLUSH);
		if unit_n!UNT_DEVCHAR _bitst _:'DEV$M_MBX' then
			;;; write eof record on mailbox
			Write_test_error(Rms_put(dev), dev)
		endif
	endunless;
	Rms_close(dev!D_CTRL_BLK);

	dev!D_FLAGS _biset _M_D_CLOSED -> dev!D_FLAGS;
	if _zero(unit_n!UNT_NDEVS _sub _1 ->> unit_n!UNT_NDEVS) then
		_extern sys\$dassgn(unit_n!UNT_TRM_CHANNEL) -> ;
		_extern sys\$dassgn(unit_n!UNT_MBX_CHANNEL) ->
	endif
enddefine;


;;; --- OPENING -----------------------------------------------------------

define lconstant Set_dev_unit(newdev, arg3);
	lvars unit_n, unit_p, newdev, arg3;
	lconstant _V0LEN = ##V_WORDS _sub ##POPBASE;

	define lconstant Get_dev_unit(newdev) -> (unit_n, unit_p);
		lvars unit_n, unit_p, ctrl_blk = newdev!D_CTRL_BLK, newdev;
		dlvars _unum;

		define lconstant Test_same_unit(dev);
			lvars unit = dev!D_UNIT_N, dev;
			;;; these tests don't work with terminals if one has been
			;;; opened as /dev/unit !!
			if unit!UNT_UNIT_NUM == _unum then
				;;; same unit - return the nonpop and pop unit structures to
				;;; Set_dev_unit
				exitto( (unit, dev!D_UNIT_P), Set_dev_unit)
			endif
		enddefine;

		_extern sys\$getdev(
					/* devnam */	Temp_Desc(newdev!D_FULL_NAME),
					/* prilen */	,
					/* pribuf */	_sysstring_desc,
					/* scdlen */	,
					/* scdbuf */	) -> ;
		sysstring!DIB\$W_UNIT -> _unum;

		;;; Determine whether any existing device refers to this one.
		;;; Test_same_unit exits to Set_dev_unit if one does
		App_open_devs(Test_same_unit);

		;;; Reach here when no device is open for this unit.
		;;; Return new unit structures which will be in the
		;;; D_UNIT_N and D_UNIT_P fields of any device refering to this
		;;; unit.

		inits(_pint( ##(b)[_1|struct DEVUNIT_N] _sub ##(b)[_V0LEN|w] )),
		initv(_pint( ##(w)[_1|struct DEVUNIT_P] _sub _V0LEN ))
					-> (unit_n, unit_p);

		;;; init fields in nonpop string
		_0		-> unit_n!UNT_NDEVS;		;;; 0 ref count
		ctrl_blk!ICB_DEVCHAR
				-> unit_n!UNT_DEVCHAR;
		_unum	-> unit_n!UNT_UNIT_NUM;		;;; VMS unit number
		_0		-> unit_n!UNT_MBX_CHANNEL;

		;;; init fields in pop vector
		false	-> unit_p!UNT_INPUT_TRAP;	;;; input waiting procedure
	enddefine;      /* Get_dev_unit */


	;;; Get a pair of unit structures for the new device -- one for
	;;; nonpop values and one for pop values.

	Get_dev_unit(newdev) -> (unit_n, unit_p);
	(unit_n, unit_p) -> (newdev!D_UNIT_N, newdev!D_UNIT_P);
	;;; increase ref count for unit
	unit_n!UNT_NDEVS _add _1 -> unit_n!UNT_NDEVS;

	if unit_n!UNT_NDEVS == _1 and unit_n!UNT_DEVCHAR _bitst _:'DEV$M_TRM' then
		;;; enable Ctrl-C -- assign channel for it
		_extern sys\$assign(
					/* devnam */	Temp_Desc(newdev!D_FULL_NAME),
					/* chan   */	unit_n@UNT_TRM_CHANNEL,
					/* acmode */	,
					/* mbxnam */	) -> ;
		Vms_set_Ctrl_C(newdev, true)
	endif
enddefine;		/* Set_dev_unit */

define Cons_device(file, fullname, mode, arg3, ctrl_blk) -> dev;
	lvars	dev, file, ctrl_blk, mode, arg3, fullname, _insize,
			_outsize, _devflags, _blksize, _isterm, _recmode;

	Init_device() -> dev;
	ctrl_blk	-> dev!D_CTRL_BLK;
	file		-> dev!D_OPEN_NAME;
	fullname 	-> dev!D_FULL_NAME;
	File_close	-> dev!D_CLOSE;

	Set_dev_unit(dev, arg3);

	_pint(ctrl_blk!ICB_BLK_SIZE) -> _blksize;
	0 ->> _insize -> _outsize;
	ctrl_blk!ICB_DEVCHAR -> _devflags;
	arg3 == "record" or arg3 == "line" -> _recmode;

	if _devflags _bitst _:'DEV$M_RTM' then
		;;; real-time dev --- CRPC AED display
		if arg3 == 1 then
			Waed_read, Waed_write
		else
			Aed_read, Aed_write
		endif -> dev!D_WRITE -> dev!D_READ;
		erase ->> dev!D_FLUSH -> dev!D_CLEAR_INPUT

	elseif _devflags _bitst _:'DEV$M_REC' or _recmode then
		;;; terminal, mailbox, or record mode etc
		if _devflags _bitst _:'DEV$M_TRM' ->> _isterm then
			;;; terminal
			_M_D_TERMINAL _biset _M_D_LOGICAL_TERM,
			if not(arg3) or _recmode then () _biset _M_D_TERM_PROMPT endif
				-> dev!D_FLAGS
		endif;
		if _devflags _bitst _:'DEV$M_TRM!DEV$M_MBX' then
			dev!D_FLAGS _biset _M_D_INTERACTIVE -> dev!D_FLAGS
		endif;
		if mode /== 1 then
			;;; i.e. reading
			if _isterm then
				128, Interact_read, Clear_term_input
			elseif dev!D_FLAGS _bitst _M_D_INTERACTIVE then
				_blksize, Interact_read, weakref[sys_clear_input] Clear_input
			else
				_blksize, Record_read, erase
			endif -> dev!D_CLEAR_INPUT -> dev!D_READ -> _insize
		endif;
		if mode /== 0 then
			;;; i.e writing
			if _isterm then
				if arg3 and not(_recmode) then
					Rawterm_write
				else
					Term_write
				endif
			elseunless arg3 and arg3 /== "line" then
				Line_write
			else
				Record_write
			endif -> dev!D_WRITE;
			Record_flush -> dev!D_FLUSH;
			if _isterm then 128 else _blksize endif -> _outsize
		endif

	else
		;;; disk, tape, etc
		if mode /== 1 then
			;;; i.e. reading
			if arg3 then Blockio_read else File_read endif -> dev!D_READ;
			erase -> dev!D_CLEAR_INPUT;
			_blksize -> _insize
		endif;
		if mode /== 0 then
			;;; i.e. writing
			if arg3 then
				Blockio_flush, Blockio_write
			else
				Record_flush, Line_write
			endif -> dev!D_WRITE -> dev!D_FLUSH;
			_blksize -> if arg3 then _insize else _outsize endif
		endif;
		if arg3 then Blockio_seek -> dev!D_SEEK endif
	endif;
	if mode /== 1 then
		weakref[sys_input_waiting] Test_input -> dev!D_TEST_INPUT
	endif;

	Cons_iobuffer(_insize) -> dev!D_IN_BUFFER;
	Cons_iobuffer(_outsize) -> dev!D_OUT_BUFFER;

	;;; add file to file table
	Add_file_tab_entry(dev)
enddefine;

define Opencreate(file, mode, arg3, ctrl_blk, openpdr);
	lvars file, mode, arg3, ctrl_blk, procedure openpdr, data,
		_state = 0, _blkio = false, _cr_attrib = true;
	if arg3 == "record" then
		false -> _cr_attrib
	elseif arg3 and arg3 /== "line" then
		true -> _blkio;
		false -> _cr_attrib
	endif;
	repeat
		if openpdr(_blkio, _cr_attrib, mode, file, ctrl_blk) ->> data then
			return(data)
		elseif _state fi_&& 2:10 == 0
		and (  _syserror == _:'RMS$_FNM'
			or _syserror == _:'RMS$_DIR'
			or _syserror == _:'RMS$_SYN')
		then
			_state fi_|| 2:10 -> _state;
			returnunless(sysfileok(file) ->> file) (false)
		elseif _state fi_&& 2:01 == 0
				and (_syserror == _:'RMS$_CRE'
					or _syserror == _:'RMS$_EXT'
					or _syserror == _:'RMS$_ACC'
					or _syserror == _:'RMS$_DME')
		then
			_state fi_|| 2:01 -> _state;
			Sysgarbage(true, 'fopn')
		else
			return(false)
		endif
	endrepeat
enddefine;

;;; --- OTHER -----------------------------------------------------------

define Get_devio_trap(_unit, _ioset);
	dlvars _unit, _ioset;
	returnunless(_ioset == _:RD_SET) (false);
	App_open_devs(
			procedure(dev);
				lvars dev, p;
				if dev!D_UNIT_N!UNT_UNIT_NUM == _unit
				and (dev!D_UNIT_P!UNT_INPUT_TRAP ->> p) then
					exitfrom(p, Get_devio_trap)
				endif
			endprocedure);
	false
enddefine;


endsection;		/* $-Sys$-Io */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov 22 1994
		Improved Blockio_write to bypass device buffer for large writes
--- John Gibson, Sep 12 1994
		Replaced use of _fi*ndc subroutine with _locc
--- John Gibson, Dec  5 1992
		Changes to Do_interact_read to make Xt wait-state async I/O
		work without cancellation on interrupts
--- John Gibson, Oct 31 1991
		Fixed problem with re-outputing prompt in Do_interact_read
--- John Gibson, Dec  6 1990
		Changes to -Do_interact_read-
--- John Gibson, Nov 18 1990
		Fixed error in order of args to -Line_write-
--- John Gibson, Oct 26 1990
		Made flags for real terminal and logical terminal distinct.
--- John Gibson, Oct 24 1990
		-Cons_device- changed to set up clear/test input procedures
		in devices.
--- John Gibson, Oct 23 1990
		Changed all device read/write/seek procedures to take args
		(dev, _bsub, userbuf, _nbytes), where all are pop values.
--- John Gibson, Sep  1 1990
		Moved Cons_iobuffer to miscio.p
--- John Gibson, Aug  7 1990
		Fix to -Opencreate-
--- John Gibson, Feb 27 1990
		Added extra arg to call of -Sysgarbage-.
--- Rob Duncan, Apr  3 1989
		Replaced not(DEF VMS_V4_OR_LATER) with DEFV VMS < 4.0
--- John Gibson, Feb 23 1989
		Changes to stop interrupted terminal reads putting out another
		prompt unless necessary.
--- John Gibson, Feb 19 1989
		Substituted _M_D_RAWTERM term flag set with _M_D_TERM_PROMPT not set
		Included io.ph
--- John Gibson, Mar 28 1988
		Moved pwm stuff to pwmio.p
 */
