/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            C.vms/src/rmsio.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 */

;;;--------------------- RMS I/O (VAX/VMS) --------------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'io.ph'
#_INCLUDE 'vmsdefs.ph'

section $-Sys;

constant
		procedure Uptolow_sysstring
	;

endsection;

section $-Sys$-Io;

constant
		procedure (Rms_close, Trm_read, Trm_write, Mbx_read, Mbx_write),

		/* these RMS control blocks are set up in amisc.s
		*/
		_fab_template,		;;; a (non-writeable) template FAB
		_rab_template,		;;; a (non-writeable) template RAB
		_nam_template,		;;; a (non-writeable) template NAM
		_work_fhcxab,		;;; a (writeable) File Header Control XAB
		_work_datxab,		;;; a (writeable) DATe XAB
		_work_proxab,		;;; a (writeable) PROtections XAB
		_work_nam,			;;; a (writeable) NAMe block
	;

endsection;


;;; ------------------------------------------------------------------------

section $-Sys$-Io;

vars
	_terminal_io_done = _0
	;


;;; --- OPENING AND CREATING FILES ----------------------------------------

	/*	Initialise a new fab
	*/
define lconstant Rm_fab_init(blockio, cr, mode, filename, _fab);
	lvars	filename, blockio, cr, mode,
			_fab, _fac, _accmode = mode fi_&& 2:11;

	;;; copy fab template into fab
	_moveq(_fab_template!FAB$B_BLN, _fab_template, _fab) -> ;
	_work_fhcxab -> _fab!FAB$L_XAB;			;;; assign xab into fab
	_0 -> _work_fhcxab!XAB$L_NXT;			;;; clear any next xab
	_0 -> _work_fhcxab!XAB$W_LRL;			;;; 0 longest record length in xab
	filename@V_BYTES[_0] -> _fab!FAB$L_FNA;	;;; filename into fab
	filename!V_LENGTH -> _fab!FAB$B_FNS;	;;; filename length into fab
	_fab!FAB$B_FAC -> _fac;					;;; file access control byte

	if _accmode /== 1 then
		;;; reading
		_fac _biset _:'FAB$M_GET' -> _fac
	endif;
	if _accmode /== 0 then
		;;; writing
		_fac _biset _:'FAB$M_PUT' -> _fac;
		;;; set Truncate at End-of-File in File OPtions field
		_fab!FAB$L_FOP _biset _:'FAB$M_TEF' -> _fab!FAB$L_FOP
	else
		;;; set sharing flags if not writing
		_fab!FAB$B_SHR _biset
			_:'FAB$M_UPI!FAB$M_PUT!FAB$M_GET!FAB$M_DEL!FAB$M_UPD'
					-> _fab!FAB$B_SHR
	endif;

	if mode &&/=_0 2:100 then
		;;; exclusive create -- fail if file already exists
		;;; set Create IF (i.e. if doesn't exist) in File OPtions field
		_fab!FAB$L_FOP _biset _:'FAB$M_CIF' -> _fab!FAB$L_FOP
	endif;

	if cr then
		;;; set c/r attribute
		_fab!FAB$B_RAT _biset _:'FAB$M_CR' -> _fab!FAB$B_RAT
	endif;

	if blockio then
		;;; set block i/o mode (and always allow reading)
		_fac _biset _:'FAB$M_BIO!FAB$M_GET' -> _fac;
		_:'FAB$C_FIX' -> _fab!FAB$B_RFM;		;;; fixed length records
		_512 -> _fab!FAB$W_MRS				;;; record size = 512
	endif;

	_fac -> _fab!FAB$B_FAC;
enddefine;


	/*	initialise a new rab
	*/
define lconstant Rm_rab_init(_rab);
	lvars _rab;
	;;; copy rab template into _rab
	_moveq(_rab_template!RAB$B_BLN, _rab_template, _rab) -> ;
enddefine;

define lconstant Rm_set_eof_byte(ctrl_blk);
	lvars	ctrl_blk, _fab = ctrl_blk@ICB_FAB, _xab = _fab!FAB$L_XAB,
			_blksize = _fab!FAB$W_BLS;
	;;; compute end-of-file byte using end block number and first free byte
	if _zero(_blksize) then _512 -> _blksize endif;
	(_xab!XAB$L_EBK _sub _1) _mult _blksize _add _xab!XAB$W_FFB
						-> ctrl_blk!ICB_EOF_BYTE
enddefine;

	/*	set block size and end-of-file byte into device control block
		fields, using _fab and _xab information
	*/
define lconstant Rm_set_values(ctrl_blk);
	lvars ctrl_blk, _fab = ctrl_blk@ICB_FAB, _xab, _blksize, _lrl;
	_fab!FAB$L_XAB -> _xab;						;;; fhc xab from fab
	_fab!FAB$W_BLS -> _lrl;						;;; block size
	unless _fab!FAB$B_FAC _bitst _:'FAB$M_BIO' then
		if _fab!FAB$W_MRS  _gr _lrl then		;;; max rec size
			_fab!FAB$W_MRS  -> _lrl
		endif;
		if _xab!XAB$W_LRL  _gr _lrl then		;;; longest rec length
			_xab!XAB$W_LRL  -> _lrl
		endif
	endunless;
	_lrl -> ctrl_blk!ICB_BLK_SIZE;
	Rm_set_eof_byte(ctrl_blk);
	_0 -> ctrl_blk!ICB_FLAGS;					;;; clear control flags
	_0 -> ctrl_blk!ICB_ASYNC_EFN;
	_fab!FAB$L_STV -> ctrl_blk!ICB_CHANNEL;		;;; set channel number opened
	_fab!FAB$L_DEV -> ctrl_blk!ICB_DEVCHAR;		;;; set device characteristics
enddefine;

define lconstant Rm_open_create(blockio, cr, mode, filename, ctrl_blk,
																_rms_routine);
	lvars	ctrl_blk, filename, blockio, devname, cr, mode, _fab, _rab,
			_rms_routine, _n, _res, _create_if;

	define lconstant Getdev(devname);
		lvars devname;
		_extern sys\$getdev(
					/* devnam */	Temp_Desc(devname),
					/* prilen */	,
					/* pribuf */	_sysstring_desc,
					/* scdlen */	,
					/* scdbuf */	) _bitst _1
	enddefine;

	unless systranslate(filename) ->> devname then
		filename -> devname
	endunless;

	;;; initialise fab
	ctrl_blk@ICB_FAB -> _fab;
	Rm_fab_init(blockio, cr, mode, filename, _fab);

	if Getdev(devname)
	and sysstring!DIB\$L_DEVCHAR _bitst _:'DEV$M_TRM!DEV$M_MBX!DEV$M_RTM'
	then
		;;; terminal, mailbox or real-time device -- don't use RMS
		unless _extern sys\$assign(
					/* devnam */	Temp_Desc(devname),
					/* chan   */	_fab@FAB$L_STV,
					/* acmode */	,
					/* mbxnam */	)
		_bitst _1 then
			return(false)
		endunless;
		sysstring!DIB\$L_DEVCHAR -> _fab!FAB$L_DEV;
		sysstring!DIB\$W_DEVBUFSIZE -> _fab!FAB$W_BLS;
		_:'FAB$M_UFO' -> _fab!FAB$L_FOP

	else
		;;; use RMS -- initialise nam block
		_work_nam -> _fab!FAB$L_NAM;			;;; set temp nam block in fab
		sysstring@V_BYTES -> _work_nam!NAM$L_RSA;
		if sysstring!V_LENGTH _lt _16:FF then
			sysstring!V_LENGTH
		else
			_16:FF
		endif -> _work_nam!NAM$B_RSS;

		_fab!FAB$L_FOP _bitst _:'FAB$M_CIF' -> _create_if;
		unless (_extern[INDIR] _rms_routine(_fab) ->> _res) _bitst _1 then
			;;; failed
			if _create_if
			and (_syserror == _:'RMS$_FLK' or _syserror == _:'RMS$_PRV') then
				;;; exclusive create specified and file already exists, but
				;;; failed to open it because locked by another user
				;;; or protection violation
				_:'RMS$_FEX' -> _syserror		;;; File EXists
			else
				_fab!FAB$L_STV -> _rmserror		;;; save ACP code in _rmserror
			endif;
			return(false)
		elseif _create_if and _res /== _:'RMS$_CREATED' then
			;;; exclusive create specified and file already exists
			_extern sys\$close(_fab) -> ;	;;; close file
			_:'RMS$_FEX' -> _syserror;		;;; File EXists
			return(false)
		endunless;

		;;; if want c/r and this is a disk or tape, then FORCE c/r
		if cr and _fab!FAB$L_DEV _bitst _:'DEV$M_FOD' then
			_fab!FAB$B_RAT _biset _:'FAB$M_CR' -> _fab!FAB$B_RAT
		endif;

		;;; full name is in sysstring
		_work_nam!NAM$B_RSL -> _sysstring_len;	;;; length of full name
		Uptolow_sysstring();
		Copy_sysstring() -> devname;

		ctrl_blk@ICB_RAB -> _rab;			;;; get rab
		Rm_rab_init(_rab);					;;; initialise rab
		ctrl_blk@ICB_FAB -> _rab!RAB$L_FAB;	;;; insert fab in rab
		unless _extern sys\$connect(_rab) _bitst _1 then
			_rab!RAB$L_STV -> _rmserror;
			return(false)
		endunless
	endif;

	Rm_set_values(ctrl_blk);
	unless ctrl_blk!ICB_DEVCHAR _bitst _:'DEV$M_FOD' then
		;;; a device
		if (isendstring(':[].;', devname) ->> _n)
		or (isendstring(':.;', devname) ->> _n)
		then
			substring(1, _n, devname) -> devname
		endif;;
		;;; 2:1000 = translate concealed names
		if systranslate(devname, 2:1000) ->> filename then
			filename -> devname
		endif
	endunless;

	devname
enddefine;

	/*	Open a file
	*/
define Rms_open();
	Rm_open_create(_extern sys\$open)
enddefine;

	/*	Create a file
	*/
define Rms_create(ctrl_blk);
	lvars ctrl_blk;
	Rm_open_create(ctrl_blk, _extern sys\$create);
	_0 -> ctrl_blk!ICB_EOF_BYTE		;;; set eof byte correctly to 0
enddefine;

	/*	Close a file
	*/
define Rms_close(ctrl_blk);
	lvars ctrl_blk, _fab = ctrl_blk@ICB_FAB;
	if _fab!FAB$L_FOP _bitst _:'FAB$M_UFO' then
		;;; deassign the opened channel
		_extern sys\$dassgn(ctrl_blk!ICB_CHANNEL) -> ;
	else
		_extern sys\$disconnect(ctrl_blk@ICB_RAB) -> ;
		_extern sys\$close(_fab) ->
	endif
enddefine;


;;; --- RECORD I/O --------------------------------------------------------

	/*	Get a record
	*/
define Rms_get(dev, prompt) -> _result;
	lvars	buf = dev!D_IN_BUFFER, ctrl_blk = dev!D_CTRL_BLK, prompt, dev,
			_rab, _recsize, _fab = ctrl_blk@ICB_FAB, _result;

	_0 ->> buf!BUF_POSITION -> buf!BUF_COUNT;	;;; reset buff position

	if dev!D_FLAGS _bitst _M_D_LOGICAL_TERM then
		;;; terminal (or mailbox pretending to be one)
		_terminal_io_done _add _1 -> _terminal_io_done
	endif;
	if _fab!FAB$L_DEV _bitst _:'DEV$M_TRM' then
		;;; real terminal -- do I/O via system services
		chain(dev, prompt, Trm_read)
	endif;

	if _fab!FAB$L_DEV _bitst _:'DEV$M_MBX' then
		;;; mailbox -- do I/O via system services
		Mbx_read(dev);
		dev!D_IN_BUFFER -> buf		;;; Could have changed to fixed-address

	else
		ctrl_blk@ICB_RAB -> _rab;
		_fab			 -> _rab!RAB$L_FAB;		;;; reset fab addr in rab
		buf@BUF_START	 -> _rab!RAB$L_UBF;		;;; set buff addr in rab
		buf!BUF_SIZE	 -> _rab!RAB$W_USZ;		;;; and buff size

		if _extern sys\$get(_rab) _bitst _1 then
			_rab!RAB$W_RSZ -> buf!BUF_COUNT;	;;; record size in bytes
			true
		elseif _syserror == _:'RMS$_EOF' then
			;;; end-of-file
			0									;;; return true
		else
			;;; error
			_rab!RAB$L_STV -> _rmserror;		;;; ACP error code in here
			false								;;; return false
		endif
	endif -> _result;

	if _result == true then
		;;; add newline at end of record if file has C/R, Print or Fortran
		;;; Record ATtribute (and there's space in the buf for it)
		buf!BUF_COUNT -> _recsize;
		if ctrl_blk@ICB_FAB!FAB$B_RAT _bitst _:'FAB$M_CR!FAB$M_PRN!FAB$M_FTN'
		and _recsize _lt buf!BUF_SIZE then
			_:`\n` -> buf!BUF_START[_recsize];
			_recsize _add _1 -> buf!BUF_COUNT
		endif
	endif
enddefine;

define lconstant Rm_write_error(_rab);
	lvars _rab, _fab, _acperr = _rab!RAB$L_STV;	;;; ACP error code
	if _syserror == _:'RMS$_EXT'				;;; (is disk extend error)
	and (_acperr == _:'SS$_EXDISKQUOTA' or _acperr == _:'SS$_OVRDSKQUOTA')
	then
		;;; disk quota error
		_rab!RAB$L_FAB -> _fab;				;;; get fab
		;;; try to allocate 3 blocks
		_3 -> _fab!FAB$L_ALQ;				;;; ALlocation Quantity
		if _extern sys\$extend(_fab) _bitst _1 then
			;;; extend worked -- return to try again
			return(if _acperr == _:'SS$_OVRDSKQUOTA' then 1 else 0 endif)
		endif
	endif;

	;;; else return false for error
	_acperr -> _rmserror;
	false
enddefine;

	/*	Put a record
	*/
define Rms_put(dev) -> _result;
	lvars	buffer = dev!D_OUT_BUFFER, ctrl_blk = dev!D_CTRL_BLK, dev,
			_rab, _size, _n, _fab = ctrl_blk@ICB_FAB, _result = true;

	if dev!D_FLAGS _bitst _M_D_LOGICAL_TERM then
		;;; terminal (or mailbox pretending to be one)
		_terminal_io_done _add _1 -> _terminal_io_done
	endif;
	if _fab!FAB$L_DEV _bitst _:'DEV$M_TRM' then
		;;; real terminal -- do I/O via system services
		chain(dev, Trm_write)
	endif;

	unless _zero(buffer!BUF_POSITION ->> _n ->> _size) then
		;;; remove newline at end of record if file has C/R, Print or Fortran
		;;; Record ATtribute
		if _fab!FAB$B_RAT _bitst _:'FAB$M_CR!FAB$M_PRN!FAB$M_FTN'
		and buffer!BUF_START[_size _sub _1] == _:`\n` then
			_size _sub _1 -> _size	;;; remove the newline
		endif
	endunless;

	if _fab!FAB$L_DEV _bitst _:'DEV$M_MBX' then
		;;; mailbox -- do I/O via system services
		_size -> buffer!BUF_POSITION;
		Mbx_write(dev, _zero(_n)) -> _result

	else
		ctrl_blk@ICB_RAB-> _rab;
		_fab			-> _rab!RAB$L_FAB;		;;; reset fab addr in rab
		buffer@BUF_START-> _rab!RAB$L_RBF;		;;; set record addr in rab
		_size			-> _rab!RAB$W_RSZ;		;;; and record size

		until _extern sys\$put(_rab) _bitst _1 do
			returnunless(Rm_write_error(_rab) ->> _result)
		enduntil
	endif;

	;;; OK -- return value of _result
	_0 -> buffer!BUF_POSITION			;;; clear buffer
enddefine;

define Rms_flush(ctrl_blk);
	lvars ctrl_blk, _rab = ctrl_blk@ICB_RAB;
	if ctrl_blk@ICB_FAB!FAB$L_FOP _bitst _:'FAB$M_UFO'
	or _extern sys\$flush(_rab) _bitst _1 then
		true
	else
		_rab!RAB$L_STV -> _rmserror;
		false
	endif
enddefine;


;;; --- BLOCK I/O --------------------------------------------------------

	/*	Read blocks
	*/
define Rms_read(buffer, ctrl_blk);
	lvars buffer, ctrl_blk, _rab;
	ctrl_blk@ICB_RAB -> _rab;
	ctrl_blk@ICB_FAB -> _rab!RAB$L_FAB;		;;; reset fab addr in rab
	buffer@BUF_START -> _rab!RAB$L_UBF;		;;; set buff addr in rab
	buffer!BUF_SIZE  -> _rab!RAB$W_USZ;		;;; and buff size
	buffer!BUF_BLK_NUM  -> _rab!RAB$L_BKT;	;;; block number to start read
	_0 ->> buffer!BUF_POSITION -> buffer!BUF_COUNT;	;;; reset buff position
	;;; set unmodified
	buffer!BUF_FLAGS _biclear _M_BUF_MODIFIED -> buffer!BUF_FLAGS;
	if _extern sys\$read(_rab) _bitst _1 then
		_rab!RAB$W_RSZ -> buffer!BUF_COUNT;	;;; size read in bytes
		true								;;; return true
	elseif _syserror == _:'RMS$_EOF' then
		;;; end-of-file
		true								;;; return true
	else
		;;; error
		_rab!RAB$L_STV -> _rmserror;		;;; ACP error code in here
		false								;;; return false
	endif
enddefine;

	/*	Write blocks
	*/
define Rms_write(buffer, ctrl_blk) -> _result;
	lvars buffer, ctrl_blk, _rab, _result = true;
	ctrl_blk@ICB_RAB -> _rab;
	ctrl_blk@ICB_FAB -> _rab!RAB$L_FAB;		;;; reset fab addr in rab
	buffer@BUF_START -> _rab!RAB$L_RBF;		;;; set buff addr in rab
	buffer!BUF_COUNT -> _rab!RAB$W_RSZ;		;;; and size
	buffer!BUF_BLK_NUM  -> _rab!RAB$L_BKT;	;;; block number to start write

	until _extern sys\$write(_rab) _bitst _1 do
		returnunless(Rm_write_error(_rab) ->> _result)
	enduntil;

	;;; OK -- return value of _result
	;;; set unmodified
	buffer!BUF_FLAGS _biclear _M_BUF_MODIFIED -> buffer!BUF_FLAGS
enddefine;

define Rms_write_bytes(ctrl_blk, _buff, _nbytes, _blocknum) -> _result;
	lvars ctrl_blk, _buff, _nbytes, _blocknum, _rab, _result = true;
	ctrl_blk@ICB_RAB -> _rab;
	ctrl_blk@ICB_FAB -> _rab!RAB$L_FAB;		;;; reset fab addr in rab
	_buff 			 -> _rab!RAB$L_RBF;		;;; set buff addr in rab
	_nbytes			 -> _rab!RAB$W_RSZ;		;;; and size
	_blocknum  		 -> _rab!RAB$L_BKT;		;;; block number to start write

	until _extern sys\$write(_rab) _bitst _1 do
		returnunless(Rm_write_error(_rab) ->> _result)
	enduntil
enddefine;


;;; --- USING RMS DISPLAY AND SEARCH ---------------------------------------

define lconstant Get_search_ctrl_blk(search) -> ctrl_blk;
	lvars ctrl_blk = fast_front(search), search, _fab = ctrl_blk@ICB_FAB;
	;;; move in filename addresses (these have already been put in the fab,
	;;; but we have to put them in again in case a GC has changed their
	;;; addresses).
	fast_back(search) -> search;					;;; pair with filenames
	fast_front(search)@V_BYTES -> _fab!FAB$L_FNA;	;;; fname
	fast_back(search)@V_BYTES -> _fab!FAB$L_DNA		;;; dfname
enddefine;

	/*	Open file for display or search
	*/
define Rms_display_search_open(ctrl_blk);
	lvars ctrl_blk, _fab;
	if ispair(ctrl_blk) then
		;;; is a search structure
		Get_search_ctrl_blk(ctrl_blk) -> ctrl_blk
	endif;

	ctrl_blk@ICB_FAB -> _fab;
	;;; set User File Open in File OPtions field of fab
	_fab!FAB$L_FOP _biset _:'FAB$M_UFO' -> _fab!FAB$L_FOP;
	;;; chain a date xab block onto the fhc xab
	_work_datxab -> _work_fhcxab!XAB$L_NXT;
	_work_proxab -> _work_datxab!XAB$L_NXT;	;;; and prot xab on that
	if _extern sys\$open(_fab) _bitst _1 then
		;;; successful open
		Rm_set_values(ctrl_blk);
		Rms_close(ctrl_blk);
		ctrl_blk								;;; for success
	else
		;;; failed -- error code in _syserror
		_fab!FAB$L_STV -> _rmserror;			;;; ACP code in _rmserror
		false									;;; return false
	endif
enddefine;

	/*	Open a file for display only -- fab to be set up
	*/
define Rms_displayopen(/*blockio, cr, _mode, fname, */ ctrl_blk);
	lvars ctrl_blk;
	;;; initialise fab for open
	Rm_fab_init((), ctrl_blk@ICB_FAB);
	chain(ctrl_blk, Rms_display_search_open)
enddefine;

	/*	Display an open file
	*/
define Rms_display(ctrl_blk);
	lvars ctrl_blk, _fab = ctrl_blk@ICB_FAB;
	_work_fhcxab -> _fab!FAB$L_XAB;
	_work_datxab -> _work_fhcxab!FAB$L_XAB;		;;; chain on date xab
	_work_proxab -> _work_datxab!XAB$L_NXT;		;;; and prot xab on that
	_extern sys\$display(_fab) -> ;
	Rm_set_eof_byte(ctrl_blk)
enddefine;

	/*	Initialise an ICB with FAB and NAM blocks
	*/
define Rms_fabnam_init(fname, dfname, ctrl_blk) -> _fab;
	lvars ctrl_blk, fname, dfname, _fab = ctrl_blk@ICB_FAB,
		_nam = ctrl_blk@ICB_NAM;
	Rm_fab_init(false, false, 0, fname, _fab);
	;;; set up default name in fab
	dfname@V_BYTES -> _fab!FAB$L_DNA;
	dfname!V_LENGTH -> _fab!FAB$B_DNS;
	;;; set for open by NAMe block (if required)
	_fab!FAB$L_FOP _biset _:'FAB$M_NAM' -> _fab!FAB$L_FOP;
	;;; set up NAMe block, insert in fab
	_nam -> _fab!FAB$L_NAM;
	_moveq(_nam_template!NAM$B_BLN, _nam_template, _nam) -> ;
	;;; set expanded string addr and length
	ctrl_blk@ICB_NAM_ESA -> _nam!NAM$L_ESA;
	_255 -> _nam!NAM$B_ESS;
	;;; set resultant string addr and length
	ctrl_blk@ICB_NAM_RSA -> _nam!NAM$L_RSA;
	_255 -> _nam!NAM$B_RSS
enddefine;

	/*	Set up parse for a filename & default, return search structure
	*/
define Rms_parse(fname, dfname);
	lvars	ctrl_blk = inits(NAM_ICB_LEN), fname, dfname, _fab,
			_fv, _fe, _fn, _fdr, _fdk, _dv, _de, _dn, _ddr, _ddk;

	;;; select required parts of filename
	sysfileok(fname, true)	-> _fv -> _fe -> _fn -> _fdr -> _fdk -> fname;
	sysfileok(dfname, true) -> _dv -> _de -> _dn -> _ddr -> _ddk -> dfname;

	if _fdk /== 1 or _ddk /== 1 then
		@@NAM$L_NODE
	elseif _fdr /== 1 or _ddr /== 1 then
		@@NAM$L_DEV
	elseif _fn /== 1 or _dn /== 1 then
		@@NAM$L_DIR
	else
		@@NAM$L_NAME
	endif -> ctrl_blk!ICB_FIRST_FIELD;

	_int(_fv) _lteq fname!V_LENGTH or _int(_dv) _lteq dfname!V_LENGTH
											-> ctrl_blk!ICB_WANT_VERSION;

	Rms_fabnam_init(fname, dfname, ctrl_blk) -> _fab;
	;;; call parse
	if _extern sys\$parse(_fab) _bitst _1 then
		;;; return search structure
		conspair(ctrl_blk, conspair(fname, dfname))
	else
		;;; something wrong
		_fab!FAB$L_STV -> _rmserror;
		false
	endif
enddefine;

	/*	Search for next filename, given search structure
	*/
define Rms_search(/*search*/) with_nargs 1;
	lvars	ctrl_blk = Get_search_ctrl_blk(),
			_fab = ctrl_blk@ICB_FAB, _nam = ctrl_blk@ICB_NAM,
			_esa = ctrl_blk@ICB_NAM_ESA, _rsa = ctrl_blk@ICB_NAM_RSA,
			_f, _bdiff
		;

	if _fab!FAB$L_CTX _bitst _1 then
		;;; return termin if PRV error on previous (see below)
		return(termin)
	endif;

	;;; make sure all addresses correct, if GC intervened between
	;;; last call of this procedure
	if _zero(_nam!NAM$B_RSL) then
		;;; resultant string not entered, so this is the first one;
		;;; the filename fields in nam refer to the esa
		##(b){_esa, _nam!NAM$L_ESA}
	else
		;;; otherwise the filename fields refer to the rsa
		##(b){_rsa, _nam!NAM$L_RSA}
	endif -> _bdiff;
	;;; correct all file spec fields in nam block (would not be necessary
	;;; if these were offsets rather than absolute addresses!)
	_nam!NAM$L_NODE@(b)[_bdiff] -> _nam!NAM$L_NODE;
	_nam!NAM$L_DEV@(b)[_bdiff]  -> _nam!NAM$L_DEV;
	_nam!NAM$L_DIR@(b)[_bdiff]  -> _nam!NAM$L_DIR;
	_nam!NAM$L_NAME@(b)[_bdiff] -> _nam!NAM$L_NAME;
	_nam!NAM$L_TYPE@(b)[_bdiff] -> _nam!NAM$L_TYPE;
	_nam!NAM$L_VER@(b)[_bdiff]  -> _nam!NAM$L_VER;
	;;; correct esa and rsa in nam
	_esa -> _nam!NAM$L_ESA;
	_rsa -> _nam!NAM$L_RSA;
	_nam -> _fab!FAB$L_NAM;			;;; set nam in fab

	;;; do search
	if _extern sys\$search(_fab) _bitst _1 then
		;;; 2nd result of true means file can be opened
		true
	else
		_fab!FAB$L_STV -> _rmserror;
		if _syserror == _:'RMS$_NMF' or _syserror == _:'RMS$_FNF'
		or _syserror == _:'RMS$_DNF' or _syserror == _:'RMS$_DEV'
		then
			;;; no more files, or file/dir/dev not found -- return termin
			return(termin)
		elseif _syserror /== _:'RMS$_PRV' then
			;;; return false for anything but PRV
			return(false)
		else
			;;; PRV error
			;;; Next test is due to a bug in RMS - if a fixed directory is
			;;; being matched and that has a protection violation, then $search
			;;; doesn't return RMS$_NMF when it should
			unless _nam!NAM$L_FNB _bitst _:'NAM$M_WILD_DIR' then
				;;; make termin be returned next time
				_fab!FAB$L_CTX _biset _1 -> _fab!FAB$L_CTX
			endunless;
			;;; return 2nd result false, meaning can't open file
			false
		endif
	endif;

	;;; move required part of filename into sysstring
	_nam!(l){ctrl_blk!ICB_FIRST_FIELD} -> _f;	;;; addr of 1st field wanted
	##(b){	if ctrl_blk!ICB_WANT_VERSION then
				_rsa@(b)[_nam!NAM$B_RSL]	;;; end lim of name
			else
				_nam!NAM$L_VER
			endif, _f} -> _sysstring_len;
	_bmove(_sysstring_len, _f, sysstring@V_BYTES) -> ;
	Uptolow_sysstring();				;;; convert to lower case
	_pint(##(b){_nam!NAM$L_NAME, _f});	;;; return path length
	true								;;; and true
enddefine;


;;; --- MISCELLANEOUS -------------------------------------------------------

	/*	Remove a named file
	*/
define Rms_erase(fname, ctrl_blk);
	lvars ctrl_blk, fname, _fab = ctrl_blk@ICB_FAB;
	Rm_fab_init(false, false, 0, fname, _fab);
	if _extern sys\$erase(_fab) _bitst _1 then
		;;; OK
		true
	else
		;;; something went wrong
		_fab!FAB$L_STV -> _rmserror;
		false
	endif
enddefine;

endsection;		/* $-Sys$-Io */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov 22 1994
		Added Rms_write_bytes and Rms_display
--- John Gibson, May 10 1994
		Replaced _e*xtern_indir with _extern[INDIR]
--- John Gibson, Feb 22 1994
		Allowed ____mode arg to Rm_open_create to have 2:100 set to indicate
		'exclusive' create
--- John Gibson, Dec  5 1992
		Fixed async read bug in Rms_get
--- John Gibson, Nov  5 1992
		Fixed Rms_search to return termin for dir/dev not found
--- John Gibson, Dec  1 1990
		Mailbox I/O now done in vmsio.p
--- John Gibson, Oct 10 1990
		VMS _extern changed to return proper system call result (thus test
		for success is now result _bitst _1).
--- John Gibson, Aug  8 1989
		Some rearrangement of procedures used by -sys_file_match etc.
--- John Gibson, Feb 23 1989
		Made Rms_get/put set _terminal_io_done true when used on a device
		with _M_D_LOGICAL_TERM set.
--- John Gibson, Oct 26 1988
		Added use of _M_ICB_MBX_OUTWAIT flag in Rms_put to allow writing to a
		mailbox with wait until another process reads it.
 */
