/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			C.vms/src/syscomp/asmout.p
 > Purpose:
 > Author:			John Gibson (see revisions)
 */

/* -------------------------------------------------------------------------

					 OUTPUT CODE PROCEDURES (VMS)

--------------------------------------------------------------------------*/

#_INCLUDE 'common.ph'
#_INCLUDE 'wdefs.ph'

section $-Popas;

constant macro $-WORD_SHIFT = 2;

define popint(n); lvars n; (n<<WORD_SHIFT) || 2:11 enddefine;

define mcint(n); lvars n; n >> WORD_SHIFT enddefine;

vars	nextlabel;

define nextlab();
	dlocal pop_pr_radix = 36;
	'L' >< nextlabel;
	nextlabel fi_+ 1 -> nextlabel
enddefine;

define lconstant asm_label(word, prefix_char);
	lvars n, q, len, string, upcase = false, r, prefix_char, word;
	lconstant SEP_CHAR = `.`;
	if isstring(word) then word else fast_word_string(word) endif -> string;
	datalength(string) -> len;
	consstring(#|
		prefix_char, SEP_CHAR;
		fast_for n to len do
			go_on dup(fast_subscrs(n, string)) to
			;;; 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6
				c c c c c c c c c c c c c c c c		;;; Ctrl-A -- Ctrl-P
				c c c c c c c c c c c c c c c c		;;; Ctrl-Q -- SPACE
				s s s $ s s s s s s s s s s s d		;;;   !    --   0
				d d d d d d d d d s s s s s s s		;;;   1    --   @
				A A A A A A A A A A A A A A A A		;;;   A    --   P
				A A A A A A A A A A s s s s u s		;;;   Q    --   `
				a a a a a a a a a a a a a a a a		;;;   a    --   p
				a a a a a a a a a a s s s s c c		;;;   q    -- \(128)
			else c;

			d: u:			;;; digit, underscore
				nextloop;

			a:				;;; lowercase alpha
				nextunless(upcase);
				if n == len
				or (fast_subscrs(n fi_+ 1, string) -> q;
					`A` fi_<= q and q fi_<= `Z`)
				then
					;;; upper follows -- represent 1 char case change by $
					() -> q, `$`, q
				else
					;;; next not back to upper -- represent case change by $$
					() -> q, `$`, `$`, q;
					false -> upcase
				endif;
				nextloop;

			A:				;;; uppercase alpha
				nextif(upcase);
				if n == len
				or (fast_subscrs(n fi_+ 1, string) -> q;
					`a` fi_<= q and q fi_<= `z`)
				then
					;;; lower follows -- represent 1 char case change by $
					() -> q, `$`, q
				else
					;;; next not back to lower -- represent case change by $$
					() -> q, `$`, `$`, q;
					true -> upcase
				endif;
				nextloop;

			$ :
				if n /== len and fast_subscrs(n fi_+ 1, string) == `-`
				and (n /== 1 or len fi_> 2) then
					;;; replace section separator $- with SEP_CHAR
					-> ;			;;; erase $
					unless n == 1 then SEP_CHAR endunless;
					n fi_+ 1 -> n;	;;; skip -
					nextloop
				;;; else drop thru to "s"
				endif;

			s: c:				;;; other sign, control etc
				;;; represent as 3 decimal digits
				() fi_// 100 -> q -> r;
				q fi_+ `0`;
				r fi_// 10 -> q -> r;
				q fi_+ `0`, r fi_+ `0`;

		endfor
	|#) -> string;

	;;; max length for assembler label is 31 chars; 29 thus allows
	;;; 2 more prefix letters to be added (why the hell don't DEC
	;;; fix this stupid limitation!)
	datalength(string) -> len;
	returnif(len fi_<= 29) (string);

	;;; encode excess in two chars
	define lconstant alphanum(n);
		lvars n;
		if n fi_< 26 then n fi_+ `A` else n fi_- 26 fi_+ `0` endif
	enddefine;

	0 -> q;
	fast_for n from 28 to len do
		fast_subscrs(n, string) fi_* n fi_+ q -> q
	endfor;
	q fi_// 36 -> q -> n;
	alphanum(n) -> fast_subscrs(28, string);
	alphanum(q fi_rem 36) -> fast_subscrs(29, string);
	substring(1, 29, string)
enddefine;

constant procedure (
	asm_symlabel	= asm_label(%`c`%),
	asm_identlabel	= asm_label(%`i`%),
	asm_wordlabel	= asm_label(%`w`%),
	asm_wordidlabel	= asm_label(%`z`%),
	asm_pdpropslabel= asm_label(%`p`%),
	asm_testdeflabel= asm_label(%`t`%),
	);


	;;; list of pop symbol prefixes for use by -Extern_make_base-
	;;; see extern.p
constant macro $- POP_SYMBOL_PREFIXES =
		[['C.' 'XC.' 'UC.' 'XUC.' 'I.' 'W.' 'Z.' 'P.' 'T.']];


#_IF DEF ALPHA

constant macro (
	$- ASM_CODE_PSECT	= '\t.psect\tpop$code,shr,exe,nowrt,quad,pic\n',
	$- ASM_NWRIT_PSECT	= '\t.psect\tpop$nwdata,noshr,noexe,nowrt,quad\n',
	$- ASM_DATA_PSECT	= '\t.psect\tpop$data,noshr,noexe,wrt,quad\n',
	);

  #_IF DEF POPC
	vars 	current_asm_segment, asm_nwdata_offset,
			procedure (nwdata_lab_offset, pdr_literal_label);
  #_ENDIF

#_ELSE

constant macro (
	$- ASM_NWRIT_PSECT	= '\t.psect\tpopcode,shr,exe,nowrt,long\n',
	$- ASM_DATA_PSECT	= '\t.psect\tpopdata,noshr,noexe,wrt,long\n',
	);

vars file_total_bytecount;

#_ENDIF

vars
	$-popc_vms_macdef_ops = [],
	$-popc_vms_extern_weak = [],
	;

define asm_startfile(a_name);
	lvars a_name;
#_IF DEF ALPHA
	lconstant tstring = '\t.title\t"%p"\n';
  #_IF DEF POPC
	0 -> asm_nwdata_offset;
	newproperty([], 64, false, "perm") -> nwdata_lab_offset;
	newmapping([], 32, false, false) -> pdr_literal_label;
  #_ENDIF
#_ELSE
	lconstant tstring = '\t.title\t%p\n';
	0 -> file_total_bytecount;
#_ENDIF

	;;; this determines the module name when the object file is
	;;; put in a library, so it must be the object file name
	asmf_printf(sys_fname_nam(a_name) <> OBJ_EXTENSION, tstring);

 #_IF DEF POPC
	;;; load library macro definitions of symbols (like FAB$, DEV$ etc)
	applist(popc_vms_macdef_ops, #_< asmf_printf(% '\t$%pDEF\n' %) >_#);
	;;; output .weak declarations for _extern[WEAK] references
	applist(popc_vms_extern_weak, #_< asmf_printf(% '\t.weak\t%p\n' %) >_#);
#_ENDIF
enddefine;

define asm_endfile = outcode(% '.end' %) enddefine;

define asm_startcode	= outcode(%'\n'<>ASM_NWRIT_PSECT%) enddefine;
define asm_startdata	= outcode(%'\n'<>ASM_DATA_PSECT%) enddefine;
#_IF DEF ALPHA
define asm_startinstr	= outcode(%'\n'<>ASM_CODE_PSECT%) enddefine;
#_ENDIF

define lconstant output_lab(lab, string);
	lvars lab, string;
	asmf_charout(lab), asmf_charout(string);

#_IF DEF POPC and DEF ALPHA
	if current_asm_segment == ASMSEG_NONWRITEABLE then
		asm_nwdata_offset -> nwdata_lab_offset(lab)
	endif
#_ENDIF
enddefine;
;;;
define asm_outlab  = output_lab(% ':\n' %) enddefine;
define asm_outglab = output_lab(% '::\n' %) enddefine;


define lconstant labset(lab, val, string);
	lvars lab, val, string, offs;
	asmf_printf(val, lab, string);

#_IF DEF POPC and DEF ALPHA
	returnunless(current_asm_segment);		;;; i.e. if doing .s file
	if nwdata_lab_offset(val) ->> offs then
		offs -> nwdata_lab_offset(lab)
	endif
#_ENDIF
enddefine;
;;;
define asm_outlabset  = labset(% '%p = %p\n' %) enddefine;
define asm_outglabset = labset(% '%p == %p\n' %) enddefine;


define lconstant outdatum(n, string, nbytes);
	lvars m, n, string, nbytes;
	returnif(n == 0);
	asmf_charout(string);
	fast_for m from n by -1 to 2 do
		asmf_pr(subscr_stack(m)), asmf_charout(`,`)
	endfor;
	asmf_pr();
	erasenum(n-1);
	asmf_charout(`\n`);

#_IF DEF POPC and DEF ALPHA
	if current_asm_segment == ASMSEG_NONWRITEABLE then
		asm_nwdata_offset fi_+ (n fi_* nbytes) -> asm_nwdata_offset
	endif
#_ENDIF
enddefine;
;;;
define asm_outbyte	= outdatum(% '\t.byte\t', BYTE_OFFS %) enddefine;
define asm_outshort	= outdatum(% '\t.word\t', SHORT_OFFS %) enddefine;
define asm_outint	= outdatum(% '\t.long\t', INT_OFFS %) enddefine;
define asm_outword	= outdatum(% '\t.long\t', INT_OFFS %) enddefine;


	;;; asm_align_double() -- output alignment for double (e.g. double float)
define asm_align_double();
#_IF DEF ALPHA
	outcode('.align quad');

  #_IF DEF POPC
	if current_asm_segment == ASMSEG_NONWRITEABLE then
		(asm_nwdata_offset+7) &&~~ 7 -> asm_nwdata_offset
	endif
  #_ENDIF
#_ENDIF
enddefine;


	;;; asm_out_dfloat(_______hi_part, _______lo_part) -- output double float
define asm_out_dfloat	= asm_outint(% 2 %) enddefine;

	;;; asm_align_file() -- output end-of-file alignment
	;;; (don't define if no alignment necessary)
#_IF DEF ALPHA
define asm_align_file	= asm_align_double(%%) enddefine;
#_ENDIF




	/*	asm_addbits is used to accumulate a sequence of bitfields into
		a (big)integer which asm_outbits is then called to output when the
		total number of bits accumulated occupies an exact number of bytes.
			___val is the currently accumulated (big)integer, containing
		_____nbits bits so far; _______new_val is the field to be added, containing
		_________new_nbits bits.
			The value returned will be the ___val input for the next field
		(with _____nbits incremented by _________new_nbits), and so on. Other than
		initialising ___val to 0 at the start, nothing is assumed about how
		the fields are added to it, so it is the responsibility of this
		procedure and asm_outbits to output the bitfields correctly.
	*/

	;;; VAX/ALPHA version ('little endian'), adds the fields at the
	;;; top and outputs the bytes from the bottom up
define asm_addbits(new_val, new_nbits, val, nbits);
	lvars new_val, new_nbits, val, nbits;
	val || (new_val << nbits) 	;;; add the new field at the top
enddefine;

	/*	In this, _____nbits is a multiple of BYTE_BITS, and ___val has been
		produced by repeated calls of asm_addbits
	*/
define asm_outbits(val, nbits);
	lvars val, nbits, count = 0;
	lconstant BYTE_MASK = (1<<BYTE_BITS)-1;
	until nbits == 0 do
		val && BYTE_MASK;			;;; output bytes from the bottom up
		val >> BYTE_BITS -> val;
		nbits-BYTE_BITS -> nbits;
		;;; this just saves putting each byte on a separate line
		if (count+1 ->> count) == 12 then asm_outbyte(count), 0 -> count endif;
	enduntil;
	if count /== 0 then asm_outbyte(count) endif
enddefine;


	/*	Optional procedure used (if present) by Poplink
		to do more compact generation of strings using ".ascii"
	*/

define asm_quick_genstring(string);
	lvars c, n = 1, l = datalength(string), string;
#_IF DEF ALPHA
	until n fi_> l do
		f_subs(n, string) -> c;
		returnif(c fi_< `\s` or c fi_> `~` or c == `\\` or c == `"`) (false);
		n fi_+ 1 -> n
	enduntil;
	asmf_charout('\t.ascii "');
	asmf_charout(string);
	l && (WORD_BYTES-1) -> l;
	unless l == 0 then
		fast_repeat WORD_BYTES-l times asmf_charout('\\x00') endrepeat;
	endunless;
	asmf_charout(`"`);
#_ELSE
	until n fi_> l do
		f_subs(n, string) -> c;
		returnunless(`\s` fi_<= c and c fi_< `~`) (false);
		n fi_+ 1 -> n
	enduntil;
	asmf_charout('\t.ascii ~');
	asmf_charout(string);
	asmf_charout(`~`);
	l && (WORD_BYTES-1) -> l;
	unless l == 0 then
		fast_repeat WORD_BYTES-l times asmf_charout('<0>') endrepeat
	endunless;
#_ENDIF
	asmf_charout(`\n`);
	true
enddefine;


	/*	For closures generated by Poplink for undef procedures
	*/
define asm_gen_poplink_code(outlabs, nfroz, jmplab);
	lvars offs, outlabs, nfroz, jmplab;
#_IF DEF ALPHA
	asm_startinstr();
	outlabs();						;;; plant exec labels
	0 -> offs;
	fast_repeat nfroz times
		asmf_printf(offs, '\tldl\tr0, 20+%p(r27)\n'); ;;; 20 = PD_CLOS_FROZVALS
		offs+WORD_OFFS -> offs;
		asmf_printf(offs, '\tstl\tr0, -%p(r24)\n')
	endrepeat;
	asmf_printf('\tldl\tr27, 16(r27)\n');			  ;;; 16 = PD_CLOS_PDPART
	asmf_printf(offs, '\tlda\tr24, -%p(r24)\n');
	asmf_printf('\tldl\tr0, (r27)\n');
	asmf_printf('\tjmp\t(r0)\n');
	asm_startcode();				;;; back to nonwriteable data
	0			;;; nothing planted in closure header
#_ELSE
	;;; plant exec labels
	outlabs();
	;;; code to push nfroz frozvals (last _____nfroz longwords planted)
	nfroz*4+3 -> offs;
	fast_repeat nfroz times
		;;; offs stays the same each time (+4 for next froz, -4 for instr)
		asmf_printf(offs, '\tmovl\t-%p(pc),-(ap)\n')	;;; 4 bytes
	endrepeat;
	;;; jump to ______jmplab
	asmf_printf(jmplab, '\tjmp\t%p\n');			;;; 6 bytes
	;;; align to longword boundary
	asmf_printf('\t.align\tlong\n');			;;; 2 bytes
	;;; return number of longwords of code planted
	nfroz+2
#_ENDIF
enddefine;

/*
 *	Exfunc closure code -- jump to subroutine _exfunc_clos_action (aextern.s)
 *	with exfunc_closure record address in a reg, etc. This procedure is
 *	passed the label of _exfunc_clos_action. The code generated must be
 *	padded to exactly 4 words.
 */

define asm_gen_exfunc_clos_code(action_lab);
	lvars action_lab;
#_IF DEF ALPHA
	;;; 'code' is a null-frame procedure descriptor (which happens to be 4
	;;; words)
	asmf_printf(action_lab, '\t.quad\t^X3008, %p\n');
#_ELSE
	;;; passes (exfunc_clos address)+8 on stack
	asmf_printf('\t.word\t0\n');			;;; entry mask and jsb -- 8 bytes
	asmf_printf(action_lab, '\tjsb\t@#%p\n');	;;; must be absolute
	asmf_printf('\t.long\t0\n');			;;; pad to 4 longwords
	asmf_printf('\t.long\t0\n');
#_ENDIF
enddefine;


/*
 *	extern_name_translate:
 *		translate an external symbol, using the same conventions as the
 *		C compiler and linker (e.g. add a leading '_', truncate to N
 *		characters, etc.)
 */

define extern_name_translate(lang, symbol, type) -> symbol;
	lvars lang, symbol, type;
	;;; nothing to do
enddefine;

endsection;		/* $-Popas */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Aug 15 1996
		New version of extern_name_translate.
--- John Gibson, Aug 11 1995
		Corrected POP*INT_SHIFT -> WORD_SHIFT
--- John Gibson, Apr  3 1995
		Added asm_outint
--- John Gibson, Feb  9 1995
		Changed current_asm_segment to have the ASMSEG_ values defined in
		common.ph
--- John Gibson, Nov 22 1994
		Moved to C.vms and added Alpha code
--- Robert John Duncan, Mar 22 1994
		Changed asm_gen_poplink_code to plant the execute labels
--- John Gibson, May 19 1993
		Added asm_gen_exfunc_clos_code
--- Robert John Duncan, Jul 27 1992
		Added -extern_name_translate-
--- John Gibson, May  1 1990
		Changed -asm_label- to encode excess chars over 29 in two chars
		at end of label.
--- John Gibson, Jul 17 1989
		OS command procedures moved to C.vms/src/syscomp/os_comms.p
--- John Gibson, Jun  7 1989
		Included common.ph
--- John Gibson, Apr 29 1989
		Made -asm_label- use $$ to indicate lower/uppercase change for
		2 or more adjacent characters of that case (shortens labels for long
		uppercase names).
--- John Gibson, Mar 23 1989
		Added -asm_addbits- and -asm_outbits-
--- John Gibson, Feb  2 1989
		Changed -asm_gen_poplink_code- to allow any number of frozvals to
		be pushed.
--- John Gibson, Nov 29 1988
		Added declaration for sysobey_list (see comment).
--- John Gibson, Aug  2 1988
		Added assembling and linking procedures.
--- John Gibson, Jan 17 1988
		Revised label formats to cope with sections, etc, and
		added new label procedures -asm_wordidlabel-, -asm_pdpropslabel-
		-asm_testdeflabel-.
			Also new procedures -asm_align_double-, -asm_out_dfloat-,
		-asm_gen_poplink_code-.
--- John Gibson, Aug 17 1987
		Added missing lvars declaration for -pre- in -asm_label-
 */
