/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:			C.vms/src/syscomp/os_comms.p
 > Purpose:
 > Author:			John Gibson (see revisions)
 > Related Files:	C.unix/src/syscomp/os_comms.p
 */

/* -------------------------------------------------------------------------

			OPERATING SYSTEM COMMANDS FOR ASSEMBLING & LINKING
								(VMS)

--------------------------------------------------------------------------*/

#_INCLUDE 'common.ph'

section $-Popas;

#_IF hd(sys_os_type)=="unix"
	;;; This is in VMS Poplog, but not in Unix (OK, because it won't
	;;; be used when porting from Unix).
constant procedure sysobey_list;
vars pop_spawn_flags;
#_ENDIF

define lconstant dcl_obey(comms, errms);
	lvars comms, errms;
	dlocal pop_spawn_flags = 2:10;	;;; faster with no DCL symbol copying
	returnif(comms == []);
	if isstring(comms) then
		sysobey(comms)
	elseif tl(comms) == [] then
		sysobey(hd(comms))
	else
		sysobey_list('$ on error then stop \'f$process()' :: comms)
	endif;
	unless testbit(pop_status, 0) then
		mishap(0, errms <> ' (see above)')
	endunless
enddefine;

	/*	Make a filename _f immune from defaults when used in DCL command
	*/
define lconstant immune_filename(f) -> f;
	lvars f;
	unless locchar(`:`, 1, f) then
		unless locchar(`[`, 1, f) then '[]' <> f -> f endunless;
		'sys$disk:' <> f -> f
	endunless;
enddefine;

define lconstant macro_cmnds(plist);
	lvars plist, fpair, o, a;
	lconstant mac32 = '$ macro/nolist/disable=traceback ';
	for fpair in plist do
		destpair(fpair) -> (a, o);
		add_created_file(o);
#_IF DEF ALPHA
		if sys_fname_extn(a) = '.a32' then
			mac32
		else
			'$ macro/alpha/nolist '
		endif
#_ELSE
		mac32
#_ENDIF 		<> a <> '/obj=' <> o
	endfor
enddefine;

define assemble_files(plist);
	lvars plist;
	unless islist(plist) then plist :: [] -> plist endunless;
	dcl_obey([% macro_cmnds(plist) %], 'ERRORS IN ASSEMBLER FILE')
enddefine;

define gen_link_command(exlink, link_cmnd, image_name, wobj_files, link_flags,
						link_other, extern_libdir, share, makebase,
						cleanup_command);
	lvars	f, dir, image_name, wobj_files, exlink, link_cmnd, link_flags,
			link_other, extern_libdir, share, makebase, cleanup_command;
	dlocal	asmf_charout = discout(link_cmnd);

	add_created_file(link_cmnd);

	unless exlink then
		asmf_pr('$ on error then exit\n');
		asmf_pr('$ DBG = "no"\n');
		asmf_pr('$ if p1 .eqs. "-D"\n$ then\n$ DBG = ""\n$ p1 = p2\n$ endif\n');
		asmf_pr('$ IM = p1\n');
		asmf_printf(image_name, '$ if p1 .eqs. "" then IM = "%p"\n');

		asmf_printf(if share then nullstring else '/nosysshr' endif,
					'$ link/notraceback/\'DBG\'debug%p/exe=\'IM\' -\n');
#_IF not(DEF ALPHA)
		if makebase then
			asmf_printf('/sym=\'f$parse(".stb",IM,,,"SYNTAX_ONLY")\' -\n')
		endif;
#_ENDIF
		for f in link_flags do asmf_printf(f, '%p -\n') endfor;
		asmf_pr('sys$input:/option\n')
	;;; else for exlink, just produce an options file
	endunless;

#_IF DEF ALPHA
	lconstant wobj_str = '%p\n';
#_ELSE
	;;; Cluster with so that <false>,<true>,[] (in first poplink file)
	;;; have small addresses
	asmf_printf(dest(wobj_files) -> wobj_files,
							'cluster=poplog$_first,0,,%p\n');
	;;; Cluster for the rest of the pop object files and libraries
	;;; must start at hex 400 (third page), leaving the second page
	;;; free for the external loading mechanism (see vmsextern.p).
	asmf_printf(VPAGE_OFFS*2, 'cluster=poplog$_main,%p,');
	lconstant wobj_str = ',-\n %p';
#_ENDIF

	;;; rest of the pop object files (libraries are in refs)
	for f in wobj_files do
		if isref(f) then cont(f) <> '/library' -> f endif;
		asmf_printf(immune_filename(f), wobj_str)
	endfor;

#_IF DEF ALPHA
	;;; Might as well start at 0 since it's allowed
	asmf_printf('cluster=pop$nwdata,0\ncollect=pop$nwdata,pop$nwdata\n');
#_ELSE
	asmf_charout(`\n`);
#_ENDIF

	;;; pop core libraries
#_IF DEF SHARED_LIBRARIES
	;;; libpop.olb is a shareable image library containing callback
	;;; shareable image(s), while libpop2.olb is an ordinary object
	;;; library containing the remaining internal stuff
	asmf_printf(extern_libdir, ' %plibpop2.olb/library\n');
#_ENDIF
	asmf_printf(extern_libdir, ' %plibpop.olb/library\n');

	for f in link_other do
		if isref(f) then cont(f) <> '/library' -> f endif;
		asmf_printf(f, ' %p\n')
	endfor;

	;;; This special object file must come last so that the dummy identifier
	;;; __pop_shrim_start comes immediately before shareable images.
	asmf_printf(extern_libdir, ' %ppop_shrim_start.object\n');

	;;; Allocate some space for RMS buffers on the callstack
	asmf_pr('iosegment=768\n');

	asmf_charout(termin)
enddefine;

define assemble_and_link(link_cmnd, a_files, im_name, makebase);
	lvars a_files, link_cmnd, im_name, makebase, stb;
	if sys_fname_extn(link_cmnd) == nullstring then
		link_cmnd <> '.' -> link_cmnd
	endif;

	dcl_obey([% macro_cmnds(a_files), '$ @' <> link_cmnd <> ' ' <> im_name%],
					'ERRORS IN LINKING');

	if makebase then
		new_fname_extn(im_name, '.stb') -> stb;
		Extern_make_base(dup(stb), true);
#_IF not(DEF ALPHA)
		sysdelete(stb <> ';-1') ->
#_ENDIF
	endif
enddefine;


define lconstant dcl_obey_libr =
	dcl_obey(%'ERRORS RUNNING LIBRARY UTILITY'%)
enddefine;

define lconstant os_lib_comlist(option, o_lib, o_files);
	lvars	o, l, comlen, linelen, sepc, odir, curdir, option, o_lib,
			o_files, comhead, delcom;
	lconstant macro (MAX_COMM_LEN = 600, MAX_LINE_LEN = 200);

	define lconstant rdelcom(o_lib, o_files);
		lvars o, o_lib, o_files, tmp_name, list;
		add_created_file(new_tmp_file(false, 'plb', '.lis') ->> tmp_name);
		dcl_obey_libr('$ libr/list=' <> tmp_name <> '\s' <> o_lib);
		pdtolist(line_repeater(tmp_name, 256)) -> list;
		[%	for o in o_files do
				sys_fname_name(o) -> o;
				if member(o, list) then o endif
			endfor
		%] -> o_files;
		os_lib_comlist("d", o_lib, o_files)
	enddefine;

	if option == "c" or option == "r" or option == "d" then
		;;; create, replace or delete
		if option == "c" then '/cre'
		elseif option == "r" then '/rep'
		else '/del='
		endif -> comhead;
		false -> delcom;
		[%	until o_files == [] do
				deststring('$ libr ') -> comlen;
				deststring(o_lib) fi_+ comlen -> comlen;
				deststring(comhead) fi_+ comlen -> comlen;
				comlen -> linelen;
				if option == "c" then '/rep' -> comhead endif;
				`\s` -> sepc;
				f_hd(o_files) -> o;
				if option == "d" then
					sys_fname_name(o) -> o, `(`
				else
					sys_fname_path(o) -> odir, `\s`
				endif -> sepc;
				repeat
					datalength(o) fi_+ 1 -> l;
					if comlen fi_+ l fi_> MAX_COMM_LEN then
						if option == "r" and not(delcom) then
							;;; because of symbol phase errors when
							;;; split into multiple commands, have
							;;; to delete rest of modules first
							;;; (those actually in the library)
							rdelcom(o_lib, o_files) -> delcom
						endif;
						quitloop
					endif;
					if linelen fi_+ l fi_> MAX_LINE_LEN then
						consstring(`-`, linelen fi_+ 1), 0 -> linelen
					endif;
					sepc, deststring(o) -> ;
					linelen fi_+ l -> linelen;
					comlen fi_+ l -> comlen;
					quitif((f_tl(o_files) ->> o_files) == []);
					f_hd(o_files) -> o;
					`,` -> sepc;
					if option == "d" then
						sys_fname_name(o) -> o;
						nextloop
					endif;

					odir -> curdir;
					sys_fname_path(o) -> odir;
					if odir = curdir then
						unless odir = nullstring then
							allbutfirst(datalength(odir), o) -> o
						endunless
					else
						immune_filename(o) -> o
					endif
				endrepeat;
				if option == "d" then `)`, linelen fi_+ 1 -> linelen endif;
				consstring(linelen)
			enduntil
		%] -> o;
		if delcom then delcom nc_<> o else o endif

	else
		;;; extract
		[%	for o in o_files do consstring(#|
				explode('$ libr/ext='), explode(sys_fname_name(o)),
				explode('/out='), explode(o), `\s`, explode(o_lib)
			  |#)
			endfor
		%]

	endif
enddefine;

define os_library_command = os_lib_comlist <> dcl_obey_libr enddefine;


	/*	Procedure to run POPLINK/POPLIBR from POPC
	*/
define run_comp_util(arg_list, name);
	lvars a, arg_list, name;
	dcl_obey(
	[%	sprintf(dup(name), '$ %p := $popsys:corepop +popsys:%p.psv'),
		sprintf(name, '$ %p @sys$input:'),
		;;; have to quote all args
		fast_for a in arg_list do
			consstring(#| `"`, explode(a), `"` |#)
		endfor
	%], sprintf(lowertoupper(name), 'ERRORS RUNNING %p'))
enddefine;


endsection;		/* $-Popas */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov 21 1994
		More changes for ALPHA
--- John Gibson, Oct 26 1994
		Different "macro" command for ALPHA
--- John Gibson, Dec  2 1993
		Fixed incorrect IM := "'p1'" in gen_link_command (needs ''p1' inside
		a quoted string)
--- Simon Nichols, Nov 30 1993
		Added declaration of fpair to macro_cmnds.
--- John Gibson, Nov 19 1993
		Changed gen_link_command to take ______exlink arg to say just produce
		an options file containing object/library args
--- John Gibson, Nov 13 1993
		Now only adds libpop.olb to link command
--- John Gibson, Aug 30 1993
		Replaced run*_poplink with run_comp_util
--- John Gibson, Jul 10 1993
		Added ________makebase argument to gen_link_command and assemble_and_link
--- Robert John Duncan, Jun 11 1993
		Changed gen_link_command to write out explicit references to the pop
		external libraries and made it take an additional argument --
		_____________extern_libdir -- which is the directory containing the libraries as
		determined by poplink. Also added an (unused) argument _______________cleanup_command.
		This is all for compatibility with the Unix version, which now has to
		do things a different way.
--- John Gibson, May  6 1993
		Changed gen_link_command to put $popexternlib/pop_shrim_start.object
		at end of link instead of c_c*ore (which is now part of
		$popexternlib/libpop.olb and might get extracted anywhere)
--- John Gibson, Jan 21 1991
		Added -share- arg to -gen_link_command-
--- John Gibson, Nov 22 1990
		Added c_c*ore.obj to link command
--- John Gibson, Nov 17 1990
		Changes to -os_lib_comlist-
--- John Gibson, Aug 23 1990
		Removed 'nop0bufs' from link options file (stops decwindows
		working from VMS 5.3).
--- John Gibson, Jul 26 1989
		New version of -os_library_command- and added -run*_poplink-
--- John Gibson, Jul 17 1989
		Extracted from VMS asmout.p
 */
