/* --- Copyright University of Sussex 1990. All rights reserved. ----------
 > File:            C.vms/src/sysisdirectory.p
 > Purpose:         Test for directory
 > Author:          John Gibson, Nov 25 1991
 > Documentation:	REF *SYSUTIL
 */

;;; ----------------- TEST FOR DIRECTORY (VMS) ---------------------------

#_INCLUDE 'declare.ph'

section $-Sys;

global constant
		procedure (Unix_convert, Explode_substring, Dir_exists)
	;

endsection;


;;; --------------------------------------------------------------------

section $-Sys => sysisdirectory;

define sysisdirectory(dir);
	lvars dir, _n, _e, _v;
	_CLAWBACK_SAVE;
	sysfileok(Unix_convert(dir, true), true) -> (dir, , , _n, _e, _v);
	if _e /== _v and substring(_e, _v fi_- _e, dir) = '.dir' then
		;;; given dir name rather than path -- make a path of it
		consstring(#|
			Explode_substring(1, _n fi_- 1, dir),
			if _n /== 1 and dup() == `]` then -> else `[` endif,
			`.`,
			Explode_substring(_n, _e fi_- _n, dir),
			`]`
		|#) -> dir
	elseif _n fi_<= datalength(dir) then
		;;; not a path
		false -> dir
	endif;
	dir and Dir_exists(dir);
	Clawback(0) ->
enddefine;

endsection;		/* $-Sys */
