/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            C.vms/src/sysobey.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 > Documentation:	REF *SYSUTIL
 */

;;; ----------------- RUN A DCL COMMAND ----------------------------------

#_INCLUDE 'declare.ph'

global constant
		procedure (sys_spawn, device_full_name, sysdelete)
	;

global vars
		poppid, pop_status, Sys$-Io$- _terminal_io_done
	;


;;; ---------------------------------------------------------------------

section $-Sys => sysobey;


	;;; obey a single operating system command string
define sysobey(string);
	lvars string, input, output, may_do_term_output = true;

	;;; copy process output file to current output and delete it
	define lconstant Insert_proc_output(proc_out);
		lvars buff, proc_out, len;
		inits(512) -> buff;
		sysopen(proc_out, 0, "line", `N`) -> proc_out;
		until (fast_sysread(proc_out, 1, buff, 512) ->> len) == 0 do
			fast_syswrite(popdevout, 1, buff, len)
		enduntil;
		sysclose(proc_out);
		sysdelete(device_full_name(proc_out)) ->
	enddefine;

	if isboolean(string) then
		;;; allows false for __________________may_do_term_output, which stops the
		;;; change to _terminal_io_done below (which if done will cause a
		;;; terminal prompt to be re-output).
		((), string) -> (string, may_do_term_output)
	endif;

	;;; for compatibilty with Unix version
	if isinteger(string) then () -> string endif;

	Check_string(string);
	if On_line_term(weakref popdevin) then
		if may_do_term_output then
			;;; will cause prompt to be re-output if in an interrupted
			;;; terminal read
			Io$- _terminal_io_done _add _1 -> Io$- _terminal_io_done
		endif;
		if string = nullstring then
			Print_str('(TYPE "q" OR "lo" TO GET BACK TO POPLOG)\n')
		endif;
		false
	else
		'_NLA0:'
	endif -> input;
	if systrmdev(popdevout) then
		false
	else
		'SYS$SCRATCH:SOB_' sys_>< poppid sys_>< '.OUT'
	endif -> output;
	sys_spawn(string, input, output, true, false) -> (, pop_status);
	if output then
		;;; copy process output to current output
		Insert_proc_output(output)
	endif
enddefine;

endsection;		/* $-Sys */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Apr 19 1994
		Uses new sys_spawn instead of old sys*spawn
--- John Gibson, Jun 20 1991
		Allowed optional bool arg to say whether terminal output may
		be produced or not.
--- John Gibson, Jul 25 1989
		Made -Insert_proc_output- an lconstant
--- John Gibson, Mar 16 1988
		Moved out of sysutil.p
 */
