/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			C.vms/src/sysutil.p
 > Purpose:
 > Author:			John Gibson (see revisions)
 > Documentation:	REF *SYSUTIL
 */

;;;---------------- SYS- UTILITY PROCEDURES ----------------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'vmsdefs.ph'
#_INCLUDE 'memseg.ph'

constant
		procedure (Sys$-No_filename_chars)
	;


vms_use_macdefs JPI, PRT, LNM;		;;; for JPI$ constants etc


;;; ----------------------------------------------------------------------

section $-Sys => systranslate;

define Uptolow_sysstring();
	lvars _baddr, _char, _lim;
	sysstring@V_BYTES -> _lim;
	_lim@(b)[_sysstring_len] -> _baddr;
	while _baddr >@(b) _lim do
		_baddr--!(b) -> _baddr -> _char;
		if _:`A` _lteq _char and _char _lteq _:`Z` then
			_char _add _32 -> _baddr!(b)
		endif
	endwhile
enddefine;

define Temp_Desc(string) -> _desc;
	lvars string;
	lconstant _desc = writeable _DESCRIPTOR '';
	string!V_LENGTH -> _desc!DSPEC_LENGTH;
	string@V_BYTES  -> _desc!DSPEC_PTR
enddefine;


;;; --- VMS SYSTEM CALL UTILITIES --------------------------------------

struct ITM
  {	{ short	ITM_BUFLEN, ITM_FUNC; | long ITM_END; }
	(byte)	ITM_BUFFER;
	(long)	ITM_RETLEN;
  };


	/*	Set info for one item in ______itmp
	*/
define lconstant Set_itmlst1(/*_func, _bufaddr, _buflen, _retlenaddr,*/ _itmp);
	lvars _itmp;

	() -> _itmp!ITM_RETLEN;
	() -> _itmp!ITM_BUFLEN;
	() -> _itmp!ITM_BUFFER;
	() -> _itmp!ITM_FUNC;

	_itmp@(struct ITM)++ -> _itmp;
	_0	-> _itmp!ITM_END;	;;; end of list
enddefine;

	/*	Interface to sys$getjpiw
	*/
define lconstant Vms_jpi(/* _func, _bufaddr, _buflen, _retlenaddr */);
	lstackmem struct ITM _itmp[2];
	Set_itmlst1((), _itmp);
	_extern sys\$getjpiw(
				/* efn	  */	,
				/* pidadr */	,
				/* prcnam */	,
				/* itmlst */	_itmp,
				/* iosb	  */	,
				/* astadr */	,
				/* astprm */	) ->
enddefine;

define Vms_jpi_string(/*func,*/ _tolower);
	lvars _tolower;
	Vms_jpi((), sysstring@V_BYTES, sysstring!V_LENGTH, ident _sysstring_len);
	if _tolower then Uptolow_sysstring() endif;
	Copy_sysstring()
enddefine;

	/*	Name of the POPLOG image
	*/
define Vms_get_image_name();
	Vms_jpi_string(_:'JPI$_IMAGNAME', true)
enddefine;

define Vms_jpi_int(/*_func*/) -> _val;
	dlvars _val;
	Vms_jpi((), ident _val, ##(b)[_1|w], _NULL)
enddefine;

	/*	Return the absolute limit for the callstack
	*/
define Abs_callstack_lim();
	;;; addr of first free page below callstack minus size of remaining
	;;; available pages
	Vms_jpi_int(_:'JPI$_FREP1VA')
			@(vpage)-[Vms_jpi_int(_:'JPI$_PAGFILCNT') _sub _1 | vpagelet.t]
enddefine;

	/*	Called by setpop etc after clearing the callstack. Free any
		excess memory used by unwound callstack calls.
	*/
define Dealloc_callstack_mem();
	lvars _pages;
	;;; leave at least 32 pagelets
	##(vpage){ _sp(), Vms_jpi_int(_:'JPI$_FREP1VA') | csword }
			_sub ##(vpage)[_32 | vpagelet.r] -> _pages;
	if _pages _sgr _0 then
		_extern sys\$cntreg(/* pagcnt */	##(vpagelet)[_pages|vpage],
							/* retadr */	,
							/* acmode */	,
							/* region */	_1) ->
	endif
enddefine;

	/*	Interface to sys$getsyiw
	*/
define lconstant Vms_syi(/* _func, _bufaddr, _buflen, _retlenaddr */);
	lstackmem struct ITM _itmp[2];
	Set_itmlst1((), _itmp);
	_extern sys\$getsyiw(
				/* efn	  */	,
				/* csiadr */	,
				/* nodename */	,
				/* itmlst */	_itmp,
				/* iosb	  */	,
				/* astadr */	,
				/* astprm */	) ->
enddefine;

define Vms_syi_int(/*_func*/) -> _val;
	dlvars _val;
	Vms_syi((), ident _val, ##(b)[_1|w], _NULL)
enddefine;

	/* Set protections on pages
	*/
define Set_mem_prot(_base, _lim, _prot);
	lvars _base, _lim, _prot;
	lstackmem struct MEMRANGE _mrp;
	if _prot == _M_PROT_NONE then
		;;; no access
		_:'PRT$C_NA'
	elseif _prot == _M_PROT_NOWRITE then
		;;; read/execute only
		_:'PRT$C_UR'
	else
		;;; read/write/execute
		_:'PRT$C_UW'
	endif -> _prot;
	_base		-> _mrp!MR_FIRST_ADDR;
	_lim--@(b)	-> _mrp!MR_LAST_ADDR;
	_extern sys\$setprt(/* inadr  */	_mrp,
						/* retadr */	,
						/* acmode */	,
						/* prot	  */	_prot,
						/* prvprt */	)
		_bitst _1
enddefine;

	/* Delete an area of memory
	*/
define Delete_mem(_baseaddr, _size);
	lvars _baseaddr, _size;
	lstackmem struct MEMRANGE _mrp;
	_baseaddr					 -> _mrp!MR_FIRST_ADDR;
	_baseaddr@(w){_size} _sub _1 -> _mrp!MR_LAST_ADDR;
	_extern sys\$deltva(
				/* inadr  */	_mrp,
				/* retadr */	,
				/* acmode */	) ->
enddefine;

	/* Create an area of memory
	*/
define Create_mem(_baseaddr, _size);
	lvars _baseaddr, _size;
	lstackmem struct MEMRANGE _mrp;
	_baseaddr					 -> _mrp!MR_FIRST_ADDR;
	_baseaddr@(w){_size} _sub _1 -> _mrp!MR_LAST_ADDR;
	_extern sys\$cretva(
				/* inadr  */	_mrp,
				/* retadr */	,
				/* acmode */	) ->
enddefine;


;;; --- LOGICAL NAMES ----------------------------------------------------

define lconstant Set_lnm_itmlst(_itmp, _nattr_id, string, _retlen_id);
	lvars string, _itmp, _nattr_id, _retlen_id;

	##(b)[_1|w]			-> _itmp!ITM_BUFLEN;
	_:'LNM$_ATTRIBUTES'	-> _itmp!ITM_FUNC;
	_nattr_id			-> _itmp!ITM_BUFFER;
	_NULL				-> _itmp!ITM_RETLEN;

	_itmp@(struct ITM)++ -> _itmp;
	string!V_LENGTH		-> _itmp!ITM_BUFLEN;
	_:'LNM$_STRING'		-> _itmp!ITM_FUNC;
	string@V_BYTES		-> _itmp!ITM_BUFFER;
	_retlen_id			-> _itmp!ITM_RETLEN;

	_itmp@(struct ITM)++ -> _itmp;
	_0			-> _itmp!ITM_END	;;; end of list
enddefine;

	/*	translate a logical name
		optional flags argument specifies:
			bits 0,1 :	unused (used for table number in updater)
			bit	 2	 :	leave case alone (default is match logname case blind
						and return result in lower case)
			bit	 3	 :	return a concealed translation (default is don't)
	*/
define systranslate(logname);
	lvars	logname, eqname, _res, _flags = 0, _l, _single_case,
			_noconceal;
	dlvars	_nattr, _tattr;
	lstackmem struct ITM _itmp[3];
	_CLAWBACK_SAVE;

	if isboolean(logname) then
		unless logname then 2:1000 -> _flags endunless;
		-> logname
	elseif isinteger(logname) then
		logname -> _flags;
		-> logname
	endif;
	Check_string(logname);
	datalength(logname) -> _l;
	returnif(_l == 0) (false);

	if fast_subscrs(_l,logname) == `:` then
		_l fi_- 1 -> _l;
		if _l fi_> 1 and fast_subscrs(_l,logname) == `:` then
			;;; host spec ending with :: -- only allow translation if it
			;;; ends with :: (this is what RMS does)
			systranslate(substring(1, _l fi_- 1, logname), _flags) -> logname;
			unless logname and (datalength(logname) ->> _l) fi_> 2
			and fast_subscrs(_l,logname) == `:`
			and fast_subscrs(_l fi_- 1,logname) == `:`
			then
				false -> logname
			endunless
		else
			systranslate(substring(1, _l, logname), _flags) -> logname;
			if logname and No_filename_chars(logname) then
				logname sys_>< ':' -> logname
			endif
		endif;
		return(Clawback(logname))
	endif;

	_flags &&=_0 2:1000 -> _noconceal;
	_flags &&=_0 2:0100 -> _single_case;
	if _single_case then _:'LNM$M_CASE_BLIND' else _0 endif -> _tattr;
	Set_lnm_itmlst(_itmp, ident _nattr, sysstring, ident _sysstring_len);
	_extern sys\$trnlnm(
					/*  attr  */ ident _tattr,
					/* tabnam */ _DESCRIPTOR 'LNM$FILE_DEV',
					/* lognam */ Temp_Desc(logname),
					/* acmode */ ,
					/* itmlst */ _itmp)
		-> _res;

	returnif(not(_res _bitst _1) or _res == _:'SS$_NOLOGNAM'
			 or (_noconceal and _nattr _bitst _:'LNM$M_CONCEALED'))
				(Clawback(false));
	if _nonzero(_sysstring_len) and fast_subscrs(1,sysstring) == `\^[` then
		;;; process permanent file - ignore first 4 chars
		substring(5, _pint(_sysstring_len _sub _4), sysstring)
	else
		Copy_sysstring()
	endif -> eqname;
	if eqname = logname then
		false
	elseif not(_nattr _bitst _:'LNM$M_TERMINAL')
	and (systranslate(eqname, _flags) ->> logname) then
		logname
	elseif _single_case then
		uppertolower(eqname)
	else
		eqname
	endif;
	Clawback()
enddefine;


	/*	Assign to a logical name.
		optional flags argument specifies:
			bits 0,1 :	table number (3 = process in user mode,
									  2 = process in supervisor mode,
									  1 = group,
									  0 = system,
									   default is process in user mode)
			bit	 2	 :	leave case alone (default is convert both args to
						uppercase)
			bit	 3	 :	mark as concealed translation (default is don't)
	*/
define updaterof systranslate(eqname, logname);
	lvars	logname, eqname, ldesc, _flags, _table, _super, _single_case,
			_noconceal, _ldesc, _tabdesc;
	dlvars	_nattr;
	lstackmem struct ITM _itmp[3];

	3 -> _flags;			;;; default to process table in user mode
	if isinteger(logname) then
		;;; optional table/mode and flag spec
		logname -> _flags, eqname -> logname;
		-> eqname
	endif;
	_flags &&=_0 2:0100 -> _single_case;
	_flags &&=_0 2:1000 -> _noconceal;
	_flags fi_&& 2:0011 -> _table;
	_table == 2 -> _super;
	if _table fi_>= 2 then
		_DESCRIPTOR 'LNM$PROCESS'
	elseif _table == 1 then
		_DESCRIPTOR 'LNM$GROUP'
	else
		_DESCRIPTOR 'LNM$SYSTEM'
	endif -> _tabdesc;

	if logname then
		Check_string(logname);
		if _single_case then lowertoupper(logname) -> logname endif;
	endif;

	if eqname then
		;;; assigning to logname
		Check_string(logname);
		Check_string(eqname);
		if _single_case then lowertoupper(eqname) -> eqname endif;
		if _noconceal then _0 else _:'LNM$M_CONCEALED' endif -> _nattr;
		Set_lnm_itmlst(_itmp, ident _nattr, eqname, _NULL);
		Temp_Desc(logname) -> _ldesc;
		if _super then
			_extern lib\$set_logical(
								/* lognam */  _ldesc,
								/* eqlnam */  ,
								/* tabnam */  ,		;;; defaults to process
								/* attr   */  ,
								/* itmlst */  _itmp)
		else
			_extern sys\$crelnm(
								/* attr   */  ,
								/* tabnam */  _tabdesc,
								/* lognam */  _ldesc,
								/* acmode */  ,
								/* itmlst */  _itmp)
		endif;
		unless () _bitst _1 then
			Syserr_mishap(logname, 1, 'ERROR ASSIGNING LOGICAL NAME')
		endunless

	else
		;;; deassigning
		if logname then Temp_Desc(logname) else _NULL endif -> _ldesc;
		unless _super then
			_extern sys\$dellnm(
								/* tabnam */  _tabdesc,
								/* lognam */  _ldesc,
								/* acmode */  )
		elseif logname then
			_extern lib\$delete_logical(
								/* lognam */  _ldesc)
		else
			_extern lib\$delete_logical()
		endunless;
		unless () _bitst _1 then
			Syserr_mishap(if logname then logname, 1 else 0 endif,
								'ERROR DEASSIGNING LOGICAL NAME(S)')
		endunless
	endif
enddefine;


;;; --- VMS ERROR MESSAGES ------------------------------------------------

vars
	_rmserror		= _0;	;;; holds RMS error code

define Os_error_message();
	lvars _errorcode;
	_syserror -> _errorcode;
	if _rmserror == _:'SS$_EXDISKQUOTA'
		or _errorcode == _:'RMS$_CRE'
		or _errorcode == _:'RMS$_EXT'
		or _errorcode == _:'RMS$_ACC'
	then
		_rmserror -> _errorcode;
		returnif(_errorcode == _:'SS$_EXQUOTA') (' (too many files open)')
	endif;
	;;; get the error ms into sysstring
	_extern sys\$getmsg(
					/* msgid  */	_errorcode,
					/* msglen */	ident _sysstring_len,
					/* bufadr */	_sysstring_desc,
					/* flags  */	_1,
					/* outadr */	)
		-> ;
	Copy_sysstring()
enddefine;


endsection;		/* $-Sys */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Apr 12 1996
		sysio*message -> nonexported Os_error_message without the brackets
--- John Gibson, Jun  2 1994
		Uses lstackmem instead of heap structs
--- John Gibson, Apr 13 1991
		Added -Delete_mem- and -Create_mem-.
--- John Gibson, Oct 10 1990
		VMS _extern changed to return proper system call result (thus test
		for success is now result _bitst _1).
--- John Gibson, May 22 1990
		Added procedures for getting sys$syiw information
--- John Gibson, Sep 11 1989
		Added -Dealloc_callstack_mem-. Rewrote -systranslate- and updater
		to use newer VMS system procedures sys$trnlnm, sys$crelnm instead
		of defunct sys$trnlog, sys$crelog etc. (It therefore now handles
		concealed names properly.)
--- John Gibson, Aug 31 1989
		Changed some names, added -Abs_callstack_lim-.
--- John Gibson, Aug 23 1989
		Moved -sysexit- stuff to C.all file sysexit.p
--- Roger Evans, Mar  7 1989
		Modified sysexit to clobber all IO and interrupts before running
		popexit, vedpopexit etc. when pop_exit_ok is false
--- John Gibson, Nov 22 1988
		Added missing ;;; on comment in -Set_mem_prot-
--- Roger Evans, Nov 18 1988
		Modified sysexit to do no IO if pop_exit_ok is false
		Added fast_sysexit
--- John Gibson, Aug 11 1988
		Replaced -Vms_setprt- with -Set_mem_prot-
--- John Gibson, Mar 16 1988
		Moved various procedures out to separate files
--- John Gibson, Feb 22 1988
		Check_string into section Sys
--- John Gibson, Feb 16 1988
		Weakref'ed Sys$-Extern$-Delete_link_files
--- John Gibson, Feb 15 1988
		Moved -systmpfile- into new file C.all/src/systmpfile.p.
		Weakref'ed -vedpopexit-.
--- John Gibson, Feb 11 1988
		Pint_->_uint etc in section Sys
 */
