/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 > File:			C.vms/src/vmsdefs.ph
 > Purpose:
 > Author:			John Gibson (see revisions)
 */

;;;------------------ VMS SYMBOL DEFINITIONS -------------------------------

struct DEVUNIT_N			;;; (a string)
  { word	V_LENGTH;
	full	KEY;
>->	int 	UNT_NDEVS,			;;; number of devs pointing to this unit
			UNT_DEVCHAR,		;;; device characteristics
			UNT_UNIT_NUM,		;;; VMS unit number
			UNT_MBX_CHANNEL,	;;; chan for dev with mailbox associated
			UNT_TRM_CHANNEL;	;;; chan for term with Ctrl-C enabled
  };

struct DEVUNIT_P			;;; (a vector)
  { word	V_LENGTH;
	full	KEY,
>->			UNT_INPUT_TRAP;		;;; input waiting trap procedure or false
  };


struct IO_CONTROL_BLOCK		;;; (a string)
  { word	V_LENGTH;
	full	KEY;
>->	int		ICB_CHANNEL;
	short	ICB_FLAGS,
			ICB_ASYNC_EFN;
	int		ICB_DEVCHAR,		;;; device characteristics
			ICB_BLK_SIZE,		;;; block size
			ICB_EOF_BYTE;		;;; eof byte

	int[32]	ICB_FAB;

	{ int[40]	ICB_RAB;
	  byte		ICB_RAB_END[0];	;;; end of ICB with RAB

	| int		ICB_FIRST_FIELD,
				ICB_WANT_VERSION;
	  int[40]	ICB_NAM;
	  byte		ICB_NAM_ESA[256],
				ICB_NAM_RSA[256],
				ICB_NAM_END[0];	;;; end of ICB with NAM block etc
	}
  };

lconstant macro (
	;;; byte length of ICB with RAB
	RAB_ICB_LEN			= _pint(##ICB_RAB_END),
	;;; byte length of ICB with NAM block etc
	NAM_ICB_LEN			= _pint(##ICB_NAM_END),

	;;; flags in ICB_FLAGS
	_M_ICB_PURGE		= _2:1e0,	;;; purge terminal type-ahead
	_M_ICB_READ_NOW		= _2:1e1,	;;; no wait on next read
	_M_ICB_MBX_OUTWAIT	= _2:1e2,	;;; output wait on mailbox
	_M_ICB_ASYNC_LIVE	= _2:1e3,	;;; async read running
	);


define lconstant add_macdef_op(name);
	lvars name;
	unless lmember(name, popc_vms_macdef_ops) then
		name :: popc_vms_macdef_ops -> popc_vms_macdef_ops
	endunless;
enddefine;

define lconstant syntax vms_use_macdefs;
	lvars name, closer = false;
	until closer == ";" or (readitem() ->> name) == ";" do
		check_word(name);
		add_macdef_op(name);
		pop11_need_nextreaditem([, ;]) -> closer
	enduntil;
	";" :: proglist -> proglist
enddefine;


	/*	procedure for defining RMS structure names as macros that
		cause automatic definition of field specs, e.g. as in
				_fab!FAB$L_DEV
	*/

define lconstant autodef_RMS_field_spec(deflist) -> whole_name;
	lvars name, whole_name, c, RMS_struct_name, deflist;
	hd(proglist_macro_pair) -> RMS_struct_name;
	unless (readitem() ->> name) == "$" then
		mishap(name, 1, 'EXPECTING $ AFTER RMS STRUCTURE NAME')
	endunless;
	readitem() -> name;		;;; field name
	RMS_struct_name <> "$" <> name -> whole_name;
	;;; see if defined already
	returnif(lmember(whole_name, deflist));

	;;; define whole name as field spec
	;;; get field size from 1st char of field name
	name(1) -> c;
	if 	   c == `B` then "byte"
	elseif c == `W` then "short"
	elseif c == `L` then "word"
	elseif c == `Q` then "double"
	else
		mishap(whole_name, 1, 'UNKNOWN FIELD SIZE IN RMS FIELD NAME')
	endif -> name;
	;;; offset of field is _:'<field name>'
	popc_def_field_spec(whole_name, name, nonmac _:(word_string(whole_name)));
	whole_name :: tl(deflist) -> tl(deflist);
	add_macdef_op("RMSALL");
	if RMS_struct_name == "XAB" then
		applist([XABFHC XABDAT XABPRO], add_macdef_op)
	endif
enddefine;

lconstant macro (
	FAB		= autodef_RMS_field_spec(%[0]%),	;;; Field Access Block
	RAB		= autodef_RMS_field_spec(%[0]%),	;;; Record Access Block
	NAM		= autodef_RMS_field_spec(%[0]%),	;;; NAMe block
	XAB		= autodef_RMS_field_spec(%[0]%),	;;; eXtended Attribute Block
	);


define lconstant macro _DESCRIPTOR string;
	lvars string; lconstant P = "%";
	add_macdef_op("DSC");
	[ #_<
		struct DESCRIPTOR =>>
			{^P ^string, $-Sys$-descriptor_key,
				=>> {^P _int(datalength(^string)),
						_:'DSC$K_DTYPE_T',
						_:'DSC$K_CLASS_S',
						^string@V_BYTES
					^P},
			^P} @DSC_SPEC
	 >_# ].dl
enddefine;


	;;; Structure of entry in POPLOG'S VMS process table
	;;; (see sysfork.p, syswait.p)
struct PROC_ENTRY
  { word	PROC_COND,		;;; 0 if entry unused, 1 if live, -1 if dead
			PROC_PID,		;;; VMS pid
			PROC_STATUS;	;;; completion status
  };


struct DEVINFO
  {	int		DIB\$L_DEVCHAR;
	byte	DIB\$B_DEVCLASS,
			DIB\$B_DEVTYPE;
	short	DIB\$W_DEVBUFSIZE;
	int		DIB\$L_DEVDEPEND;
	short	DIB\$W_UNIT,
			DIB\$W_DEVNAMOFF;
  };


	/*	Specifies an area of memory in VMS system calls
	*/
struct MEMRANGE
  { (byte)	MR_FIRST_ADDR,
			MR_LAST_ADDR;
  };


constant
		procedure (consdescriptor, Sys$-Temp_Desc),
		Sys$-descriptor_key
	;

vars
		Sys$- _syserror, Sys$- _rmserror
	;

vms_use_macdefs DEV, IO;		;;; For DEV$, IO$ constants


/* --- Revision History ---------------------------------------------------
--- John Gibson, Apr  6 1995
		Revised types of struct fields
--- John Gibson, Nov 30 1993
		Changed nonmac _ to nonmac _: in autodef_RMS_field_spec and
		_DESCRIPTOR
--- John Gibson, Dec  5 1992
		Added ICB_ASYNC_EFN field in control block
--- John Gibson, Dec  5 1990
		Added _DESCRIPTOR
--- John Gibson, Aug  8 1989
		Added ICB_FIRST_FIELD and ICB_WANT_VERSION fields.
--- John Gibson, Mar  3 1989
		Changes to -autodef_RMS_field_spec-, lconstant'ed.
--- John Gibson, Oct 25 1988
		Added _M_ICB_MBX_OUTWAIT flag.
--- John Gibson, Jan 12 1988
		Added ICB_RAB_END and ICB_NAM_END fields to IO_CONTROL_BLOCK struct
--- John Gibson, Aug 18 1987
		Moved definition of struct DESCRIPTOR into syscomp/symdefs.p
 */
