/* --- Copyright University of Sussex 1998. All rights reserved. ----------
 > File:			C.vms/src/vmsextern.p
 > Purpose:
 > Author:			John Gibson (see revisions)
 */

;;;-------------- ROUTINES FOR EXTERNAL PROCEDURES (VMS) ----------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'vmsdefs.ph'

#_IF DEF SHARED_LIBRARIES

constant
		procedure (sys_spawn, sysdelete, allbutlast, sys_fname, sys_fname_nam,
		sys_fname_path, sys_fname_extn, sysmailbox, systmpfile,
		sys_file_copy, issubstring_lim, newanyproperty, device_full_name,
		Sys$-Get_mem_break, Sys$-Allow_shrim_mapping, Sys$-Delete_mem,
		Sys$-Extern$-Get_symbol_ptr, Sys$-Extern$-Name_translate
		)
	;

vars
		poppid, pop_spawn_flags, pop_runtime,
	;

#_ELSE

#_INCLUDE 'memseg.ph'

constant
		procedure (sysobey, sysdelete, sysseek, allbutlast,
		subword, newproperty, sys_fname_nam,
		Sys$-Sr$-Shrim_margin, Sys$-Sr$-Shrim_too_big,
		)
	;

vars
		poppid, pop_status, pop_spawn_flags,
		Sys$-Sr$- _prohibit_restore
	;

section $-Sys;

constant
		procedure (Open_seg_shift_gap_base, Do_open_seg_shift_gc,
		Vms_get_image_name, Delete_mem, Create_mem,
		Get_mem_break, Set_mem_break,
		Extern$-Readb, Extern$-Writeb, Extern$-Name_translate
		),
	;

endsection;

#_ENDIF


;;; ----------------------------------------------------------------------

section $-Sys$-Extern => Extern_make_base;

define lconstant Convert_symbols(symbol_list, outf);
	lvars spec, name, symbol_list, outf;
	fast_for spec in symbol_list do
		;;; ____spec is a vector where ____spec(1) is the symbol name as a word or
		;;; string, and ____spec(2) is a language name string (or a pair
		;;; conspair(_________lang-name, ____type), where ____type is used only by Popc).
		;;; If symbol name is a string, take it as is, otherwise do standard
		;;; O/S conversion on it, taking language name into account.
		Name_translate(spec(1),
						ispair(spec(2)->>lang) and fast_front(lang) or lang,
						false) ->> name -> spec(1);
#_IF not(DEF SHARED_LIBRARIES)
		if outf then
			;;; output external pointer for symbol to assembler file
			outf(name, external_ptr_key, false, '.address %d,%d,%p\n')
		endif
#_ENDIF
	endfor
enddefine;

	/*	Full filename of shareable image -- defaults to sys$share unless
		there's a translation.
	*/
define lconstant Shrim_filename(image_name) -> file_name;
	lvars image_name, file_name;
	if isword(image_name) then
		fast_word_string(image_name) -> image_name
	endif;
	unless systranslate(image_name) ->> file_name then
		'sys$share:' <> image_name <> '.exe' -> file_name
	endunless
enddefine;



;;; === NEW VERSION ALLOWING SHAREABLE IMAGES ONLY =======================
;;; (Currently used for Alpha, but contains nothing Alpha-specific)

#_IF DEF SHARED_LIBRARIES

lvars
	linked_symbols_list = [],
	active_images_prop	= false,
	;

	;;; Dummy version which creates empty output file
define Extern_make_base(infile, outfile, del_prefixes);
	lvars infile, outfile, del_prefixes;
	sysclose(syscreate(outfile, 1, "record"));
enddefine;

	/*	Copy a (symbols only) file onto the end of a save file.
	*/
define Save_symtab(symfile, save_dev);
	lvars save_dev, symfile;
	mishap(0, 'SYSTEM ERROR IN Save_symtab');
enddefine;

	/*	Do the reverse, i.e. copy the object file/symbol table on
		the end of a save file onto a separate file.
	*/
define Restore_symtab(symfile, save_dev);
	lvars symfile, save_dev;
	mishap(0, 'SYSTEM ERROR IN Restore_symtab');
enddefine;

define Temp_name();
	'sys$scratch:pxt' sys_>< poppid <> '.'
enddefine;

define Get_link_base();
	false
enddefine;


;;; ----------------------------------------------------------------------

struct IMHDR
  {	full	IMH_NAM,
			IMH_DEFNAME,
			IMH_FULLNAME;
  };

struct SYMVEC		;;; (vector)
  { int		V_LENGTH;
	full	KEY;
>->	struct IMHDR SV_IMHDR;
	full	SV_SYMS[];
  };

struct ACTIM		;;; (vector)
  {	int		V_LENGTH;
	full	KEY;
>->	struct IMHDR AIM_IMHDR;
	full	AIM_LOADED,
			AIM_BASE_ADDR,
			AIM_SIZE;
  };

define lconstant load_shrim_symbols(_imhdr, symvec);
	lvars	exptr, string, symvec, _ptr, _lim, _nam, _defname, _imhdr;
	lconstant	_fdesc = writeable _DESCRIPTOR '',
				_symdesc = writeable _DESCRIPTOR '';

	Temp_Desc(_imhdr!IMH_NAM) -> _nam;
	_imhdr!IMH_DEFNAME -> string;
	if string then
		;;; filename
		string!V_LENGTH -> _fdesc!DSPEC_LENGTH;
		string@V_BYTES  -> _fdesc!DSPEC_PTR;
		_fdesc
	else
		;;; logical name or default to sys$share:.exe
		_NULL
	endif -> _defname;

	symvec@SV_SYMS -> _ptr;
	symvec@V_WORDS[symvec!V_LENGTH] -> _lim;
	while _ptr <@(w) _lim do
		_ptr!(w)++ -> (exptr, _ptr);
		exptr!XP_PROPS -> string;
		string!V_LENGTH -> _symdesc!DSPEC_LENGTH;
		string@V_BYTES  -> _symdesc!DSPEC_PTR;
		unless _extern[WEAK] lib\$find_image_symbol(	;;; WEAK checked below
					_nam,
					_symdesc,
					exptr@XP_PTR,
					_defname)
		_bitst _1 then
			Syserr_mishap(exptr, 1, 'ERROR LOADING EXTERNAL SYMBOL')
		endunless
	endwhile
enddefine;


;;; ----------------------------------------------------------------------

	/*	Do the guts of an external load.
	*/
define Do_link_load(objfiles, symbol_list, dummy, dummy);
	lvars	sym, n, s, l, exptr, pair, len, shrim, mbx, comf, spec,
			hash_vec, mbx_name, nam, fname, buf = inits(512), procedure p,
			symbol_list, objfiles, dummy, symvec, actim, load_vec,
			_len;

	dlocal	pop_spawn_flags = 2:10,
			0 % false ->> comf -> mbx,
				(if comf then sysdelete(comf) -> endif,
				 if mbx then sysclose(mbx) endif)
			  %;

	define lconstant hash(ssub, len, str);
		lvars ssub, len, str;
		((fast_subscrs(ssub fi_+ (len fi_>> 1), str) fi_+ len) fi_&& 31) fi_+ 1
	enddefine;

	define lconstant file_fullname(fname);
		lvars fname;
		device_full_name(sysclose(dup(sysopen(fname, 0, true, `N`))))
	enddefine;


	if pop_runtime then
		unless active_images_prop then
			newanyproperty([], 8, false, false, syshash, nonop =, "perm",
								false, false) -> active_images_prop
		endunless
	endif;


	;;; lib$find_image_symbol exists only in a shareable image (hence if this
	;;; file references it strongly we can't link it in corepop11 with
	;;; /nosysshr)

	if _zero(_extern[WEAK] lib\$find_image_symbol) then
		mishap(0, 'CAN\'T PERFORM EXTERNAL LOAD -- IMAGE LINKED WITH /nosysshr')
	endif;

	;;; We use the output from the 'analyze/image' utility to determine
	;;; which symbols are in each shareable image

	systmpfile(false, 'pxt$', '.com') -> comf;
	discout(comf) -> p;
	p('$ on error then goto ERROR\n');
	[%	for shrim in rev(objfiles) do
			if isword(shrim) then fast_word_string(shrim) -> shrim endif;
			if locchar(`/`, 1, shrim) ->> n then
				allbutlast(datalength(shrim)-n+1, shrim) -> shrim
			endif;
			if systranslate(shrim) then
				if isendstring(':', shrim) then
					allbutlast(1, shrim)
				else
					shrim
				endif -> nam;
				false
			else
				sys_fname_nam(shrim) -> nam;
				if uppertolower(shrim) = nam then
					;;; no filename components -- must be sys$share
					'sys$share:' <> nam <> '.exe' -> shrim;
					false
				else
					if sys_fname_extn(shrim) = nullstring then
						shrim <> '.exe' -> shrim
					endif;
					shrim
				endif
			endif -> fname;
			uppertolower(nam) -> nam;
			if pop_runtime and active_images_prop(nam) ->> actim then
				file_fullname(shrim) -> shrim;
				unless sys_fname(shrim, 1,5)
					= sys_fname(actim@AIM_IMHDR!IMH_FULLNAME, 1,5) then
					mishap(shrim, 1, 'SHAREABLE IMAGE NAME CONFLICTS WITH EXISTING IMAGE')
				endunless;
				if actim!AIM_LOADED then
					actim@AIM_IMHDR!IMH_FULLNAME -> shrim
				endif
			endif;

			p('$ analyze/image/gst\s' <> shrim <> '\n');
			p('$ write sys$output "***END***"\n');
			consvector(nam, fname, shrim, 3)
		endfor
	%] -> objfiles;
	p('$ exit\n$ ERROR: write sys$output "***ERROR***"\n$ stop \'f$process()\n');
	p(termin);

	'PXT$' sys_>< poppid -> mbx_name;
	sysmailbox(mbx_name, 0, "line") -> mbx;
	sys_spawn('@' sys_>< comf, false, mbx_name, false, false) -> ;

	Convert_symbols(symbol_list, false);
	Initv(32, []) -> hash_vec;
	fast_for spec in symbol_list do
		Get_symbol_ptr(spec) -> exptr;		;;; assigns ptr into spec
		lowertoupper(spec(1)) ->> sym -> exptr!XP_PROPS;
		hash(1, datalength(sym), sym) -> n;
		exptr :: fast_subscrv(n,hash_vec) -> fast_subscrv(n,hash_vec)
	endfor;

	{%	for shrim in objfiles do
			{%	explode(shrim);				;;; struct IMHDR
				until (sysread(mbx, buf, 512) ->> n) == 0 do
					unless isstartstring('\t\tsymbol:\s"', buf) then
						nextunless(fast_subscrs(1,buf) == `*`);
						quitif(isstartstring('***END***', buf));
						if isstartstring('***ERROR***', buf) then
							mishap(shrim(3), 1,
									'INVALID OR NONEXISTENT SHAREABLE IMAGE')
						endif
					endunless;
					locchar(`"`, 12, buf) fi_- 12 -> len;
					fast_subscrv(hash(12,len,buf),hash_vec) -> l;
					fast_for pair on l do
						nextunless(fast_front(pair) ->> exptr);
						exptr!XP_PROPS -> sym;
						_int(len) -> _len;
						if sym!V_LENGTH == _len
						and _bcmp(@@(b)[_len], sym@V_BYTES, buf@V_BYTES[_11])
						then
							false -> fast_front(pair);
							exptr
						endif
					endfor
				enduntil
			%};
			if datalength(dup()) /== 3 then nonwriteable () else -> endif
		endfor
	%} -> load_vec;

	lvars undef_syms = [];
	fast_for l in_vector hash_vec do
		fast_for exptr in l do
			if exptr then
				exptr!XP_PROPS :: undef_syms -> undef_syms
			endif
		endfor;
		sys_grbg_list(l)
	endfor;

	if undef_syms /== [] then
		mishap(dl(undef_syms), listlength(undef_syms),
							'UNDEFINED EXTERNAL SYMBOLS')
	endif;


	lvars new_active = [];
	if pop_runtime then

		define lconstant getsize_load(/* _imhdr, symvec */);
			lvars _break = Get_mem_break();
			load_shrim_symbols(/* _imhdr, symvec */);
			@@(vpage){Get_mem_break(), _break}, _break
		enddefine;

		fast_for symvec in_vector load_vec do
			symvec@SV_IMHDR!IMH_NAM -> nam;
			if active_images_prop(nam) ->> actim then
				symvec@SV_IMHDR!IMH_FULLNAME -> shrim;
				if shrim /= actim@AIM_IMHDR!IMH_FULLNAME then
					;;; version has changed -- reload a temp copy
					lvars tmpname = systmpfile(false, 'pxt$', '.exe');
					sys_file_copy(shrim, tmpname);
					sys_fname_nam(tmpname) -> actim@AIM_IMHDR!IMH_NAM;
					tmpname -> actim@AIM_IMHDR!IMH_DEFNAME;
					shrim -> actim@AIM_IMHDR!IMH_FULLNAME;

					if actim!AIM_BASE_ADDR ->> s then
						;;; can only delete the mem occupied by a previous
						;;; temp copy load, since the initial load may have
						;;; loaded other shrims
						Delete_mem(s!XP_PTR, _int(actim!AIM_SIZE))
					endif;

					getsize_load(actim@AIM_IMHDR, symvec);
					Cons_extern_ptr() -> actim!AIM_BASE_ADDR;
					_pint()			  -> actim!AIM_SIZE;
					sysdelete(tmpname) ->
				else
					load_shrim_symbols(actim@AIM_IMHDR, symvec)
				endif;
				unless actim!AIM_LOADED then
					actim :: new_active -> new_active;
					true -> actim!AIM_LOADED
				endunless
			else
				if _nonzero(getsize_load(symvec@SV_IMHDR, symvec) ->) then
					;;; new activation
					consvector(
						nam,
						symvec@SV_IMHDR!IMH_DEFNAME,
						file_fullname(symvec@SV_IMHDR!IMH_FULLNAME),
						true, false, false,
						6) ->> actim -> active_images_prop(nam);
					actim :: new_active -> new_active
				endif
			endif
		endfor
	endif;

	conspair(nonwriteable load_vec, new_active)
					:: linked_symbols_list -> linked_symbols_list
enddefine;

define Undo_link_load();
	lvars actim, pair;
	dest(linked_symbols_list) -> (pair, linked_symbols_list);
	fast_for actim in back(pair) do
		;;; can't unload shareable images in VMS -- this says reload
		;;; a temp copy the next time if the version has changed
		false -> actim!AIM_LOADED
	endfor
enddefine;



;;;; --- RESTORING SAVED IMAGES -----------------------------------------

	/*	After a sysrestore, restore shareable image symbols
	*/
define Reactivate_shrims(new_system);
	lvars new_system;

	define lconstant load_syms();
		lvars symvec, load_vec, pair;
		dlocal interrupt = fast_sysexit;
		fast_for pair in linked_symbols_list do
			fast_front(pair) -> load_vec;
			fast_for symvec in_vector load_vec do
				load_shrim_symbols(symvec@SV_IMHDR, symvec)
			endfor
		endfor
	enddefine;

	;;; don't bother activating them unless this is run-time
	returnunless(pop_runtime);

	if new_system then
		;;; the open seg is empty and can be temporarily deleted and
		;;; recreated after the shrims get mapped (avoiding creating an
		;;; unnecessary segment)
		Allow_shrim_mapping(load_syms)
	else
		load_syms()
	endif
enddefine;



;;; === OLD VAX VERSION ALLOWING OBJECT FILE/LIBRARIES ===================

#_ELSE		/* not(SHARED_LIBRARIES) */

;;; --- VMS OBJECT FILE DEFINITIONS --------------------------------------

lconstant macro (
	_OBJ\$C_GSD		= _1,
	_OBJ\$C_EOM		= _3,
	_OBJ\$C_EOMW	= _7,

	_GSY\$V_DEF		= _2:1e1,
	);

struct				;;; program section
  { byte	GPS\$B_GSDTYP, GPS\$B_ALIGN;
	short	GPS\$W_FLAGS;
	long	GPS\$L_ALLOC;
	byte	GPS\$B_NAMLNG, GPS\$T_NAME[];
  };

struct				;;; shareable image program section
  { byte	GSPS\$B_GSDTYP, GSPS\$B_ALIGN;
	short	GSPS\$W_FLAGS;
	long	GSPS\$L_ALLOC, GSPS\$L_BASE;
	byte	GSPS\$B_NAMLNG, GSPS\$T_NAME[];
  };

struct				;;; ident consistency check
  { byte	IDC\$B_GSDTYP;
	short	IDC\$W_FLAGS;
	struct { byte IDC\$B_NAMLNG, IDC\$T_NAME[]; }
			IDC\$T_STRINGS[3];
  };

struct				;;; environment definition/reference
  { byte	ENV\$B_GSDTYP;
	short	ENV\$W_FLAGS, ENV\$W_ENVINDX;
	byte	ENV\$B_NAMLNG, ENV\$T_NAME[];
  };

struct				;;; symbol reference
  { byte	SRF\$B_GSDTYP, SRF\$B_DATYP;
	short	SRF\$W_FLAGS;
	byte	SRF\$B_NAMLNG, SRF\$T_NAME[];
  };

struct				;;; symbol definition
  { byte	SDF\$B_GSDTYP, SDF\$B_DATYP;
	short	SDF\$W_FLAGS;
	byte	SDF\$B_PSINDX;
	long	SDF\$L_VALUE;
	byte	SDF\$B_NAMLNG, SDF\$T_NAME[];
  };

struct				;;; symbol definition with word psect
  { byte	SDFW\$B_GSDTYP, SDFW\$B_DATYP;
	short	SDFW\$W_FLAGS;
	byte	SDFW\$W_PSINDX;
	long	SDFW\$L_VALUE;
	byte	SDFW\$B_NAMLNG, SDFW\$T_NAME[];
  };

struct				;;; entry point/procedure with formals
  { byte	EPM\$B_GSDTYP, EPM\$B_DATYP;
	short	EPM\$W_FLAGS;
	byte	EPM\$B_PSINDX;
	long	EPM\$L_VALUE;
	short	EPM\$W_MASK;
	byte	EPM\$B_NAMLNG, EPM\$T_NAME[];
  };

struct				;;; entry point/procedure with formals with word psect
  { byte	EPMW\$B_GSDTYP, EPMW\$B_DATYP;
	short	EPMW\$W_FLAGS;
	byte	EPMW\$W_PSINDX;
	long	EPMW\$L_VALUE;
	short	EPMW\$W_MASK;
	byte	EPMW\$B_NAMLNG, EPMW\$T_NAME[];
  };

struct				;;; local symbol reference
  { byte	LSRF\$B_GSDTYP, LSRF\$B_DATYP;
	short	LSRF\$W_FLAGS, LSRF\$W_ENVINDX;
	byte	LSRF\$B_NAMLNG, LSRF\$T_NAME[];
  };

struct				;;; local symbol definition
  { byte	LSDF\$B_GSDTYP, LSDF\$B_DATYP;
	short	LSDF\$W_FLAGS, LSDF\$W_ENVINDX;
	byte	LSDF\$W_PSINDX;
	long	LSDF\$L_VALUE;
	byte	LSDF\$B_NAMLNG, LSDF\$T_NAME[];
  };

struct				;;; local entry point/procedure with formals
  { byte	LEPM\$B_GSDTYP, LEPM\$B_DATYP;
	short	LEPM\$W_FLAGS, LEPM\$W_ENVINDX;
	byte	LEPM\$W_PSINDX;
	long	LEPM\$L_VALUE;
	short	LEPM\$W_MASK;
	byte	LEPM\$B_NAMLNG, LEPM\$T_NAME[];
  };

struct				;;; continuation of procedure with formals
  {	byte	FML\$B_MINARGS,
			FML\$B_MAXARGS;
	struct {byte  ARG\$B_VALCTL, ARG\$B_BYTECNT, ARG\$T_DESC[]; }
			FML\$T_DESCRIPTORS[];
  };


;;; --------------------------------------------------------------------

lvars
	read_buf = false,
	shrim_sym_vec,
	;

define lconstant Process_gsd_rec(recbuf, reclen, deleting);
	lvars recbuf, reclen, deleting, prefix, del_list,
		_subrec, _lim, _nextrec, _sym, _symlen, _subtype, _bucket, _l
		;

	define lconstant skip_fmlpart(_fmlpart) -> _next;
		lvars _fmlpart, _next = _fmlpart@FML\$T_DESCRIPTORS;
		repeat _pint(_fmlpart!FML\$B_MINARGS) times
			_next@ARG\$T_DESC[_next!ARG\$B_BYTECNT] -> _next
		endrepeat
	enddefine;

	recbuf@V_BYTES -> _subrec;
	_subrec@(b)[_int(reclen)] -> _lim;
	_subrec@(b)++ -> _subrec;		;;; skip gsd record type
	while _subrec <@(b) _lim do
		_subrec!GPS\$B_GSDTYP -> _subtype;
		;;; switch on sub-record type
		;;; this idiotic nonsense is because there are no length
		;;; fields in the subrecords, so the length of any particular
		;;; one has to be computed specially
		go_on _pint(_subtype _add _1) to
;;; subtype  0   1   2   3   4    5    6    7   8   9   10   11   12
			PSC SYM EPM PRO SYMW EPMW PROW IDC ENV LSY LEPM LPRO SPSC
		else ERR;

		PSC:
			;;; program section -- ignore
			_subrec@GPS\$T_NAME[_subrec!GPS\$B_NAMLNG] -> _subrec;
			nextloop;

		SYM:
			;;; symbol record
			unless _subrec!SDF\$W_FLAGS _bitst _GSY\$V_DEF then
				;;; reference only -- ignore
				_subrec@SRF\$T_NAME[_subrec!SRF\$B_NAMLNG] -> _subrec;
				nextloop
			endunless;
			_subrec!SDF\$B_NAMLNG -> _symlen, _subrec@SDF\$T_NAME -> _sym;
			_sym@(b)[_symlen] -> _nextrec;
			goto process_sym;

		EPM:
			;;; entry point symbol
			_subrec!EPM\$B_NAMLNG -> _symlen, _subrec@EPM\$T_NAME -> _sym;
			_sym@(b)[_symlen] -> _nextrec;
			goto process_sym;

		PRO:
			;;; procedure with formal args symbol
			_subrec!EPM\$B_NAMLNG -> _symlen, _subrec@EPM\$T_NAME -> _sym;
			skip_fmlpart(_sym@(b)[_symlen]) -> _nextrec;
			goto process_sym;

		SYMW:
			;;; symbol record with word psect
			_subrec!SDFW\$B_NAMLNG -> _symlen, _subrec@SDFW\$T_NAME -> _sym;
			_sym@(b)[_symlen] -> _nextrec;
			goto process_sym;

		EPMW:
			;;; entry point with word psect
			_subrec!EPMW\$B_NAMLNG -> _symlen, _subrec@EPMW\$T_NAME -> _sym;
			_sym@(b)[_symlen] -> _nextrec;
			goto process_sym;

		PROW:
			;;; procedure with formals with word psect
			_subrec!EPMW\$B_NAMLNG -> _symlen, _subrec@EPMW\$T_NAME -> _sym;
			skip_fmlpart(_sym@(b)[_symlen]) -> _nextrec;
			goto process_sym;

		IDC:
			;;; ident consistency check -- ignore
			_subrec@IDC\$T_STRINGS -> _subrec;
			repeat 3 times
				_subrec@IDC\$T_NAME[_subrec!IDC\$B_NAMLNG] -> _subrec
			endrepeat;
			nextloop;

		ENV:
			;;; environment definition/reference -- ignore
			_subrec@ENV\$T_NAME[_subrec!ENV\$B_NAMLNG] -> _subrec;
			nextloop;

		LSY:
			;;; local symbol record -- ignore
			if _subrec!SDF\$W_FLAGS _bitst _GSY\$V_DEF then
				_subrec@LSDF\$T_NAME[_subrec!LSDF\$B_NAMLNG]
			else
				_subrec@LSRF\$T_NAME[_subrec!LSRF\$B_NAMLNG]
			endif -> _subrec;
			nextloop;

		LEPM:
			;;; local entry point -- ignore
			_subrec@LEPM\$T_NAME[_subrec!LEPM\$B_NAMLNG] -> _subrec;
			nextloop;

		LPRO:
			;;; local procedure with formals -- ignore
			skip_fmlpart(_subrec@LEPM\$T_NAME[_subrec!LEPM\$B_NAMLNG])
															-> _subrec;
			nextloop;

		SPSC:
			;;; shareable image program section -- ignore
			_subrec@GSPS\$T_NAME[_subrec!GSPS\$B_NAMLNG] -> _subrec;
			nextloop;

		ERR:
			mishap(_pint(_subtype), 1, 'UNKNOWN GSD SUBRECORD TYPE');


		;;; come here to process global symbol definition
		process_sym:

#_IF DEF V5_STB_BUG
		;;; compute bucket of symbol in shrim_sym_vec, using last char of symm
		( _sym!(b)[_symlen _sub _1] _sub _shift(_symlen, _4) _sub _1)
											_bimask _16:FF -> _bucket;
		if deleting then
			if deleting == 0 then
				;;; delete if in shareable image
				shrim_sym_vec!V_WORDS[_bucket]
			else
				deleting
			endif -> del_list;
			;;; remove if has appropriate prefix/equals shrim symbol
			fast_for prefix in del_list do
				prefix!V_LENGTH -> _l;
				if deleting == 0 then
					nextif(_l /== _symlen)
				else
					nextif(_l _gr _symlen)
				endif;
				if _bcmp(@@(b)[_l], prefix@V_BYTES, _sym) then
					;;; can be removed -- shift rest of record down
					_bmove(@@(b){_lim, _nextrec}, _nextrec, _subrec) -> _lim;
					nextloop(2)		;;; next subrec
				endif
			endfor;
			;;; else retain it
			_nextrec -> _subrec;

		else

			;;; accumulate shareable image symbol
			@@(b){_lim, recbuf} -> _lim;
			@@(b){_nextrec, recbuf} -> _nextrec;
			substring(_pint(##(b){_sym, recbuf@V_BYTES} _add _1),
											_pint(_symlen), recbuf)
				:: shrim_sym_vec!V_WORDS[_bucket]
							-> shrim_sym_vec!V_WORDS[_bucket];
			recbuf@(b){_lim} -> _lim;
			recbuf@(b){_nextrec} -> _subrec
		endif

#_ELSE	;;; bug is cured in V5.3
		;;; remove if has appropriate prefix
		fast_for prefix in deleting do
			prefix!V_LENGTH -> _l;
			nextif(_l _gr _symlen);
			if _bcmp(@@(b)[_l], prefix@V_BYTES, _sym) then
				;;; can be removed -- shift rest of record down
				_bmove(@@(b){_lim, _nextrec}, _nextrec, _subrec) -> _lim;
				nextloop(2)		;;; next subrec
			endif
		endfor;
		;;; else retain it
		_nextrec -> _subrec;
#_ENDIF

	endwhile;

	;;; return final length of record
	_pint(##(b){_lim, recbuf@V_BYTES})
enddefine;

	/*	This (exported) procedure takes the POPLOG symbol table
		and produces a new one in which all symbols commencing with one of
		the list del_prefixes have been removed. This is used to get
		rid of POP's symbols which are not needed for external linking
	*/
define Extern_make_base(infile, outfile, del_prefixes);
	lvars recbuf reclen infile outfile del_prefixes _type;
	;;; if 3rd arg is true, means delete all the pop symbols
	;;; (POP_SYMBOL_PREFIXES is defined in asmout.p)
	if del_prefixes == true then
#_IF DEF POP_SYMBOL_PREFIXES
		POP_SYMBOL_PREFIXES -> del_prefixes
#_ELSE
		[] -> del_prefixes
#_ENDIF
	endif;

	sysopen(infile, 0, "record", `N`) -> infile;
	syscreate(outfile, 1, "record") -> outfile;
	if read_buf then read_buf else inits(512) endif -> recbuf;
	repeat
		sysread(infile, recbuf, 512) -> reclen;
		if reclen == 0 then
			mishap(infile, 1, 'PREMATURE EOF ON OBJECT MODULE')
		endif;
		_int(recbuf(1)) -> _type;		;;; first byte is record type
		if _type == _OBJ\$C_GSD then
			;;; global symbol directory record - process sub records
			Process_gsd_rec(recbuf, reclen, del_prefixes) -> reclen;
			unless reclen == 1 then
				;;; i.e. not all subrecords removed, write it
				syswrite(outfile, recbuf, reclen)
			endunless;
		else
			;;; any other kind. Just write it out
			syswrite(outfile, recbuf, reclen);
			;;; done if this is an end-of-module record
			quitif(_type == _OBJ\$C_EOM or _type == _OBJ\$C_EOMW)
		endif
	endrepeat;
	sysclose(infile);
	sysclose(outfile);
enddefine;


#_IF DEF V5_STB_BUG
	;;; Accumulate the symbols from a shareable image global symbol table
	;;; (dev is positioned at the start of the gst)
define lconstant Acc_shrim_symbols(dev);
	lvars dev, buf = read_buf, _len, _type;
	repeat
		Readb(dev, buf@V_BYTES, _2);	;;; read next rec length
		buf!V_SHORTS[_0] -> _len;
		;;; read next record (length is rounded up even)
		Readb(dev, buf@V_BYTES, (_len _add _1) _biclear _1);

		buf!V_BYTES[_0] -> _type;		;;; first byte is record type
		;;; done if this is an end-of-module record
		quitif(_type == _OBJ\$C_EOM or _type == _OBJ\$C_EOMW);
		if _type == _OBJ\$C_GSD then
			;;; global symbol directory record - process sub records
			Process_gsd_rec(buf, _pint(_len), false) ->
		endif
	endrepeat
enddefine;
#_ENDIF


;;; --- SAVING/RESTORING SYMBOL TABLE FILES -----------------------------

	/*	Temp property relating symbol files to their shareable image lists
		(set up first time by Do_link_load)
	*/
lvars procedure
	symfile_shrim_include	= identfn;

	/*	Copy a (symbols only) file onto the end of a save file.
	*/
define Save_symtab(symfile, save_dev);
	lvars save_dev, symfile, buf = inits(514), name, _n;
	;;; copy the shareable image list first
	for name in symfile_shrim_include(symfile) do
		datalength(name) ->> _n -> fast_subscrs(1, buf);
		name -> substring(2, _n, buf);
		syswrite(save_dev, buf, _n fi_+ 1)
	endfor;
	0 -> fast_subscrs(1, buf);
	syswrite(save_dev, buf, 1);		;;; zero terminates

	sysopen(symfile, 0, "record", `N`) -> symfile;
	;;; do copy - write the record length before each record
	until (sysread(symfile, 3, buf, 512) ->> _n) == 0 do
		_int(_n) -> buf!V_SHORTS[_0];		;;; rec len in first 2 bytes
		syswrite(save_dev, buf, _n fi_+ 2)
	enduntil;
	sysclose(symfile)
enddefine;

	/*	Do the reverse, i.e. copy the object file/symbol table on
		the end of a save file onto a separate file.
	*/
define Restore_symtab(symfile, save_dev);
	lvars symfile, save_dev, buf = inits(514), _n;
	;;; get shareable image list first
	[%	repeat
			sysread(save_dev, buf, 1) -> ;
			fast_subscrs(1, buf) -> _n;
			quitif(_n == 0);
			sysread(save_dev, buf, _n) -> ;
			subword(1, _n, buf)
		endrepeat
	%] -> symfile_shrim_include(symfile);

	syscreate(symfile, 1, "record") -> symfile;
	until sysread(save_dev, buf, 2) == 0 do
		_pint(buf!V_SHORTS[_0]) -> _n;		;;; rec len in 1st 2 bytes
		sysread(save_dev, buf, _n) -> ;
		syswrite(symfile, buf, _n)
	enduntil;
	sysclose(symfile)
enddefine;

define Temp_name();
	'sys$scratch:pxt' sys_>< poppid <> '.'
enddefine;

define Get_link_base();
	lvars name = Vms_get_image_name(), l = datalength(name);
	allbutlast(l-locchar_back(`.`, l, name), name) <> 'stb'
enddefine;


;;; --- IMAGE ANALYSIS -------------------------------------------------------

	/* Image Format (VMS 5.3, Image format major = '02', minor = '05')
	*/
struct IMAGE_HEADER
  { short	IMHD_ISD_OFFS,		;;; offset to im sect descs (= pre-header size)
			IMHD_TRANARR_OFFS,	;;; offset to transfer address array
			IMHD_SYMINFO_OFFS,	;;; offset to debug/global sym table offsets
			IMHD_IMNAME_OFFS,	;;; offset to image name/ident
			IMHD_PATCH_OFFS,	;;; offset to patch data
			IMHD_UNKNOWN,		;;; unknown (sys version array info?)
			IMHD_MAJOR_ID,		;;; image format major id (as chars)
			IMHD_MINOR_ID;		;;;   "     "    minor id  "    "
	byte	IMHD_NUM_HDR_BLKS,	;;; number of header blocks
			IMHD_IMAGE_TYPE;	;;; image type
	short	IMHD_SPARE2;		;;; spare
	long[2]	IMHD_PRIV_MASK;		;;; requested privilege mask
	short	IMHD_NUM_IO_CHANS,	;;; number of I/O channels
			IMHD_NUM_IO_PAGES;	;;; number of I/O pages
	24		IMHD_IMAGE_FLAGS;	;;; image flags
	byte	IMHD_MATCH_CTRL;	;;; gsd match control
	long	IMHD_GSD_IDENT,		;;; gsd ident
			IMHD_SYS_VERS,		;;; system version
			IMHD_FIXUP_ADDR;	;;; address within image of fixup sect
  };

struct IMAGE_SYMINFO
  { long	IMSYM_DBGSYM_VBN,	;;; debug symbol table vbn
			IMSYM_GBLSYM_VBN;	;;; global symbol table vbn
	short	IMSYM_DBG_NUM_BLKS,	;;; debug symtab number of blocks
			IMSYM_GBL_NUM_RECS;	;;; global symtab number of records
	long	IMSYM_DBGMOD_VBN,	;;; debug module/psect table vbn
			IMSYM_DBGMOD_SIZE;	;;;   "        "         "   size in bytes
  };

struct IMAGE_SECT_DESC
  { short	ISD_SIZE,			;;; byte size of this ISD
			ISD_NUM_PAGES;		;;; number of pages in section
	24		ISD_PAGE_ADDR;		;;; page address within image
	byte	ISD_PFC;			;;; page fault cluster size
	24		ISD_FLAGS;			;;; flags
	byte	ISD_TYPE;			;;; section type
	;;; end of demand zero section
	long	ISD_VBN;			;;; vbn within file
	;;; end of non-global section
	long	ISD_GSD_ID;			;;; global section id major/minor
	byte	ISD_NAME_LEN,		;;; name length
			ISD_GSNAME[];		;;; global section name
  };


	;;; ISD flags
lconstant macro (
	ISD_M_GBL			= 2:1e0,
	ISD_M_CRF			= 2:1e1,
	ISD_M_DZRO			= 2:1e2,
	ISD_M_WRT			= 2:1e3,
	ISD_M_LASTCLU		= 2:1e7,
	ISD_M_INITIALCODE	= 2:1e8,
	ISD_M_BASED			= 2:1e9,
	ISD_M_FIXUPVEC		= 2:1e10,
	ISD_M_RESIDENT		= 2:1e11,
	ISD_M_VECTOR		= 2:1e17,
	ISD_M_PROTECT		= 2:1e18,

	ISD_GSMATCH_SHIFT	= 4,
	ISD_M_GSMATCH		= 2:111 << ISD_GSMATCH_SHIFT,	;;; bits 4,5,6
	);


	;;; (Pop's) struct representing a shareable image
struct SHRIM
  { (vpage)	SHRIM_BASE_ADDR;	;;; start addr where mapped
	24		SHRIM_AREA_NPAGES;	;;; num of pages in area for first of an area
	byte	SHRIM_ENTRY_LEN;	;;; word length of this entry
	24		SHRIM_ORG_NPAGES;	;;; pages shrims in area took when linked
	byte	SHRIM_GSD_MATCH;	;;; match criterion
	long	SHRIM_GSD_ID;		;;; gsd major/minor id
	byte	SHRIM_NAME_LEN,		;;; byte length of name
			SHRIM_NAME[];		;;; name
  };

	;;; Table of shareable images loaded
lconstant macro SHRIM_NWORDS = 200;
lconstant
	_shrim_stack		= _INIT_NONPOP_STRUCT(w[SHRIM_NWORDS]),
	_shrim_stack_lim	= _shrim_stack@(w)[_:SHRIM_NWORDS],

	imbuf	= writeable inits(64),
	_imbuf	= imbuf@V_WORDS,
	;

lvars
	exe_version			= 1,

	;;; next free pointer in the table -- saved and restored
	_shrim_stack_sp		= _shrim_stack,
	;

	;;; Pointer to next shrim to activate -- this must be a permanent
	;;; non-pop variable so that it's not restored by sysrestore
vars
	_shrim_activated_ptr = _shrim_stack;


lconstant	procedure (Anal_image)
	;


	/*	Determine if a given shareable image is already present, and if not,
		add an entry to the shareable image stack
	*/
define lconstant Anal_shr_image(image_name, _gsd_id, _gsd_match) -> _totsize;
	lvars	image_name, _shrim = _shrim_stack, _namelen, _name,
			_entry_len, _next, _ownsize, _shrsize, _totsize,
			_gsd_id, _gsd_match
		;
	image_name!V_LENGTH -> _namelen;
	image_name@V_BYTES -> _name;
	while _shrim <@(w) _shrim_stack_sp do
		if _shrim!SHRIM_NAME_LEN == _namelen
		and _bcmp(_namelen, _shrim@SHRIM_NAME, _name) then
			;;; already present
			return(_0 -> _totsize)
		else
			;;; next entry
			_shrim@(w)[_shrim!SHRIM_ENTRY_LEN] -> _shrim
		endif
	endwhile;

	;;; It's new -- analyse recursively.
	Anal_image(Shrim_filename(image_name), _NULL, true)
											-> (_shrsize, _ownsize, );
	_shrsize _add _ownsize -> _totsize;

	;;; Add table entry (except for base address which is filled in when
	;;; it's activated)
	##(w)[##SHRIM_NAME[_namelen] | b.r] -> _entry_len;
	_shrim_stack_sp -> _shrim;
	if (_shrim@(w)[_entry_len] ->> _next) >@(w) _shrim_stack_lim then
		mishap(0, 'SHAREABLE IMAGE STACK FULL')
	else
		_next -> _shrim_stack_sp
	endif;
	_NULL		-> _shrim!SHRIM_BASE_ADDR;
	_0			-> _shrim!SHRIM_AREA_NPAGES;
	_entry_len	-> _shrim!SHRIM_ENTRY_LEN;
	_0			-> _shrim!SHRIM_ORG_NPAGES;
	_gsd_id		-> _shrim!SHRIM_GSD_ID;
	_gsd_match	-> _shrim!SHRIM_GSD_MATCH;
	_namelen	-> _shrim!SHRIM_NAME_LEN;
	_bmove(_namelen, image_name@V_BYTES, _shrim@SHRIM_NAME) ->
enddefine;

define lconstant Open_image(file, check_id) -> file;
	lvars file, check_id;
	if isdevice(file) then
		sysseek(file, 0, 0)
	else
		;;; open image file
		sysopen(file, 0, true, `N`) -> file
	endif;
	;;; read fixed header
	Readb(file, _imbuf, @@(struct IMAGE_HEADER)++);
	;;; check the image format major id
	if check_id and _imbuf!IMHD_MAJOR_ID /== _16:3230 then	;;; = '02'
		printf(';;; WARNING: VMS IMAGE FORMAT HAS CHANGED - EXTERNAL LOADING MAY NOT WORK\n')
	endif;
	;;; seek to start of image section descriptors
	sysseek(file, _pint(_imbuf!IMHD_ISD_OFFS), 0)
enddefine;

	/*	Analyse an image -- find sizes by counting sizes of image sections.
	*/
define lconstant Anal_image(file, _seg_base, shrim)
										-> (_shrsize, _ownsize, _fixup_seg);
	lvars	dev, file, shrim, linkexe, _size, _ownsize, _shrsize, _isdsize,
			_seg_base, _syminfo, _flags, _fixup_seg = _NULL;
		;

	;;; true if doing the linked executable image first or second time
	;;; (_seg_base /== _NULL for second time)
	isdevice(file) -> linkexe;

	;;; open image, read header and seek to image sect descriptors
	Open_image(file, linkexe and _seg_base == _NULL) -> dev;

	_0 ->> _ownsize -> _shrsize;
	_imbuf!IMHD_SYMINFO_OFFS -> _syminfo;

	until _zero(Readb(dev, _imbuf, @@(s)++), _imbuf!ISD_SIZE ->> _isdsize) do

		if _isdsize == _16:FFFF then
			;;; end of block padding -- move to next
			sysseek(dev, (sysseek(dev,0,1,true)+511) &&~~ 511, 0);
			nextloop
		endif;

		Readb(dev, _imbuf@(s)[_1], --@@(s){_isdsize});	;;; rest of isd
		if _isdsize _gr @@ISD_GSD_ID then
			;;; Shareable image section
			nextif(_seg_base /== _NULL);

			;;; extract its name (excluding the last 4 characters for the
			;;; section number, _XXX etc), and add its total size to the
			;;; total for this image
			Anal_shr_image(
				substring(_pint(##ISD_GSNAME _add _1),
							_pint(_imbuf!ISD_NAME_LEN _sub _4), imbuf),
				_imbuf!ISD_GSD_ID,
				_shift(_imbuf!ISD_FLAGS _bimask _:ISD_M_GSMATCH,
							_:-ISD_GSMATCH_SHIFT)
			) _add _shrsize -> _shrsize

		elseunless _imbuf!ISD_TYPE == _253 then
			;;; i.e. not stack section
			@@(vpage)[_imbuf!ISD_NUM_PAGES] -> _size;
			if _seg_base /== _NULL then
				;;; doing the linked executable image second time
				if _imbuf!ISD_PAGE_ADDR == _1 then
					;;; The padding section -- change it to have size 1 page
					;;; so it doesn't overwrite the rest of POPLOG!
					;;; Making shareable images work (decently) relies entirely
					;;; on this ...
					_1 -> _imbuf!ISD_NUM_PAGES;
					sysseek(dev, _pint(_negate(_isdsize)), 1);
					Writeb(dev, _imbuf, _isdsize);
				else
					if _imbuf!ISD_FLAGS _bitst _:ISD_M_WRT then
						_0
					else
						_M_SEG_CONSTANT
					endif -> _flags;
					if _imbuf!ISD_FLAGS _bitst _:ISD_M_FIXUPVEC then
						;;; image activator fixup section
						_flags _biset _M_SEG_IMAGE_FIXUP -> _flags;
						;;; return seg for it so we can mess around with
						;;; it after the image is activated
						_seg_table_next_free -> _fixup_seg
					endif;
					;;; add a segment for this own section
					Add_nonpop_seg_entry(_seg_base, _size, _flags);
					_seg_base@(w){_size} -> _seg_base
				endif
			else
				unless linkexe and _imbuf!ISD_PAGE_ADDR == _1 then
					;;; accumulate size of own section
					_ownsize _add _size -> _ownsize
				endunless
			endif

		endif
	enduntil;

#_IF DEF V5_STB_BUG
	if shrim then
		;;; shareable image -- accumulate symbols from global symbol table
		sysseek(dev, _pint(_syminfo), 0);
		Readb(dev, _imbuf, @@(struct IMAGE_SYMINFO)++);
		;;; get to start of gst
		sysseek(dev, _pint((_imbuf!IMSYM_GBLSYM_VBN _sub _1) _mult _512), 0);
		Acc_shrim_symbols(dev)
	endif;
#_ENDIF

	unless linkexe then sysclose(dev) endunless
enddefine;

define lconstant Analyse_image() with_nargs 3;
	lvars _sv_seg, _sv_shrim;
	;;; save positions of seg table and shrim stack to restore on
	;;; abnormal exit
	dlocal 0 % (_seg_table_next_free -> _sv_seg, _shrim_stack_sp -> _sv_shrim),
			   (if dlocal_context == 2 then
					_sv_seg -> _seg_table_next_free, _sv_shrim -> _shrim_stack_sp
				endif)
			 %;
	Anal_image()
enddefine;

	/*	Return size of image own sections only
	*/
define lconstant Image_ownsize(file) -> _ownsize;
	lvars dev, file, _size, _ownsize = _0, _isdsize;
	Open_image(file, true) -> dev;
	until _zero(Readb(dev, _imbuf, @@(s)++), _imbuf!ISD_SIZE ->> _isdsize) do
		if _isdsize == _16:FFFF then
			;;; end of block padding -- move to next
			sysseek(dev, (sysseek(dev,0,1,true)+511) &&~~ 511, 0);
			nextloop
		endif;

		Readb(dev, _imbuf@(s)[_1], --@@(s){_isdsize});	;;; rest of isd
		unless _isdsize _gr @@ISD_GSD_ID
		or _imbuf!ISD_TYPE == _253 then
			;;; i.e. not shareable im/stack section
			@@(vpage)[_imbuf!ISD_NUM_PAGES] _add _ownsize -> _ownsize
		endunless
	enduntil;
	sysclose(dev)
enddefine;


;;; --- ACTIVATING IMAGES ------------------------------------------------

define lconstant Extract_shrim_info(_shrim) -> (name, _gsd_ident);
	lvars name, _shrim, _len = _shrim!SHRIM_NAME_LEN;
	lconstant _gsd_ident = _INIT_NONPOP_STRUCT(w[2]);
	inits(_pint(_len)) -> name;
	_bmove(_len, _shrim@SHRIM_NAME, name@V_BYTES) -> ;
	_shrim!SHRIM_GSD_MATCH	-> _gsd_ident!(w)[_0];
	_shrim!SHRIM_GSD_ID		-> _gsd_ident!(w)[_1]
enddefine;

	/*	Next two procedures use the unsupported system calls sys$imgact
	 *	and sys$imgfix. If they ever take these out, we've had it.
	 */

define lconstant Get_sysshr_base(name, _gsd_ident);
	lvars name, _gsd_ident;
	lstackmem struct MEMRANGE _mrp;

	if _extern sys\$imgact(
				/* name	  */	Temp_Desc(name),
				/* dflnam */	_DESCRIPTOR 'sys$share:.exe',
				/* hdrbuf */	,
				/* imgctl */	_2:10000,	;;; merge into P0 space
				/* inadr  */	,
				/* retadr */	_mrp,
				/* ident  */	_gsd_ident,
				/* acmode */	)
		_bitst _1
	then
		;;; return base address for shareable image in basic system
		_mrp!MR_FIRST_ADDR
	else
		Syserr_mishap(name, 1, 'ERROR ACTIVATING IMAGE')
	endif
enddefine;

define lconstant Activate_image(name, _gsd_ident, _baseaddr, _maxsize);
	lvars name, _baseaddr, _lastaddr, _maxsize, _gsd_ident;
	lstackmem struct MEMRANGE _mrp;

	_baseaddr -> _mrp!MR_FIRST_ADDR;
	_baseaddr@(w){_maxsize} _sub _1 ->> _lastaddr -> _mrp!MR_LAST_ADDR;
	if _extern sys\$imgact(
				/* name	  */	Temp_Desc(name),
				/* dflnam */	_DESCRIPTOR 'sys$share:.exe',
				/* hdrbuf */	,
				/* imgctl */	_2:10000,	;;; merge into P0 space
				/* inadr  */	_mrp,
				/* retadr */	_mrp,
				/* ident  */	_gsd_ident,
				/* acmode */	)
		_bitst _1
	and _extern sys\$imgfix() _bitst _1
	then
		unless _mrp!MR_FIRST_ADDR == _baseaddr
		and _mrp!MR_LAST_ADDR <=@(b) _lastaddr then
			mishap(name, 1, 'SYSTEM ERROR IN EXTERNAL LOAD (image mapped in wrong place)')
		endunless;
		;;; return limit address
		_mrp!MR_LAST_ADDR _add _1

	elseif _syserror == _:'SS$_VA_IN_USE' then
		;;; VA_IN_USE is what we get when the (shareable) image is too big
		_NULL
	elseif _syserror == _:'SS$_NOSUCHSEC' or _syserror == _:'SS$_IVSECIDCTL'
	then
		mishap(name, 1, 'ERROR ACTIVATING IMAGE (shareable image version mismatch)')
	else
		Syserr_mishap(name, 1, 'ERROR ACTIVATING IMAGE')
	endif
enddefine;

	/*	Activate new areas of shareable images (at least one)
	*/
define lconstant Activate_new_shrims();
	lvars _shrim, _base, _size, _lim, _start_shrim;

	define lconstant Outgrown_area(_start_shrim);
		lvars _shrim = _start_shrim, _sizenow = _0, _start_shrim;
		;;; find size now
		repeat
			Image_ownsize(Shrim_filename(Extract_shrim_info(_shrim) ->))
										_add _sizenow -> _sizenow;
			_shrim@(w)[_shrim!SHRIM_ENTRY_LEN] -> _shrim;
			quitif(_shrim == _shrim_stack_sp
					or _nonzero(_shrim!SHRIM_AREA_NPAGES))
		endrepeat;
		$-Sys$-Sr$-Shrim_too_big(
			_sizenow, @@(vpage)[_start_shrim!SHRIM_AREA_NPAGES],
			@@(vpage)[_start_shrim!SHRIM_ORG_NPAGES], _0)
	enddefine;

	_shrim_activated_ptr -> _shrim;
	repeat
		_shrim -> _start_shrim;
		_shrim!SHRIM_BASE_ADDR -> _base;			;;; base addr for area
		@@(vpage)[_shrim!SHRIM_AREA_NPAGES] -> _size;	;;; size of area
		Delete_mem(_base, _size);					;;; delete whole area
		_base@(vpage){_size} -> _lim;				;;; limit of area

		repeat
			_base -> _shrim!SHRIM_BASE_ADDR;
			Activate_image(Extract_shrim_info(_shrim),
								_base, @@(w){_lim, _base}) -> _base;
			if _base == _NULL then
				;;; shareable images have grown too big
				Outgrown_area(_start_shrim)
			endif;
			_shrim@(w)[_shrim!SHRIM_ENTRY_LEN] ->> _shrim
												-> _shrim_activated_ptr;
			returnif(_shrim == _shrim_stack_sp);		;;; finished
			quitif(_nonzero(_shrim!SHRIM_AREA_NPAGES))	;;; next area
		endrepeat
	endrepeat
enddefine;


;;; --- IMAGE ACTIVATOR FIXUP SECTION -------------------------------------

	/* Base address for outer executable images we link (page 1) */
lconstant macro _EXEC_IM_BASE = @@(vpage)[_1];

struct FIXUP_HEADER
  { long	FIXHD_UNKNOWN[2];	;;; don't know what these two 0 words are for
	short	FIXHD_HDR_SIZE,		;;; header size
			FIXHD_FLAGS;		;;; flags
	long	FIXHD_G_OFFS,		;;; offset to G^ fixups 1st FIXUP_VEC
			FIXHD_DOTADDR_OFFS,	;;; offset to .address fixups 1st FIXUP_VEC
			FIXHD_PROTCHG_OFFS,	;;; offset to prot change fixups FIXUP_PROTCHGS
			FIXHD_IMAGES_OFFS,	;;; offset to images table -- 1st FIXUP_IMAGE
			FIXHD_IMAGE_COUNT;	;;; number of images (including current)
	;;; header is actually 16 words, but rest is zero
  };

	/*	For G^ and .address fixups. Both kinds consist of a variable
		number of these structures, followed by a 0 word where the next
		FIXV_NUM_ENTRIES would be.

		The FIXV_ENTRIES for G^ are offsets into the image given by
		FIXV_IMAGE_NUM.

		The FIXV_ENTRIES for .address are offsets into the current image
		of words containing offsets into the image FIXV_IMAGE_NUM (offsets
		into the current image are always based at EXEC_IM_BASE where we
		linked it).
	*/
struct FIXUP_VEC
  { long	FIXV_NUM_ENTRIES,	;;; this is 0 after last vector
			FIXV_IMAGE_NUM,		;;; image number starting at 0 for this image
			FIXV_ENTRIES[];		;;; entries
  };

struct FIXUP_PROTCHG
  { long	FIXPC_OFFS;			;;; offset into current image
	short	FIXPC_NUM_PAGES,	;;; number of pages
			FIXPC_PROT;			;;; new protection
  };

struct FIXUP_PROTCHGS
  { long	FIXPC_NUM_ENTRIES;	;;; number of entries
	struct FIXUP_PROTCHG
			FIXPC_ENTRIES[];
  };

struct FIXUP_IMAGE
  { (vpage)	FIXIM_BASE;			;;; base addr of image after activation
	word	FIXIM_UNKNOWN[4];	;;; unknown zeros (image 0 has 64 in last)
	(struct SHRIM)
			FIXIM_SHRIM_PTR;	;;; unknown zero, but we use for shrim ptr
	byte	FIXIM_NAME_LEN,		;;; name length
			FIXIM_NAME[39];		;;; name (making up 16 words in all)
  };

	/*	Doctor the fixup section of an outer linked image after activating it.
	*/
define lconstant Doctor_fixup(_fixup_seg);
	lvars	_shrim, _nlen, _base = _fixup_seg!SEG_BASE_PTR,
			_im, _size = _fixup_seg!SEG_SIZE, _tmp_mem, _fixup_seg;

	;;; First, make the fixup section writeable
	unless Set_mem_prot(_base, _base@(vpage){_size}, _M_PROT_ALL) then
		mishap(0, 'SYSTEM ERROR IN EXTERNAL LOAD (can\'t make fixup writeable)')
	endunless;

	;;; Add a pointer to a shrim record to each shareable image
	;;; in the fixup section
	_base@(w){_base!FIXHD_IMAGES_OFFS} -> _im;
	fast_repeat _pint(_base!FIXHD_IMAGE_COUNT _sub _1) times
		_im@(struct FIXUP_IMAGE)++ -> _im;		;;; ignore image 0 (this image)
		_im!FIXIM_NAME_LEN -> _nlen;
		;;; find name in shrim stack
		_shrim_stack -> _shrim;
		while _shrim <@(struct SHRIM) _shrim_stack_sp do
			if _shrim!SHRIM_NAME_LEN == _nlen
			and _bcmp(@@(b)[_nlen], _shrim@SHRIM_NAME, _im@FIXIM_NAME)
			then
				;;; found it
				_shrim -> _im!FIXIM_SHRIM_PTR;
				nextloop(2)
			else
				_shrim@(w)[_shrim!SHRIM_ENTRY_LEN] -> _shrim
			endif
		endwhile;
		mishap(0, 'SYSTEM ERROR IN EXTERNAL LOAD (no shrim for image name)')
	endrepeat;

	Set_mem_prot(_base, _base@(vpage){_size}, _M_PROT_NOWRITE) ->
enddefine;

	/*	Refix a fixup section after restoring a saved image, i.e.
		dealing with shareable images whose base address has changed
		from what it was when the saved image was created.
	*/
define lconstant Refix_fixup(_fixup_seg);
	lvars	_e, _p, _im, _diff, _n, _vec, _imgnum, _imgtab,
			_base = _fixup_seg!SEG_BASE_PTR, _fixup_seg;
	lstackmem struct MEMRANGE _mrp;

	_base@(w){_base!FIXHD_IMAGES_OFFS} -> _imgtab;

	;;; do G^ fixups first
	_base@(w){_base!FIXHD_G_OFFS} -> _vec;		;;; start of vector sequence
	until _zero(_vec!FIXV_NUM_ENTRIES ->> _n) do
		_vec!FIXV_IMAGE_NUM -> _imgnum;
		_imgtab@(struct FIXUP_IMAGE)[_imgnum] -> _im;
		_vec@FIXV_ENTRIES -> _e;
		_vec@FIXV_ENTRIES[_n] -> _vec;
		;;; diff between where shareable image is now and where it was
		@@(w){_im!FIXIM_SHRIM_PTR!SHRIM_BASE_ADDR, _im!FIXIM_BASE} -> _diff;
		if _nonzero(_diff) then
			;;; adjust all the entries by diff
			while _e <@(l) _vec do
				_e!(l) _add _diff -> _e!(l)++ -> _e
			endwhile
		;;; else nothing to do
		endif
	enduntil;

	;;; then .address
	_base@(w){_base!FIXHD_DOTADDR_OFFS} -> _vec;	;;; start of vector sequence
	until _zero(_vec!FIXV_NUM_ENTRIES ->> _n) do
		_vec!FIXV_IMAGE_NUM -> _imgnum;
		_imgtab@(struct FIXUP_IMAGE)[_imgnum] -> _im;
		_vec@FIXV_ENTRIES -> _e;
		_vec@FIXV_ENTRIES[_n] -> _vec;
		;;; diff between where shareable image is now and where it was
		@@(w){_im!FIXIM_SHRIM_PTR!SHRIM_BASE_ADDR, _im!FIXIM_BASE} -> _diff;
		if _nonzero(_diff) then
			;;; adjust all the entries by diff
			while _e <@(l) _vec do
				_EXEC_IM_BASE@(w){_e!(l)++ -> _e} -> _p;
				_p!(l) _add _diff -> _p!(l)
			endwhile
		;;; else nothing to do
		endif
	enduntil;

	;;; adjust the FIXIM_BASE field for each shareable image
	_base@(w){_base!FIXHD_IMAGES_OFFS} -> _im;
	fast_repeat _pint(_base!FIXHD_IMAGE_COUNT _sub _1) times
		_im@(struct FIXUP_IMAGE)++ -> _im;	;;; ignore image 0 (this image)
		_im!FIXIM_SHRIM_PTR!SHRIM_BASE_ADDR -> _im!FIXIM_BASE
	endrepeat;

	;;; finally, do protection changes (might as well)
	_base@(w){_base!FIXHD_PROTCHG_OFFS} -> _p;
	_p!FIXPC_NUM_ENTRIES -> _n;
	_p@FIXPC_ENTRIES -> _p;
	fast_repeat _pint(_n) times
		_EXEC_IM_BASE@(vpage){_p!FIXPC_OFFS} -> _e;
		_e 										-> _mrp!MR_FIRST_ADDR;
		_e@(vpage)[_p!FIXPC_NUM_PAGES] _sub _1	-> _mrp!MR_LAST_ADDR;
		_extern sys\$setprt(
					/* inadr  */	_mrp,
					/* retadr */	,
					/* acmode */	,
					/* prot	  */	_p!FIXPC_PROT,
					/* prvprt */	) -> ;
		_p@(struct FIXUP_PROTCHG)++ -> _p
	endrepeat
enddefine;


;;; ----------------------------------------------------------------------

	/*	Do the guts of an external load.
	*/
define Do_link_load(objfiles, symbol_list, old_link_base, new_link_base);
	lvars	symbol_list, objfiles, old_link_base, new_link_base,
			_imstart, _size, _nbytes,
		;

	dlocal	read_buf = inits(514);

	define lconstant Is_share_spec(spec, n);
		lvars n, spec;
		uppertolower(spec) -> spec;
		if isstartstring(allbutfirst(n,spec), 'shareable') then
			consword(sys_fname_nam(allbutlast(datalength(spec)-n+1, spec)))
		else
			false
		endif
	enddefine;

	lvars spec, shr, shr_list, switches = '', n;
	if symfile_shrim_include == identfn then
		;;; First external load --- initialise _shrim_stack to system images
		;;; and move the activated pointer to past these
#_IF DEF V5_STB_BUG
		Initv(256, []) -> shrim_sym_vec;
#_ENDIF
		Analyse_image(Vms_get_image_name(), _NULL, false) -> (,,);
		_shrim_stack_sp -> _shrim_activated_ptr;
		;;; property for accumulating list of shareable images for
		;;; symbol files
		newproperty([], 4, [], "tmparg") -> symfile_shrim_include
	endif;

	;;; get current list of shareable images to include
	symfile_shrim_include(old_link_base) -> shr_list;

	;;; weed out explicit shareable images and linker switches
	lvars first = true;
	[%	for spec in objfiles do
			if isword(spec) then spec!W_STRING -> spec endif;
			if (locchar(`/`, 1, spec) ->> n) == 1 then
				spec <> switches -> switches
			elseif n and (Is_share_spec(spec, n) ->> shr) then
				unless fast_lmember(shr, shr_list) then
					shr :: shr_list -> shr_list
				endunless
			else
				if first then
					;;; ensure default dir established
					unless locchar(`:`, 1, spec) then
						unless locchar(`[`, 1, spec) then
							'[]' <> spec -> spec
						endunless;
						'sys$disk:' <> spec -> spec
					endunless;
					false -> first
				endif;
				spec
			endif
		endfor
	%] -> objfiles;

	;;; base address for object file cluster in image
	Open_seg_shift_gap_base()@POPBASE -> _imstart;

	;;; temp file names
	lvars	tmpname			= Temp_name(),
			comname			= tmpname <> 'com',
			aobj			= tmpname <> 'obj',
			new_link_image	= tmpname <> ('exe_' sys_>< exe_version),
			procout 		= tmpname <> 'lis',
			old_link_input	= old_link_base,
		;

	dlvars	procedure out;

#_IF DEF V5_STB_BUG
	tmpname <> 'stb' -> old_link_input;
#_ENDIF

	define lconstant outf();
		dlocal cucharout = out;
		printf()
	enddefine;

	;;; --- create command file for sysobey
	discout(comname) -> out;
	out('$ set message/facil/ident/sever/text\n');
	out('$ on warning then stop \'f$process()\n');

	;;; --- assembler command and input
	outf(aobj, '$ macro/nolist/disable=traceback/obj=%p sys$input:\n');

	;;; demand-zero padding section to fill the address space upto _imstart
	;;; so that the symbol value section starts there
	out('.psect exload$pad,noshr,wrt,noexe,long\n');
	outf(_pint(@@(vpage){_imstart, _EXEC_IM_BASE}), '.blkb %p\n');

	;;; symbol section for array of external pointers with symbol values
	;;; (rounded to an exact number of pages -- becomes a pop segment)
	out('.psect exload$symbols,noshr,wrt,exe,long\n');
	Convert_symbols(symbol_list, outf);		;;; outputs external pointers
	@@(w)[_int(listlength(symbol_list)) | struct EXTERNAL_PTR] -> _size;
	@@(vpage){_size | w.r} _sub _size -> _size;
	if _nonzero(_size) then
		;;; output padding struct
		if _neg(_size _sub @@(struct POPREC1)++ ->> _nbytes) then
			_size _add @@(vpage)++ -> _size;
			_size _sub @@(struct POPREC1)++ -> _nbytes
		endif;
		outf(_nbytes, rawstruct_key, _size, '.long %d,%d\n.blkb %d\n')
	endif;
	out('.end\n');

	;;; --- link command and options input
	outf(procout, '$ assign/user %p sys$error\n');
	out('$ assign/user nla0: sys$output\n');
	outf(new_link_base, switches, new_link_image,
		'$ link/notraceback/nodebug/nomap/exe=%p%p/symbol=%p sys$input:/options\n');

	;;; shareable images
	fast_for spec in shr_list do
		out(Shrim_filename(spec!W_STRING)), out('/share\n')
	endfor;

	;;; (absolute) input symbols from previous loads, plus
	;;; padding and symbol sections, all in a cluster
	outf(aobj, old_link_input, 'cluster=exload$first,,,%p,%p\n');

	;;; then the user's file specs, each on a separate line
	;;; (note that first one establishes the the default file spec)
	fast_for spec in objfiles do out(spec), out(`\n`) endfor;

	;;; pop external library
	out('popexternlib:libpop.olb/library\n');

	;;; finish command file
	out(termin);

#_IF DEF V5_STB_BUG		;;; bug is fixed in V5.3
	;;; VMS V5 puts all shareable image symbols in the output
	;;; symbol table file (Yuk!). Use the symbols accumulated in
	;;; shrim_sym_vec to create a temporary file with them edited out.
	Extern_make_base(old_link_base, old_link_input, 0);
#_ENDIF

	;;; --- Run command file.
	;;; Set -pop_spawn_flags- to prevent copying of DCL symbols (bit 1 = 1);
	;;; this speeds up spawning a lot.
	dlocal pop_spawn_flags = 2:10;
	sysobey('@' <> comname, false);		;;; false says no terminal output

	sysdelete(comname) -> ;
	sysdelete(aobj) -> ;
#_IF DEF V5_STB_BUG
	sysdelete(old_link_input) -> ;
#_ENDIF

	;;; --- Check for errors
	lvars dev, fail, n;
	if pop_status &&=_0 1 then
		sysopen(procout, 0, "line", `N`) -> dev;
		false -> fail;
		while (sysread(dev, read_buf, 512) ->> n) /== 0 do
			;;; check that it's not just 'no transfer address' -- yuk
			unless n == 1 or issubstring('LINK-W-USRTFR', 1, read_buf) then
				appdata(substring(1,n,read_buf), cucharout);
				true -> fail
			endunless
		endwhile;
		sysclose(dev);
		sysdelete(procout) -> ;
		if fail then
			sysdelete(new_link_image) -> ;
			sysdelete(new_link_base) -> ;
			mishap(0, 'ERRORS IN EXTERNAL LOAD LINK (see above)')
		endif
	endif;

	;;; --- Analyse the linked image, computing sizes, adding new shareable
	;;; images to the shareable image stack and segments for the outer
	;;; image sections to the segment table
	sysopen(new_link_image, 2, true, `N`) -> dev;
	lvars (_shrsize, _ownsize, ) = Analyse_image(dev, _NULL, false);

	;;; original size of shrims
	lvars _org_shrsize = _shrsize;
	;;; then allow margin for expansion
	$-Sys$-Sr$-Shrim_margin(_shrsize) _add _shrsize -> _shrsize;

	;;; check gap base hasn't changed (could have if more space had been
	;;; allocated for fixed structs, i.e. we shouldn't use them after getting
	;;; _imstart above).
	if Open_seg_shift_gap_base()@POPBASE /== _imstart then
		mishap(0, 'SYSTEM ERROR IN EXTERNAL LOAD (shift gap base wrong)')
	endif;
	;;; Shift up the open seg to make room for everything
	unless Do_open_seg_shift_gc(_ownsize _add _shrsize, false) then
		;;; can't do a copying gc
		mishap(0, 'INSUFFICIENT MEMORY TO MAKE SPACE FOR EXTERNAL LOAD')
	endunless;

	;;; add seg table entries for own sections
	lvars _exptr_seg = _seg_table_next_free;
	lvars (, , _fixup_seg) = Analyse_image(dev, _imstart, false);
	sysclose(dev);

	;;; --- Activate any new shareable images, starting them in memory after
	;;; the own sections of the outer image
	if _shrim_stack_sp >@(w) _shrim_activated_ptr then
		;;; there are some -- add a segment for the area
		Add_nonpop_seg_entry(_imstart@(w){_ownsize}, _shrsize,
								_M_SEG_EXT_DYN_MEM _biset _M_SEG_NO_SAVE);

		;;; fill in base addr and size for whole area in first entry
		_imstart@(w){_ownsize}	-> _shrim_activated_ptr!SHRIM_BASE_ADDR;
		##(vpage){_shrsize} 	-> _shrim_activated_ptr!SHRIM_AREA_NPAGES;
		##(vpage){_org_shrsize} -> _shrim_activated_ptr!SHRIM_ORG_NPAGES;
		;;; then activate them
		Activate_new_shrims();
		;;; can't do a sysrestore after this because the shareable images
		;;; can't be cleared
		true -> $-Sys$-Sr$- _prohibit_restore
	endif;
	shr_list -> symfile_shrim_include(new_link_base);

	;;; --- Activate the outer image and delete it.
	Delete_mem(_EXEC_IM_BASE, @@(vpage)++);		;;; one page here
	Delete_mem(_imstart, _ownsize);				;;; rest at _imstart
	Activate_image(new_link_image, _NULL, _EXEC_IM_BASE,
						@@(vpage){_imstart, _EXEC_IM_BASE} _add	_ownsize) -> ;

	if _fixup_seg /== _NULL then
		;;; Play games with the fixup section -- make it writeable and then add
		;;; pointers to shrim stack entries into each shareable image entry in
		;;; the fixup
		Doctor_fixup(_fixup_seg)
	endif;

	;;; Must keep changing the file name so VMS thinks it's
	;;; a different image every time ...
	exe_version + 1 -> exe_version;

	sysdelete(new_link_image) -> ;

	;;; Turn the seg containing the exptrs into a pop fixed seg
	unless _exptr_seg!SEG_BASE_PTR == _imstart then
		mishap(0, 'SYSTEM ERROR IN EXTERNAL LOAD (image start wrong)')
	endunless;
	_imstart@~POPBASE ->> _imstart		-> _exptr_seg!SEG_BASE_PTR;
	_imstart@(w){_exptr_seg!SEG_SIZE}	-> _exptr_seg!SEG_FREE_PTR;
	_M_SEG_FIXED_STRUCTS _biset _M_SEG_FIXED_EXPTRS -> _exptr_seg!SEG_FLAGS;

	;;; Put external pointers with symbol values in spec(3) for each symbol
	fast_for spec in symbol_list do
		_imstart -> spec(3);
		_imstart@(struct EXTERNAL_PTR)++ -> _imstart
	endfor
enddefine;


;;;; --- RESTORING SAVED IMAGES -----------------------------------------

	/*	After a sysrestore, restore shareable images not so far activated,
		and then re-fixup fixup sections.
	*/
define Reactivate_shrims();
	lvars _shrim = _shrim_activated_ptr;
	while _shrim <@(struct SHRIM) _shrim_stack_sp do
		if _nonzero(_shrim!SHRIM_AREA_NPAGES) then
			;;; found first of a block of externally-loaded images
			;;; -- activate this and any others following
			Activate_new_shrims();
			quitloop
		endif;
		;;; else an image in the basic system -- just fill in its base
		;;; address and step activated ptr
		Get_sysshr_base(Extract_shrim_info(_shrim)) -> _shrim!SHRIM_BASE_ADDR;
		_shrim@(w)[_shrim!SHRIM_ENTRY_LEN] ->> _shrim -> _shrim_activated_ptr
	endwhile;

	lvars _seg = _seg_table;

	while _seg <@(struct SEG) _seg_table_next_free do
		if _seg!SEG_FLAGS _bitst _M_SEG_IMAGE_FIXUP then
			Refix_fixup(_seg)
		endif;
		_seg@(struct SEG)++ -> _seg
	endwhile
enddefine;


#_ENDIF		/* SHARED_LIBRARIES */

endsection;		/* $-Sys$-Extern */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Jun 16 1998
		Fixed bug in Convert_symbols (not passing language name correctly)
--- John Gibson, Aug 16 1996
		Removed Do_p*opc_load.
--- John Gibson, May 28 1996
		Changed SHARED_LIBRARIES code to use Get_symbol_ptr to get the
		external pointer for each symbol.
--- John Gibson, Nov 24 1994
		Added the new SHARED_LIBRARIES (shareable images only) version
--- John Gibson, Jun  2 1994
		Replaced use of _d*ouble with lstackmem
--- John Gibson, Dec  3 1993
		Changed Convert_symbols to truncate symbols to 31 chars
--- John Gibson, Nov  5 1991
		Corrected mem_pad_key to rawstruct_key
--- Simon Nichols, Nov  1 1991
		Added declaration of _nbytes to Do_link_Load.
--- John Gibson, Oct 30 1991
		Changed Do_link_load so that shareable image names in object file
		list can have filename/directory components etc.
--- John Gibson, Sep 13 1991
		Made padding struct generated by Do_link_Load use a rawstruct rather
		than a string
--- John Gibson, Apr 29 1991
		Major revisions to cope with expansion of shareable images and
		external symbol relocation in saved images.
--- John Gibson, Feb 16 1991
		Fixed problem with where segment table entries are added.
--- John Gibson, Feb  7 1991
		VMS V5 bug where linker adds shareable image symbols to output .stb
		file is cured in V5.3 (quite possibly earlier). Undid fixes to get
		round it (but left old code flagged with #_IF DEF V5_STB_BUG).
--- John Gibson, Oct 10 1990
		VMS _extern changed to return proper system call result (thus test
		for success is now result _bitst _1).
--- John Gibson, Jul  7 1990
		Changed -Do_link_load- for new format entries in symbol_list.
--- John Gibson, May 20 1990
		Added popexternlib:libpop.olb/library to link command
--- John Gibson, Feb 19 1990
		Changes to mechanism for using copying gc to shift up open seg
--- John Gibson, Feb 12 1990
		Added 'set message ...' command to command file sysobey'ed by
		-Do_link_load- (to ensure that all warnings/errors produce
		output).
--- John Gibson, Dec  1 1989
		Changes for new pop pointers
--- John Gibson, Jul 25 1989
		Changed -Do_link_load- to create a command file and then sysobey
		it. Also now sets -pop_spawn_flags- to prevent copying of
		DCL symbols when running sysobey (speeds it up a lot).
--- John Gibson, May 11 1989
		Changed -Process_gsd_rec- to cope with all current types of GSD
		subrecords.
--- John Gibson, Apr 30 1989
		Put into section $-Sys$-Extern.
--- John Gibson, Oct 18 1988
		Changes for VMS V5:
		1. 	Linker now puts shareable image symbols out on the .stb
			file, so Do_link_load must accumulate all symbols on each
			shareable image used and use this to strip them off each .stb
			before it goes into the next link.
		2.	Memory occupied by images mapped in with sys$imgact must be
			deleted first.
--- John Gibson, Feb 16 1988
		Restore_check_shrims into Sys$-Extern
 */
