/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 * File:			C.win32/extern/src/copysign.c
 * Purpose:			Define copysign() missing from NuTC.lib
 * Author:			Robert Duncan, May 31 1996
 */

#include <stdlib.h>

double copysign(double x, double y) {
#ifdef _X86_
	/* using __asm avoids a reference into the MS CRT library */
	__asm {
		mov	eax, dword ptr [x+4]
		mov	ecx, dword ptr [y+4]
		and	eax, 07fffffffh
		and	ecx, 080000000h
		or	eax, ecx
		mov	dword ptr [x+4], eax
	}
	return x;
#else
	extern double _copysign(double, double);
	return _copysign(x, y);
#endif
}
