/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 * File:			C.win32/extern/src/start.c
 * Purpose:			Common entry point to Poplog
 * Author:			Robert John Duncan, Jan 22 1996 (see revisions)
 * Documentation:
 * Related Files:
 */

#include "popcore.h"

static LONG poplogRunning = 0;
static BOOL poplogMainThread = TRUE;

OSVERSIONINFO pop_os_version_info;

void pop_init() {
	if (pop_os_version_info.dwOSVersionInfoSize == 0) {
		/* first time */
		pop_os_version_info.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
		GetVersionEx(&pop_os_version_info);
	}
	pop_init_heap();
	pop_init_ast();
}

BOOL pop_start(BOOL bMainThread, UINT* exitCode)
{
	if (InterlockedExchange(&poplogRunning, 1) != 0)
		/* only one thread can run Poplog */
		return FALSE;
	poplogMainThread = bMainThread;

	__try {
		*exitCode = pop_main();
	}
	__except (pop_exception_filter(GetExceptionInformation())) {
		*exitCode = GetExceptionCode();
	}

	return TRUE;
}

void pop_exit(UINT exitCode) {
	if (poplogMainThread)
		ExitProcess(exitCode);
	else
		// NB -- this will leave other threads running
		ExitThread(exitCode);
}


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Jun 20 1996
		Removed initialisation call from pop_start: now done in Setup_system
--- Robert Duncan, Jun  4 1996
		Added pop_os_version_info and pop_init.
 */
