;;; --- Copyright University of Sussex 1994. All rights reserved. ----------
;;; File:		C.win32/extern/src/util.asm
;;; Purpose:		Assembly code utilities
;;; Author:		Robert John Duncan, Jun 14 1994
;;; Documentation:
;;; Related Files:

	.386
	.model	c, flat
	.code

	; conversions between Poplog/Unix time (number of seconds since
	; 1 Jan 1970) and Win32 FILETIME (number of 100ns intervals
	; since 1 Jan 1601)

	; values for low and high components of the Poplog/Unix base date
	; expressed as a FILETIME structure
lo1970	equ	0D53E8000H
hi1970	equ	0019DB1DEH


	; FILETIME --> Poplog time
	; NB: this may raise a Divide by Zero exception if the result is
	; out of range
pop_time_from_file_time\
	proc	popTime: ptr dword, fileTime: ptr dword

	; load fileTime to EDX:EAX
	mov	ecx, fileTime
	mov	eax, [ecx+0]
	mov	edx, [ecx+4]

	; subtract 1970 base date (with correction for usec rounding)
	sub	eax, lo1970-5
	sbb	edx, hi1970

	; divide by 1e7 to get time in seconds:
	; quotient goes in EAX, remainder in EDX
	mov	ecx, 10000000
	div	ecx

	; store quotient to argument
	mov	ecx, popTime
	mov	[ecx], eax

	; divide remainder by 10 to get microseconds (returned as result):
	; remainder here can be ignored because of the correction above
	mov	eax, edx
	sub	edx, edx
	mov	ecx, 10
	div	ecx

	ret
pop_time_from_file_time\
	endp


pop_time_to_file_time\
	proc	popTime: dword, fileTime: ptr dword

	; load popTime to EAX and convert to 100ns in EDX:EAX
	mov	eax, popTime
	mov	ecx, 10000000
	mul	ecx

	; add 1970 base date
	add	eax, lo1970
	adc	edx, hi1970

	; store result to fileTime structure
	mov	ecx, fileTime
	mov	[ecx+0], eax
	mov	[ecx+4], edx

	ret
pop_time_to_file_time\
	endp

	; add together kernel and user process times given as FILETIME
	; structures and convert result to 1/100th seconds
pop_sum_process_times\
	proc	kernelTime : ptr dword, userTime : ptr dword

	; load user time to EDX:EAX
	mov	ecx, userTime
	mov	eax, [ecx+0]
	mov	edx, [ecx+4]

	; add kernel time
	mov	ecx, kernelTime
	add	eax, [ecx+0]
	adc	edx, [ecx+4]

	; add rounding correction
	add	eax, 50000
	adc	edx, 0

	; divide by 1e5 to get time in 1/100th seconds:
	; quotient left in EAX is the result
	mov	ecx, 100000
	div	ecx

	ret
pop_sum_process_times\
	endp

	end
