/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			C.win32/lib/auto/pipeout.p
 > Author:			Robert John Duncan, Jan  8 1996 (see revisions)
 > Purpose:			Supply input to a child process
 > Related Files:	LIB * PIPEIN, C.unix/lib/auto/pipeout.p
 */
compile_mode:pop11 +strict;

section;

	/*	Spawn a process to run a command taking its input from a given
		source. Arguments:
			src				- source for input
			command, args	- same as for sys_create_process
			wait			- whether to wait for process to finish
	*/
define pipeout(src, command, args, wait);
	lvars (odev, idev) = syspipe(false);
	lvars pid = sys_create_process(command, args,
					{^idev ^popdevout ^popdeverr}, wait);
	sysclose(idev);
	if isref(src) then
		;;; cont(src) is a procedure which will write to the pipe
		cont(src)(odev);
	else
		lvars procedure (
			putchar = discout(odev),
			getchar = isprocedure(src) and src or discin(src),
		);
		until putchar(dup(getchar())) == termin do /*nothing*/ enduntil;
	endif;
	sysclose(odev);
	;;; NB: we may already have waited while the process consumed all
	;;; its input, but there's nothing we can do about that; this wait
	;;; covers only the time between its reading the last character and
	;;; actually terminating
	if wait then sys_wait(pid) -> (,) endif;
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Robert Duncan, May 24 1996
		Specified std i/o explicitly in sys_create_process call
 */
