/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			C.win32/lib/auto/sys_file_match.p
 > Purpose:			Produce a file-name repeater from given file spec
 > Author:			Robert John Duncan, Feb  7 1996
 > Documentation:   REF *SYSUTIL
 > Related Files:	C.win32/src/sys_files_matching.p
 */
compile_mode :pop11 +strict;

section;

lvars
	do_sys_file_stat  = false,
	strip_directory	  = false,
	show_hidden_files = false,
;

define lconstant Has_wildcard(s);
	lvars i;
	fast_for i to datalength(s) do
		returnif(fast_subscrs(i,s) == `?` or fast_subscrs(i,s) == `*`)(i);
	endfor;
	false;
enddefine;

define lconstant Matched(file);
	lvars i;
	if do_sys_file_stat then
		sys_file_stat(file, do_sys_file_stat);
	endif;
	if strip_directory
	and (locchar_back(`\\`, datalength(file), file) ->> i)
	then
		allbutfirst(i, file)
	else
		file
	endif;
	suspend(do_sys_file_stat and 2 or 1);
enddefine;

define lconstant match(prefix, dpats, fpat, vers);
	lvars flags = show_hidden_files and 2:10 or 2:00;
	until dpats == [] do
		lvars dpat = hd(dpats);
		if Has_wildcard(dpat) then
			lvars d;
			for d in sys_files_matching(prefix dir_>< dpat, flags||1) do
				match(d, tl(dpats), fpat, vers);
			endfor;
			return;
		elseif dpat = '...' then
			match(prefix, tl(dpats), fpat, vers);
			lvars d;
			for d in sys_files_matching(prefix dir_>< '*', flags||1) do
				match(d, dpats, fpat, vers);
			endfor;
			return;
		else
			prefix dir_>< dpat -> prefix;
			tl(dpats) -> dpats;
		endif;
	enduntil;
	if strip_directory then
		suspend(prefix, false, 2);
	endif;
	lvars matched = sys_files_matching(prefix dir_>< fpat, flags);
	if vers then
		;;; special version matching: this is an expensive way to do it,
		;;; but it's not a common form
		lvars f, g;
		for f in matched do
			if isendstring('-', f) then
				nextloop;
			elseif vers = nullstring then
				Matched(f);
			else
				for g in sys_files_matching(f <> vers, flags) do
					if skipchar_back(`-`, datalength(g), g) == datalength(f)
					then
						Matched(g);
					endif;
				endfor;
			endif;
		endfor;
	else
		applist(matched, Matched);
	endif;
enddefine;

define lconstant do_sfm(do_sys_file_stat, strip_directory, show_hidden_files)
with_nargs 7;
	dlocal do_sys_file_stat, strip_directory, show_hidden_files;
	match();
	termin;
enddefine;

define sys_file_match(fpat, dpat, statvec, flags) -> rep;
	unless dpat then nullstring -> dpat endunless;
	if statvec then
		unless isvector(statvec) then
			mishap(statvec, 1, 'VECTOR NEEDED');
		endunless;
	endif;
	if flags == true then
		1 -> flags;
	elseif flags == false then
		0 -> flags;
	endif;

	;;; identify pathname components in each pattern: drive, directory,
	;;; name and version
	define Get_indexes(pat);
		lvars (pat,,dir,name,,vers) = sysfileok(pat, true);
		;;; check for trailing '...' which will have confused sysfileok
		lvars path = allbutfirst(dir-1, pat);
		if path = '...' or isendstring('\\...', path) then
			chain(pat <> '\\', Get_indexes);
		endif;
		;;; check for '#' which should be included in the version
		lvars i;
		for i from vers-1 by -1 to name do
			lvars c = pat(i);
			unless c == `-` or c == `*` or c == `?` then
				if c == `#` then i -> vers endif;
				quitloop;
			endunless;
		endfor;
		pat, {1 ^dir ^name ^vers ^(length(pat)+1)};
	enddefine;
	lvars (fpat, fvec) = Get_indexes(fpat);
	lvars (dpat, dvec) = Get_indexes(dpat);

	;;; extract components for matching
	define Get_component(i, j);
		fvec(j) > fvec(i) and substring(fvec(i), fvec(j)-fvec(i), fpat) or
		dvec(j) > dvec(i) and substring(dvec(i), dvec(j)-dvec(i), dpat) or
		nullstring;
	enddefine;
	lvars drive = Get_component(1, 2);
	lvars dir = Get_component(2, 3);
	lvars name = Get_component(3, 4);
	lvars vers = Get_component(4, 5);

	;;; this is the full pattern
	lvars pat = consstring(#|
			explode(drive),
			explode(dir),
			explode(name),
			explode(vers),
		|#);

	;;; if drive is given it must be fixed
	if Has_wildcard(drive) then
		mishap(pat, 1, 'ILLEGAL FILENAME PATTERN');
	endif;

	;;; break directory part into a fixed prefix and a list of
	;;; subdirectory components to be matched
	lvars prefix = drive;
	lvars dirs = [%
		lvars i = 1, j;
		while locchar(`\\`, i, dir) ->> j do
			lvars dpat = substring(i, j-i+1, dir);
			quitif(dpat = '...\\' or Has_wildcard(dpat));
			prefix <> dpat -> prefix;
			j+1 -> i;
		endwhile;
		while locchar(`\\`, i, dir) ->> j do
			substring(i, j-i, dir);
			j+1 -> i;
		endwhile;
	%];

	;;; construct file pattern and optional version matcher if '#' was
	;;; specified
	if isstartstring('#', vers) then
		;;; special treatment
		allbutfirst(1, vers) -> vers;
	else
		(name <> vers, false) -> (name, vers);
	endif;
	if name == nullstring then '*' -> name endif;

	;;; construct process to return files one at a time
	lvars proc = consproc(prefix, dirs, name, vers, statvec,
						  flags &&/=_0 2:001, flags &&/=_0 2:100,
						  7, do_sfm);
	;;; return repeater
	lvars rep = runproc(%0, proc%);
	pat -> pdprops(rep);
enddefine;

endsection;
