/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			C.win32/src/sys_file_stat.p
 > Purpose:			Get basic information about a file
 > Author:			Robert John Duncan, Feb 28 1994 (see revisions)
 > Documentation:	___REF * _____SYSIO
 > Related Files:
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'io.ph'
#_INCLUDE 'win32defs.ph'

section $-Sys;

constant procedure (Check_vector, Dword_->_pint, Io$-Create_file);

endsection;

;;; -----------------------------------------------------------------------


section $-Sys => sys_file_stat;

	/*	This is kept purely for compatibility with Unix and VMS:
		it returns no more than the file size and last modification time
	*/
define sys_file_stat(file, fvec) -> fvec;
	lvars file, fvec, _handle;
	if isboolean(fvec) then
		;;; for Unix compatibility
		((), file, fvec) -> (file, fvec, ());
	endif;
	Check_vector(fvec);
	if isdevice(file) then
		;;; flush if open for writing
		Check_device(file, 2:1001);
		;;; extract file handle from device record
		file!D_CTRL_BLK!DCB_HANDLE -> _handle;
	else
		sysfileok(file) -> file;
		;;; try open file for reading
		Io$-Create_file(file, _:WIN32_GENERIC_READ, _:WIN32_FILE_SHARE_READ,
				_0, _:WIN32_OPEN_EXISTING, _:WIN32_FILE_ATTRIBUTE_NORMAL)
			-> _handle;
		returnif(_handle == _:WIN32_INVALID_HANDLE_VALUE)(false -> fvec);
	endif;
	lvars _len = datalength(fvec);
	if _len fi_> 0 then
		;;; get the file size in field 1
		dlvars _size_hi = _0;
		lvars _size_lo = _extern pop_get_file_size(_handle, ident _size_hi);
		if _size_lo == _16:FFFFFFFF
		and (GET_LAST_ERROR, _syserror /== _:WIN32_NO_ERROR)
		then
			;;; failed -- could be a pipe, etc.
			0
		else
			;;; convert hi/lo halves of size to pop (big)integer
			Dword_->_pint(_size_hi, _size_lo)
		endif -> fast_subscrv(1, fvec);
	endif;
	if _len fi_> 1 then
		;;; get the last modification time in field 2
		Uint_->_bigint(_extern pop_get_file_time(_handle))
			-> fast_subscrv(2, fvec);
	endif;
	unless isdevice(file) then
		_extern pop_close_handle(_handle) -> ;
	endunless;
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- Robert John Duncan, Jun  6 1997
		Changed arguments to Create_file
--- Robert John Duncan, Jan  8 1996
		Openc*reate replaced by Create_file
 */
