/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			C.win32/src/sys_host_name.p
 > Purpose:			Return host computer name
 > Author:			Robert John Duncan, Feb 16 1994 (see revisions)
 > Documentation:	___REF * ______SYSTEM
 > Related Files:
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'win32defs.ph'


section $-Sys => sys_host_name;

define sys_host_name() -> name;
	lvars _n = _extern pop_get_computer_name(wkstring1@V_BYTES,
					_:WKSTRING_LENGTH);
	if _zero(_n) then
		false -> name;
	elseif _n _lt _:WKSTRING_LENGTH then
		Tchars_out(wkstring1, _n) -> name;
	else
		lvars wkstring = Get_tstring(_n);
		if _extern pop_get_computer_name(wkstring@V_BYTES, _n _add _1) == _n
		then
			Tchars_out(wkstring, _n) -> name;
		else
			;;; shouldn't happen
			false -> name;
		endif;
	endif;
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Jan 29 1997
		Modifications for UNICODE compilation
 */
