/* --- Copyright University of Sussex 1998. All rights reserved. ----------
 > File:			C.win32/src/sysutil.p
 > Purpose:			System utility procedures
 > Author:			Robert John Duncan, Feb 25 1994 (see revisions)
 > Documentation:	___REF * _______SYSUTIL
 > Related Files:
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'win32defs.ph'

;;; -----------------------------------------------------------------------

vars _syserror = _0;

section $-Sys;

	/*	Convert a 64-bit unsigned number, given as two system integers,
		into a Pop (big)integer
	*/
define Dword_->_pint(_hi, _lo) -> n;
	lvars n, _hi, _lo;
	_CLAWBACK_SAVE;
	Uint_->_pint(_lo) -> n;
	unless _zero(_hi) then
		Clawback((Uint_->_pint(_hi) << WORD_BITS) + n) -> n;
	endunless;
enddefine;

	/*	Set protection on pages
	*/
define Set_mem_prot(_base, _lim, _prot);
	lvars _base, _lim, _prot;
	_nonzero(_extern pop_virtual_protect(_base, _lim, _prot));
enddefine;

	/*	Return the absolute limit for the callstack
	*/
define Abs_callstack_lim();
	_extern pop_get_callstack_base();
enddefine;

	/*	Free any excess memory used by unwound callstack calls.
		Called by setpop etc after clearing the callstack.
	*/
define Dealloc_callstack_mem();
	;;; This should be possible in NT: use ____________VirtualQuery to find the base
	;;; address of the committed stack region, and then ___________VirtualFree to
	;;; decommit some of it. Some other time ...
enddefine;

	/*	Return the user's login name
	*/
define Get_user_name() -> user;
	lvars user, _n;
	lvars _n = _extern pop_get_user_name(wkstring1@V_TCHARS, _:WKSTRING_LENGTH);
	;;; _n is the length of the name including the last null byte
	if _zero(_n) then
		nullstring -> user;
	elseif _n _lteq _:WKSTRING_LENGTH then
		Tchars_out(wkstring1, _n _sub _1) -> user;
	else
		;;; try again with a larger buffer
		Get_tstring(_n _sub _1) -> user;
		if _extern pop_get_user_name(user@V_TCHARS, _n) == _n then
			Tchars_out(user, _n _sub _1) -> user;
		else
			nullstring -> user;
		endif;
	endif;
enddefine;

	/*	Test whether an environment variable is set
	*/
define Is_environment_variable(name);
	lvars t_name = Tchars_in(name, wkstring1);
	_nonzero(_extern pop_get_environment_variable(t_name@V_TCHARS, _0, _0));
enddefine;

	/*	Expand environment vars in a string
	*/
define Expand_environment_strings(string) -> string;
	lvars t_string = Tchars_in(string, wkstring1);
	lvars buffer = wkstring2;
	lvars _n = _extern pop_expand_environment_strings(t_string@V_TCHARS,
		buffer@V_TCHARS, _:WKSTRING_LENGTH);
	;;; _n is the length of the expansion including the last null byte
	if _n _gr _:WKSTRING_LENGTH then
		;;; try again with a larger buffer
		Get_tstring(_n _sub _1) -> buffer;
		returnunless(_extern pop_expand_environment_strings(t_string@V_BYTES,
			buffer@V_BYTES, _n) == _n);
	endif;
	if _nonzero(_n) then
		Tchars_out(buffer, _n _sub _1) -> string;
	endif;
enddefine;

	/*	Return a string describing the error code recorded in _syserror:
		could use the API function FormatMessage, but that tends to be
		too wordy for sticking on the end of a mishap message, so we just
		build up a table of common error numbers with their names
	*/
define lconstant error_message =
	newproperty([
		[^WIN32_ERROR_ACCESS_DENIED			'ACCESS_DENIED']
		[^WIN32_ERROR_BROKEN_PIPE			'BROKEN_PIPE']
		[^WIN32_ERROR_DISK_FULL				'DISK_FULL']
		[^WIN32_ERROR_FILE_EXISTS			'FILE_EXISTS']
		[^WIN32_ERROR_FILE_NOT_FOUND		'FILE_NOT_FOUND']
		[^WIN32_ERROR_HANDLE_DISK_FULL		'HANDLE_DISK_FULL']
		[^WIN32_ERROR_INVALID_DRIVE			'INVALID_DRIVE']
		[^WIN32_ERROR_INVALID_HANDLE		'INVALID_HANDLE']
		[^WIN32_ERROR_INVALID_NAME			'INVALID_NAME']
		[^WIN32_ERROR_LOCK_VIOLATION		'LOCK_VIOLATION']
		[^WIN32_ERROR_NOT_ENOUGH_QUOTA		'NOT_ENOUGH_QUOTA']
		[^WIN32_ERROR_PATH_NOT_FOUND		'PATH_NOT_FOUND']
		[^WIN32_ERROR_SHARING_VIOLATION		'SHARING_VIOLATION']
		[^WIN32_ERROR_TOO_MANY_OPEN_FILES	'TOO_MANY_OPEN_FILES']
		[^WIN32_ERROR_WRITE_PROTECT			'WRITE_PROTECT']
	], length(dup())*2, false, "perm");
enddefine;

define Os_error_message() -> msg;
	lvars code = _pint(_syserror), msg;
	unless error_message(code) ->> msg then
		code -> msg;
	endunless;
	'error: ' sys_>< msg  -> msg;
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- Robert Duncan, Jul 28 1998
		Added Is_environment_variable
--- Robert Duncan, Jan 29 1997
		Modifications for UNICODE compilation
--- Robert Duncan, Jul 23 1996
		Moved in Expand_environment_strings
--- John Gibson, Apr 13 1996
		sysio*message -> nonexported Os_error_message without the brackets
 */
