/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			C.win32/win/auto/win_version.p
 > Purpose:			Get Windows version information
 > Author:			Robert Duncan, Jul  2 1997
 > Documentation:
 > Related Files:
 */
compile_mode :pop11 +strict;

section;
exload_batch;

include win_types;

l_typespec OSVERSIONINFO {
	dwOSVersionInfoSize	: DWORD,
	dwMajorVersion		: DWORD,
	dwMinorVersion		: DWORD,
	dwBuildNumber		: DWORD,
	dwPlatformId		: DWORD,
	szCSDVersion		: CHAR[128],
};

lconstant
	VER_PLATFORM_WIN32_WINDOWS	= 1,
	VER_PLATFORM_WIN32_NT		= 2,
;

exload win_version [kernel32]
lconstant
	GetVersionExA(1)	: BOOL,
endexload;

;;; win_version(vec) -> vec
;;;     Fills in and returns a vector of information about the Windows
;;;     host platform. The vector may have up to six fields filled in as
;;;     follows:

;;; 	1.	Platform identifier (word or <false>). Possible values:
;;; 			"WIN32_WINDOWS"		(Win32 on Windows 95)
;;; 			"WIN32_NT"			(Win32 on Windows NT)
;;; 			false				(Unknown platform)
;;; 	2.	Major version (integer)
;;; 	3.	Minor version (integer)
;;; 	4.	Build number (integer)
;;; 	5.	Platform identifier (integer)
;;; 	6.	Additional descriptive information (string)

define win_version(vec) -> vec;
	unless isvector(vec) then
		mishap(vec, 1, 'VECTOR NEEDED');
	endunless;
	l_typespec info :OSVERSIONINFO;
	lvars info = EXPTRINITSTR(:OSVERSIONINFO);
	SIZEOFTYPE(:OSVERSIONINFO) -> exacc info.dwOSVersionInfoSize;
	lvars res = exacc GetVersionExA(info);
	if res == 0 then
		mishap(0, 'Failed to get version information');
	endif;
	lvars len = datalength(vec);
	returnif(len == 0);
	;;; get platform indicator
	lvars platform = exacc info.dwPlatformId;
	if platform == VER_PLATFORM_WIN32_WINDOWS then
		"WIN32_WINDOWS"
	elseif platform == VER_PLATFORM_WIN32_NT then
		"WIN32_NT"
	else
		;;; unknown platform type
		"undef"
	endif -> fast_subscrv(1, vec);
	returnif(len == 1);
	exacc info.dwMajorVersion -> fast_subscrv(2, vec);
	returnif(len == 2);
	exacc info.dwMinorVersion -> fast_subscrv(3, vec);
	returnif(len == 3);
	exacc info.dwBuildNumber -> fast_subscrv(4, vec);
	returnif(len == 4);
	exacc info.dwPlatformId -> fast_subscrv(5, vec);
	returnif(len == 5);
	exacc_ntstring(exacc info.szCSDVersion) -> fast_subscrv(6, vec);
enddefine;

endexload_batch;
endsection;		/* $- */
