/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			C.win32/win/src/windows.p
 * Purpose:			A simple Poplog/Windows interface
 > Author:			Robert John Duncan, Jul 15 1994 (see revisions)
 */

#_INCLUDE 'windows.ph'

section;

constant procedure (Sys$-Xt$-X_cb_apply);

defclass PopWindow [external_ptr writeable] {
	popWindowProps		: full,
	popWindowHandle		: exptr,
	popWindowChildren	: full,
};

defclass PopWindowMessage [writeable] {
	popWindowMessageType	: uint,
	popWindowMessageArg		: int,
	popWindowMessageExtra	: exval,
};

endsection;

section $-Sys$-Windows =>
	popwin_get_message
	popwin_send_message
	popwin_create_base_window
;

define CheckrPopWindow(item) -> item;
	lvars item;
	unless isPopWindow(item) then
		mishap(item, 1, 'WINDOW NEEDED');
	endunless;
enddefine;

define CheckrPopWindowMessage(item) -> item;
	lvars item;
	unless isPopWindowMessage(item) then
		mishap(item, 1, 'WINDOW MESSAGE NEEDED');
	endunless;
enddefine;

	/*	Get the next message posted to this thread
	*/
define popwin_get_message(win, msg) -> msg;
	lvars win, msg;
	CheckrPopWindow(win) -> ;
	CheckrPopWindowMessage(msg) -> ;
	lconstant pmsg = writeable inits(SIZEOF(struct POP_MSG));
	until _nonzero($-Sys$-Xt$-X_cb_apply(pmsg, _1, _extern popwin_get_message)) do
		;;; interrupted
		_CHECKINTERRUPT;
	enduntil;
	pmsg!PM_MESSAGE -> msg!PWM_TYPE;
	pmsg!PM_WPARAM -> msg!PWM_ARG;
	pmsg!PM_LPARAM -> msg!PWM_EXTRA;
enddefine;

	/*	Send a message to a window
	*/
define popwin_send_message(win, msg);
	lvars win, msg;
	CheckrPopWindow(win) -> ;
	CheckrPopWindowMessage(msg) -> ;
	lstackmem struct POP_MSG _pmsg;
	win!PW_HWND -> _pmsg!PM_HWND;
	msg!PWM_TYPE -> _pmsg!PM_MESSAGE;
	msg!PWM_ARG -> _pmsg!PM_WPARAM;
	msg!PWM_EXTRA -> _pmsg!PM_LPARAM;
	Sint_->_pint(_extern popwin_send_message(_pmsg));
enddefine;

	/*	Create a base window
	*/
define popwin_create_base_window(props) -> window;
	lvars props, window;
	lvars _hwnd = _extern popwin_create_base_window();
	if _zero(_hwnd) then
		GET_LAST_ERROR;
		Syserr_mishap(0, 'FAILED TO CREATE BASE WINDOW');
	endif;
	;;; quick hack to get the one child window
	lconstant exptr = writeable struct EXTERNAL_PTR
		=>> {% false, external_ptr_key, _NULL %};
	_extern popwin_get_window(_hwnd, _:WIN32_GW_CHILD) -> exptr!XP_PTR;
	lvars child = consPopWindow(props, exptr, []);
	;;; create the base window
	_hwnd -> exptr!XP_PTR;
	consPopWindow(props, exptr, [^child]) -> window;
enddefine;

endsection;

/*******************************************************************************
New Interface as of 30/01/96
*******************************************************************************/

section $-Sys$-Windows =>
	popwin_add_task
	popwin_message_loop
;

vars popwin_task_list = [];

define popwin_add_task(procedure task);
	dlocal pop_enable_interrupts = false;
	popwin_task_list nc_<> [^task] -> popwin_task_list;
enddefine;

define popwin_message_loop();
	dlocal popwin_task_list = [];	;;; things to do out of callback
	lvars _wait = 0;				;;; whether to wait for a message to come
	while _nonzero($-Sys$-Xt$-X_cb_apply(_wait, _1, _extern popwin_try_message))
	do
		_CHECKINTERRUPT;
		if popwin_task_list == [] then
			;;; wait for something to happen
			1 -> _wait;
		else
			lvars task;
			sys_grbg_destpair(popwin_task_list) -> (task, popwin_task_list);
			task();
			0 -> _wait;
		endif;
	endwhile;
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Robert John Duncan, Feb  7 1996
		Changed popwin_get_message to use X_cb_apply to allow for callback
		while processing messages, e.g. arising from SendMessage.
		Added support for new (experimental MDI) interface.
 */
