/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			C.win32/win/src/windows.ph
 > Purpose:			Header file for Poplog windows sources
 > Author:			Robert John Duncan, Jul 15 1994 (see revisions)
 */

#_INCLUDE '../../src/syspop.ph'
#_INCLUDE '../../src/win32macros.ph'
#_INCLUDE '../../src/win32defs.ph'

	;;; Primitive Win32 types
deftype
	HWND	= DWORD,
	LPARAM	= DWORD,
	WPARAM	= DWORD
;

	;;; Simplified Windows message structure
struct POP_MSG {
	HWND	PM_HWND;
	int		PM_MESSAGE;
	WPARAM	PM_WPARAM;
	LPARAM	PM_LPARAM;
};

	;;; System overlays for Pop window classes (declared below)
struct POP_WINDOW {				/* PopWindow */
	full	PW_PROPS,
			KEY;
>->	HWND	PW_HWND;
	full	PW_CHILDREN;
};

struct POP_WINDOW_MESSAGE {		/* PopWindowMessage */
	int		PWM_TYPE;
	full	KEY;
>->	int		PWM_ARG;
	DWORD	PWM_EXTRA;
};

	;;; Basic window structure
defclass-declare PopWindow [external_ptr writeable] {
	popWindowProps		: full,			/* anything */
	popWindowHandle		: exptr,		/* window handle (HWND) */
	popWindowChildren	: full,			/* list of child windows */
};

	;;; Windows message forwarded to Poplog
defclass-declare PopWindowMessage [writeable] {
	popWindowMessageType	: uint,		/* message */
	popWindowMessageArg		: int,		/* wParam */
	popWindowMessageExtra	: exval,	/* lParam */
};

	;;; Fundamental messages
define :inline iconstant MAKE_POP_MESSAGE(n);
	(WIN32_WM_USER + 16:100 + (n))
enddefine;

lconstant macro (
	POPM_CLOSE = MAKE_POP_MESSAGE(1),
);

/* --- Revision History ---------------------------------------------------
--- Robert John Duncan, Feb  7 1996
		Changed MAKE_POP_MESSAGE to increase the base for Poplog messages as
		recommended for Windows '95.
 */
