/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:			C.windows/lib/lib/popwinlib.p
 > Purpose:			Enable Windows libraries and documentation
 > Author:			Robert Duncan, Jul  2 1997
 */
compile_mode :pop11 +strict;

section;


lconstant
	WINDIR		= '$usepop/pop/win/',
	WINAUTO		= WINDIR dir_>< 'auto/',
	WINLIB		= WINDIR dir_>< 'lib/',
	WINSRC		= WINDIR dir_>< 'src/',
	WININCLUDE	= WINDIR dir_>< 'include/',
	WINHELP		= WINDIR dir_>< 'help/',
	WINREF		= WINDIR dir_>< 'ref/',
	WINTEACH	= WINDIR dir_>< 'teach/',
;


/* Set up library search lists */

;;; Make the additions go at the end
declare_incremental list[prec=100]
	(popautolist, popuseslist, popsyslist, popincludelist);

extend_searchlist(WINAUTO, popautolist, true) -> popautolist;
extend_searchlist(WINLIB, popuseslist, true) -> popuseslist;
extend_searchlist(WINSRC, popsyslist, true) -> popsyslist;
extend_searchlist(WININCLUDE, popincludelist, true) -> popincludelist;


/* Set up documentation search lists */

#_IF DEF vedprocess or DEF POPC_COMPILING

#_IF not(DEF POPC_COMPILING)
uses ved_src;		;;; for vedsrclist
#_ENDIF

lconstant
	winhelp        = [^WINHELP help],
	winref         = [^WINREF ref],
	winteach       = [^WINTEACH teach],
	winsrc         = [^WINSRC src],
	winhelplist    = [^winhelp ^winref ^winteach],
	winreflist     = [^winref ^winhelp ^winteach],
	winteachlist   = [^winteach ^winhelp ^winref],
	winsrclist     = [^winsrc],
;

extend_searchlist(winhelplist, weakref vedhelplist) -> weakref vedhelplist;
extend_searchlist(winreflist, weakref vedreflist) -> weakref vedreflist;
extend_searchlist(winteachlist, weakref vedteachlist) -> weakref vedteachlist;
extend_searchlist(winsrclist, weakref vedsrclist) -> weakref vedsrclist;

#_ENDIF


constant popwinlib = true;		;;; For uses

endsection;		/* $- */
