@NEWMASTER@ jonm Thu Jun 6 07:33:13 BST 1991
54d
46,52d
@NEWMASTER@ jonm Sat Jul 6 04:54:04 BST 1991
199,203d
20,21c
	blank_item = consXpolListItem(OL_STRING, '\(0)', ext_null, 0, ext_null,0),
.
17a
	ext_null = consexternal_ptr(),
.
@NEWMASTER@ jonm Sat Aug 17 15:08:48 BST 1991
9,10c
section;

uses xt_widgetclass;

/* ==== Private Scrolling List Management Functions ====================== */

lconstant
	ScrollingList = XptWidgetSet("OpenLook")("ScrollingListWidget"),

/*  a single blank OlListItem is used when adding things to a scrollinglist */
	blank_item = consXpolListItem(OL_STRING, '\(0)',
			null_external_ptr, 0, null_external_ptr,0),

	list_item_assoc = newproperty([],20, [], "tmparg");
;

lvars applTouchItem = false, applUpdateView applDeleteItem;

/* scrolling list entries have the following structure : */
defclass lconstant list_item [external_ptr] {
	li_props: full,					;;; external_ptr_props
>->	li_exptr: exptr,				;;; external_ptr
	li_descriptor: full,			;;; OlListToken returned by XpolAddItem
	li_item: full,					;;; POPLOG item equiv of list entry
	li_label: full					;;; printed version of li_item
};

/* Listin:
Generates a list repeater
*/

define lconstant Listin(list);
	lvars list;
	unless list.islist then mishap(list,1,'LIST NEEDED'); endunless;
	define lconstant listin_repeater with_props false;
		lvars item;
		if list == [] then termin
		elseif list.isprocedure then
			list();
		elseif back(list).isprocedure then
			back(list) -> list;
			list();
		else
			if list == [] then termin else dest(list) -> list; endif;
		endif;
	enddefine;
	listin_repeater;
enddefine;


/* Get_widget_list_procs:
Gets procedures from Widget to add and remove items from the scrolling list
*/

define lconstant Get_widget_list_procs(widget);
	lvars widget;
	XptImportProcedure(XptValue(widget, XtN applTouchItem, TYPESPEC(:exptr)))
			-> applTouchItem;
	XptImportProcedure(XptValue(widget, XtN applDeleteItem, TYPESPEC(:exptr)))
			-> applDeleteItem;
	XptImportProcedure(XptValue(widget, XtN applUpdateView, TYPESPEC(:exptr)))
			-> applUpdateView;
enddefine;

/* Make_label(item)
Prints out item and uses output of print to build fixed address nt string
*/

define lconstant Make_label(item);
	lvars item;
	if item.isstring and item.is_fixed and
			fast_subscrs(datalength(item), item) == 0 then
		;;; no need to do the following operation on item
		item
	else
		dlocal cucharout = identfn;
		cons_fixed(#| syspr(item), 0 |#, string_key);
	endif;
enddefine;

define lconstant Set_list_items(widget, repeater);
	lvars tag widget repeater item current_items label has_changed = false;
	list_item_assoc(widget) -> current_items;
	[% fast_repeat
		repeater() -> item;			;;; returns next thing to put in list
		quitif(item == termin);

		if current_items /== [] then
			;;; we've got some entries in the scrolling list - so just get
			;;; the next entry and change its label
			fast_destpair(current_items) -> current_items ->> tag;

			nextif(tag.li_item = item);
			;;; even better - we don't need to rename the thing since its
			;;; the same as it was previously
		else
			;;; need to extend the length of the list, so add a blank item
			;;; at end:
			XpolAddListItem(widget, false, false, blank_item) -> tag;
			;;; build new list_item wrapper for item, and register it.
			conslist_item("OlListToken", tag, tag, nullstring, nullstring)
						->> XptRegister(tag) ->> tag;
		endif;

		;;; if we haven't already changed the list, notify the widget that
		;;; we are about to set some things so it doesn't update itself
		unless has_changed then
			exacc applUpdateView(widget, 0);
			true -> has_changed;
		endunless;

		;;; record both item and nt_string version of item to stop then GC'ing
		item -> tag.li_item;
		Make_label(item) ->> tag.li_label -> label;

		;;; set OlListItem.label field correctly
		label -> exacc :OlListItem tag.label;

		;;; tell widget we've touched it
		exacc applTouchItem(widget, tag);

	endfast_repeat; %] -> list_item_assoc(widget);

	;;; remove any extra items from end of list
	if current_items /== [] then
		unless has_changed then
			exacc applUpdateView(widget, 0);
			true -> has_changed;
		endunless;
		fast_for tag in current_items do
			exacc applDeleteItem(widget, tag);
		endfast_for;
	endif;

	if has_changed then
		;;; we did something to it - so tell it to update itself
		exacc applUpdateView(widget, 1);
	endif;
enddefine;

define lconstant Get_list_items(widget, wants_tokens);
	lvars widget current_items, wants_tokens;
	list_item_assoc(widget) -> current_items;
	define lconstant List_item_repeater;
		if current_items == [] then
			termin
		else
			fast_destpair(current_items) -> current_items;
			unless wants_tokens then li_item(); endunless;
		endif;
	enddefine;
	List_item_repeater;
enddefine;

/* ==== Public Interface to List =================================== */

define global XpolListItems(widget) -> repeater;
	lvars widget, repeater, wants_tokens = false;
	unless isexternal_ptr_class(widget) then
		widget -> (widget, wants_tokens);
	endunless;
	unless XtIsSubclass(widget, ScrollingList) then
		mishap(widget,1,'OpenLook Scrolling List Widget Needed');
	endunless;
	unless applTouchItem then Get_widget_list_procs(widget); endunless;
	pdtolist(Get_list_items(widget,wants_tokens)) -> repeater;
enddefine;

define updaterof XpolListItems(repeater, widget);
	lvars widget, repeater;
	unless XtIsSubclass(widget, ScrollingList) then
		mishap(widget,1,'OpenLook Scrolling List Widget Needed');
	endunless;
	unless applTouchItem then Get_widget_list_procs(widget); endunless;
	unless repeater.isprocedure then Listin(repeater) -> repeater endunless;
	Set_list_items(widget, repeater);
enddefine;

define global XpolListTokenToItem(tag) -> item;
	lvars tag item;
	XptLiveTypeCheck(XptRegister(tag),"OlListToken") -> tag;
	if tag.islist_item then
		tag.li_item
	else
		exacc :OlListItem tag.label
	endif -> item;
enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Jonathan Meyer, Jul  6 1991
		Changed to use null_external_ptr
 */
.
7a
compile_mode :pop11 +strict;
.
