/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_key_sensitive.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 21st June 1992
;;; File: go_key_sensitive.p
;;; Authors: B Rabau (based on original code of J L Cunningham)

compile_mode :pop11 +strict;

;;; This file should be used in conjunction with go_action.p ...

;;;------------------------------------------------------
;;; Definitions which where previously defined in sketch_basics.p

uses go_sensitive.p

;;; Dummy action (default action on key-stroke):
define no_key_action( key_stroke, dummy_object );
lvars key_stroke, dummy_object;
;;; REF: Dummy action in GO (default action on key-strokes): erase arguments.
	;;; printf('SENSITIVE: %p is hit on object %p\n',[% key_stroke,
	;;; datakey(dummy_object) %])
enddefine;


;;;------------------------------------------------------
;;; SENSITIVE TO KEY STROKES IN LIVE MODE

;;; INTRO: The MIXIN go_key_sensitive adds behaviour (actions) to the
;;; INTRO: Graphical Objects when keyboard events occur over the object. The
;;; INTRO: actions only get called in "live" mode (see HELP * GO_LIVE).
;;; INTRO: The actions are devided in two categories: down and up which
;;; INTRO: correspond to the state of a mouse button.
;;; INTRO: In "edit" mode the  behaviour is determined by the edit actions
;;; INTRO: (REF * GO_XACTIONS/go_edit_key_action).
;;; INTRO: See also LIB * GO_MOUSE_SENSITIVE for mouse actions.

define :mixin go_key_sensitive;
	slot go_key_down_action = no_key_action;
;;; REF: Procedure called when a keyboard key-down event happens when the
;;; REF: mouse is over this object.
	slot go_key_up_action   = no_key_action;
;;; REF: Procedure called when a keyboard key-up event happens after a
;;; REF: key-down event happened with the mouse over this object.
enddefine;


define :method go_accepts_events( type, raw_event_data, obj :go_key_sensitive ) -> accepts;
lvars type, raw_event_data, obj, accepts;
;;; REF: go_accepts_events( TYPE, RAW_EVENT_DATA, MOUSE_SENSITIVE ) -> BOOLEAN;
;;; REF: Returns whether or not this object accepts the event. In this
;;; REF: case whether the event is a keyboard event.
;;; REF: RAW_EVENT_DATA is a vecto (see REF * GO_XACTION/go_expand_event_data).
;;; REF: KEY_SENSITIVE is a go_key_sensitive object (LIB * GO_KEY_SENSITIVE).
	(type == "keyboard") -> accepts;
	unless accepts then
		call_next_method( type, raw_event_data, obj ) -> accepts;
	endunless;
enddefine;


;;; In live_mode the go_keyboard key can be user
;;; defined with the go_key_action() method
;;;

define :method go_key_down_action_string( uio :go_key_sensitive );
lvars uio;
;;; REF: go_key_down_action_string( KEY_SENSITIVE ) -> STRING;
;;; REF: Gets the string representing the action triggered when a keyboard
;;; REF: key goes down. The string can be any compilable pop11 structure which
;;; REF: expects two arguments on the stack: the key and the object over which
;;; REF: the mouse resided when the key was hit.
;;; REF: KEY_SENSITIVE is a go_key_sensitive object (LIB * GO_KEY_SENSITIVE).
	go_action_string(uio.go_key_down_action);
enddefine;

define :method updaterof go_key_down_action_string(str, uio :go_key_sensitive );
lvars uio;
;;; REF: STRING -> go_key_down_action_string( KEY_SENSITIVE );
;;; REF: Compiles the string representing the action triggered when a keyboard
;;; REF: key goes up. The string can be any compilable pop11 structure which
;;; REF: expects two arguments on the stack: the key and the object over which
;;; REF: the mouse resides when the key is hit.
	go_compile_action(str) -> uio.go_key_down_action;
enddefine;

define :method go_key_up_action_string( uio :go_key_sensitive );
lvars uio;
;;; REF: go_key_up_action_string( KEY_SENSITIVE ) -> STRING;
;;; REF: Gets the string representing the action triggered when a keyboard
;;; REF: key goes up. The string can be any compilable pop11 structure which
;;; REF: expects two arguments on the stack: the key and the object over which
;;; REF: the mouse resided when the key was hit.
	go_action_string(uio.go_key_up_action);
enddefine;

define :method updaterof go_key_up_action_string(str, uio :go_key_sensitive );
lvars uio;
;;; REF: STRING -> go_key_up_action_string( KEY_SENSITIVE );
;;; REF: Compiles the string representing the action triggered when a keyboard
;;; REF: key goes up. The string can be any compilable pop11 structure which
;;; REF: expects two arguments on the stack: the key and the object over which
;;; REF: the mouse resides when the key is hit.
	go_compile_action(str) -> uio.go_key_up_action;
enddefine;


;;;----------------------------------------------------------------
;;; Variable for "uses"
vars go_key_sensitive = true;


/* --- Revision History --------------------------------------------
 * BR 21/06/93
 *     Added the go_accepts_events() method.
 * BR 04/05/93
 *     Split file go_sensitive.p into three parts:
 *         - go_sensitive.p       Common procedures for compilation aid
 *         - go_key_sensitive.p   The mixin for adding keyboard sensitivity
 *         - go_mouse_sensitive.p The mixin for adding mouse sensitivity
 *     Added comments.
 */
;;; eof
