/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_xresize.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */

compile_mode :pop11 +strict;

uses go_pane;

section;

uses xt_callback;
uses XtN;

;;; INTRO: This library provides a general callback attachment facility to add
;;; INTRO: a procedure to an rc_graphic's window which is called when the window
;;; INTRO: is resized. A SINGLE callback is attached to the rc_graphic's widget.

;;; INTRO: The callback needs to be of the form:
;;; INTRO: 	<procedure name>( widget );
;;; INTRO: in which the widget will be instantiated to the rc_window which is
;;; INTRO: resized.

;;; INTRO: It uses the XtNresizeEvent as explained in REF *XPWGRAPHIC (see also
;;; INTRO: notify-resize-event).

/* ---------------------------- WARNING ---------------------------- *
Unfortunately there was an inconsistency in the XpwGraphic's Translation
table (see REF * XPWGRAPHIC). A patch for poplog 14.1 follows below.
 */


/* WRAPPER TO ALLOW LESS THAN THREE ARGUMENTS */
define lconstant go_resizewrapper(resized_window, proc_call_data, reference);
lvars resized_window, proc_call_data, reference;

	;;; call the real RC procedure attached to the resize event
	proc_call_data();

enddefine;

define :method go_resize_setup( proc_call_closure, pane :go_pane );
lvars pane;
;;; REF: go_resize_setup( PROCEDURE, PANE );
;;; REF: Call the given procedure whenever the pane is resized (see also
;;; REF: REF *XPWGRAPHIC/XtNresizeEvent.
;;; REF: PANE is an instance of the go_pane class (REF * GO_PANE).
lvars window;
	the_go_window( pane ) -> window;

#_IF DEFV pop_internal_version < 143000
	/* --------------------- END PATCH resizeEvent --------------------- */
	/* PATCH moved here so that file can be loaded before window created */
	lvars tmp_trans=
		XtParseTranslationTable('<Configure>: notify-resize-event() \n');
	XtOverrideTranslations( window, tmp_trans );
	/* --------------------- END PATCH resizeEvent --------------------- */
#_ENDIF

	;;;  detach old callback(s)
	XtRemoveAllCallbacks(window, XtN resizeEvent);

	;;;  attach resizewrapper as callback (to call setsize)
	XtAddCallback(window,
			XtN resizeEvent,
			go_resizewrapper,
			proc_call_closure
			);
enddefine;

endsection;

;;;----------------------------------------------------------------
;;; Variable for "uses"
vars go_resize = true;


;;; INTRO: EXAMPLE - to call a user "refresh" procedure after resizing
;;; INTRO: go_resize_setup( go_redraw(% go_default_pane %), go_default_pane );

/*  --- Revision History ---------------------------------------------------
 * BR 25/05/93
 *     Added comments.
 * BR 30/03/93
 *     Changed go_window_pane class into go_pane class.
 *     Adapted History format
 * BR 20/11/92
 *     Adapted for GO
 * BR 25/08/92
 *     Moved Patch inside rc_resize_setup to allow saved images.
 * JLC 25/03/92
 *     Moved call of XtOverride, so that file could be loaded
 *     Moved call of rc_setsize() into wrapper - this makes the assumption
 *         that users will always want to use the correct window size.
 *     Made tmp_trans into an lvar
 *     Changed rc_resizeproc to rc_resize_setup() and introduced the
 *         user assignable rc_resize_action (and changed rc_graphic)
 */
;;; eof
