/* --- Copyright University of Sussex 1989. All rights reserved. ----------
 > File:            C.alpha/src/array_cons.p
 > Purpose:
 > Author:          John Gibson, Aug 25 1994
 > Related Files:   C.alpha/src/ass.p, C.all/src/arrays.p
 */

;;; ------------- CONSTRUCTING ARRAY PROCEDURES (ALPHA) --------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'drop_code.ph'

constant
		_array_sub
	;


;;; ---------------------------------------------------------------------

section $-Sys$-Vm;

	/*	Construct a raw array procedure. _________tabsize is the word offset size of
		the array params starting at PD_ARRAY_TABLE.
	*/
define $-Sys$-Array$-Cons(_tabsize) -> _arrayp;
	lvars _tabsize, _arrayp, _drop_ptr, _size, _rtn;

	;;; macro for dropping instructions
	lconstant macro _CODE = [_drop_ptr!(code)++ -> _drop_ptr];

	;;; get procedure record -- 10 instructions
	@@PD_ARRAY_TABLE{_tabsize} _add @@(w)[_10 | code.r] _sub @@POPBASE
										-> _size;
	Get_store(_size) -> _arrayp;

	;;; initialise some of procedure header
	##(w){_size} -> _arrayp!PD_LENGTH;
	_0		->> _arrayp!PD_REGMASK
			->> _arrayp!PD_NUM_STK_VARS
			->> _arrayp!PD_NUM_PSTK_VARS
			->> _arrayp!PD_NLOCALS
			-> _arrayp!PD_GC_SCAN_LEN;
	##SF_LOCALS -> _arrayp!PD_GC_OFFSET_LEN;
	lconstant _flen = ##SF_LOCALS _sub ##SF_RETURN_ADDR;	;;; = 2
	_flen -> _arrayp!PD_FRAME_LEN;

	_array_sub _sub false -> _rtn;
	if _rtn _bitst _2:1e15 then _rtn _add _2:1e16 -> _rtn endif;

	;;; start of code
	_arrayp@PD_ARRAY_TABLE{_tabsize} ->> _drop_ptr -> _arrayp!PD_EXECUTE;

	;;; stack frame and routine address
	_MEMf_INST(_OP_lda, _:RGsp, @@(w)-[_flen], _:RGsp)				-> _CODE;
	_MEMf_INST(_OP_ldah, _:RGt0, _shift(_rtn, _-16), _:RGfalse)		-> _CODE;
	_MEMf_INST(_OP_stW, _:RGret, @@SF_RETURN_ADDR[_flen], _:RGsp)	-> _CODE;
	_MEMf_INST(_OP_lda, _:RGt0, _rtn, _:RGt0)						-> _CODE;
	_MEMf_INST(_OP_stW, _:RGpb, @@SF_OWNER, _:RGsp)					-> _CODE;

	;;; call the array subscript routine
	;;; (picks up parameters from PB+PD_ARRAY_TABLE, stacks computed
	;;; subscript and PD_ARRAY_VECTOR, and then chains PD_ARRAY_SUBSCR_PDR)
	_MEMf_JMP_INST(_HINT_jsr, _:RGret, _:RGt0)						-> _CODE;

	;;; exit code
	_drop_ptr -> _arrayp!PD_EXIT;			;;; pointer to exit code
	_MEMf_INST(_OP_ldW, _:RGret, @@SF_RETURN_ADDR[_flen], _:RGsp)	-> _CODE;
	_MEMf_INST(_OP_lda, _:RGsp, @@(w)[_flen], _:RGsp)				-> _CODE;
	_MEMf_INST(_OP_ldW, _:RGpb, @@SF_OWNER, _:RGsp)					-> _CODE;
	_MEMf_JMP_INST(_HINT_ret, _:RGzero, _:RGret)					-> _CODE;
enddefine;

endsection;			/* $-Sys$-Vm */
